/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.ajax4jsf.resource.ResourceContext;

public class ServletResourceContext
extends ResourceContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public ServletResourceContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    @Override
    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    @Override
    public void setDateHeader(String name, long value) {
        this.response.setDateHeader(name, value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    @Override
    public Object getSessionAttribute(String name) {
        return this.request.getSession(false).getAttribute(name);
    }

    @Override
    public Object getContextAttribute(String name) {
        return this.context.getAttribute(name);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    @Override
    public String getRequestParameter(String data_parameter) {
        return this.request.getParameter(data_parameter);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public void setContentLength(int contentLength) {
        this.response.setContentLength(contentLength);
    }

    @Override
    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    @Override
    public String getServletPath() {
        return this.request.getServletPath();
    }
}

