/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.ajax4jsf.css.CssCompressor;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.compiler.HtmlCompiler;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.StyleRenderer;
import org.richfaces.skin.SkinFactory;

public class TemplateCSSRenderer
extends StyleRenderer {
    private static final String COMPILED_TEMPLATE_PROPERTY = "compiled-template";
    private static final String COMPRESS_STYLE_PARAMETER = "org.ajax4jsf.COMPRESS_STYLE";
    private RendererBase renderer = new RendererBase(){

        @Override
        protected Class<? extends UIComponent> getComponentClass() {
            return UIComponent.class;
        }
    };

    @Override
    public int send(InternetResource base, ResourceContext context) throws IOException {
        int bytesLength;
        PreparedTemplate template = null;
        CountingOutputWriter countingOutputWriter = new CountingOutputWriter();
        template = this.getTemplate(base, context);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean _CompressStyleOn = !"false".equals(facesContext.getExternalContext().getInitParameter(COMPRESS_STYLE_PARAMETER));
        PrintWriter writer = context.getWriter();
        String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
        if (null == defaultRenderKitId) {
            defaultRenderKitId = "HTML_BASIC";
        }
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit(facesContext, defaultRenderKitId);
        ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)countingOutputWriter, null, "UTF-8");
        facesContext.setResponseWriter(responseWriter);
        responseWriter.startDocument();
        template.encode(this.renderer, facesContext, null);
        responseWriter.endDocument();
        responseWriter.flush();
        responseWriter.close();
        if (_CompressStyleOn) {
            CssCompressor compressor = new CssCompressor(countingOutputWriter.getContent());
            bytesLength = compressor.compress(writer, -1);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        } else {
            ((Writer)writer).write(countingOutputWriter.getContent().toString());
            bytesLength = countingOutputWriter.getWritten();
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        return bytesLength;
    }

    public synchronized PreparedTemplate getTemplate(InternetResource base, ResourceContext context) throws IOException {
        PreparedTemplate template = (PreparedTemplate)base.getProperty(COMPILED_TEMPLATE_PROPERTY);
        if (null == template) {
            HtmlCompiler compiler = new HtmlCompiler();
            InputStream resourceAsStream = base.getResourceAsStream(context);
            if (null != resourceAsStream) {
                template = compiler.compile(resourceAsStream, base.getKey());
                base.setProperty(COMPILED_TEMPLATE_PROPERTY, template);
                resourceAsStream.close();
            } else {
                throw new IOException("CSS Template " + base.getKey() + " not found");
            }
        }
        return template;
    }

    @Override
    public boolean requireFacesContext() {
        return true;
    }

    @Override
    public Object getData(InternetResource base, FacesContext context, Object data) {
        PreparedTemplate template;
        FacesResourceContext resourceContext = new FacesResourceContext(context);
        try {
            template = this.getTemplate(base, resourceContext);
        }
        catch (IOException e) {
            return null;
        }
        UIComponent component = (UIComponent)(data instanceof UIComponent ? data : null);
        TemplateContext templateContext = new TemplateContext(null, context, component);
        Object value = template.getValue(templateContext);
        if (null == value) {
            SkinFactory skinFactory = SkinFactory.getInstance();
            int hashCode = skinFactory.getSkin(context).hashCode(context);
            int baseHashCode = skinFactory.getBaseSkin(context).hashCode(context);
            value = ByteBuffer.allocate(8).putInt(hashCode).putInt(baseHashCode).array();
        }
        return value;
    }
}

