/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp.nekko;

import org.ajax4jsf.webapp.nekko.HtmlCorrectionState;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.cyberneko.html.HTMLAugmentations;
import org.cyberneko.html.filters.DefaultFilter;

public class HtmlCorrectionFilter
extends DefaultFilter {
    private HtmlCorrectionState _state = new BaseHtmlCorrectionState(null);

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this._state = new BaseHtmlCorrectionState(null);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this._state.endElement(element, augs);
        super.endElement(element, augs);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this._state.startElement(element, attributes, augs);
        super.startElement(element, attributes, augs);
    }

    void insertStartElement(String name, QName base) {
        QName element = this.createQName(name, base);
        XMLAttributesImpl attrs = new XMLAttributesImpl();
        HTMLAugmentations augs = new HTMLAugmentations();
        super.startElement(element, (XMLAttributes)attrs, (Augmentations)augs);
    }

    private QName createQName(String name, QName base) {
        String prefix = base.prefix;
        String rawname = null != prefix && !"".equals(prefix) ? prefix + ':' + name : name;
        QName element = new QName(prefix, name, rawname, base.uri);
        return element;
    }

    void insertEndElement(String name, QName base) {
        QName element = this.createQName(name, base);
        HTMLAugmentations augs = new HTMLAugmentations();
        super.endElement(element, (Augmentations)augs);
    }

    private class BaseHtmlCorrectionState
    implements HtmlCorrectionState {
        private int depth = 0;
        private HtmlCorrectionState previsiosState;

        public BaseHtmlCorrectionState(HtmlCorrectionState previsiosState) {
            this.previsiosState = previsiosState;
        }

        @Override
        public void endElement(QName element, Augmentations augs) throws XNIException {
            --this.depth;
            if (this.depth < 0 && this.previsiosState != null) {
                HtmlCorrectionFilter.this._state = this.previsiosState;
            }
        }

        @Override
        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (element.rawname.equalsIgnoreCase("table")) {
                HtmlCorrectionFilter.this._state = new TableHtmlCorrectionState(this);
            } else {
                ++this.depth;
            }
        }
    }

    private class TableHtmlCorrectionState
    implements HtmlCorrectionState {
        private int depth = 0;
        private boolean inTbody = false;
        private HtmlCorrectionState previsiosState;

        public TableHtmlCorrectionState(HtmlCorrectionState previsiosState) {
            this.previsiosState = previsiosState;
        }

        @Override
        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.inTbody) {
                HtmlCorrectionFilter.this.insertEndElement("tbody", element);
            }
            HtmlCorrectionFilter.this._state = this.previsiosState;
        }

        @Override
        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (element.rawname.equalsIgnoreCase("tr")) {
                if (!this.inTbody) {
                    this.inTbody = true;
                    HtmlCorrectionFilter.this.insertStartElement("tbody", element);
                }
            } else if (this.inTbody) {
                HtmlCorrectionFilter.this.insertEndElement("tbody", element);
                this.inTbody = false;
            }
            HtmlCorrectionFilter.this._state = new BaseHtmlCorrectionState(this);
        }
    }
}

