/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

public abstract class CacheableTreeDataModel<T>
extends TreeDataModel<T> {
    private Log log = LogFactory.getLog(CacheableTreeDataModel.class);
    private static final DataVisitor NULL_VISITOR = new DataVisitor(){

        @Override
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
        }
    };
    private TreeDataModel<T> treeDataModel;

    @Override
    public boolean isLeaf() {
        TreeRowKey rowKey = (TreeRowKey)this.getRowKey();
        T treeNode = this.locateTreeNode(rowKey);
        if (treeNode != null && !this.nodeAdaptor.isLeaf(treeNode)) {
            return false;
        }
        treeNode = this.treeDataModel.locateTreeNode(rowKey);
        if (treeNode != null) {
            return this.nodeAdaptor.isLeaf(treeNode);
        }
        return false;
    }

    public CacheableTreeDataModel(TreeDataModel<T> model, TreeDataModel.MissingNodeHandler<T> missingNodeHandler) {
        super(model.getClazz(), model.getNodeAdaptor(), missingNodeHandler);
        this.setWrappedData(missingNodeHandler.handleMissingNode(null, null));
        this.setTreeDataModel(model);
    }

    @Override
    public void walkModel(FacesContext context, DataVisitor visitor, Range range, Object key, Object argument, boolean last) throws IOException {
        this.treeDataModel.walkModel(context, visitor, range, key, argument, last);
    }

    public void setTreeDataModel(TreeDataModel<T> treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    public TreeDataModel<T> getTreeDataModel() {
        return this.treeDataModel;
    }

    @Override
    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        T cachedTreeNode = this.locateTreeNode((TreeRowKey)rowKey);
        T treeNode = this.treeDataModel.locateTreeNode((TreeRowKey)rowKey);
        if (treeNode != null) {
            if (cachedTreeNode == null || this.nodeAdaptor.isLeaf(cachedTreeNode) && !this.nodeAdaptor.isLeaf(treeNode)) {
                this.treeDataModel.walk(context, new CacheFillingVisitor(), range, rowKey, argument, last);
            }
            super.walk(context, dataVisitor, range, rowKey, argument, last);
        }
    }

    public void setTransient(boolean newTransientValue) {
        if (!newTransientValue) {
            throw new IllegalArgumentException("ReplaceableTreeDataModel shouldn't be transient!");
        }
    }

    protected abstract void setDefaultNodeData(T var1, Object var2);

    @Override
    public Object convertToKey(FacesContext context, String keyString, UIComponent component, Converter converter) {
        Object convertedKey = this.treeDataModel.convertToKey(context, keyString, component, converter);
        if (convertedKey != null) {
            final TreeRowKey treeRowKey = (TreeRowKey)convertedKey;
            try {
                this.walk(context, NULL_VISITOR, new TreeRange(){

                    @Override
                    public boolean processChildren(TreeRowKey rowKey) {
                        return rowKey == null || rowKey.isSubKey(treeRowKey);
                    }

                    @Override
                    public boolean processNode(TreeRowKey rowKey) {
                        return this.processChildren(rowKey) || rowKey.equals(treeRowKey);
                    }
                }, null);
            }
            catch (IOException e) {
                context.getExternalContext().log(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return convertedKey;
    }

    @Override
    public T locateTreeNode(TreeRowKey rowKey) {
        return this.locateTreeNode(rowKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(Object parentRowKey, TreeNode newNode, Object id) {
        super.addNode(parentRowKey, newNode, id);
        if (this.treeDataModel != null) {
            Object savedRowKey = this.treeDataModel.getRowKey();
            try {
                this.treeDataModel.setRowKey(this.getRowKey());
                this.treeDataModel.addNode(parentRowKey, newNode, id);
            }
            finally {
                try {
                    this.treeDataModel.setRowKey(savedRowKey);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(Object rowKey) {
        super.removeNode(rowKey);
        if (this.treeDataModel != null) {
            Object savedRowKey = this.treeDataModel.getRowKey();
            try {
                this.treeDataModel.setRowKey(this.getRowKey());
                this.treeDataModel.removeNode(rowKey);
            }
            finally {
                try {
                    this.treeDataModel.setRowKey(savedRowKey);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNode getModelTreeNode() {
        TreeNode node = null;
        if (this.treeDataModel != null) {
            Object savedRowKey = this.treeDataModel.getRowKey();
            try {
                this.treeDataModel.setRowKey(this.getRowKey());
                node = this.treeDataModel.getModelTreeNode();
            }
            finally {
                try {
                    this.treeDataModel.setRowKey(savedRowKey);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return node;
    }

    private final class CacheFillingVisitor
    implements DataVisitor {
        private CacheFillingVisitor() {
        }

        @Override
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeRowKey treeRowKey = (TreeRowKey)rowKey;
            CacheableTreeDataModel.this.treeDataModel.setRowKey(treeRowKey);
            CacheableTreeDataModel.this.setDefaultNodeData(CacheableTreeDataModel.this.locateTreeNode(treeRowKey, true), CacheableTreeDataModel.this.treeDataModel.getRowData());
        }
    }
}

