/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import org.richfaces.model.CacheableTreeDataModel;
import org.richfaces.model.CacheableTreeNodeImpl;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRowKey;

public class ClassicCacheableTreeDataModel
extends CacheableTreeDataModel<TreeNode> {
    private static final TreeDataModel.MissingNodeHandler<TreeNode> missingNodeHandler = new TreeDataModel.MissingNodeHandler<TreeNode>(){

        @Override
        public TreeNode handleMissingNode(TreeNode parentNode, Object pathSegment) {
            CacheableTreeNodeImpl childNode = new CacheableTreeNodeImpl();
            if (parentNode != null) {
                parentNode.addChild(pathSegment, childNode);
            }
            return childNode;
        }
    };

    public ClassicCacheableTreeDataModel(TreeDataModel<TreeNode> model) {
        super(model, missingNodeHandler);
    }

    @Override
    protected void setDefaultNodeData(TreeNode node, Object data) {
        if (node != null) {
            CacheableTreeNodeImpl cacheableTreeNode = (CacheableTreeNodeImpl)node;
            cacheableTreeNode.setData(data);
            cacheableTreeNode.setNotLeaf(!this.isLeaf());
        }
    }

    @Override
    public TreeNode getTreeNode() {
        if (this.isRowAvailable()) {
            return (TreeNode)this.locateTreeNode((TreeRowKey)this.getRowKey());
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }
}

