/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.Serializable;
import org.richfaces.model.ComplexTreeRowKey;

public class StackingTreeModelKey<T>
implements Serializable,
ComplexTreeRowKey {
    private static final long serialVersionUID = -6821854350257816571L;
    protected T modelKey;
    protected String modelId;

    public StackingTreeModelKey(String modelId, T modelKey) {
        this.modelId = modelId;
        this.modelKey = modelKey;
    }

    public String toString() {
        return this.modelId + ':' + this.modelKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
        result = 31 * result + (this.modelKey == null ? 0 : this.modelKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackingTreeModelKey other = (StackingTreeModelKey)obj;
        if (this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId)) {
            return false;
        }
        return !(this.modelKey == null ? other.modelKey != null : !this.modelKey.equals(other.modelKey));
    }

    public String getModelId() {
        return this.modelId;
    }

    public Object getModelKey() {
        return this.modelKey;
    }

    @Override
    public int getKeySegmentsCount() {
        return 2;
    }

    @Override
    public Object getKeySegment(int i) {
        switch (i) {
            case 0: {
                return this.modelId;
            }
            case 1: {
                return this.modelKey;
            }
        }
        throw new IllegalArgumentException(String.valueOf(i));
    }
}

