/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.richfaces.javacc.RichMacroDefinition;
import org.richfaces.json.JSContentHandler;
import org.richfaces.renderkit.Expression;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MacroDefinitionJSContentHandler
extends JSContentHandler {
    private String prolog;
    private String epilog;

    public MacroDefinitionJSContentHandler(Writer writer, String prolog, String epilog) {
        super(writer);
        this.prolog = prolog;
        this.epilog = epilog;
    }

    protected List<?> parseExpressiion(String expressionString) throws SAXException {
        try {
            if (expressionString.length() != 0) {
                List result = new RichMacroDefinition(new StringReader(expressionString)).expression();
                return result;
            }
            ArrayList<String> list = new ArrayList<String>(1);
            list.add("");
            return list;
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void encodeExpressionString(String string) throws IOException, SAXException {
        List<?> parsedExpressiion = this.parseExpressiion(string);
        boolean isExpression = false;
        for (Object next : parsedExpressiion) {
            if (!(next instanceof Expression)) continue;
            isExpression = true;
            break;
        }
        if (isExpression) {
            this.outputWriter.write("function (context) { return ");
        }
        boolean first = true;
        for (Object next : parsedExpressiion) {
            if (next == null) continue;
            if (!first) {
                this.outputWriter.write(43);
            }
            if (next instanceof Expression) {
                Expression macroExpression = (Expression)next;
                this.outputWriter.write(this.prolog);
                this.encode(macroExpression.getExpression().toString());
                this.outputWriter.write(this.epilog);
            } else {
                this.outputWriter.write(39);
                this.encode(next.toString());
                this.outputWriter.write(39);
            }
            first = false;
        }
        if (isExpression) {
            this.outputWriter.write(";}");
        }
    }

    @Override
    protected void encodeAttributeValue(Attributes attributes, int idx) throws SAXException, IOException {
        String value = attributes.getValue(idx);
        this.encodeExpressionString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isProcessingCdata()) {
            super.characters(ch, start, length);
        } else {
            oldWriter = this.outputWriter;
            this.outputWriter = new WellFormedWriter(oldWriter);
            try {
                parsedExpression = this.parseExpressiion(new String(ch, start, length));
                iterator = parsedExpression.iterator();
                while (iterator.hasNext()) {
                    next = iterator.next();
                    if (next instanceof Expression) {
                        expression = (Expression)next;
                        if (this.isBeforeDocumentStart() || this.level < 0) {
                            return;
                        }
                        try {
                            if (this.level != 0 && !this.closeElement(false) && !this.isProcessingCdata()) {
                                this.outputWriter.write(44);
                            }
                            if (!this.isProcessingCdata()) {
                                this.outputWriter.write("new ET(");
                            }
                            this.outputWriter.write("function (context) { return ");
                            this.outputWriter.write(this.prolog);
                            this.encode(expression.getExpression().toString());
                            this.outputWriter.write(this.epilog);
                            this.outputWriter.write("}");
                            if (this.isProcessingCdata()) ** GOTO lbl32
                            this.outputWriter.write(")");
                        }
                        catch (IOException e) {
                            throw new SAXException("Write error", e);
                        }
                    } else {
                        cs = next.toString().toCharArray();
                        super.characters(cs, 0, cs.length);
                    }
lbl32:
                    // 3 sources

                    if (!iterator.hasNext()) continue;
                    try {
                        this.outputWriter.write(44);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this.outputWriter = oldWriter;
            }
        }
    }

    @Override
    protected void encodeText(char[] chars, int start, int length) throws SAXException, IOException {
        if (!this.isProcessingCdata()) {
            String str = new String(chars, start, length);
            this.encodeExpressionString(str);
        } else {
            super.encodeText(chars, start, length);
        }
    }

    static class WellFormedWriter
    extends FilterWriter {
        private char lastChar;

        public WellFormedWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            while (cbuf[off] == this.lastChar && this.lastChar == ',' && len > 0) {
                ++off;
                --len;
            }
            while (len > 1 && cbuf[off] == cbuf[off + 1] && cbuf[off] == ',') {
                --len;
                ++off;
            }
            super.write(cbuf, off, len);
            this.lastChar = cbuf[off + len - 1];
        }

        @Override
        public void write(int c) throws IOException {
            if (c != this.lastChar || this.lastChar != ',') {
                super.write(c);
                this.lastChar = (char)c;
            }
        }
    }
}

