/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.richfaces.skin.BasicSkinImpl;
import org.richfaces.skin.Skin;

public abstract class AbstractChainableSkinImpl
extends BasicSkinImpl {
    private static final Operation RESOLVE = new Operation(){

        @Override
        public Object doExternalCall(FacesContext context, Skin impl, String name) {
            return impl.getParameter(context, name);
        }

        @Override
        public Object doLocalCall(FacesContext context, AbstractChainableSkinImpl impl, String name) {
            return impl.localResolveSkinParameter(context, name);
        }
    };
    private static final Operation CONTAINS = new Operation(){

        private Object wrapBoolean(boolean value) {
            return value ? Boolean.TRUE : null;
        }

        @Override
        public Object doExternalCall(FacesContext context, Skin impl, String name) {
            return this.wrapBoolean(impl.containsProperty(name));
        }

        @Override
        public Object doLocalCall(FacesContext context, AbstractChainableSkinImpl impl, String name) {
            return this.wrapBoolean(impl.localContainsProperty(context, name));
        }
    };

    AbstractChainableSkinImpl(Map properties) {
        super(properties);
    }

    protected abstract Skin getBaseSkin(FacesContext var1);

    protected Object localResolveSkinParameter(FacesContext context, String name) {
        return this.getSkinParams().get(name);
    }

    protected boolean localContainsProperty(FacesContext context, String name) {
        return this.getSkinParams().containsKey(name);
    }

    protected Object executeOperation(FacesContext context, Operation operation, String name, int[] singleInt) {
        Skin baseSkin;
        int n = singleInt[0];
        singleInt[0] = n + 1;
        if (n > 1000) {
            throw new FacesException(Messages.getMessage("SKIN_CYCLIC_REFERENCE", name));
        }
        Object object = operation.doLocalCall(context, this, name);
        if (object == null && (baseSkin = this.getBaseSkin(context)) != null) {
            if (baseSkin instanceof AbstractChainableSkinImpl) {
                AbstractChainableSkinImpl skinImpl = (AbstractChainableSkinImpl)baseSkin;
                object = operation.doChainedCall(context, skinImpl, name, singleInt);
            } else {
                object = operation.doExternalCall(context, baseSkin, name);
            }
        }
        return object;
    }

    protected Object resolveSkinParameter(FacesContext context, String name, int[] singleInt) {
        return this.executeOperation(context, RESOLVE, name, singleInt);
    }

    protected boolean containsProperty(FacesContext context, String name, int[] singleInt) {
        return Boolean.TRUE.equals(this.executeOperation(context, CONTAINS, name, singleInt));
    }

    @Override
    protected Object resolveSkinParameter(FacesContext context, String name) {
        String string;
        int[] singleInt = new int[]{0};
        Object resolvedParameter = this.resolveSkinParameter(context, name, singleInt);
        while (resolvedParameter instanceof String && (string = (String)resolvedParameter).length() > 0 && string.charAt(0) == '&') {
            resolvedParameter = this.resolveSkinParameter(context, string.substring(1), singleInt);
            if (resolvedParameter != null) continue;
            throw new FacesException(Messages.getMessage("SKIN_ILLEGAL_REFERENCE", name));
        }
        return resolvedParameter;
    }

    @Override
    public boolean containsProperty(String name) {
        return this.containsProperty(FacesContext.getCurrentInstance(), name, new int[]{0});
    }

    @Override
    protected int computeHashCode(FacesContext context) {
        int hash = super.computeHashCode(context);
        Skin baseSkin = this.getBaseSkin(context);
        if (baseSkin != null) {
            hash = 31 * hash + baseSkin.hashCode(context);
        }
        return hash;
    }

    private static abstract class Operation {
        private Operation() {
        }

        public Object doChainedCall(FacesContext context, AbstractChainableSkinImpl impl, String name, int[] singleInt) {
            return impl.executeOperation(context, this, name, singleInt);
        }

        public abstract Object doLocalCall(FacesContext var1, AbstractChainableSkinImpl var2, String var3);

        public abstract Object doExternalCall(FacesContext var1, Skin var2, String var3);
    }
}

