/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.ContestoEnum;
import org.openspcoop2.core.config.rs.server.model.ListaScope;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.config.rs.server.model.Scope;

@Path(value="/")
public interface ScopeApi {
    @POST
    @Path(value="/scope")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di uno scope", tags={"scope"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void createScope(@Valid Scope var1);

    @DELETE
    @Path(value="/scope/{nome}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina uno scope", tags={"scope"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Scope eliminato con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void deleteScope(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1);

    @GET
    @Path(value="/scope")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca scope", tags={"scope"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaScope.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaScope findAllScope(@QueryParam(value="q") String var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="offset") @DefaultValue(value="0") Integer var3, @QueryParam(value="contesto") ContestoEnum var4);

    @GET
    @Path(value="/scope/{nome}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di uno scope", tags={"scope"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati dello scope restituiti con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public Scope getScope(@PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var1);

    @PUT
    @Path(value="/scope/{nome}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di uno scope", tags={"scope"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Lo scope \u00e8 stato aggiornato correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public void updateScope(@Valid Scope var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2);
}

