/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl;

import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.StringProperty;

public class ProtocolPropertiesHelper {
    private ProtocolPropertiesHelper() {
    }

    private static String getPropertyPrefix(String key) {
        return "Property " + key + " ";
    }

    private static Object returnProperty(boolean permitReturnNull, String key, AbstractProperty<?> prop, String expectedClassName) throws CoreException {
        if (permitReturnNull && prop == null) {
            return null;
        }
        throw new CoreException(ProtocolPropertiesHelper.getPropertyPrefix(key) + "non \u00e8 " + expectedClassName + ": " + (prop != null ? prop.getClass().getName() : "null prop"));
    }

    public static Boolean getBooleanProperty(Map<String, AbstractProperty<?>> p, String key, boolean required) throws CoreException {
        return ProtocolPropertiesHelper.getBooleanProperty(p, key, required, false);
    }

    public static Boolean getBooleanProperty(Map<String, AbstractProperty<?>> p, String key, boolean required, boolean permitReturnNull) throws CoreException {
        AbstractProperty prop = ProtocolPropertiesHelper.getProperty(p, key, required);
        if (prop instanceof BooleanProperty) {
            return (Boolean)((BooleanProperty)prop).getValue();
        }
        return (Boolean)ProtocolPropertiesHelper.returnProperty(permitReturnNull, key, prop, "Boolean");
    }

    public static String getStringProperty(Map<String, AbstractProperty<?>> p, String key, boolean required) throws CoreException {
        AbstractProperty prop = ProtocolPropertiesHelper.getProperty(p, key, required);
        if (prop == null) {
            return null;
        }
        if (prop instanceof StringProperty) {
            return (String)((StringProperty)prop).getValue();
        }
        throw new CoreException(ProtocolPropertiesHelper.getPropertyPrefix(key) + "non \u00e8 una StringProperty:" + prop.getClass().getName());
    }

    public static byte[] getByteArrayProperty(Map<String, AbstractProperty<?>> p, String key, boolean required) throws CoreException {
        byte[] empty = null;
        AbstractProperty prop = ProtocolPropertiesHelper.getProperty(p, key, required);
        if (prop == null) {
            return empty;
        }
        if (prop instanceof BinaryProperty) {
            return (byte[])((BinaryProperty)prop).getValue();
        }
        throw new CoreException(ProtocolPropertiesHelper.getPropertyPrefix(key) + "non \u00e8 una BinaryProperty:" + prop.getClass().getName());
    }

    public static Integer getIntegerProperty(Map<String, AbstractProperty<?>> p, String key, boolean required) throws CoreException {
        AbstractProperty prop = ProtocolPropertiesHelper.getProperty(p, key, required);
        if (prop == null) {
            return null;
        }
        if (prop instanceof NumberProperty) {
            return ((Long)((NumberProperty)prop).getValue()).intValue();
        }
        throw new CoreException(ProtocolPropertiesHelper.getPropertyPrefix(key) + "non \u00e8 una NumberProperty:" + prop.getClass().getName());
    }

    public static AbstractProperty getProperty(Map<String, AbstractProperty<?>> p, String key, boolean required) throws CoreException {
        if (p.containsKey(key)) {
            return p.get(key);
        }
        if (required) {
            throw new CoreException(ProtocolPropertiesHelper.getPropertyPrefix(key) + "non trovata");
        }
        return null;
    }
}

