/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.rs.server.api.impl.ProtocolPropertiesHelper;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiApiServiceImpl;
import org.openspcoop2.core.config.rs.server.api.impl.api.ApiEnv;
import org.openspcoop2.core.config.rs.server.model.Api;
import org.openspcoop2.core.config.rs.server.model.ApiAzione;
import org.openspcoop2.core.config.rs.server.model.ApiModI;
import org.openspcoop2.core.config.rs.server.model.ApiModIAzioneSoap;
import org.openspcoop2.core.config.rs.server.model.ApiModIPatternInterazioneAPIRest;
import org.openspcoop2.core.config.rs.server.model.ApiModIPatternInterazioneCorrelazioneRest;
import org.openspcoop2.core.config.rs.server.model.ApiModIPatternInterazioneCorrelazioneSoap;
import org.openspcoop2.core.config.rs.server.model.ApiModIPatternInterazioneRest;
import org.openspcoop2.core.config.rs.server.model.ApiModIPatternInterazioneSoap;
import org.openspcoop2.core.config.rs.server.model.ApiModIRisorsaRest;
import org.openspcoop2.core.config.rs.server.model.ApiModISicurezzaCanale;
import org.openspcoop2.core.config.rs.server.model.ApiModISicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ApiModISicurezzaMessaggioApplicabilitaCustom;
import org.openspcoop2.core.config.rs.server.model.ApiModISicurezzaMessaggioOperazione;
import org.openspcoop2.core.config.rs.server.model.ApiModISicurezzaMessaggioOperazioneRidefinito;
import org.openspcoop2.core.config.rs.server.model.ApiRisorsa;
import org.openspcoop2.core.config.rs.server.model.HttpMethodEnum;
import org.openspcoop2.core.config.rs.server.model.ModIPatternInterazioneEnum;
import org.openspcoop2.core.config.rs.server.model.ModIPatternInterazioneFunzioneEnum;
import org.openspcoop2.core.config.rs.server.model.ModIPatternInterazioneTipoEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaCanaleEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioApplicabilitaCustomEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioApplicabilitaEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioGenerazioneTokenEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioOperazioneEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioPatternAuditEnum;
import org.openspcoop2.core.config.rs.server.model.ModISicurezzaMessaggioRestHeaderEnum;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.utils.AzioniUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.properties.ModIProfiliInterazioneRESTConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModiApiApiHelper {
    private static final String SPECIFICARE_CONFIGURAZIONE_MODI = "Specificare la configurazione 'ModI'";

    private ModiApiApiHelper() {
    }

    private static String getErroreAuditPatternSpecificatoConPattern(ModISicurezzaMessaggioPatternAuditEnum auditPattern, ModISicurezzaMessaggioEnum pattern) {
        return "sicurezza_messaggio.informazioni_utente (audit-pattern: " + String.valueOf((Object)auditPattern) + ") specificato con pattern " + String.valueOf((Object)pattern);
    }

    private static String getErroreAuditPatternSpecificatoConApplicabilita(ModISicurezzaMessaggioApplicabilitaEnum applicabilita) {
        return "sicurezza_messaggio.informazioni_utente specificato con applicabilit\u00e0 " + String.valueOf((Object)applicabilita);
    }

    private static String getErroreAuditPatternRichiedeTokenNonLocale(ModISicurezzaMessaggioPatternAuditEnum auditPattern) {
        return "sicurezza_messaggio.informazioni_utente con audit-pattern '" + String.valueOf((Object)auditPattern) + "' richiede la generazione di un token oauth o pdnd";
    }

    private static String getErroreDigestRichiestaSpecificatoConPatternApplicabilita(ModISicurezzaMessaggioEnum pattern, ModISicurezzaMessaggioApplicabilitaEnum applicabilita) {
        return "sicurezza_messaggio.digest_richiesta specificato con pattern " + String.valueOf((Object)pattern) + " o applicabilita " + String.valueOf((Object)applicabilita);
    }

    public static void populateApiAzioneWithProtocolInfo(AccordoServizioParteComune as, Operation az, ApiEnv env, ApiAzione ret) throws CoreException, DriverRegistroServiziException, ProtocolException, DriverConfigurazioneException, ValidationException, UtilsException {
        HashMap p = new HashMap();
        Optional<PortType> portType = as.getPortTypeList().stream().filter(pt -> pt.getId().equals(az.getIdPortType())).findAny();
        if (!portType.isPresent()) {
            throw FaultCode.ERRORE_INTERNO.toException("Port type non trovato");
        }
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
        IDPortTypeAzione idPortTypeAzione = new IDPortTypeAzione();
        IDPortType idPortType = new IDPortType();
        idPortType.setIdAccordo(idAccordoFromAccordo);
        idPortType.setNome(portType.get().getNome());
        idPortTypeAzione.setIdPortType(idPortType);
        idPortTypeAzione.setNome(az.getNome());
        ConsoleConfiguration consoleConf = ApiApiHelper.getConsoleConfiguration(env, idPortTypeAzione);
        ProtocolProperties prop = env.apcHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)az.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        ApiModIAzioneSoap apimodi = new ApiModIAzioneSoap();
        ApiModIPatternInterazioneSoap interazione = new ApiModIPatternInterazioneSoap();
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("crud")) {
            interazione.setPattern(ModIPatternInterazioneEnum.CRUD);
        } else if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("bloccante")) {
            interazione.setPattern(ModIPatternInterazioneEnum.BLOCCANTE);
        } else if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("nonBloccante")) {
            ModIPatternInterazioneTipoEnum tipo = ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncProfile", true).equals("PULL") ? ModIPatternInterazioneTipoEnum.PULL : ModIPatternInterazioneTipoEnum.PUSH;
            interazione.setTipo(tipo);
            ModIPatternInterazioneFunzioneEnum funzione = ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncRole", true).equals("Richiesta") ? ModIPatternInterazioneFunzioneEnum.RICHIESTA : ModIPatternInterazioneFunzioneEnum.RISPOSTA;
            interazione.setFunzione(funzione);
            if (funzione.equals((Object)ModIPatternInterazioneFunzioneEnum.RISPOSTA)) {
                interazione.setAzioneCorrelata(ModiApiApiHelper.getAzioneCorrelata(p, env));
            }
            interazione.setPattern(ModIPatternInterazioneEnum.NON_BLOCCANTE);
        }
        apimodi.setInterazione(interazione);
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageProfileActionMode", true).equals("default")) {
            ApiModISicurezzaMessaggioOperazione op = new ApiModISicurezzaMessaggioOperazione();
            op.setStato(ModISicurezzaMessaggioOperazioneEnum.API);
            apimodi.setSicurezzaMessaggio(op);
        } else {
            ApiModISicurezzaMessaggioOperazioneRidefinito rid = new ApiModISicurezzaMessaggioOperazioneRidefinito();
            rid.setStato(ModISicurezzaMessaggioOperazioneEnum.RIDEFINITO);
            rid.setConfigurazione(ModiApiApiHelper.getSicurezzaMessaggio(p, true));
            apimodi.setSicurezzaMessaggio(rid);
        }
        ret.setModi(apimodi);
    }

    public static void populateApiRisorsaWithProtocolInfo(AccordoServizioParteComune as, Resource res, ApiEnv env, ApiRisorsa ret) throws DriverRegistroServiziException, ProtocolException, DriverConfigurazioneException, CoreException, RegistryNotFound, RegistryException, ValidationException, UtilsException {
        HashMap p = new HashMap();
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
        IDResource idres = new IDResource();
        idres.setIdAccordo(idAccordoFromAccordo);
        idres.setNome(res.getNome());
        ConsoleConfiguration consoleConf = ApiApiHelper.getConsoleConfiguration(env, idres, res.getMethod() != null ? res.getMethod().toString() : null, res.getPath());
        ProtocolProperties prop = env.apcHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)res.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        ApiModIRisorsaRest apimodi = new ApiModIRisorsaRest();
        ApiModIPatternInterazioneRest interazione = new ApiModIPatternInterazioneRest();
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("crud")) {
            interazione.setPattern(ModIPatternInterazioneEnum.CRUD);
        } else if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("bloccante")) {
            interazione.setPattern(ModIPatternInterazioneEnum.BLOCCANTE);
        } else if (ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionProfile", true).equals("nonBloccante")) {
            ModIPatternInterazioneTipoEnum tipo = ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncProfile", true).equals("PULL") ? ModIPatternInterazioneTipoEnum.PULL : ModIPatternInterazioneTipoEnum.PUSH;
            interazione.setTipo(tipo);
            ModIPatternInterazioneFunzioneEnum funzione = ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncRole", true).equals("Richiesta") ? ModIPatternInterazioneFunzioneEnum.RICHIESTA : ModIPatternInterazioneFunzioneEnum.RISPOSTA;
            interazione.setFunzione(funzione);
            if (funzione.equals((Object)ModIPatternInterazioneFunzioneEnum.RISPOSTA)) {
                interazione.setRisorsaCorrelata(ModiApiApiHelper.getRisorsaCorrelata(p, env));
            }
            interazione.setPattern(ModIPatternInterazioneEnum.NON_BLOCCANTE);
        }
        apimodi.setInterazione(interazione);
        if (ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageProfileActionMode", true).equals("default")) {
            ApiModISicurezzaMessaggioOperazione op = new ApiModISicurezzaMessaggioOperazione();
            op.setStato(ModISicurezzaMessaggioOperazioneEnum.API);
            apimodi.setSicurezzaMessaggio(op);
        } else {
            ApiModISicurezzaMessaggioOperazioneRidefinito rid = new ApiModISicurezzaMessaggioOperazioneRidefinito();
            rid.setStato(ModISicurezzaMessaggioOperazioneEnum.RIDEFINITO);
            rid.setConfigurazione(ModiApiApiHelper.getSicurezzaMessaggio(p, false));
            apimodi.setSicurezzaMessaggio(rid);
        }
        ret.setModi(apimodi);
    }

    private static ApiModIPatternInterazioneCorrelazioneRest getRisorsaCorrelata(Map<String, AbstractProperty<?>> p, ApiEnv env) throws DriverRegistroServiziException, CoreException, RegistryNotFound, RegistryException, DriverConfigurazioneException {
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromUri(ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncApiRequest", true));
        IDResource id = new IDResource();
        id.setIdAccordo(idAccordoFromAccordo);
        id.setNome(ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncActionRequest", true));
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        Resource resource = registryReader.getResourceAccordo(id);
        ApiModIPatternInterazioneCorrelazioneRest risorsaCorrelata = new ApiModIPatternInterazioneCorrelazioneRest();
        risorsaCorrelata.setApiNome(idAccordoFromAccordo.getNome());
        risorsaCorrelata.setApiVersione(idAccordoFromAccordo.getVersione());
        HttpMethodEnum method = HttpMethodEnum.QUALSIASI;
        if (resource.getMethod() != null) {
            switch (resource.getMethod()) {
                case DELETE: {
                    method = HttpMethodEnum.DELETE;
                    break;
                }
                case GET: {
                    method = HttpMethodEnum.GET;
                    break;
                }
                case HEAD: {
                    method = HttpMethodEnum.HEAD;
                    break;
                }
                case LINK: {
                    method = HttpMethodEnum.LINK;
                    break;
                }
                case OPTIONS: {
                    method = HttpMethodEnum.OPTIONS;
                    break;
                }
                case PATCH: {
                    method = HttpMethodEnum.PATCH;
                    break;
                }
                case POST: {
                    method = HttpMethodEnum.POST;
                    break;
                }
                case PUT: {
                    method = HttpMethodEnum.PUT;
                    break;
                }
                case TRACE: {
                    method = HttpMethodEnum.TRACE;
                    break;
                }
                case UNLINK: {
                    method = HttpMethodEnum.UNLINK;
                }
            }
        }
        risorsaCorrelata.setRisorsaHttpMethod(method);
        risorsaCorrelata.setRisorsaPath(resource.getPath());
        return risorsaCorrelata;
    }

    private static ApiModIPatternInterazioneCorrelazioneSoap getAzioneCorrelata(Map<String, AbstractProperty<?>> p, ApiEnv env) throws DriverRegistroServiziException, CoreException {
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromUri(ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncApiRequest", true));
        ApiModIPatternInterazioneCorrelazioneSoap risorsaCorrelata = new ApiModIPatternInterazioneCorrelazioneSoap();
        risorsaCorrelata.setApiNome(idAccordoFromAccordo.getNome());
        risorsaCorrelata.setApiVersione(idAccordoFromAccordo.getVersione());
        risorsaCorrelata.setServizio(ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncServiceRequest", true));
        risorsaCorrelata.setAzione(ProtocolPropertiesHelper.getStringProperty(p, "modipaInteractionAsyncActionRequest", true));
        return risorsaCorrelata;
    }

    public static ApiModI getApiModI(AccordoServizioParteComune as, ProfiloEnum profilo, ApiEnv env) throws DriverRegistroServiziException, ProtocolException, DriverConfigurazioneException, CoreException, ValidationException, UtilsException {
        Boolean bulkValue;
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Operazione utilizzabile solamente con Profilo 'ModI'");
        }
        HashMap p = new HashMap();
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromAccordo(as);
        ConsoleConfiguration consoleConf = ApiApiHelper.getConsoleConfiguration(env, idAccordoFromAccordo);
        ProtocolProperties prop = env.apcHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)as.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        ApiModI apimodi = new ApiModI();
        ApiModISicurezzaCanale sicurezzaCanale = new ApiModISicurezzaCanale();
        String sicurezzaCanalePatternString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityChannelProfile", true);
        sicurezzaCanale.setPattern(sicurezzaCanalePatternString.equals("idac01") ? ModISicurezzaCanaleEnum.AUTH01 : ModISicurezzaCanaleEnum.AUTH02);
        apimodi.setSicurezzaCanale(sicurezzaCanale);
        boolean isRest = as.getServiceBinding().equals((Object)ServiceBinding.REST);
        if (isRest && (bulkValue = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaInteractionBulkResource", false)) != null && bulkValue.booleanValue()) {
            ApiModIPatternInterazioneAPIRest interazione = new ApiModIPatternInterazioneAPIRest();
            interazione.setBulk(true);
            apimodi.setInterazione(interazione);
        }
        apimodi.setSicurezzaMessaggio(ModiApiApiHelper.getSicurezzaMessaggio(p, !isRest));
        return apimodi;
    }

    private static ApiModISicurezzaMessaggio getSicurezzaMessaggio(Map<String, AbstractProperty<?>> p, boolean isSOAP) throws CoreException {
        ApiModISicurezzaMessaggio sicurezzaMessaggio = new ApiModISicurezzaMessaggio();
        String sicurezzaMessaggioPatternString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageProfile", true);
        ModISicurezzaMessaggioEnum profiloSicurezzaMessaggioPattern = null;
        if (sicurezzaMessaggioPatternString.equals("idam01")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.AUTH01;
        } else if (sicurezzaMessaggioPatternString.equals("idam02")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.AUTH02;
        } else if (sicurezzaMessaggioPatternString.equals("-")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.DISABILITATO;
        } else if (sicurezzaMessaggioPatternString.equals("idam0301")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH01;
        } else if (sicurezzaMessaggioPatternString.equals("idam0302")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH02;
        } else if (sicurezzaMessaggioPatternString.equals("idam0401")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH01;
        } else if (sicurezzaMessaggioPatternString.equals("idam0402")) {
            profiloSicurezzaMessaggioPattern = ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH02;
        }
        sicurezzaMessaggio.setPattern(profiloSicurezzaMessaggioPattern);
        String sicurezzaMessaggioGnerazioneTokenString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageSorgenteToken", false);
        if (sicurezzaMessaggioGnerazioneTokenString != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggioGnerazioneTokenString)) {
            ModISicurezzaMessaggioGenerazioneTokenEnum generazioneToken = null;
            if (sicurezzaMessaggioGnerazioneTokenString.equals("locale")) {
                generazioneToken = ModISicurezzaMessaggioGenerazioneTokenEnum.LOCALE;
            } else if (sicurezzaMessaggioGnerazioneTokenString.equals("pdnd")) {
                generazioneToken = ModISicurezzaMessaggioGenerazioneTokenEnum.PDND;
            } else if (sicurezzaMessaggioGnerazioneTokenString.equals("oauth")) {
                generazioneToken = ModISicurezzaMessaggioGenerazioneTokenEnum.OAUTH;
            }
            sicurezzaMessaggio.setGenerazioneToken(generazioneToken);
        }
        if (profiloSicurezzaMessaggioPattern != null && !profiloSicurezzaMessaggioPattern.equals((Object)ModISicurezzaMessaggioEnum.DISABILITATO)) {
            if (isSOAP) {
                ModiApiApiHelper.populateSicurezzaMessaggioSOAP(p, sicurezzaMessaggio);
            } else {
                ModiApiApiHelper.populateSicurezzaMessaggioREST(p, sicurezzaMessaggio);
            }
            sicurezzaMessaggio.setDigestRichiesta(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageRequestDigest", true));
            sicurezzaMessaggio.setInformazioniUtente(ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessageCorniceSicurezza", true));
            if (sicurezzaMessaggio.isInformazioniUtente() != null && sicurezzaMessaggio.isInformazioniUtente().booleanValue()) {
                String sicurezzaMessaggioInformazioniUtenteSchemaString;
                String sicurezzaMessaggioInformazioniUtentePatternString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageCorniceSicurezzaPattern", false);
                if (sicurezzaMessaggioInformazioniUtentePatternString != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggioInformazioniUtentePatternString)) {
                    ModISicurezzaMessaggioPatternAuditEnum patternAudit = null;
                    if (sicurezzaMessaggioInformazioniUtentePatternString.equals("old")) {
                        patternAudit = ModISicurezzaMessaggioPatternAuditEnum.LEGACY;
                    } else if (sicurezzaMessaggioInformazioniUtentePatternString.equals("audit01")) {
                        patternAudit = ModISicurezzaMessaggioPatternAuditEnum.REST01;
                    } else if (sicurezzaMessaggioInformazioniUtentePatternString.equals("audit02")) {
                        patternAudit = ModISicurezzaMessaggioPatternAuditEnum.REST02;
                    }
                    sicurezzaMessaggio.setPatternAudit(patternAudit);
                }
                if ((sicurezzaMessaggioInformazioniUtenteSchemaString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageCorniceSicurezzaSchema", false)) != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggioInformazioniUtenteSchemaString)) {
                    sicurezzaMessaggio.setSchemaAudit(sicurezzaMessaggioInformazioniUtenteSchemaString);
                }
            }
        } else {
            sicurezzaMessaggio.setInformazioniUtente(false);
            sicurezzaMessaggio.setDigestRichiesta(false);
            sicurezzaMessaggio.setSoapFirmaAllegati(false);
        }
        return sicurezzaMessaggio;
    }

    private static void populateSicurezzaMessaggioSOAP(Map<String, AbstractProperty<?>> p, ApiModISicurezzaMessaggio sicurezzaMessaggio) throws CoreException {
        ModISicurezzaMessaggioApplicabilitaEnum applicabilita = null;
        String sicurezzaMessaggioApplicabilitaString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageConfig", true);
        if (sicurezzaMessaggioApplicabilitaString.equals("entrambi_attachments")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.QUALSIASI;
            sicurezzaMessaggio.setSoapFirmaAllegati(true);
        } else if (sicurezzaMessaggioApplicabilitaString.equals("richiesta_attachments")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA;
            sicurezzaMessaggio.setSoapFirmaAllegati(true);
        } else if (sicurezzaMessaggioApplicabilitaString.equals("risposta_attachments")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RISPOSTA;
            sicurezzaMessaggio.setSoapFirmaAllegati(true);
        } else if (sicurezzaMessaggioApplicabilitaString.equals("entrambi")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.QUALSIASI;
        } else if (sicurezzaMessaggioApplicabilitaString.equals("richiesta")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA;
        } else if (sicurezzaMessaggioApplicabilitaString.equals("risposta")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RISPOSTA;
        }
        sicurezzaMessaggio.setApplicabilita(applicabilita);
    }

    private static void populateSicurezzaMessaggioREST(Map<String, AbstractProperty<?>> p, ApiModISicurezzaMessaggio sicurezzaMessaggio) throws CoreException {
        ModISicurezzaMessaggioRestHeaderEnum restHeader = null;
        String restHeaderString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageHeaderName", true);
        boolean custom = false;
        if (restHeaderString.equals("modipa")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.AGID;
        } else if (restHeaderString.equals("authorization")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.BEARER;
        } else if (restHeaderString.equals("autonlyreq_modipa")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.AGID_BEARER_REQUEST;
        } else if (restHeaderString.equals("authorization_modipa")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.AGID_BEARER;
        } else if (restHeaderString.equals("custom")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.CUSTOM;
            custom = true;
        } else if (restHeaderString.equals("autonlyreq_custom")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.CUSTOM_BEARER_REQUEST;
            custom = true;
        } else if (restHeaderString.equals("authorization_custom")) {
            restHeader = ModISicurezzaMessaggioRestHeaderEnum.CUSTOM_BEARER;
            custom = true;
        }
        sicurezzaMessaggio.setRestHeader(restHeader);
        if (custom) {
            String restHeaderCustomString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageHeaderCustomName", true);
            sicurezzaMessaggio.setRestHeaderCustom(restHeaderCustomString);
        }
        ModISicurezzaMessaggioApplicabilitaEnum applicabilita = null;
        String sicurezzaMessaggioApplicabilitaString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageConfig", true);
        if (sicurezzaMessaggioApplicabilitaString.equals("entrambi")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.QUALSIASI;
        } else if (sicurezzaMessaggioApplicabilitaString.equals("richiesta")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA;
        } else if (sicurezzaMessaggioApplicabilitaString.equals("risposta")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.RISPOSTA;
        } else if (sicurezzaMessaggioApplicabilitaString.equals("custom")) {
            applicabilita = ModISicurezzaMessaggioApplicabilitaEnum.CUSTOM;
            ApiModISicurezzaMessaggioApplicabilitaCustom appCustom = new ApiModISicurezzaMessaggioApplicabilitaCustom();
            appCustom.setApplicabilita(applicabilita);
            String applicabilitaCustomRichiestaString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityRequest", true);
            ModISicurezzaMessaggioApplicabilitaCustomEnum applicabilitaCustomRichiesta = null;
            if (applicabilitaCustomRichiestaString.equals("true")) {
                applicabilitaCustomRichiesta = ModISicurezzaMessaggioApplicabilitaCustomEnum.ABILITATO;
            } else if (applicabilitaCustomRichiestaString.equals("false")) {
                applicabilitaCustomRichiesta = ModISicurezzaMessaggioApplicabilitaCustomEnum.DISABILITATO;
            } else if (applicabilitaCustomRichiestaString.equals("custom")) {
                applicabilitaCustomRichiesta = ModISicurezzaMessaggioApplicabilitaCustomEnum.CUSTOM;
                appCustom.setRichiestaContentType(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityRequestContentType", true));
            }
            appCustom.setRichiesta(applicabilitaCustomRichiesta);
            String applicabilitaCustomRispostaString = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityResponse", true);
            ModISicurezzaMessaggioApplicabilitaCustomEnum applicabilitaCustomRisposta = null;
            if (applicabilitaCustomRispostaString.equals("true")) {
                applicabilitaCustomRisposta = ModISicurezzaMessaggioApplicabilitaCustomEnum.ABILITATO;
            } else if (applicabilitaCustomRispostaString.equals("false")) {
                applicabilitaCustomRisposta = ModISicurezzaMessaggioApplicabilitaCustomEnum.DISABILITATO;
            } else if (applicabilitaCustomRispostaString.equals("custom")) {
                applicabilitaCustomRisposta = ModISicurezzaMessaggioApplicabilitaCustomEnum.CUSTOM;
                appCustom.setRispostaContentType(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityResponseContentType", true));
                appCustom.setRispostaCodice(ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityResponseReturnCode", true));
            }
            appCustom.setRisposta(applicabilitaCustomRisposta);
            sicurezzaMessaggio.setApplicabilitaCustom(appCustom);
        }
        sicurezzaMessaggio.setApplicabilita(applicabilita);
    }

    public static ProtocolProperties getProtocolProperties(ApiAzione body, AccordoServizioParteComune as, Operation op, ApiEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException, RegistryNotFound, RegistryException {
        return ModiApiApiHelper.getSOAPModiProtocolProperties(body.getModi(), as, op, env);
    }

    public static ProtocolProperties getProtocolProperties(ApiRisorsa body, Resource res, ApiEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverRegistroServiziNotFound, RegistryNotFound, RegistryException {
        return ModiApiApiHelper.getRESTModiProtocolProperties(body.getModi(), res, env);
    }

    public static ProtocolProperties getRESTModiProtocolProperties(ApiModIRisorsaRest modi, Resource res, ApiEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverRegistroServiziNotFound, RegistryNotFound, RegistryException {
        if (modi == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
        }
        ModIProfiliInterazioneRESTConfig config = null;
        ModIProperties modIProperties = null;
        try {
            modIProperties = ModIProperties.getInstance();
            config = new ModIProfiliInterazioneRESTConfig(modIProperties, res.getMethod() != null ? res.getMethod().toString() : null, res);
        }
        catch (ProtocolException e) {
            throw FaultCode.ERRORE_INTERNO.toException(e.getMessage());
        }
        ProtocolProperties p = new ProtocolProperties();
        if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.BLOCCANTE)) {
            if (!config.isCompatibileBloccante()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
            }
            p.addProperty("modipaInteractionProfile", "bloccante");
        } else if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.NON_BLOCCANTE)) {
            boolean isPull = modi.getInterazione().getTipo().equals((Object)ModIPatternInterazioneTipoEnum.PULL);
            boolean isRichiesta = modi.getInterazione().getFunzione().equals((Object)ModIPatternInterazioneFunzioneEnum.RICHIESTA);
            if (isPull) {
                if (!config.isCompatibileNonBloccantePull()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                }
                p.addProperty("modipaInteractionAsyncProfile", "PULL");
                if (isRichiesta) {
                    if (!config.isCompatibileNonBloccantePullRequest()) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                    }
                    p.addProperty("modipaInteractionAsyncRole", "Richiesta");
                } else {
                    if (!config.isCompatibileNonBloccantePullResponse()) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                    }
                    p.addProperty("modipaInteractionAsyncRole", "Risposta");
                }
            } else {
                if (!config.isCompatibileNonBloccantePush()) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                }
                p.addProperty("modipaInteractionAsyncProfile", "PUSH");
                if (isRichiesta) {
                    if (!config.isCompatibileNonBloccantePushRequest()) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                    }
                    p.addProperty("modipaInteractionAsyncRole", "Richiesta");
                } else {
                    if (!config.isCompatibileNonBloccantePushResponse()) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern " + String.valueOf((Object)modi.getInterazione().getPattern()) + " non compatibile");
                    }
                    p.addProperty("modipaInteractionAsyncRole", "Risposta");
                }
            }
            if (!isRichiesta) {
                ModiApiApiHelper.addRisorsaCorrelata(modi.getInterazione().getRisorsaCorrelata(), env, p, isPull);
            }
            p.addProperty("modipaInteractionProfile", "nonBloccante");
        } else if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.CRUD)) {
            p.addProperty("modipaInteractionProfile", "crud");
        }
        if (modi.getSicurezzaMessaggio().getStato().equals((Object)ModISicurezzaMessaggioOperazioneEnum.API)) {
            p.addProperty("modipaSecurityMessageProfileActionMode", "default");
        } else {
            p.addProperty("modipaSecurityMessageProfileActionMode", "ridefinisci");
            ApiModISicurezzaMessaggioOperazioneRidefinito rid = (ApiModISicurezzaMessaggioOperazioneRidefinito)modi.getSicurezzaMessaggio();
            if (!rid.getConfigurazione().getPattern().equals((Object)ModISicurezzaMessaggioEnum.DISABILITATO)) {
                ModiApiApiHelper.getRESTProperties(rid.getConfigurazione(), p, modIProperties);
            }
        }
        return p;
    }

    private static void addRisorsaCorrelata(ApiModIPatternInterazioneCorrelazioneRest corr, ApiEnv env, ProtocolProperties p, boolean isPull) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverRegistroServiziNotFound, RegistryNotFound, RegistryException {
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromValues(corr.getApiNome(), env.idSoggetto.getTipo(), env.idSoggetto.getNome(), corr.getApiVersione());
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        AccordoServizioParteComune accordoServizioFull = env.apcCore.getAccordoServizioFull(idAccordoFromAccordo);
        Resource found = null;
        HttpMethod method = null;
        switch (corr.getRisorsaHttpMethod()) {
            case DELETE: {
                method = HttpMethod.DELETE;
                break;
            }
            case GET: {
                method = HttpMethod.GET;
                break;
            }
            case HEAD: {
                method = HttpMethod.HEAD;
                break;
            }
            case LINK: {
                method = HttpMethod.LINK;
                break;
            }
            case OPTIONS: {
                method = HttpMethod.OPTIONS;
                break;
            }
            case PATCH: {
                method = HttpMethod.PATCH;
                break;
            }
            case POST: {
                method = HttpMethod.POST;
                break;
            }
            case PUT: {
                method = HttpMethod.PUT;
                break;
            }
            case TRACE: {
                method = HttpMethod.TRACE;
                break;
            }
            case UNLINK: {
                method = HttpMethod.UNLINK;
                break;
            }
        }
        for (Resource r : accordoServizioFull.getResourceList()) {
            if (!ModiApiApiHelper.sameResource(r, method, corr.getRisorsaPath())) continue;
            found = r;
        }
        if (found == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Azione non trovata");
        }
        String nomeRisorsa = found.getNome();
        ModiApiApiHelper.checkAzione(idAccordoFromAccordo, null, nomeRisorsa, isPull, registryReader);
        p.addProperty("modipaInteractionAsyncApiRequest", idAccordoFromAccordo.toString());
        p.addProperty("modipaInteractionAsyncActionRequest", nomeRisorsa);
        p.addProperty("modipaInteractionAsyncServiceRequest", "-");
    }

    private static boolean sameResource(Resource r, HttpMethod method, String path) {
        boolean equalsMethod = false;
        equalsMethod = r.getMethod() == null ? method == null : r.getMethod().equals((Object)method);
        return equalsMethod && r.getPath().equals(path);
    }

    public static ProtocolProperties getSOAPModiProtocolProperties(ApiModIAzioneSoap modi, AccordoServizioParteComune as, Operation op, ApiEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException, RegistryNotFound, RegistryException {
        if (modi == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
        }
        ModIProperties modIProperties = null;
        try {
            modIProperties = ModIProperties.getInstance();
        }
        catch (ProtocolException e) {
            throw FaultCode.ERRORE_INTERNO.toException(e.getMessage());
        }
        ProtocolProperties p = new ProtocolProperties();
        if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.BLOCCANTE)) {
            if (modi.getInterazione().getTipo() != null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile specificare interazione.tipo con pattern " + String.valueOf((Object)modi.getInterazione().getPattern()));
            }
            if (modi.getInterazione().getFunzione() != null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile specificare interazione.funzione con pattern " + String.valueOf((Object)modi.getInterazione().getPattern()));
            }
            if (modi.getInterazione().getAzioneCorrelata() != null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile specificare interazione.azione_correlata con funzione " + String.valueOf((Object)modi.getInterazione().getFunzione()));
            }
            p.addProperty("modipaInteractionProfile", "bloccante");
        } else if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.NON_BLOCCANTE)) {
            boolean isPull = modi.getInterazione().getTipo().equals((Object)ModIPatternInterazioneTipoEnum.PULL);
            boolean isRichiesta = modi.getInterazione().getFunzione().equals((Object)ModIPatternInterazioneFunzioneEnum.RICHIESTA);
            if (isPull) {
                p.addProperty("modipaInteractionAsyncProfile", "PULL");
                if (isRichiesta) {
                    p.addProperty("modipaInteractionAsyncRole", "Richiesta");
                } else {
                    p.addProperty("modipaInteractionAsyncRole", "Risposta");
                }
            } else {
                p.addProperty("modipaInteractionAsyncProfile", "PUSH");
                if (isRichiesta) {
                    p.addProperty("modipaInteractionAsyncRole", "Richiesta");
                } else {
                    p.addProperty("modipaInteractionAsyncRole", "Risposta");
                }
            }
            if (!isRichiesta) {
                ModiApiApiHelper.addAzioneCorrelata(modi.getInterazione().getAzioneCorrelata(), env, p, isPull);
            }
            p.addProperty("modipaInteractionProfile", "nonBloccante");
        } else if (modi.getInterazione().getPattern().equals((Object)ModIPatternInterazioneEnum.CRUD)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Pattern interazione CRUD non permesso per servizi SOAP");
        }
        if (modi.getSicurezzaMessaggio().getStato().equals((Object)ModISicurezzaMessaggioOperazioneEnum.API)) {
            p.addProperty("modipaSecurityMessageProfileActionMode", "default");
        } else {
            ApiModISicurezzaMessaggioOperazioneRidefinito rid = (ApiModISicurezzaMessaggioOperazioneRidefinito)modi.getSicurezzaMessaggio();
            p.addProperty("modipaSecurityMessageProfileActionMode", "ridefinisci");
            ModiApiApiHelper.getSOAPProperties(rid.getConfigurazione(), p, modIProperties);
        }
        return p;
    }

    private static void addAzioneCorrelata(ApiModIPatternInterazioneCorrelazioneSoap azioneCorrelata, ApiEnv env, ProtocolProperties p, boolean isPull) throws DriverRegistroServiziException, DriverConfigurazioneException, RegistryNotFound, RegistryException {
        IDAccordo idAccordoFromAccordo = env.idAccordoFactory.getIDAccordoFromValues(azioneCorrelata.getApiNome(), env.idSoggetto.getTipo(), env.idSoggetto.getNome(), azioneCorrelata.getApiVersione());
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        ModiApiApiHelper.checkAzione(idAccordoFromAccordo, azioneCorrelata.getServizio(), azioneCorrelata.getAzione(), isPull, registryReader);
        p.addProperty("modipaInteractionAsyncApiRequest", idAccordoFromAccordo.toString());
        p.addProperty("modipaInteractionAsyncServiceRequest", azioneCorrelata.getServizio());
        p.addProperty("modipaInteractionAsyncActionRequest", azioneCorrelata.getAzione());
    }

    private static void checkAzione(IDAccordo idAccordoFromAccordo, String servizio, String azione, boolean isPull, IRegistryReader registryReader) throws RegistryNotFound, RegistryException, DriverConfigurazioneException {
        AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
        asps.setTipoSoggettoErogatore(idAccordoFromAccordo.getSoggettoReferente().getTipo());
        asps.setNomeSoggettoErogatore(idAccordoFromAccordo.getSoggettoReferente().getNome());
        asps.setNome(idAccordoFromAccordo.getNome());
        asps.setVersione(idAccordoFromAccordo.getVersione());
        asps.setPortType(servizio);
        AccordoServizioParteComune as = registryReader.getAccordoServizioParteComune(idAccordoFromAccordo, false, false);
        AccordoServizioParteComuneSintetico aspc = new AccordoServizioParteComuneSintetico(as);
        Map azioni = AzioniUtils.getAzioniConLabel((AccordoServizioParteSpecifica)asps, (AccordoServizioParteComuneSintetico)aspc, (boolean)false, (boolean)false, new ArrayList(), (String)"-", (String)"-", (Logger)LoggerFactory.getLogger(ApiApiServiceImpl.class));
        if (azioni != null && !azioni.isEmpty()) {
            for (String azioneId : azioni.keySet()) {
                String tmpRelazione;
                String tmpRuolo;
                String tmpInterazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)as, (String)servizio, (String)azioneId, (String)"modipaInteractionProfile");
                if (!"nonBloccante".equals(tmpInterazione) || isPull != "PULL".equals(tmpRuolo = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)as, (String)servizio, (String)azioneId, (String)"modipaInteractionAsyncProfile")) || !"Richiesta".equals(tmpRelazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)as, (String)servizio, (String)azioneId, (String)"modipaInteractionAsyncRole")) || !azioneId.equals(azione)) continue;
                return;
            }
        }
        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Azione non correlabile");
    }

    public static ProtocolProperties getProtocolProperties(Api body) {
        return ModiApiApiHelper.getModiProtocolProperties(body.getModi(), body.getTipoInterfaccia().getProtocollo());
    }

    public static ProtocolProperties updateModiProtocolProperties(AccordoServizioParteComune as, ProfiloEnum profilo, ApiModI modi) {
        if (profilo == null || !profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Operazione utilizzabile solamente con Profilo 'ModI'");
        }
        TipoApiEnum protocollo = as.getFormatoSpecifica().equals((Object)FormatoSpecifica.WSDL_11) ? TipoApiEnum.SOAP : TipoApiEnum.REST;
        return ModiApiApiHelper.getModiProtocolProperties(modi, protocollo);
    }

    private static ProtocolProperties getModiProtocolProperties(ApiModI modi, TipoApiEnum protocollo) {
        if (modi == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(SPECIFICARE_CONFIGURAZIONE_MODI);
        }
        ProtocolProperties p = new ProtocolProperties();
        String chan = modi.getSicurezzaCanale().getPattern().equals((Object)ModISicurezzaCanaleEnum.AUTH01) ? "idac01" : "idac02";
        p.addProperty("modipaSecurityChannelProfile", chan);
        ModIProperties modIProperties = null;
        try {
            modIProperties = ModIProperties.getInstance();
        }
        catch (ProtocolException e) {
            throw FaultCode.ERRORE_INTERNO.toException(e.getMessage());
        }
        if (protocollo.equals((Object)TipoApiEnum.SOAP)) {
            ModiApiApiHelper.getSOAPProperties(modi.getSicurezzaMessaggio(), p, modIProperties);
        } else if (protocollo.equals((Object)TipoApiEnum.REST)) {
            boolean bulk = modi.getInterazione() != null && modi.getInterazione().isBulk() != null && modi.getInterazione().isBulk() != false;
            p.addProperty("modipaInteractionBulkResource", bulk);
            ModiApiApiHelper.getRESTProperties(modi.getSicurezzaMessaggio(), p, modIProperties);
        }
        return p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getRESTProperties(ApiModISicurezzaMessaggio sicurezzaMessaggio, ProtocolProperties p, ModIProperties modIProperties) {
        String profiloSicurezzaMessaggio = null;
        switch (sicurezzaMessaggio.getPattern()) {
            case AUTH01: {
                profiloSicurezzaMessaggio = "idam01";
                break;
            }
            case AUTH02: {
                profiloSicurezzaMessaggio = "idam02";
                break;
            }
            case DISABILITATO: {
                profiloSicurezzaMessaggio = "-";
                break;
            }
            case INTEGRITY01_AUTH01: {
                profiloSicurezzaMessaggio = "idam0301";
                break;
            }
            case INTEGRITY01_AUTH02: {
                profiloSicurezzaMessaggio = "idam0302";
                break;
            }
            case INTEGRITY02_AUTH01: {
                profiloSicurezzaMessaggio = "idam0401";
                break;
            }
            case INTEGRITY02_AUTH02: {
                profiloSicurezzaMessaggio = "idam0402";
            }
        }
        p.addProperty("modipaSecurityMessageProfile", profiloSicurezzaMessaggio);
        boolean cornicePropValue = false;
        boolean digestPropValue = false;
        if (sicurezzaMessaggio.isSoapFirmaAllegati() != null && sicurezzaMessaggio.isSoapFirmaAllegati().booleanValue()) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.soap_firma_allegati specificato con servizio di tipo REST");
        }
        if (!sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.DISABILITATO)) {
            boolean integrityX509 = sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH01) || sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH02);
            boolean integrityKid = sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH01) || sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH02);
            boolean integrity = integrityX509 || integrityKid;
            boolean sorgenteLocale = true;
            if (sicurezzaMessaggio.getGenerazioneToken() != null) {
                String sorgenteToken = null;
                switch (sicurezzaMessaggio.getGenerazioneToken()) {
                    case LOCALE: {
                        sorgenteToken = "locale";
                        if (!integrityKid) break;
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.generazione_token, valorizzato con '" + String.valueOf((Object)sicurezzaMessaggio.getGenerazioneToken()) + "', non \u00e8 compatibile con il pattern '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "'");
                    }
                    case PDND: {
                        sorgenteToken = "pdnd";
                        sorgenteLocale = false;
                        break;
                    }
                    case OAUTH: {
                        sorgenteToken = "oauth";
                        sorgenteLocale = false;
                    }
                }
                p.addProperty("modipaSecurityMessageSorgenteToken", sorgenteToken);
            } else if (integrityKid) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.generazione_token deve essere valorizzato con il pattern '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "'");
            }
            if (sicurezzaMessaggio.getRestHeader() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.rest_header deve essere specificato con servizio di tipo REST e pattern " + String.valueOf((Object)sicurezzaMessaggio.getPattern()));
            }
            boolean applicabilitaInfoUtente = false;
            boolean applicabilitaDigest = false;
            String headerHTTPREST = "";
            boolean custom = false;
            boolean dueHeaderInRequest = false;
            switch (sicurezzaMessaggio.getRestHeader()) {
                case AGID: {
                    headerHTTPREST = "modipa";
                    break;
                }
                case BEARER: {
                    headerHTTPREST = "authorization";
                    break;
                }
                case AGID_BEARER_REQUEST: {
                    headerHTTPREST = "autonlyreq_modipa";
                    dueHeaderInRequest = true;
                    break;
                }
                case AGID_BEARER: {
                    headerHTTPREST = "authorization_modipa";
                    break;
                }
                case CUSTOM: {
                    headerHTTPREST = "custom";
                    custom = true;
                    break;
                }
                case CUSTOM_BEARER_REQUEST: {
                    headerHTTPREST = "autonlyreq_custom";
                    dueHeaderInRequest = true;
                    custom = true;
                    break;
                }
                case CUSTOM_BEARER: {
                    headerHTTPREST = "authorization_custom";
                    custom = true;
                }
            }
            p.addProperty("modipaSecurityMessageHeaderName", headerHTTPREST);
            if (custom && sicurezzaMessaggio.getRestHeaderCustom() != null) {
                p.addProperty("modipaSecurityMessageHeaderCustomName", sicurezzaMessaggio.getRestHeaderCustom());
            }
            String erroreTokenNonLocaleConPatternSicurezza = "con una generazione token non locale e un pattern di sicurezza";
            if (!sorgenteLocale && integrity && !dueHeaderInRequest) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.rest_header deve essere definita come '" + ModISicurezzaMessaggioRestHeaderEnum.AGID_BEARER_REQUEST.toString() + "' o '" + ModISicurezzaMessaggioRestHeaderEnum.CUSTOM_BEARER_REQUEST.toString() + "' " + erroreTokenNonLocaleConPatternSicurezza + " '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "'");
            }
            String applicabilita = "";
            if (!sorgenteLocale && !integrity) {
                if (sicurezzaMessaggio.getApplicabilita() == null) {
                    sicurezzaMessaggio.setApplicabilita(ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA);
                } else if (!sicurezzaMessaggio.getApplicabilita().equals((Object)ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita deve essere definita come '" + ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA.toString() + "' " + erroreTokenNonLocaleConPatternSicurezza + " '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "'");
                }
            } else if (sicurezzaMessaggio.getApplicabilita() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita deve essere specificato");
            }
            if (sicurezzaMessaggio.getApplicabilita().equals((Object)ModISicurezzaMessaggioApplicabilitaEnum.CUSTOM)) {
                p.addProperty("modipaSecurityMessageConfig", "custom");
                if (sicurezzaMessaggio.getApplicabilitaCustom() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom deve essere specificato con servizio di tipo REST e applicabilita " + String.valueOf((Object)sicurezzaMessaggio.getApplicabilita()));
                }
                ApiModISicurezzaMessaggioApplicabilitaCustom appCustom = sicurezzaMessaggio.getApplicabilitaCustom();
                String sicurezzaRichiesta = "";
                boolean requireContentTypeRequest = false;
                switch (appCustom.getRichiesta()) {
                    case ABILITATO: {
                        sicurezzaRichiesta = "true";
                        break;
                    }
                    case CUSTOM: {
                        sicurezzaRichiesta = "custom";
                        requireContentTypeRequest = true;
                        break;
                    }
                    case DISABILITATO: {
                        sicurezzaRichiesta = "false";
                    }
                }
                p.addProperty("modipaSecurityRequest", sicurezzaRichiesta);
                if (appCustom.getRichiestaContentType() != null) {
                    if (!requireContentTypeRequest) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom.richiesta_content_type non deve essere specificato con servizio di tipo REST e applicabilita_custom.richiesta " + String.valueOf((Object)appCustom.getRichiesta()));
                    }
                    p.addProperty("modipaSecurityRequestContentType", appCustom.getRichiestaContentType());
                } else if (requireContentTypeRequest) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom.richiesta_content_type deve essere specificato con servizio di tipo REST e applicabilita_custom.richiesta " + String.valueOf((Object)appCustom.getRichiesta()));
                }
                String sicurezzaRisposta = "";
                boolean requireContentTypeAndReturnCodeResponse = false;
                switch (appCustom.getRisposta()) {
                    case ABILITATO: {
                        sicurezzaRisposta = "true";
                        break;
                    }
                    case CUSTOM: {
                        sicurezzaRisposta = "custom";
                        requireContentTypeAndReturnCodeResponse = true;
                        break;
                    }
                    case DISABILITATO: {
                        sicurezzaRisposta = "false";
                    }
                }
                p.addProperty("modipaSecurityResponse", sicurezzaRisposta);
                if (appCustom.getRispostaContentType() != null && appCustom.getRispostaCodice() != null) {
                    if (!requireContentTypeAndReturnCodeResponse) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom.risposta_content_type e sicurezza_messaggio.applicabilita_custom.risposta_codice non devono essere specificati con servizio di tipo REST e applicabilita_custom.risposta " + String.valueOf((Object)appCustom.getRisposta()));
                    }
                    p.addProperty("modipaSecurityResponseContentType", appCustom.getRispostaContentType());
                    p.addProperty("modipaSecurityResponseReturnCode", appCustom.getRispostaCodice());
                } else if (requireContentTypeAndReturnCodeResponse) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom.risposta_content_type e sicurezza_messaggio.applicabilita_custom.risposta_codice devono essere specificati con servizio di tipo REST e applicabilita_custom.risposta " + String.valueOf((Object)appCustom.getRisposta()));
                }
                applicabilitaDigest = true;
                applicabilitaInfoUtente = true;
                if (sicurezzaMessaggio.isInformazioniUtente() != null && sicurezzaMessaggio.isInformazioniUtente().booleanValue()) {
                    cornicePropValue = sicurezzaMessaggio.isInformazioniUtente();
                    if (!integrity || !applicabilitaInfoUtente) {
                        if (integrity) throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConApplicabilita(sicurezzaMessaggio.getApplicabilita()));
                        if (sicurezzaMessaggio.getPatternAudit() == null || ModISicurezzaMessaggioPatternAuditEnum.LEGACY.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                            ModISicurezzaMessaggioPatternAuditEnum auditPattern = sicurezzaMessaggio.getPatternAudit() != null ? sicurezzaMessaggio.getPatternAudit() : ModISicurezzaMessaggioPatternAuditEnum.LEGACY;
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConPattern(auditPattern, sicurezzaMessaggio.getPattern()));
                        }
                    }
                    if (sorgenteLocale && sicurezzaMessaggio.getPatternAudit() != null && ModISicurezzaMessaggioPatternAuditEnum.REST02.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternRichiedeTokenNonLocale(sicurezzaMessaggio.getPatternAudit()));
                    }
                }
                if (sicurezzaMessaggio.isDigestRichiesta() != null && sicurezzaMessaggio.isDigestRichiesta().booleanValue()) {
                    if (!integrity || !applicabilitaDigest) throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreDigestRichiestaSpecificatoConPatternApplicabilita(sicurezzaMessaggio.getPattern(), sicurezzaMessaggio.getApplicabilita()));
                    digestPropValue = sicurezzaMessaggio.isDigestRichiesta();
                }
            } else {
                if (sicurezzaMessaggio.getApplicabilitaCustom() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita_custom non deve essere specificato con servizio di tipo REST e applicabilita " + String.valueOf((Object)sicurezzaMessaggio.getApplicabilita()));
                }
                switch (sicurezzaMessaggio.getApplicabilita()) {
                    case CUSTOM: {
                        break;
                    }
                    case QUALSIASI: {
                        applicabilita = "entrambi";
                        applicabilitaDigest = true;
                        applicabilitaInfoUtente = true;
                        break;
                    }
                    case RICHIESTA: {
                        applicabilita = "richiesta";
                        applicabilitaInfoUtente = true;
                        break;
                    }
                    case RISPOSTA: {
                        applicabilita = "risposta";
                    }
                }
                p.addProperty("modipaSecurityMessageConfig", applicabilita);
                if (sicurezzaMessaggio.isInformazioniUtente() != null && sicurezzaMessaggio.isInformazioniUtente().booleanValue()) {
                    cornicePropValue = sicurezzaMessaggio.isInformazioniUtente();
                    if (!integrity || !applicabilitaInfoUtente) {
                        if (integrity) throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConApplicabilita(sicurezzaMessaggio.getApplicabilita()));
                        if (sicurezzaMessaggio.getPatternAudit() == null || ModISicurezzaMessaggioPatternAuditEnum.LEGACY.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                            ModISicurezzaMessaggioPatternAuditEnum auditPattern = sicurezzaMessaggio.getPatternAudit() != null ? sicurezzaMessaggio.getPatternAudit() : ModISicurezzaMessaggioPatternAuditEnum.LEGACY;
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConPattern(auditPattern, sicurezzaMessaggio.getPattern()));
                        }
                    }
                    if (sorgenteLocale && sicurezzaMessaggio.getPatternAudit() != null && ModISicurezzaMessaggioPatternAuditEnum.REST02.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternRichiedeTokenNonLocale(sicurezzaMessaggio.getPatternAudit()));
                    }
                }
                if (sicurezzaMessaggio.isDigestRichiesta() != null && sicurezzaMessaggio.isDigestRichiesta().booleanValue()) {
                    if (!integrity || !applicabilitaDigest) throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreDigestRichiestaSpecificatoConPatternApplicabilita(sicurezzaMessaggio.getPattern(), sicurezzaMessaggio.getApplicabilita()));
                    digestPropValue = sicurezzaMessaggio.isDigestRichiesta();
                }
            }
            p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageRequestDigest", (Boolean)digestPropValue));
            p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageCorniceSicurezza", (Boolean)cornicePropValue));
            if (!cornicePropValue) return;
            String patternAudit = null;
            boolean schemaRequired = false;
            if (sicurezzaMessaggio.getPatternAudit() != null) {
                switch (sicurezzaMessaggio.getPatternAudit()) {
                    case LEGACY: {
                        patternAudit = "old";
                        break;
                    }
                    case REST01: {
                        patternAudit = "audit01";
                        schemaRequired = true;
                        break;
                    }
                    case REST02: {
                        patternAudit = "audit02";
                        schemaRequired = true;
                    }
                }
                p.addProperty("modipaSecurityMessageCorniceSicurezzaPattern", patternAudit);
            }
            if ((sicurezzaMessaggio.getSchemaAudit() == null || !StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggio.getSchemaAudit())) && !schemaRequired) return;
            List l = null;
            String schemaAudit = null;
            try {
                l = modIProperties.getAuditConfig();
                if (sicurezzaMessaggio.getSchemaAudit() != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggio.getSchemaAudit())) {
                    schemaAudit = sicurezzaMessaggio.getSchemaAudit();
                    boolean find = false;
                    if (l != null && !l.isEmpty()) {
                        for (ModIAuditConfig modIAuditConfig : l) {
                            if (!schemaAudit.equals(modIAuditConfig.getNome())) continue;
                            find = true;
                            break;
                        }
                    }
                    if (!find) {
                        throw new CoreException("lo schema indicato non risultato configurato");
                    }
                } else {
                    if (l == null || l.isEmpty() || l.size() == 1 && l.get(0) == null) {
                        throw new CoreException("Nella configurazione ModI non \u00e8 stato definito uno schema utilizzabile con il pattern di audit '" + patternAudit + "'");
                    }
                    if (l.size() > 1) {
                        throw new CoreException("Nella configurazione ModI sono stati definito pi\u00f9 schemi utilizzabile con il pattern di audit '" + patternAudit + "'; indicare lo schema da associare tramite il claim 'schema_audit'");
                    }
                    schemaAudit = ((ModIAuditConfig)l.get(0)).getNome();
                }
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.schema_audit specificato '" + sicurezzaMessaggio.getSchemaAudit() + "' con pattern di audit '" + String.valueOf((Object)sicurezzaMessaggio.getPatternAudit()) + "' non valido: " + e.getMessage());
            }
            p.addProperty("modipaSecurityMessageCorniceSicurezzaSchema", schemaAudit);
            return;
        }
        p.addProperty("modipaSecurityMessageHeaderName", "");
        p.addProperty("modipaSecurityMessageConfig", "");
        p.addProperty("modipaSecurityRequest", "");
        p.addProperty("modipaSecurityRequestContentType", "");
        p.addProperty("modipaSecurityResponse", "");
        p.addProperty("modipaSecurityResponseContentType", "");
        p.addProperty("modipaSecurityResponseReturnCode", "");
    }

    private static void getSOAPProperties(ApiModISicurezzaMessaggio sicurezzaMessaggio, ProtocolProperties p, ModIProperties modIProperties) {
        String profiloSicurezzaMessaggio = null;
        switch (sicurezzaMessaggio.getPattern()) {
            case AUTH01: {
                profiloSicurezzaMessaggio = "idam01";
                break;
            }
            case AUTH02: {
                profiloSicurezzaMessaggio = "idam02";
                break;
            }
            case DISABILITATO: {
                profiloSicurezzaMessaggio = "-";
                break;
            }
            case INTEGRITY01_AUTH01: {
                profiloSicurezzaMessaggio = "idam0301";
                break;
            }
            case INTEGRITY01_AUTH02: {
                profiloSicurezzaMessaggio = "idam0302";
                break;
            }
            case INTEGRITY02_AUTH01: 
            case INTEGRITY02_AUTH02: {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.pattern '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "' non utilizzabile con API SOAP");
            }
        }
        p.addProperty("modipaSecurityMessageProfile", profiloSicurezzaMessaggio);
        boolean cornicePropValue = false;
        boolean digestPropValue = false;
        if (sicurezzaMessaggio.getRestHeader() != null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.rest_header specificato con servizio di tipo SOAP");
        }
        if (!sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.DISABILITATO)) {
            boolean isSoapFirmaAllegati;
            boolean integrity;
            boolean integrityX509 = sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH01) || sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY01_AUTH02);
            boolean integrityKid = sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH01) || sicurezzaMessaggio.getPattern().equals((Object)ModISicurezzaMessaggioEnum.INTEGRITY02_AUTH02);
            boolean bl = integrity = integrityX509 || integrityKid;
            if (integrityKid) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.pattern '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "' non utilizzabile con API SOAP");
            }
            boolean sorgenteLocale = true;
            if (sicurezzaMessaggio.getGenerazioneToken() != null) {
                String sorgenteToken = null;
                switch (sicurezzaMessaggio.getGenerazioneToken()) {
                    case LOCALE: {
                        sorgenteToken = "locale";
                        break;
                    }
                    case PDND: {
                        sorgenteToken = "pdnd";
                        sorgenteLocale = false;
                        break;
                    }
                    case OAUTH: {
                        sorgenteToken = "oauth";
                        sorgenteLocale = false;
                    }
                }
                p.addProperty("modipaSecurityMessageSorgenteToken", sorgenteToken);
            }
            String applicabilita = "";
            boolean bl2 = isSoapFirmaAllegati = sicurezzaMessaggio.isSoapFirmaAllegati() != null && sicurezzaMessaggio.isSoapFirmaAllegati() != false;
            if (isSoapFirmaAllegati && !integrity) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.soap_firma_allegati specificato con pattern " + String.valueOf((Object)sicurezzaMessaggio.getPattern()));
            }
            boolean applicabilitaInfoUtente = false;
            boolean applicabilitaDigest = false;
            if (!sorgenteLocale && !integrity) {
                if (sicurezzaMessaggio.getApplicabilita() == null) {
                    sicurezzaMessaggio.setApplicabilita(ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA);
                } else if (!sicurezzaMessaggio.getApplicabilita().equals((Object)ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita deve essere definita come '" + ModISicurezzaMessaggioApplicabilitaEnum.RICHIESTA.toString() + "' con una generazione token non locale e un pattern di sicurezza '" + String.valueOf((Object)sicurezzaMessaggio.getPattern()) + "'");
                }
            }
            if (sicurezzaMessaggio.getApplicabilita() != null) {
                switch (sicurezzaMessaggio.getApplicabilita()) {
                    case CUSTOM: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.applicabilita custom specificato con servizio di tipo SOAP");
                    }
                    case QUALSIASI: {
                        applicabilita = isSoapFirmaAllegati ? "entrambi_attachments" : "entrambi";
                        applicabilitaInfoUtente = true;
                        applicabilitaDigest = true;
                        break;
                    }
                    case RICHIESTA: {
                        applicabilita = isSoapFirmaAllegati ? "richiesta_attachments" : "richiesta";
                        applicabilitaInfoUtente = true;
                        break;
                    }
                    case RISPOSTA: {
                        applicabilita = isSoapFirmaAllegati ? "risposta_attachments" : "risposta";
                    }
                }
                p.addProperty("modipaSecurityMessageConfig", applicabilita);
            } else {
                p.addProperty("modipaSecurityMessageConfig", "entrambi");
                applicabilitaInfoUtente = true;
                applicabilitaDigest = true;
            }
            if (sicurezzaMessaggio.isInformazioniUtente() != null && sicurezzaMessaggio.isInformazioniUtente().booleanValue()) {
                cornicePropValue = sicurezzaMessaggio.isInformazioniUtente();
                if (!integrity || !applicabilitaInfoUtente) {
                    if (!integrity) {
                        if (sicurezzaMessaggio.getPatternAudit() == null || ModISicurezzaMessaggioPatternAuditEnum.LEGACY.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                            ModISicurezzaMessaggioPatternAuditEnum auditPattern = sicurezzaMessaggio.getPatternAudit() != null ? sicurezzaMessaggio.getPatternAudit() : ModISicurezzaMessaggioPatternAuditEnum.LEGACY;
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConPattern(auditPattern, sicurezzaMessaggio.getPattern()));
                        }
                    } else {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternSpecificatoConApplicabilita(sicurezzaMessaggio.getApplicabilita()));
                    }
                }
                if (sorgenteLocale && sicurezzaMessaggio.getPatternAudit() != null && ModISicurezzaMessaggioPatternAuditEnum.REST02.equals((Object)sicurezzaMessaggio.getPatternAudit())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreAuditPatternRichiedeTokenNonLocale(sicurezzaMessaggio.getPatternAudit()));
                }
            }
            if (sicurezzaMessaggio.isDigestRichiesta() != null && sicurezzaMessaggio.isDigestRichiesta().booleanValue()) {
                if (integrity && applicabilitaDigest) {
                    digestPropValue = sicurezzaMessaggio.isDigestRichiesta();
                } else {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(ModiApiApiHelper.getErroreDigestRichiestaSpecificatoConPatternApplicabilita(sicurezzaMessaggio.getPattern(), sicurezzaMessaggio.getApplicabilita()));
                }
            }
            p.addProperty("modipaSecurityRequest", "");
            p.addProperty("modipaSecurityRequestContentType", "");
            p.addProperty("modipaSecurityResponse", "");
            p.addProperty("modipaSecurityResponseContentType", "");
            p.addProperty("modipaSecurityResponseReturnCode", "");
        } else {
            p.addProperty("modipaSecurityMessageConfig", "");
            p.addProperty("modipaSecurityRequest", "");
            p.addProperty("modipaSecurityRequestContentType", "");
            p.addProperty("modipaSecurityResponse", "");
            p.addProperty("modipaSecurityResponseContentType", "");
            p.addProperty("modipaSecurityResponseReturnCode", "");
        }
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageRequestDigest", (Boolean)digestPropValue));
        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessageCorniceSicurezza", (Boolean)cornicePropValue));
        if (cornicePropValue) {
            String patternAudit = null;
            boolean schemaRequired = false;
            if (sicurezzaMessaggio.getPatternAudit() != null) {
                switch (sicurezzaMessaggio.getPatternAudit()) {
                    case LEGACY: {
                        patternAudit = "old";
                        break;
                    }
                    case REST01: {
                        patternAudit = "audit01";
                        schemaRequired = true;
                        break;
                    }
                    case REST02: {
                        patternAudit = "audit02";
                        schemaRequired = true;
                    }
                }
                p.addProperty("modipaSecurityMessageCorniceSicurezzaPattern", patternAudit);
            }
            if (sicurezzaMessaggio.getSchemaAudit() != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggio.getSchemaAudit()) || schemaRequired) {
                List l = null;
                String schemaAudit = null;
                try {
                    l = modIProperties.getAuditConfig();
                    if (sicurezzaMessaggio.getSchemaAudit() != null && StringUtils.isNotEmpty((CharSequence)sicurezzaMessaggio.getSchemaAudit())) {
                        schemaAudit = sicurezzaMessaggio.getSchemaAudit();
                        boolean find = false;
                        if (l != null && !l.isEmpty()) {
                            for (ModIAuditConfig modIAuditConfig : l) {
                                if (!schemaAudit.equals(modIAuditConfig.getNome())) continue;
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            throw new CoreException("lo schema indicato non risultato configurato");
                        }
                    } else {
                        if (l == null || l.isEmpty() || l.size() == 1 && l.get(0) == null) {
                            throw new CoreException("Nella configurazione ModI non \u00e8 stato definito uno schema utilizzabile con il pattern di audit '" + patternAudit + "'");
                        }
                        if (l.size() > 1) {
                            throw new CoreException("Nella configurazione ModI sono stati definito pi\u00f9 schemi utilizzabile con il pattern di audit '" + patternAudit + "'; indicare lo schema da associare tramite il claim 'schema_audit'");
                        }
                        schemaAudit = ((ModIAuditConfig)l.get(0)).getNome();
                    }
                }
                catch (Exception e) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("sicurezza_messaggio.schema_audit specificato '" + sicurezzaMessaggio.getSchemaAudit() + "' con pattern di audit '" + String.valueOf((Object)sicurezzaMessaggio.getPatternAudit()) + "' non valido: " + e.getMessage());
                }
                p.addProperty("modipaSecurityMessageCorniceSicurezzaSchema", schemaAudit);
            }
        }
    }
}

