/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.applicativi;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.rs.server.api.impl.ProtocolPropertiesHelper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.applicativi.ApplicativiEnv;
import org.openspcoop2.core.config.rs.server.model.Applicativo;
import org.openspcoop2.core.config.rs.server.model.AuthenticationHttps;
import org.openspcoop2.core.config.rs.server.model.AuthenticationToken;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStore;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStoreArchive;
import org.openspcoop2.core.config.rs.server.model.BaseKeyStorePublicFile;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoAuthenticationToken;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoEsterno;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoInterno;
import org.openspcoop2.core.config.rs.server.model.ModIApplicativoSicurezzaMessaggio;
import org.openspcoop2.core.config.rs.server.model.ModIBaseApplicativoKeystore;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreArchive;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreFile;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreFileApplicativo;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreHSM;
import org.openspcoop2.core.config.rs.server.model.ModIKeyStoreHSMApplicativo;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreEnum;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreFullEnum;
import org.openspcoop2.core.config.rs.server.model.ModIKeystoreTipologiaEnum;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationKeystoreUtilities;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;

public class ModiApplicativiApiHelper {
    private ModiApplicativiApiHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProtocolProperties getProtocolProperties(Applicativo body, ServizioApplicativo sa, ApplicativiEnv env) {
        ProtocolProperties p = new ProtocolProperties();
        if (ModiApplicativiApiHelper.isDominioInterno(sa, env)) {
            if (body.getModi() != null) {
                ModIKeyStoreArchive archiveKeystore;
                String filename;
                String tipo;
                ModIKeyStoreFileApplicativo fsKeystore;
                ModIKeyStoreHSMApplicativo hsmKeystore;
                if (!(body.getModi() instanceof ModIApplicativoInterno)) throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non valida");
                ModIApplicativoInterno mai = (ModIApplicativoInterno)body.getModi();
                if (mai.getSicurezzaMessaggio() == null && mai.getToken() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non valida: definire almeno una configurazione tra sicurezza messaggio e token");
                }
                if (mai.getSicurezzaMessaggio() != null) {
                    p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessage", (Boolean)true));
                    if (mai.getSicurezzaMessaggio().getKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.HSM)) {
                        hsmKeystore = (ModIKeyStoreHSMApplicativo)mai.getSicurezzaMessaggio().getKeystore();
                        p.addProperty("modipaKeystoreMode", "hsm");
                        p.addProperty("modipaKeystoreType", hsmKeystore.getPcks11Tipo());
                        p.addProperty("modipaKeyAlias", hsmKeystore.getKeyAlias());
                        if (hsmKeystore.getKeystoreCertificato() != null && hsmKeystore.getKeystoreCertificato().length > 0) {
                            String filename2 = "applicativo.cer";
                            p.addProperty("modipaKeystoreCertificate", hsmKeystore.getKeystoreCertificato(), filename2, filename2);
                            try {
                                CertificateInfo cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig((ProtocolProperties)p, (boolean)true);
                                if (cert != null && cert.getSubject() != null) {
                                    p.addProperty("modipaKeyCNSubject", cert.getSubject().toString());
                                    if (cert.getIssuer() != null) {
                                        p.addProperty("modipaKeyCNIssuer", cert.getIssuer().toString());
                                    }
                                }
                            }
                            catch (Exception cert) {}
                        }
                    } else if (mai.getSicurezzaMessaggio().getKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.FILESYSTEM)) {
                        fsKeystore = (ModIKeyStoreFileApplicativo)mai.getSicurezzaMessaggio().getKeystore();
                        p.addProperty("modipaKeystoreMode", "path");
                        tipo = null;
                        switch (fsKeystore.getKeystoreTipo()) {
                            case JKS: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                                break;
                            }
                            case PKCS12: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                                break;
                            }
                            case JWK: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK;
                                break;
                            }
                            case KEYS: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR;
                                break;
                            }
                        }
                        p.addProperty("modipaKeystoreType", tipo);
                        p.addProperty("modipaKeyAlias", fsKeystore.getKeyAlias());
                        p.addProperty("modipaKeyPassword", fsKeystore.getKeyPassword());
                        p.addProperty("modipaKeystorePassword", fsKeystore.getKeystorePassword());
                        p.addProperty("modipaKeystorePath", fsKeystore.getKeystorePath());
                        if (fsKeystore.getPublicKeyPath() != null && StringUtils.isNotEmpty((CharSequence)fsKeystore.getPublicKeyPath())) {
                            p.addProperty("modipaKeystorePathPublicKey", fsKeystore.getPublicKeyPath());
                        }
                        p.addProperty("modipaKeystoreByokPolicy", fsKeystore.getKeystoreByokPolicy());
                        if (fsKeystore.getKeystoreCertificato() != null && fsKeystore.getKeystoreCertificato().length > 0) {
                            filename = "applicativo.cer";
                            p.addProperty("modipaKeystoreCertificate", fsKeystore.getKeystoreCertificato(), filename, filename);
                            try {
                                CertificateInfo cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig((ProtocolProperties)p, (boolean)true);
                                if (cert != null && cert.getSubject() != null) {
                                    p.addProperty("modipaKeyCNSubject", cert.getSubject().toString());
                                    if (cert.getIssuer() != null) {
                                        p.addProperty("modipaKeyCNIssuer", cert.getIssuer().toString());
                                    }
                                }
                            }
                            catch (Exception cert) {}
                        }
                    } else {
                        archiveKeystore = (ModIKeyStoreArchive)mai.getSicurezzaMessaggio().getKeystore();
                        p.addProperty("modipaKeystoreMode", "archive");
                        tipo = null;
                        filename = null;
                        switch (archiveKeystore.getKeystoreTipo()) {
                            case JKS: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                                filename = "Keystore.jks";
                                break;
                            }
                            case PKCS12: {
                                tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                                filename = "Keystore.p12";
                                break;
                            }
                        }
                        p.addProperty("modipaKeystoreType", tipo);
                        p.addProperty("modipaKeyAlias", archiveKeystore.getKeyAlias());
                        p.addProperty("modipaKeyPassword", archiveKeystore.getKeyPassword());
                        p.addProperty("modipaKeystorePassword", archiveKeystore.getKeystorePassword());
                        p.addProperty("modipaKeystoreArchive", archiveKeystore.getKeystoreArchivio(), filename, filename);
                        try {
                            CertificateInfo cert = ModIDynamicConfigurationKeystoreUtilities.readKeystoreConfig((ProtocolProperties)p, (boolean)false);
                            if (cert != null && cert.getSubject() != null) {
                                p.addProperty("modipaKeyCNSubject", cert.getSubject().toString());
                                if (cert.getIssuer() != null) {
                                    p.addProperty("modipaKeyCNIssuer", cert.getIssuer().toString());
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (mai.getSicurezzaMessaggio().getReplyAudience() != null) {
                        p.addProperty("modipaSecurityMessageResponseAud", mai.getSicurezzaMessaggio().getReplyAudience());
                    }
                    if (mai.getSicurezzaMessaggio().getUrlX5u() != null) {
                        p.addProperty("modipaSecurityMessageRestRequestX509Url", mai.getSicurezzaMessaggio().getUrlX5u());
                    }
                }
                if (mai.getToken() != null) {
                    p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityToken", (Boolean)true));
                    if (mai.getToken().getTokenPolicy() != null) {
                        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityTokenPolicy", (String)mai.getToken().getTokenPolicy()));
                    }
                    p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityTokenClientId", (String)mai.getToken().getIdentificativo()));
                    if (mai.getToken().getKid() != null) {
                        p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityTokenKID", (String)mai.getToken().getKid()));
                    }
                }
                if (mai.getDpop() == null || mai.getDpop().getKeystore() == null) return p;
                p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaDPoPStato", (Boolean)true));
                if (mai.getDpop().getKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.HSM)) {
                    hsmKeystore = (ModIKeyStoreHSMApplicativo)mai.getDpop().getKeystore();
                    p.addProperty("modipaDPoPKeystoreMode", "hsm");
                    p.addProperty("modipaDPoPKeystoreType", hsmKeystore.getPcks11Tipo());
                    p.addProperty("modipaDPoPKeyAlias", hsmKeystore.getKeyAlias());
                    return p;
                } else if (mai.getDpop().getKeystore().getTipologia().equals((Object)ModIKeystoreTipologiaEnum.FILESYSTEM)) {
                    fsKeystore = (ModIKeyStoreFileApplicativo)mai.getDpop().getKeystore();
                    p.addProperty("modipaDPoPKeystoreMode", "path");
                    tipo = null;
                    switch (fsKeystore.getKeystoreTipo()) {
                        case JKS: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                            break;
                        }
                        case PKCS12: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                            break;
                        }
                        case JWK: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK;
                            break;
                        }
                        case KEYS: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR;
                            break;
                        }
                    }
                    p.addProperty("modipaDPoPKeystoreType", tipo);
                    p.addProperty("modipaDPoPKeyAlias", fsKeystore.getKeyAlias());
                    p.addProperty("modipaDPoPKeyPassword", fsKeystore.getKeyPassword());
                    p.addProperty("modipaDPoPKeystorePassword", fsKeystore.getKeystorePassword());
                    p.addProperty("modipaDPoPKeystorePath", fsKeystore.getKeystorePath());
                    if (fsKeystore.getPublicKeyPath() != null && StringUtils.isNotEmpty((CharSequence)fsKeystore.getPublicKeyPath())) {
                        p.addProperty("modipaDPoPKeystorePathPublicKey", fsKeystore.getPublicKeyPath());
                    }
                    p.addProperty("modipaDPoPKeystoreByokPolicy", fsKeystore.getKeystoreByokPolicy());
                    return p;
                } else {
                    archiveKeystore = (ModIKeyStoreArchive)mai.getDpop().getKeystore();
                    p.addProperty("modipaDPoPKeystoreMode", "archive");
                    tipo = null;
                    filename = null;
                    switch (archiveKeystore.getKeystoreTipo()) {
                        case JKS: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS;
                            filename = "Keystore.jks";
                            break;
                        }
                        case PKCS12: {
                            tipo = ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12;
                            filename = "Keystore.p12";
                            break;
                        }
                    }
                    p.addProperty("modipaDPoPKeystoreType", tipo);
                    p.addProperty("modipaDPoPKeyAlias", archiveKeystore.getKeyAlias());
                    p.addProperty("modipaDPoPKeyPassword", archiveKeystore.getKeyPassword());
                    p.addProperty("modipaDPoPKeystorePassword", archiveKeystore.getKeystorePassword());
                    p.addProperty("modipaDPoPKeystoreArchive", archiveKeystore.getKeystoreArchivio(), filename, filename);
                }
                return p;
            }
            p.addProperty((AbstractProperty)ProtocolPropertiesFactory.newProperty((String)"modipaSecurityMessage", (Boolean)false));
            return p;
        }
        if (!(body.getCredenziali() instanceof AuthenticationHttps) && !(body.getCredenziali() instanceof AuthenticationToken)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non sono state fornite credenziali (certificato o tokenClientId) che identificano l\u2019applicativo");
        }
        if (body.getModi() == null) return p;
        if (!(body.getModi() instanceof ModIApplicativoEsterno)) throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non valida");
        ModIApplicativoEsterno mae = (ModIApplicativoEsterno)body.getModi();
        if (mae.getReplyAudience() == null) return p;
        p.addProperty("modipaSecurityMessageResponseAud", mae.getReplyAudience());
        return p;
    }

    private static boolean isDominioInterno(ServizioApplicativo sa, ApplicativiEnv env) {
        IDSoggetto idSoggetto = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
        return env.isDominioInterno(idSoggetto);
    }

    public static void populateProtocolInfo(ServizioApplicativo sa, ApplicativiEnv env, Applicativo ret) throws Exception {
        Map<String, AbstractProperty<?>> p = ApplicativiApiHelper.getProtocolPropertiesMap(sa, env);
        if (ModiApplicativiApiHelper.isDominioInterno(sa, env)) {
            ModIApplicativoInterno app = new ModIApplicativoInterno();
            app.setDominio(DominioEnum.INTERNO);
            boolean enabledSicurezzaMessaggio = false;
            AbstractProperty ap = ProtocolPropertiesHelper.getProperty(p, "modipaSecurityMessage", false);
            if (ap != null && ap.getValue() != null) {
                enabledSicurezzaMessaggio = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityMessage", true);
            }
            if (enabledSicurezzaMessaggio) {
                String x509;
                ModIApplicativoSicurezzaMessaggio sicurezzaMsg = new ModIApplicativoSicurezzaMessaggio();
                String keystoreModeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreMode", true);
                if (keystoreModeString.equals("hsm")) {
                    datiKeystore = new ModIKeyStoreHSMApplicativo();
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).tipologia(ModIKeystoreTipologiaEnum.HSM);
                    String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).setPcks11Tipo(keystoreTipoString);
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                    ((ModIKeyStoreHSMApplicativo)datiKeystore).setKeystoreCertificato(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaKeystoreCertificate", false));
                    sicurezzaMsg.setKeystore(datiKeystore);
                } else if (keystoreModeString.equals("path")) {
                    datiKeystore = new ModIKeyStoreFileApplicativo();
                    ((ModIKeyStoreFile)((Object)datiKeystore)).tipologia(ModIKeystoreTipologiaEnum.FILESYSTEM);
                    keystoreTipo = null;
                    keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                    if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                        keystoreTipo = ModIKeystoreFullEnum.JKS;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                        keystoreTipo = ModIKeystoreFullEnum.PKCS12;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK)) {
                        keystoreTipo = ModIKeystoreFullEnum.JWK;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR)) {
                        keystoreTipo = ModIKeystoreFullEnum.KEYS;
                    }
                    ((ModIKeyStoreFile)((Object)datiKeystore)).setKeystoreTipo((ModIKeystoreFullEnum)keystoreTipo);
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
                    ((BaseKeyStorePublicFile)((Object)datiKeystore)).setKeystorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePath", true));
                    ((BaseKeyStorePublicFile)((Object)datiKeystore)).setPublicKeyPath(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePathPublicKey", false));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystoreByokPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreByokPolicy", false));
                    ((ModIKeyStoreFileApplicativo)datiKeystore).setKeystoreCertificato(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaKeystoreCertificate", false));
                    sicurezzaMsg.setKeystore(datiKeystore);
                } else if (keystoreModeString.equals("archive")) {
                    datiKeystore = new ModIKeyStoreArchive().tipologia(ModIKeystoreTipologiaEnum.ARCHIVIO);
                    keystoreTipo = null;
                    keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystoreType", true);
                    if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                        keystoreTipo = ModIKeystoreEnum.JKS;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                        keystoreTipo = ModIKeystoreEnum.PKCS12;
                    }
                    ((ModIKeyStoreArchive)datiKeystore).setKeystoreTipo((ModIKeystoreEnum)keystoreTipo);
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyAlias", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeyPassword", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaKeystorePassword", true));
                    ((BaseKeyStoreArchive)((Object)datiKeystore)).setKeystoreArchivio(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaKeystoreArchive", true));
                    sicurezzaMsg.setKeystore(datiKeystore);
                }
                String wsaTo = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseAud", false);
                if (wsaTo != null) {
                    sicurezzaMsg.setReplyAudience(wsaTo);
                }
                if ((x509 = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageRestRequestX509Url", false)) != null) {
                    sicurezzaMsg.setUrlX5u(x509);
                }
                app.setSicurezzaMessaggio(sicurezzaMsg);
            }
            boolean enabledSicurezzaToken = false;
            ap = ProtocolPropertiesHelper.getProperty(p, "modipaSecurityToken", false);
            if (ap != null && ap.getValue() != null) {
                enabledSicurezzaToken = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaSecurityToken", true);
            }
            if (enabledSicurezzaToken) {
                String kid;
                String identificativo;
                ModIApplicativoAuthenticationToken token = new ModIApplicativoAuthenticationToken();
                String tokenPolicy = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityTokenPolicy", false);
                if (tokenPolicy != null) {
                    token.setTokenPolicy(tokenPolicy);
                }
                if ((identificativo = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityTokenClientId", false)) != null) {
                    token.setIdentificativo(identificativo);
                }
                if ((kid = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityTokenKID", false)) != null) {
                    token.setKid(kid);
                }
                app.setToken(token);
            }
            boolean enabledDpop = false;
            ap = ProtocolPropertiesHelper.getProperty(p, "modipaDPoPStato", false);
            if (ap != null && ap.getValue() != null) {
                enabledDpop = ProtocolPropertiesHelper.getBooleanProperty(p, "modipaDPoPStato", true);
            }
            if (enabledDpop) {
                ModIBaseApplicativoKeystore dpop = new ModIBaseApplicativoKeystore();
                String keystoreModeString = ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystoreMode", true);
                if (keystoreModeString.equals("hsm")) {
                    datiKeystore = new ModIKeyStoreHSMApplicativo();
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).tipologia(ModIKeystoreTipologiaEnum.HSM);
                    String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystoreType", true);
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).setPcks11Tipo(keystoreTipoString);
                    ((ModIKeyStoreHSM)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeyAlias", true));
                    dpop.setKeystore(datiKeystore);
                } else if (keystoreModeString.equals("path")) {
                    datiKeystore = new ModIKeyStoreFileApplicativo();
                    ((ModIKeyStoreFile)((Object)datiKeystore)).tipologia(ModIKeystoreTipologiaEnum.FILESYSTEM);
                    ModIKeystoreFullEnum keystoreTipo = null;
                    String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystoreType", true);
                    if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                        keystoreTipo = ModIKeystoreFullEnum.JKS;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                        keystoreTipo = ModIKeystoreFullEnum.PKCS12;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JWK)) {
                        keystoreTipo = ModIKeystoreFullEnum.JWK;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_KEY_PAIR)) {
                        keystoreTipo = ModIKeystoreFullEnum.KEYS;
                    }
                    ((ModIKeyStoreFile)((Object)datiKeystore)).setKeystoreTipo(keystoreTipo);
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeyAlias", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeyPassword", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystorePassword", true));
                    ((BaseKeyStorePublicFile)((Object)datiKeystore)).setKeystorePath(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystorePath", true));
                    ((BaseKeyStorePublicFile)((Object)datiKeystore)).setPublicKeyPath(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystorePathPublicKey", false));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystoreByokPolicy(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystoreByokPolicy", false));
                    dpop.setKeystore(datiKeystore);
                } else if (keystoreModeString.equals("archive")) {
                    datiKeystore = new ModIKeyStoreArchive().tipologia(ModIKeystoreTipologiaEnum.ARCHIVIO);
                    ModIKeystoreEnum keystoreTipo = null;
                    String keystoreTipoString = ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystoreType", true);
                    if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_JKS)) {
                        keystoreTipo = ModIKeystoreEnum.JKS;
                    } else if (keystoreTipoString.equals(ModICostanti.MODIPA_KEYSTORE_TYPE_VALUE_PKCS12)) {
                        keystoreTipo = ModIKeystoreEnum.PKCS12;
                    }
                    ((ModIKeyStoreArchive)datiKeystore).setKeystoreTipo(keystoreTipo);
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyAlias(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeyAlias", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeyPassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeyPassword", true));
                    ((BaseKeyStore)((Object)datiKeystore)).setKeystorePassword(ProtocolPropertiesHelper.getStringProperty(p, "modipaDPoPKeystorePassword", true));
                    ((BaseKeyStoreArchive)((Object)datiKeystore)).setKeystoreArchivio(ProtocolPropertiesHelper.getByteArrayProperty(p, "modipaDPoPKeystoreArchive", true));
                    dpop.setKeystore(datiKeystore);
                }
                app.setDpop(dpop);
            }
            if (enabledSicurezzaMessaggio || enabledSicurezzaToken || enabledDpop) {
                ret.setModi(app);
            }
        } else {
            ModIApplicativoEsterno app = new ModIApplicativoEsterno();
            app.setDominio(DominioEnum.ESTERNO);
            String wsaTo = ProtocolPropertiesHelper.getStringProperty(p, "modipaSecurityMessageResponseAud", false);
            if (wsaTo != null) {
                app.setReplyAudience(wsaTo);
            }
            ret.setModi(app);
        }
    }
}

