/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.UriInfo;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.StringEscapeUtils;
import org.govway.struts.upload.FormFile;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazioneRegola;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneToken;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneHashGenerator;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRichiestaIdentificazione;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRispostaIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataSoggettiErogatori;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaBloccante;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Environment;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.HttpRequestWrapper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.StatoDescrizione;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreAPIHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreHTTPApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.EDeliveryErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniCheckNotNull;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.FatturaPAErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ModiErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.SPCoopErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.configurazione.ErogazioniConfEnv;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.configurazione.FruizioniConfEnv;
import org.openspcoop2.core.config.rs.server.config.LoggerProperties;
import org.openspcoop2.core.config.rs.server.model.APIImpl;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKey;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKeyPosizione;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneBasic;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneCustom;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneAbilitata;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneAbilitataNew;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneCustom;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneDisabilitata;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneXACML;
import org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneXACMLView;
import org.openspcoop2.core.config.rs.server.model.AllAnyEnum;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoItem;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoItemGenerico;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoItemSpecificaLivelloServizio;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoItemSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoItemSpecificaSicurezza;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaLivelloServizio;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSicurezza;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGenerali;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGeneraliView;
import org.openspcoop2.core.config.rs.server.model.ApiImplItem;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApiView;
import org.openspcoop2.core.config.rs.server.model.ApiImplViewItem;
import org.openspcoop2.core.config.rs.server.model.BaseConnettoreHttp;
import org.openspcoop2.core.config.rs.server.model.CachingRisposta;
import org.openspcoop2.core.config.rs.server.model.CachingRispostaRegola;
import org.openspcoop2.core.config.rs.server.model.CanaleEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneApiKey;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpBasic;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsClient;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneProxy;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneView;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiGestioneToken;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaEnum;
import org.openspcoop2.core.config.rs.server.model.DiagnosticiSeverita;
import org.openspcoop2.core.config.rs.server.model.Erogazione;
import org.openspcoop2.core.config.rs.server.model.ErogazioneItem;
import org.openspcoop2.core.config.rs.server.model.ErogazioneViewItem;
import org.openspcoop2.core.config.rs.server.model.FonteEnum;
import org.openspcoop2.core.config.rs.server.model.Fruizione;
import org.openspcoop2.core.config.rs.server.model.FruizioneItem;
import org.openspcoop2.core.config.rs.server.model.FruizioneViewItem;
import org.openspcoop2.core.config.rs.server.model.GestioneCors;
import org.openspcoop2.core.config.rs.server.model.GestioneCorsAccessControl;
import org.openspcoop2.core.config.rs.server.model.GruppoEreditaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.GruppoNuovaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.HttpMethodEnum;
import org.openspcoop2.core.config.rs.server.model.ListaApiImplAllegati;
import org.openspcoop2.core.config.rs.server.model.ModalitaConfigurazioneGruppoEnum;
import org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutenticazione;
import org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.OneOfControlloAccessiAutenticazioneAutenticazione;
import org.openspcoop2.core.config.rs.server.model.OneOfControlloAccessiAutorizzazioneAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.OneOfControlloAccessiAutorizzazioneViewAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriIntervalloEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriMetricaEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingIdentificazionePolicyEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyBase;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyBaseConIdentificazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyCriteri;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyErogazioneView;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFiltro;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFiltroErogazione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFiltroFruizione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneView;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyGroupBy;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyGroupByTokenClaimEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyIdentificativo;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneDiagnosticiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggiConfigurazioneRegola;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneBase;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneFasi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneFiletrace;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneFiletraceMessaggio;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneFiltroEsiti;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazioneInformazioniRegistrate;
import org.openspcoop2.core.config.rs.server.model.RuoloAllegatoAPIImpl;
import org.openspcoop2.core.config.rs.server.model.StatoApiEnum;
import org.openspcoop2.core.config.rs.server.model.StatoDefaultRidefinitoEnum;
import org.openspcoop2.core.config.rs.server.model.StatoFunzionalitaConWarningEnum;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazionePrincipalToken;
import org.openspcoop2.core.config.rs.server.model.TipoAutorizzazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoGestioneCorsEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaLivelloServizioEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaSemiformaleEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaSicurezzaEnum;
import org.openspcoop2.core.config.rs.server.model.TipoValidazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TracciamentoTransazioniStato;
import org.openspcoop2.core.config.rs.server.model.TracciamentoTransazioniStatoFase;
import org.openspcoop2.core.config.rs.server.model.TracciamentoTransazioniStatoFaseBloccante;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoRealtime;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.GruppoSintetico;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.core.registry.driver.db.IDSoggettoDB;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.autorizzazione.canali.CanaliUtils;
import org.openspcoop2.protocol.basic.Utilities;
import org.openspcoop2.protocol.information_missing.constants.StatoType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.beans.utils.ProfiloUtils;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.AutorizzazioneUtilities;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.SerialiableFormFile;
import org.openspcoop2.web.ctrlstat.costanti.ConnettoreServletType;
import org.openspcoop2.web.ctrlstat.plugins.servlet.ServletExtendedConnettoreUtils;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ErogazioniApiHelper {
    private ErogazioniApiHelper() {
    }

    public static void validateProperties(ErogazioniEnv env, ProtocolProperties protocolProperties, AccordoServizioParteSpecifica asps, ConsoleOperationType operationType) throws Exception {
        if (protocolProperties != null) {
            try {
                ConsoleConfiguration consoleConf = ErogazioniApiHelper.getConsoleConfiguration(env, asps);
                env.apsHelper.validaProtocolProperties(consoleConf, ConsoleOperationType.ADD, protocolProperties);
                IDServizio oldIdAps = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
                oldIdAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                oldIdAps.setPortType(asps.getPortType());
                IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
                IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
                IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
                consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteSpecifica(consoleConf, operationType, (IConsoleHelper)env.apsHelper, protocolProperties, registryReader, configRegistryReader, oldIdAps);
                consoleDynamicConfiguration.validateDynamicConfigAccordoServizioParteSpecifica(consoleConf, operationType, (IConsoleHelper)env.apsHelper, protocolProperties, registryReader, configRegistryReader, oldIdAps);
            }
            catch (ProtocolException e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException((Throwable)e);
            }
        }
    }

    public static void validateProperties(ErogazioniEnv env, ProtocolProperties protocolProperties, IDFruizione id, ConsoleOperationType operationType) throws Exception {
        if (protocolProperties != null) {
            try {
                ConsoleConfiguration consoleConf = ErogazioniApiHelper.getConsoleConfiguration(env, id);
                env.apsHelper.validaProtocolProperties(consoleConf, ConsoleOperationType.ADD, protocolProperties);
                IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
                IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
                IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
                consoleDynamicConfiguration.updateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConf, operationType, (IConsoleHelper)env.apsHelper, protocolProperties, registryReader, configRegistryReader, id);
                consoleDynamicConfiguration.validateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConf, operationType, (IConsoleHelper)env.apsHelper, protocolProperties, registryReader, configRegistryReader, id);
            }
            catch (ProtocolException e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException((Throwable)e);
            }
        }
    }

    public static ConsoleConfiguration getConsoleConfiguration(ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws Exception {
        IDServizio oldIdAps = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
        oldIdAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
        oldIdAps.setPortType(asps.getPortType());
        IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
        env.requestWrapper.overrideParameter("_tabKey_tipologiaErogazione_VIA_PARAM", "erogazione");
        return consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType.ADD, (IConsoleHelper)env.apsHelper, registryReader, configRegistryReader, oldIdAps);
    }

    public static void updateConsoleConfiguration(ErogazioniEnv env, AccordoServizioParteSpecifica asps, ConsoleConfiguration consoleConf, ProtocolProperties prop) throws Exception {
        IDServizio oldIdAps = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
        oldIdAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
        oldIdAps.setPortType(asps.getPortType());
        IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
        env.requestWrapper.overrideParameter("_tabKey_tipologiaErogazione_VIA_PARAM", "erogazione");
        consoleDynamicConfiguration.updateDynamicConfigAccordoServizioParteSpecifica(consoleConf, ConsoleOperationType.CHANGE, (IConsoleHelper)env.apsHelper, prop, registryReader, configRegistryReader, oldIdAps);
    }

    public static ConsoleConfiguration getConsoleConfiguration(ErogazioniEnv env, IDFruizione id) throws Exception {
        IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
        env.requestWrapper.overrideParameter("_tabKey_tipologiaErogazione_VIA_PARAM", "fruizione");
        return consoleDynamicConfiguration.getDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleOperationType.ADD, (IConsoleHelper)env.apsHelper, registryReader, configRegistryReader, id);
    }

    public static void updateConsoleConfiguration(ErogazioniEnv env, IDFruizione id, ConsoleConfiguration consoleConf, ProtocolProperties prop) throws Exception {
        IConsoleDynamicConfiguration consoleDynamicConfiguration = env.protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = env.soggettiCore.getRegistryReader(env.protocolFactory);
        IConfigIntegrationReader configRegistryReader = env.soggettiCore.getConfigIntegrationReader(env.protocolFactory);
        env.requestWrapper.overrideParameter("_tabKey_tipologiaErogazione_VIA_PARAM", "erogazione");
        consoleDynamicConfiguration.updateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConf, ConsoleOperationType.CHANGE, (IConsoleHelper)env.apsHelper, prop, registryReader, configRegistryReader, id);
    }

    public static ProtocolProperties getProtocolProperties(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws Exception {
        ConsoleConfiguration consoleConf = ErogazioniApiHelper.getConsoleConfiguration(env, asps);
        ProtocolProperties prop = env.apsHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)asps.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        return prop;
    }

    public static ProtocolProperties getProtocolProperties(IDFruizione id, Fruitore f, ErogazioniEnv env) throws Exception {
        ConsoleConfiguration consoleConf = ErogazioniApiHelper.getConsoleConfiguration(env, id);
        ProtocolProperties prop = env.apsHelper.estraiProtocolPropertiesDaRequest(consoleConf, ConsoleOperationType.CHANGE);
        ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)prop, (List)f.getProtocolPropertyList(), (ConsoleOperationType)ConsoleOperationType.CHANGE);
        return prop;
    }

    public static Map<String, AbstractProperty<?>> getProtocolPropertiesMap(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws Exception {
        ProtocolProperties prop = ErogazioniApiHelper.getProtocolProperties(asps, env);
        HashMap p = new HashMap();
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        return p;
    }

    public static Map<String, AbstractProperty<?>> getProtocolPropertiesMap(IDFruizione id, Fruitore f, ErogazioniEnv env) throws Exception {
        ProtocolProperties prop = ErogazioniApiHelper.getProtocolProperties(id, f, env);
        HashMap p = new HashMap();
        for (int i = 0; i < prop.sizeProperties(); ++i) {
            p.put(prop.getIdProperty(i), prop.getProperty(i));
        }
        return p;
    }

    public static ProtocolProperties getProtocolProperties(Erogazione body, ProfiloEnum profilo, AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps, ErogazioniEnv env, boolean required) throws Exception {
        if (!profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA) && body.getModi() != null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non conforme con il profilo '" + String.valueOf(profilo) + "' indicato");
        }
        switch (profilo) {
            case APIGATEWAY: {
                return null;
            }
            case EDELIVERY: {
                return EDeliveryErogazioniApiHelper.getProtocolProperties(body);
            }
            case FATTURAPA: {
                return FatturaPAErogazioniApiHelper.getProtocolProperties(body);
            }
            case MODI: 
            case MODIPA: {
                return ModiErogazioniApiHelper.getProtocolProperties(body, aspc, asps, env, required);
            }
            case SPCOOP: {
                return SPCoopErogazioniApiHelper.getProtocolProperties(body);
            }
        }
        return null;
    }

    public static ProtocolProperties getProtocolProperties(Fruizione body, ProfiloEnum profilo, AccordoServizioParteSpecifica asps, ErogazioniEnv env, boolean required) throws Exception {
        if (!profilo.equals((Object)ProfiloEnum.MODI) && !profilo.equals((Object)ProfiloEnum.MODIPA) && body.getModi() != null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione 'ModI' non conforme con il profilo '" + String.valueOf(profilo) + "' indicato");
        }
        switch (profilo) {
            case APIGATEWAY: {
                return null;
            }
            case EDELIVERY: {
                return EDeliveryErogazioniApiHelper.getProtocolProperties(body);
            }
            case FATTURAPA: {
                return FatturaPAErogazioniApiHelper.getProtocolProperties(body);
            }
            case MODI: 
            case MODIPA: {
                return ModiErogazioniApiHelper.getProtocolProperties(body, asps, env, required);
            }
            case SPCOOP: {
                return SPCoopErogazioniApiHelper.getProtocolProperties(body);
            }
        }
        return null;
    }

    public static final <T> T deserializeModalitaConfGruppo(ModalitaConfigurazioneGruppoEnum discr, Object body) throws UtilsException, InstantiationException, IllegalAccessException {
        switch (discr) {
            case EREDITA: {
                GruppoEreditaConfigurazione conf = (GruppoEreditaConfigurazione)BaseHelper.deserializeDefault((Object)body, GruppoEreditaConfigurazione.class);
                if (StringUtils.isEmpty((CharSequence)conf.getNome())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(GruppoEreditaConfigurazione.class.getName() + ": Indicare il campo obbligatorio 'nome'");
                }
                return (T)conf;
            }
            case NUOVA: {
                GruppoNuovaConfigurazione conf = (GruppoNuovaConfigurazione)BaseHelper.deserializeDefault((Object)body, GruppoNuovaConfigurazione.class);
                ErogazioniCheckNotNull.checkAutenticazione(conf);
                return (T)conf;
            }
        }
        return null;
    }

    public static final void fillAps(AccordoServizioParteSpecifica specifico, APIImpl impl, ErogazioniEnv env) throws ProtocolException {
        specifico.setNome(impl.getApiNome());
        if (impl.getTipoServizio() != null && StringUtils.isNotEmpty((CharSequence)impl.getTipoServizio())) {
            List l = env.protocolFactoryMgr.getProtocolFactoryByName(env.tipo_protocollo).createProtocolConfiguration().getTipiServizi(null);
            if (l != null && !l.contains(impl.getTipoServizio())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo servizio indicato '" + impl.getTipoServizio() + "' non supportato dal profilo '" + String.valueOf(env.profilo) + "'");
            }
            specifico.setTipo(impl.getTipoServizio());
        }
        specifico.setVersione(impl.getApiVersione());
        specifico.setPortType(impl.getApiSoapServizio());
    }

    public static final AccordoServizioParteSpecifica apiImplToAps(APIImpl impl, Soggetto soggErogatore, AccordoServizioParteComuneSintetico as, ErogazioniEnv env) throws DriverRegistroServiziException, ProtocolException {
        AccordoServizioParteSpecifica ret = new AccordoServizioParteSpecifica();
        ErogazioniApiHelper.fillAps(ret, impl, env);
        if (as.getServiceBinding() == ServiceBinding.SOAP) {
            ret.setNome(ret.getPortType());
        }
        if (env.apsCore.isSupportatoVersionamentoAccordiServizioParteSpecifica(env.tipo_protocollo)) {
            ret.setVersione(as.getVersione());
        }
        if (impl instanceof Erogazione) {
            Erogazione erogazione = (Erogazione)impl;
            if (erogazione.getErogazioneNome() != null && !"".equals(erogazione.getErogazioneNome())) {
                ret.setNome(erogazione.getErogazioneNome());
            }
            if (env.apsCore.isSupportatoVersionamentoAccordiServizioParteSpecifica(env.tipo_protocollo) && erogazione.getErogazioneVersione() != null && erogazione.getErogazioneVersione() > 0) {
                ret.setVersione(erogazione.getErogazioneVersione());
            }
            ret.setDescrizione(erogazione.getDescrizione());
        } else if (impl instanceof Fruizione) {
            Fruizione fruizione = (Fruizione)impl;
            if (fruizione.getFruizioneNome() != null && !"".equals(fruizione.getFruizioneNome())) {
                ret.setNome(fruizione.getFruizioneNome());
            }
            if (env.apsCore.isSupportatoVersionamentoAccordiServizioParteSpecifica(env.tipo_protocollo) && fruizione.getFruizioneVersione() != null && fruizione.getFruizioneVersione() > 0) {
                ret.setVersione(fruizione.getFruizioneVersione());
            }
        }
        ret.setIdSoggetto(soggErogatore.getId());
        ret.setTipoSoggettoErogatore(soggErogatore.getTipo());
        ret.setNomeSoggettoErogatore(soggErogatore.getNome());
        ret.setVersioneProtocollo(soggErogatore.getVersioneProtocollo());
        ret.setByteWsdlImplementativoErogatore(null);
        ret.setByteWsdlImplementativoFruitore(null);
        ret.setIdAccordo(as.getId());
        ret.setAccordoServizioParteComune(env.idAccordoFactory.getUriFromAccordo(as));
        ret.setTipologiaServizio(TipologiaServizio.NORMALE);
        ret.setSuperUser(env.userLogin);
        ret.setPrivato(Boolean.valueOf(false));
        ret.setStatoPackage(StatoType.FINALE.getValue());
        ret.setConfigurazioneServizio(new ConfigurazioneServizio());
        if (StringUtils.isEmpty((CharSequence)ret.getTipo())) {
            String tipoServizio = env.protocolFactoryMgr.getProtocolFactoryByName(env.tipo_protocollo).createProtocolConfiguration().getTipoServizioDefault(Utilities.convert((ServiceBinding)as.getServiceBinding()));
            ret.setTipo(tipoServizio);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static final void serviziUpdateCheckData(AccordoServizioParteComuneSintetico as, AccordoServizioParteSpecifica asps, boolean isErogazione, ErogazioniEnv env) throws Exception {
        searchSoggetti = new ConsoleSearch(true);
        searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", env.tipo_protocollo);
        soggettiCompatibili = (String[])env.soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti).stream().map((Function<Soggetto, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziUpdateCheckData$0(org.openspcoop2.core.registry.Soggetto ), (Lorg/openspcoop2/core/registry/Soggetto;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziUpdateCheckData$1(int ), (I)[Ljava/lang/String;)());
        accordiList = (String[])AccordiServizioParteSpecificaUtilities.getListaIdAPI((String)env.tipo_protocollo, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper).stream().map((Function<IDAccordoDB, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziUpdateCheckData$2(org.openspcoop2.core.registry.driver.db.IDAccordoDB ), (Lorg/openspcoop2/core/registry/driver/db/IDAccordoDB;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziUpdateCheckData$3(int ), (I)[Ljava/lang/String;)());
        erogatore = new IdSoggetto(new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()));
        erogatore.setId(asps.getIdSoggetto());
        connRegistro = asps.getConfigurazioneServizio().getConnettore();
        endpointtype = connRegistro.getTipo();
        endpoint_url = (String)connRegistro.getProperties().get("location");
        ptArray = (String[])AccordiServizioParteSpecificaUtilities.getListaPortTypes((AccordoServizioParteComuneSintetico)as, (AccordiServizioParteSpecificaHelper)env.apsHelper).stream().map((Function<PortTypeSintetico, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziUpdateCheckData$4(org.openspcoop2.core.registry.beans.PortTypeSintetico ), (Lorg/openspcoop2/core/registry/beans/PortTypeSintetico;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziUpdateCheckData$5(int ), (I)[Ljava/lang/String;)());
        accordoPrivato = as.getPrivato() != null && as.getPrivato() != false;
        connRest = new ConnettoreHTTPApiHelper().buildConnettore(connRegistro.getProperties(), connRegistro.getTipo());
        httpApiKey = connRest.getAutenticazioneApikey();
        apiKey = httpApiKey != null && httpApiKey.getApiKey() != null && StringUtils.isNotEmpty((CharSequence)httpApiKey.getApiKey()) != false;
        httpsConf = connRest.getAutenticazioneHttps();
        httpConf = connRest.getAutenticazioneHttp();
        v0 = httpsConf != null ? (ConnettoreConfigurazioneHttpsClient)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getClient(), ()Lorg/openspcoop2/core/config/rs/server/model/ConnettoreConfigurazioneHttpsClient;)((ConnettoreConfigurazioneHttps)httpsConf)) : (httpsClient = null);
        httpsServer = httpsConf != null ? (ConnettoreConfigurazioneHttpsServer)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getServer(), ()Lorg/openspcoop2/core/config/rs/server/model/ConnettoreConfigurazioneHttpsServer;)((ConnettoreConfigurazioneHttps)httpsConf)) : null;
        proxy = connRest.getProxy();
        timeoutConf = connRest.getTempiRisposta();
        tokenPolicy = connRest.getTokenPolicy();
        autenticazioneToken = tokenPolicy != null;
        httpsstato = httpsClient != null;
        http_stato = connRest.getAutenticazioneHttp() != null;
        proxy_enabled = connRest.getProxy() != null;
        tempiRisposta_enabled = connRest.getTempiRisposta() != null;
        httpskeystore = null;
        if (httpsClient != null) {
            httpskeystore = httpsClient.getKeystorePath() != null || httpsClient.getKeystoreTipo() != null ? "ridefinisci" : "default";
        }
        xamlPolicy = new BinaryParameter();
        erogazioneAutenticazione = null;
        erogazioneAutenticazioneOpzionale = true;
        erogazioneAutenticazionePrincipal = null;
        erogazioneAutenticazioneParametroList = null;
        erogazioneAutorizzazione = null;
        erogazioneAutorizzazioneAutenticati = false;
        erogazioneAutorizzazioneRuoli = false;
        erogazioneAutorizzazioneRuoliTipologia = null;
        erogazioneAutorizzazioneRuoliMatch = null;
        fruizioneAutenticazione = null;
        fruizioneAutenticazioneOpzionale = true;
        fruizioneAutenticazionePrincipal = null;
        fruizioneAutenticazioneParametroList = null;
        fruizioneAutorizzazione = null;
        fruizioneAutorizzazioneAutenticati = false;
        fruizioneAutorizzazioneRuoli = false;
        fruizioneAutorizzazioneRuoliTipologia = null;
        fruizioneAutorizzazioneRuoliMatch = null;
        gestioneCanaliEnabled = env.gestioneCanali;
        canale = null;
        if (isErogazione) {
            ServletUtils.setObjectIntoSession((HttpServletRequest)env.requestWrapper, (HttpSession)env.requestWrapper.getSession(), (Object)"erogazione", (String)"_tabKey_tipologiaErogazione");
            idServizio = asps.getOldIDServizioForUpdate();
            idPA = env.paCore.getIDPortaApplicativaAssociataDefault(idServizio);
            pa = env.paCore.getPortaApplicativa(idPA);
            erogazioneAutenticazione = pa.getAutenticazione();
            erogazioneAutenticazioneOpzionale = Helper.statoFunzionalitaConfToBool(pa.getAutenticazioneOpzionale());
            erogazioneAutenticazionePrincipal = env.paCore.getTipoAutenticazionePrincipal(pa.getProprietaAutenticazioneList());
            erogazioneAutenticazioneParametroList = env.paCore.getParametroAutenticazione(erogazioneAutenticazione, pa.getProprietaAutenticazioneList());
            erogazioneAutorizzazione = pa.getAutorizzazione();
            erogazioneAutorizzazioneAutenticati = TipoAutorizzazione.isAuthenticationRequired((String)pa.getAutorizzazione());
            erogazioneAutorizzazioneRuoli = TipoAutorizzazione.isRolesRequired((String)pa.getAutorizzazione());
            erogazioneAutorizzazioneRuoliTipologia = AutorizzazioneUtilities.convertToRuoloTipologia((String)pa.getAutorizzazione()).toString();
            erogazioneAutorizzazioneRuoliMatch = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$6(org.openspcoop2.core.config.PortaApplicativa ), ()Ljava/lang/String;)((PortaApplicativa)pa));
            if (pa.getXacmlPolicy() != null) {
                xamlPolicy.setValue(pa.getXacmlPolicy().getBytes());
                xamlPolicy.setName("docSicXacmlPol");
            }
            canale = pa.getCanale();
        } else {
            ServletUtils.setObjectIntoSession((HttpServletRequest)env.requestWrapper, (HttpSession)env.requestWrapper.getSession(), (Object)"fruizione", (String)"_tabKey_tipologiaErogazione");
            idServizio = asps.getOldIDServizioForUpdate();
            idPD = env.pdCore.getIDPortaDelegataAssociataDefault(idServizio, env.idSoggetto.toIDSoggetto());
            pd = env.pdCore.getPortaDelegata(idPD);
            fruizioneAutenticazione = pd.getAutenticazione();
            fruizioneAutenticazioneOpzionale = Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale());
            fruizioneAutenticazionePrincipal = env.pdCore.getTipoAutenticazionePrincipal(pd.getProprietaAutenticazioneList());
            fruizioneAutenticazioneParametroList = env.pdCore.getParametroAutenticazione(fruizioneAutenticazione, pd.getProprietaAutenticazioneList());
            fruizioneAutorizzazione = pd.getAutorizzazione();
            fruizioneAutorizzazioneAutenticati = TipoAutorizzazione.isAuthenticationRequired((String)pd.getAutorizzazione());
            fruizioneAutorizzazioneRuoli = TipoAutorizzazione.isRolesRequired((String)pd.getAutorizzazione());
            fruizioneAutorizzazioneRuoliTipologia = AutorizzazioneUtilities.convertToRuoloTipologia((String)pd.getAutorizzazione()).toString();
            fruizioneAutorizzazioneRuoliMatch = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$7(org.openspcoop2.core.config.PortaDelegata ), ()Ljava/lang/String;)((PortaDelegata)pd));
            if (pd.getXacmlPolicy() != null) {
                xamlPolicy.setValue(pd.getXacmlPolicy().getBytes());
                xamlPolicy.setName("docSicXacmlPol");
            }
            canale = pd.getCanale();
        }
        canaleStato = null;
        canaleStato = canale == null ? "default" : "ridefinito";
        parametersPOST = null;
        conTmp = null;
        listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(conTmp, (ConnettoreServletType)ConnettoreServletType.ACCORDO_SERVIZIO_PARTE_SPECIFICA_ADD, (ConsoleHelper)env.apsHelper, parametersPOST, (boolean)false, (String)endpointtype);
        oldId = asps.getOldIDServizioForUpdate();
        v1 = env.apsHelper;
        v2 = oldId.getNome();
        v3 = oldId.getTipo();
        v4 = oldId.getVersione();
        v5 = asps.getNome();
        v6 = asps.getTipo();
        v7 = erogatore.getId().toString();
        v8 = erogatore.getNome();
        v9 = erogatore.getTipo();
        v10 = as.getId().toString();
        v11 = env.apcCore.toMessageServiceBinding(as.getServiceBinding());
        v12 = httpConf != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUsername(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpBasic)httpConf)) : null;
        v13 = httpConf != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUsername(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpBasic)httpConf)) : null;
        v14 = new BinaryParameter();
        v15 = new BinaryParameter();
        v16 = asps.getId().toString();
        v17 = asps.getVersioneProtocollo();
        v18 = asps.getPortType();
        v19 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$8(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttps)httpsConf));
        v20 = (Boolean)BaseHelper.evalorElse((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$9(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps ), ()Ljava/lang/Boolean;)((ConnettoreConfigurazioneHttps)httpsConf), (Object)false);
        v21 = httpsConf != null ? !httpsConf.isTrustAllServerCerts().booleanValue() : true;
        v22 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststorePath(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v23 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$10(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsServer ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer));
        v24 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststorePassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v25 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAlgoritmo(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v26 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystorePath(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v27 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$11(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsClient ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient));
        v28 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystorePassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v29 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeyPassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v30 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAlgoritmo(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v31 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeyAlias(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v32 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststoreCrl(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v33 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststoreOcspPolicy(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v34 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystoreByokPolicy(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v35 = as.getVersione().toString();
        v36 = ServletUtils.boolToCheckBoxStatus((Boolean)http_stato);
        v37 = ServletUtils.boolToCheckBoxStatus((Boolean)proxy_enabled);
        v38 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getHostname(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v39 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$12(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneProxy ), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy));
        v40 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUsername(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v41 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getPassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v42 = ServletUtils.boolToCheckBoxStatus((Boolean)tempiRisposta_enabled);
        v43 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$13(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v44 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$14(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v45 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziUpdateCheckData$15(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v46 = ServletUtils.boolToCheckBoxStatus((Boolean)false);
        v47 = ServletUtils.boolToCheckBoxStatus((Boolean)erogazioneAutenticazioneOpzionale);
        v48 = AutorizzazioneUtilities.convertToStato((String)erogazioneAutorizzazione);
        v49 = ServletUtils.boolToCheckBoxStatus((Boolean)erogazioneAutorizzazioneAutenticati);
        v50 = ServletUtils.boolToCheckBoxStatus((Boolean)erogazioneAutorizzazioneRuoli);
        v51 = env.isSupportatoAutenticazioneSoggetti;
        v52 = ServletUtils.boolToCheckBoxStatus((Boolean)fruizioneAutenticazioneOpzionale);
        v53 = AutorizzazioneUtilities.convertToStato((String)fruizioneAutorizzazione);
        v54 = ServletUtils.boolToCheckBoxStatus((Boolean)fruizioneAutorizzazioneAutenticati);
        v55 = ServletUtils.boolToCheckBoxStatus((Boolean)fruizioneAutorizzazioneRuoli);
        v56 = env.tipo_protocollo;
        v57 = apiKey != false ? "yes" : "no";
        if (!apiKey) ** GOTO lbl-1000
        v58 = env.erogazioniHelper;
        v59 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKeyHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        v60 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppIdHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        if (v58.isAutenticazioneApiKeyUseOAS3Names(v59, v60)) {
            v61 = true;
        } else lbl-1000:
        // 2 sources

        {
            v61 = false;
        }
        if (!apiKey) ** GOTO lbl-1000
        v62 = env.erogazioniHelper;
        v63 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppId(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        if (v62.isAutenticazioneApiKeyUseAppId(v63)) {
            v64 = true;
        } else lbl-1000:
        // 2 sources

        {
            v64 = false;
        }
        if (!v1.serviziCheckData(TipoOperazione.CHANGE, soggettiCompatibili, accordiList, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, "no", endpointtype, endpoint_url, null, null, v12, v13, null, null, null, null, null, v14, v15, v16, v17, v18, ptArray, accordoPrivato, false, endpoint_url, v19, v20, v21, v22, v23, v24, v25, httpsstato, httpskeystore, "", v26, v27, v28, v29, v30, v31, v32, v33, v34, null, v35, false, null, v36, v37, v38, v39, v40, v41, v42, v43, v44, v45, v46, "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, erogazioneAutenticazione, v47, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, v48, v49, v50, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, v51, isErogazione, listExtendedConnettore, null, null, fruizioneAutenticazione, v52, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, v53, v54, v55, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, v56, xamlPolicy, "", null, null, autenticazioneToken, tokenPolicy, v57, v61, v64, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKeyHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKey(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppIdHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppId(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, false, null, canaleStato, canale, gestioneCanaliEnabled)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
    }

    public static final List<IDSoggettoDB> getSoggettiCompatibiliAutorizzazione(CredenzialeTipo tipoAutenticazione, Boolean appId, IdSoggetto erogatore, ErogazioniEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException {
        List tipiSoggettiGestitiProtocollo;
        List list;
        PddTipologia pddTipologiaSoggettoAutenticati = null;
        boolean gestioneErogatoriSoggettiAutenticatiEscludiSoggettoErogatore = false;
        if (env.apsCore.isMultitenant() && env.apsCore.getMultitenantSoggettiErogazioni() != null) {
            switch (env.apsCore.getMultitenantSoggettiErogazioni()) {
                case SOLO_SOGGETTI_ESTERNI: {
                    pddTipologiaSoggettoAutenticati = PddTipologia.ESTERNO;
                    break;
                }
                case ESCLUDI_SOGGETTO_EROGATORE: {
                    gestioneErogatoriSoggettiAutenticatiEscludiSoggettoErogatore = true;
                    break;
                }
            }
        }
        if (!(list = env.soggettiCore.getSoggettiFromTipoAutenticazione(tipiSoggettiGestitiProtocollo = env.soggettiCore.getTipiSoggettiGestitiProtocollo(env.tipo_protocollo), null, tipoAutenticazione, appId, pddTipologiaSoggettoAutenticati)).isEmpty() && gestioneErogatoriSoggettiAutenticatiEscludiSoggettoErogatore) {
            for (int i = 0; i < list.size(); ++i) {
                IDSoggettoDB soggettoCheck = (IDSoggettoDB)list.get(i);
                if (!soggettoCheck.getTipo().equals(erogatore.getTipo()) || !soggettoCheck.getNome().equals(erogatore.getNome())) continue;
                list.remove(i);
                break;
            }
        }
        return list;
    }

    public static BooleanNullable getAutenticazioneOpzionale(Object authn) {
        if (authn != null) {
            if (authn instanceof APIImplAutenticazioneBasic) {
                return new BooleanNullable(((APIImplAutenticazioneBasic)authn).isOpzionale());
            }
            if (authn instanceof APIImplAutenticazioneHttps) {
                return new BooleanNullable(((APIImplAutenticazioneHttps)authn).isOpzionale());
            }
            if (authn instanceof APIImplAutenticazionePrincipal) {
                return new BooleanNullable(((APIImplAutenticazionePrincipal)authn).isOpzionale());
            }
            if (authn instanceof APIImplAutenticazioneApiKey) {
                return new BooleanNullable(((APIImplAutenticazioneApiKey)authn).isOpzionale());
            }
            if (authn instanceof APIImplAutenticazioneCustom) {
                return new BooleanNullable(((APIImplAutenticazioneCustom)authn).isOpzionale());
            }
        }
        return BooleanNullable.NULL();
    }

    public static TipoAutenticazionePrincipal getTipoAutenticazionePrincipal(Object authn) {
        APIImplAutenticazionePrincipal authPrincipal;
        TipoAutenticazioneEnum tipo;
        if (authn instanceof APIImplAutenticazionePrincipal && TipoAutenticazioneEnum.PRINCIPAL.equals((Object)(tipo = (authPrincipal = (APIImplAutenticazionePrincipal)authn).getTipo()))) {
            try {
                return Enums.tipoAutenticazionePrincipalFromRest.get((Object)authPrincipal.getTipoPrincipal());
            }
            catch (Exception e) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione principal non \u00e8 correttamente definita: " + e.getMessage());
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getAutenticazioneParametroList(ErogazioniEnv env, TipoAutenticazioneEnum tipo, Object authn) {
        APIImplAutenticazioneApiKeyPosizione defaultValues;
        if (TipoAutenticazioneEnum.HTTP_BASIC.equals((Object)tipo)) {
            APIImplAutenticazioneBasic authnBasic = null;
            if (authn != null) {
                if (!(authn instanceof APIImplAutenticazioneBasic)) throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione '" + String.valueOf((Object)tipo) + "' non \u00e8 correttamente definita (trovata configurazione '" + authn.getClass().getName() + "')");
                authnBasic = (APIImplAutenticazioneBasic)authn;
            }
            if (authnBasic == null) return null;
            ArrayList<Proprieta> listConfig = new ArrayList<Proprieta>();
            if (authnBasic.isForward() != null) {
                Proprieta propertyAutenticazione = new Proprieta();
                propertyAutenticazione.setNome("cleanAuthorizationHeader");
                if (authnBasic.isForward().booleanValue()) {
                    propertyAutenticazione.setValore("false");
                } else {
                    propertyAutenticazione.setValore("true");
                }
                listConfig.add(propertyAutenticazione);
            }
            if (listConfig.isEmpty()) return null;
            return env.stationCore.getParametroAutenticazione(Enums.tipoAutenticazioneFromRest.get((Object)tipo).toString(), listConfig);
        }
        if (TipoAutenticazioneEnum.PRINCIPAL.equals((Object)tipo)) {
            Proprieta propertyAutenticazione;
            APIImplAutenticazionePrincipal authnPrincipal = null;
            if (authn != null) {
                if (!(authn instanceof APIImplAutenticazionePrincipal)) throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione '" + String.valueOf((Object)tipo) + "' non \u00e8 correttamente definita (trovata configurazione '" + authn.getClass().getName() + "')");
                authnPrincipal = (APIImplAutenticazionePrincipal)authn;
            }
            if (authnPrincipal == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException("Autenticazione principal non correttamente formata");
            TipoAutenticazionePrincipal autenticazionePrincipal = Enums.tipoAutenticazionePrincipalFromRest.get((Object)authnPrincipal.getTipoPrincipal());
            Proprieta propTipoAuthn = new Proprieta();
            propTipoAuthn.setNome("tipoAutenticazione");
            propTipoAuthn.setValore(autenticazionePrincipal.getValue());
            ArrayList<Proprieta> listConfig = new ArrayList<Proprieta>();
            listConfig.add(propTipoAuthn);
            switch (autenticazionePrincipal) {
                case CONTAINER: 
                case INDIRIZZO_IP: 
                case INDIRIZZO_IP_X_FORWARDED_FOR: {
                    break;
                }
                case HEADER: {
                    if (authnPrincipal.getNome() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 stato indicato il nome di un header http per l'autenticazione principal '" + String.valueOf((Object)authnPrincipal.getTipoPrincipal()) + "' indicata");
                    }
                    propertyAutenticazione = new Proprieta();
                    propertyAutenticazione.setNome("nome");
                    propertyAutenticazione.setValore(authnPrincipal.getNome());
                    listConfig.add(propertyAutenticazione);
                    break;
                }
                case FORM: {
                    if (authnPrincipal.getNome() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 stato indicato il nome di un parametro della url per l'autenticazione principal '" + String.valueOf((Object)authnPrincipal.getTipoPrincipal()) + "' indicata");
                    }
                    propertyAutenticazione = new Proprieta();
                    propertyAutenticazione.setNome("nome");
                    propertyAutenticazione.setValore(authnPrincipal.getNome());
                    listConfig.add(propertyAutenticazione);
                    break;
                }
                case URL: {
                    if (authnPrincipal.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 stata fornita una espressione regolare per l'autenticazione principal '" + String.valueOf((Object)authnPrincipal.getTipoPrincipal()) + "' indicata");
                    }
                    propertyAutenticazione = new Proprieta();
                    propertyAutenticazione.setNome("pattern");
                    propertyAutenticazione.setValore(authnPrincipal.getPattern());
                    listConfig.add(propertyAutenticazione);
                    break;
                }
                case TOKEN: {
                    if (authnPrincipal.getToken() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 stato indicato il token claim, da cui estrarre il principal, per l'autenticazione '" + String.valueOf((Object)authnPrincipal.getTipoPrincipal()) + "' indicata");
                    }
                    if (TipoAutenticazionePrincipalToken.CUSTOM.equals((Object)authnPrincipal.getToken()) && authnPrincipal.getNome() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non \u00e8 stato indicato il nome del token claim, da cui estrarre il principal, per l'autenticazione '" + String.valueOf((Object)authnPrincipal.getTipoPrincipal()) + "' indicata");
                    }
                    propertyAutenticazione = new Proprieta();
                    propertyAutenticazione.setNome("claim");
                    switch (authnPrincipal.getToken()) {
                        case SUBJECT: {
                            propertyAutenticazione.setValore("subject");
                            break;
                        }
                        case CLIENTID: {
                            propertyAutenticazione.setValore("clientId");
                            break;
                        }
                        case USERNAME: {
                            propertyAutenticazione.setValore("username");
                            break;
                        }
                        case EMAIL: {
                            propertyAutenticazione.setValore("eMail");
                            break;
                        }
                        case CUSTOM: {
                            propertyAutenticazione.setValore("custom");
                        }
                    }
                    listConfig.add(propertyAutenticazione);
                    if (!TipoAutenticazionePrincipalToken.CUSTOM.equals((Object)authnPrincipal.getToken())) break;
                    propertyAutenticazione = new Proprieta();
                    propertyAutenticazione.setNome("nome");
                    propertyAutenticazione.setValore(authnPrincipal.getNome());
                    listConfig.add(propertyAutenticazione);
                }
            }
            if (authnPrincipal.isForward() != null) {
                propertyAutenticazione = new Proprieta();
                propertyAutenticazione.setNome("cleanPrincipal");
                if (authnPrincipal.isForward().booleanValue()) {
                    propertyAutenticazione.setValore("false");
                } else {
                    propertyAutenticazione.setValore("true");
                }
                listConfig.add(propertyAutenticazione);
            }
            if (listConfig.isEmpty()) return null;
            return env.stationCore.getParametroAutenticazione(tipo.toString(), listConfig);
        }
        if (!TipoAutenticazioneEnum.API_KEY.equals((Object)tipo)) return null;
        APIImplAutenticazioneApiKey authnApiKey = null;
        if (authn != null) {
            if (!(authn instanceof APIImplAutenticazioneApiKey)) throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione '" + String.valueOf((Object)tipo) + "' non \u00e8 correttamente definita (trovata configurazione '" + authn.getClass().getName() + "')");
            authnApiKey = (APIImplAutenticazioneApiKey)authn;
        }
        if (authn == null) return null;
        ArrayList<Proprieta> listConfig = new ArrayList<Proprieta>();
        ErogazioniApiHelper._addProprieta("appId", authnApiKey.isAppId() != null && authnApiKey.isAppId() != false ? "true" : "false", listConfig);
        if (authnApiKey.getPosizione() != null && authnApiKey.getPosizione().isQueryParameter() != null) {
            ErogazioniApiHelper._addProprieta("queryParameter", authnApiKey.getPosizione().isQueryParameter() != false ? "true" : "false", listConfig);
        } else {
            defaultValues = new APIImplAutenticazioneApiKeyPosizione();
            ErogazioniApiHelper._addProprieta("queryParameter", defaultValues.isQueryParameter() != false ? "true" : "false", listConfig);
        }
        if (authnApiKey.getPosizione() != null && authnApiKey.getPosizione().isHeader() != null) {
            ErogazioniApiHelper._addProprieta("header", authnApiKey.getPosizione().isHeader() != false ? "true" : "false", listConfig);
        } else {
            defaultValues = new APIImplAutenticazioneApiKeyPosizione();
            ErogazioniApiHelper._addProprieta("header", defaultValues.isHeader() != false ? "true" : "false", listConfig);
        }
        if (authnApiKey.getPosizione() != null && authnApiKey.getPosizione().isCookie() != null) {
            ErogazioniApiHelper._addProprieta("cookie", authnApiKey.getPosizione().isCookie() != false ? "true" : "false", listConfig);
        } else {
            defaultValues = new APIImplAutenticazioneApiKeyPosizione();
            ErogazioniApiHelper._addProprieta("cookie", defaultValues.isCookie() != false ? "true" : "false", listConfig);
        }
        boolean apiKeyNamesCustom = false;
        boolean appIdNamesCustom = false;
        if (authnApiKey.getApiKeyNomi() != null && (StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getQueryParameter()) || StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getHeader()) || StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getCookie()))) {
            apiKeyNamesCustom = true;
        }
        if (authnApiKey.getAppIdNomi() != null && (StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getQueryParameter()) || StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getHeader()) || StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getCookie()))) {
            appIdNamesCustom = true;
        }
        ErogazioniApiHelper._addProprieta("useOAS3Names", apiKeyNamesCustom || appIdNamesCustom ? "false" : "true", listConfig);
        ErogazioniApiHelper._addProprieta("cleanApiKey", authnApiKey.isApiKeyForward() != null && authnApiKey.isApiKeyForward() != false ? "false" : "true", listConfig);
        ErogazioniApiHelper._addProprieta("cleanAppId", authnApiKey.isAppIdForward() != null && authnApiKey.isAppIdForward() != false ? "false" : "true", listConfig);
        ErogazioniApiHelper._addProprieta("queryParameterApiKey", apiKeyNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getQueryParameter()) ? authnApiKey.getApiKeyNomi().getQueryParameter() : "api_key", listConfig);
        ErogazioniApiHelper._addProprieta("headerApiKey", apiKeyNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getHeader()) ? authnApiKey.getApiKeyNomi().getHeader() : "X-API-KEY", listConfig);
        ErogazioniApiHelper._addProprieta("cookieApiKey", apiKeyNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getApiKeyNomi().getCookie()) ? authnApiKey.getApiKeyNomi().getCookie() : "X-API-KEY", listConfig);
        ErogazioniApiHelper._addProprieta("queryParameterAppId", appIdNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getQueryParameter()) ? authnApiKey.getAppIdNomi().getQueryParameter() : "app_id", listConfig);
        ErogazioniApiHelper._addProprieta("headerAppId", appIdNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getHeader()) ? authnApiKey.getAppIdNomi().getHeader() : "X-APP-ID", listConfig);
        ErogazioniApiHelper._addProprieta("cookieAppId", appIdNamesCustom && StringUtils.isNotEmpty((CharSequence)authnApiKey.getAppIdNomi().getCookie()) ? authnApiKey.getAppIdNomi().getCookie() : "X-APP-ID", listConfig);
        if (listConfig.isEmpty()) return null;
        return env.stationCore.getParametroAutenticazione(Enums.tipoAutenticazioneFromRest.get((Object)tipo).toString(), listConfig);
    }

    private static final void _addProprieta(String nome, String valore, List<Proprieta> listConfig) {
        Proprieta propertyAutenticazione = new Proprieta();
        propertyAutenticazione.setNome(nome);
        propertyAutenticazione.setValore(valore);
        listConfig.add(propertyAutenticazione);
    }

    /*
     * Unable to fully structure code
     */
    public static final void serviziCheckData(TipoOperazione tipoOp, ErogazioniEnv env, AccordoServizioParteComuneSintetico as, AccordoServizioParteSpecifica asps, Optional<IdSoggetto> fruitore, APIImpl impl) throws Exception {
        generaPortaApplicativa = fruitore.isPresent() == false;
        erogatore = new IdSoggetto(new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()));
        erogatore.setId(asps.getIdSoggetto());
        if (impl == null) {
            impl = new APIImpl();
            impl.setConnettore(new BaseConnettoreHttp());
        }
        accordoPrivato = as.getPrivato() != null && as.getPrivato() != false;
        ptList = AccordiServizioParteSpecificaUtilities.getListaPortTypes((AccordoServizioParteComuneSintetico)as, (AccordiServizioParteSpecificaHelper)env.apsHelper);
        ptArray = (String[])ptList.stream().map((Function<PortTypeSintetico, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziCheckData$16(org.openspcoop2.core.registry.beans.PortTypeSintetico ), (Lorg/openspcoop2/core/registry/beans/PortTypeSintetico;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziCheckData$17(int ), (I)[Ljava/lang/String;)());
        searchSoggetti = new ConsoleSearch(true);
        searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", env.tipo_protocollo);
        fruizioniEscludiSoggettoFruitore = false;
        if (fruitore.isPresent()) {
            confCore = new ConfigurazioneCore(env.stationCore);
            confFruizioneErogatori = confCore.getConfigurazioneGenerale().getMultitenant().getFruizioneSceltaSoggettiErogatori();
            if (confFruizioneErogatori == PortaDelegataSoggettiErogatori.SOGGETTI_ESTERNI) {
                searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
            } else if (confFruizioneErogatori == PortaDelegataSoggettiErogatori.ESCLUDI_SOGGETTO_FRUITORE) {
                fruizioniEscludiSoggettoFruitore = true;
            }
        } else {
            searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
        }
        listSoggetti = env.soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti);
        escludiFruitore = fruizioniEscludiSoggettoFruitore;
        soggettiCompatibili = (String[])listSoggetti.stream().filter((Predicate<Soggetto>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$serviziCheckData$18(boolean boolean java.util.Optional org.openspcoop2.core.registry.Soggetto ), (Lorg/openspcoop2/core/registry/Soggetto;)Z)((boolean)generaPortaApplicativa, (boolean)escludiFruitore, fruitore)).map((Function<Soggetto, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziCheckData$19(org.openspcoop2.core.registry.Soggetto ), (Lorg/openspcoop2/core/registry/Soggetto;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziCheckData$20(int ), (I)[Ljava/lang/String;)());
        if (soggettiCompatibili.length == 0) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non ci sono soggetti compatibili per erogare il servizio");
        }
        listaIdAPI = AccordiServizioParteSpecificaUtilities.getListaIdAPI((String)env.tipo_protocollo, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper);
        accordiList = (String[])listaIdAPI.stream().map((Function<IDAccordoDB, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$serviziCheckData$21(org.openspcoop2.core.registry.driver.db.IDAccordoDB ), (Lorg/openspcoop2/core/registry/driver/db/IDAccordoDB;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$serviziCheckData$22(int ), (I)[Ljava/lang/String;)());
        conn = impl.getConnettore();
        httpApiKey = conn.getAutenticazioneApikey();
        apiKey = httpApiKey != null && httpApiKey.getApiKey() != null && StringUtils.isNotEmpty((CharSequence)httpApiKey.getApiKey()) != false;
        httpsConf = conn.getAutenticazioneHttps();
        httpConf = conn.getAutenticazioneHttp();
        endpointtype = httpsConf != null ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome();
        parametersPOST = null;
        conTmp = null;
        listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(conTmp, (ConnettoreServletType)ConnettoreServletType.ACCORDO_SERVIZIO_PARTE_SPECIFICA_ADD, (ConsoleHelper)env.apsHelper, parametersPOST, (boolean)false, (String)endpointtype);
        v0 = httpsConf != null ? (ConnettoreConfigurazioneHttpsClient)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getClient(), ()Lorg/openspcoop2/core/config/rs/server/model/ConnettoreConfigurazioneHttpsClient;)((ConnettoreConfigurazioneHttps)httpsConf)) : (httpsClient = null);
        httpsServer = httpsConf != null ? (ConnettoreConfigurazioneHttpsServer)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getServer(), ()Lorg/openspcoop2/core/config/rs/server/model/ConnettoreConfigurazioneHttpsServer;)((ConnettoreConfigurazioneHttps)httpsConf)) : null;
        proxy = conn.getProxy();
        timeoutConf = conn.getTempiRisposta();
        tokenPolicy = conn.getTokenPolicy();
        autenticazioneToken = tokenPolicy != null;
        httpsstato = httpsClient != null;
        http_stato = conn.getAutenticazioneHttp() != null;
        proxy_enabled = conn.getProxy() != null;
        tempiRisposta_enabled = conn.getTempiRisposta() != null;
        httpskeystore = null;
        if (httpsClient != null) {
            httpskeystore = httpsClient.getKeystorePath() != null || httpsClient.getKeystoreTipo() != null ? "ridefinisci" : "default";
        }
        authz = impl.getAutorizzazione();
        authn = impl.getAutenticazione();
        ruoliFonte = FonteEnum.QUALSIASI;
        erogazioneRuolo = null;
        isRichiedente = false;
        isRuoli = false;
        statoAutorizzazione = null;
        autenticazionePrincipal = null;
        autenticazioneParametroList = null;
        if (authn != null) {
            autenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(authn);
            autenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, authn.getTipo(), authn);
        }
        autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(authn);
        ruoliRichiesti = null;
        if (generaPortaApplicativa && as.getServiceBinding() == ServiceBinding.SOAP && authz != null && authz.getTipo() != null) {
            switch (1.$SwitchMap$org$openspcoop2$core$config$rs$server$model$TipoAutorizzazioneEnum[authz.getTipo().ordinal()]) {
                case 1: {
                    if (authz instanceof APIImplAutorizzazioneAbilitataNew) {
                        authzAbilitata = (APIImplAutorizzazioneAbilitataNew)authz;
                        if (authzAbilitata.getRuoliFonte() != null) {
                            ruoliFonte = authzAbilitata.getRuoliFonte();
                        }
                        erogazioneRuolo = authzAbilitata.getRuolo();
                        isRichiedente = authzAbilitata.isRichiedente();
                        isRuoli = authzAbilitata.isRuoli();
                        statoAutorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
                        ruoliRichiesti = authzAbilitata.getRuoliRichiesti();
                        break;
                    }
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                case 2: {
                    if (authz instanceof APIImplAutorizzazioneXACML) {
                        authzXacml = (APIImplAutorizzazioneXACML)authz;
                        if (authzXacml.getPolicy() == null) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Campo obbligatorio 'policy' non presente nell'autorizzazione indicata");
                        }
                        if (authzXacml.getRuoliFonte() != null) {
                            ruoliFonte = authzXacml.getRuoliFonte();
                        }
                        statoAutorizzazione = "xacml-Policy";
                        break;
                    }
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                case 3: {
                    statoAutorizzazione = AutorizzazioneUtilities.STATO_DISABILITATO;
                    break;
                }
                case 4: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autorizzazione '" + String.valueOf((Object)authz.getTipo()) + "' non utilizzabile");
                }
            }
        }
        if (isRichiedente) {
            configAuthzFinal = (APIImplAutorizzazioneAbilitataNew)authz;
            if (!(!env.isSupportatoAutenticazioneSoggetti || authn != null && authn.getTipo() != TipoAutenticazioneEnum.DISABILITATO || generaPortaApplicativa && env.isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Per poter abilitare l'autorizzazione per richiedente, devi abilitare l'autenticazione");
            }
            if (!StringUtils.isEmpty((CharSequence)configAuthzFinal.getSoggetto()) && !(soggettoCompatibile = ErogazioniApiHelper.getSoggettiCompatibiliAutorizzazione(credTipo = (CredenzialeTipo)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$23(org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutenticazione ), ()Lorg/openspcoop2/core/registry/constants/CredenzialeTipo;)((OneOfAPIImplAutenticazione)authn)), appId = null, env.idSoggetto, env).stream().map((Function<IDSoggettoDB, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNome(), (Lorg/openspcoop2/core/registry/driver/db/IDSoggettoDB;)Ljava/lang/String;)()).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$serviziCheckData$24(org.openspcoop2.core.config.rs.server.model.APIImplAutorizzazioneAbilitataNew java.lang.String ), (Ljava/lang/String;)Z)((APIImplAutorizzazioneAbilitataNew)configAuthzFinal)).findAny()).isPresent()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto " + configAuthzFinal.getSoggetto() + " scelto per l'autorizzazione puntuale non esiste o non \u00e8 compatibile con la modalit\u00e0 di autenticazione scelta");
            }
        }
        if (isRuoli && !StringUtils.isEmpty((CharSequence)(configAuthzFinal = (APIImplAutorizzazioneAbilitataNew)authz).getRuolo())) {
            ruoliCore = new RuoliCore(env.stationCore);
            regRuolo = null;
            try {
                regRuolo = ruoliCore.getRuolo(configAuthzFinal.getRuolo());
            }
            catch (DriverConfigurazioneException soggettoCompatibile) {
                // empty catch block
            }
            if (regRuolo == null) {
                throw FaultCode.NOT_FOUND.toException("Non esiste nessun ruolo con nome " + configAuthzFinal.getRuolo());
            }
        }
        xamlPolicy = new BinaryParameter();
        if (authz instanceof APIImplAutorizzazioneXACML) {
            authzXacml = (APIImplAutorizzazioneXACML)authz;
            xamlPolicy.setValue(authzXacml.getPolicy());
        }
        xamlPolicy.setName("docSicXacmlPol");
        inUsoMessage = new StringBuilder();
        if (AccordiServizioParteSpecificaUtilities.alreadyExists((AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, (long)erogatore.getId(), (IDServizio)env.idServizioFactory.getIDServizioFromAccordo(asps), (String)env.idAccordoFactory.getUriFromAccordo(as), (String)((String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$25(java.util.Optional ), ()Ljava/lang/String;)(fruitore))), (String)((String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$26(java.util.Optional ), ()Ljava/lang/String;)(fruitore))), (String)env.tipo_protocollo, (String)asps.getVersioneProtocollo(), (String)asps.getPortType(), (boolean)(generaPortaApplicativa == false), (boolean)generaPortaApplicativa, (StringBuilder)inUsoMessage)) {
            throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
        }
        gestioneCanaliEnabled = env.gestioneCanali;
        canale = null;
        if (gestioneCanaliEnabled) {
            if (impl instanceof Erogazione) {
                canale = ((Erogazione)impl).getCanale();
            } else if (impl instanceof Fruizione) {
                canale = ((Fruizione)impl).getCanale();
            }
            if (canale != null && !env.canali.contains(canale)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il canale fornito '" + canale + "' non \u00e8 presente nel registro");
            }
        }
        canaleStato = null;
        canaleStato = canale == null ? "default" : "ridefinito";
        v1 = env.apsHelper;
        v2 = asps.getNome();
        v3 = asps.getTipo();
        v4 = asps.getVersione();
        v5 = asps.getNome();
        v6 = asps.getTipo();
        v7 = erogatore.getId().toString();
        v8 = erogatore.getNome();
        v9 = erogatore.getTipo();
        v10 = as.getId().toString();
        v11 = env.apcCore.toMessageServiceBinding(as.getServiceBinding());
        v12 = impl.getConnettore().getEndpoint();
        v13 = httpConf != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUsername(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpBasic)httpConf)) : null;
        v14 = httpConf != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getPassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpBasic)httpConf)) : null;
        v15 = new BinaryParameter();
        v16 = new BinaryParameter();
        v17 = (String)BaseHelper.evalorElse((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$27(org.openspcoop2.core.registry.AccordoServizioParteSpecifica ), ()Ljava/lang/String;)((AccordoServizioParteSpecifica)asps), (Object)"0");
        v18 = asps.getVersioneProtocollo();
        v19 = asps.getPortType();
        v20 = conn.getEndpoint();
        v21 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$28(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttps)httpsConf));
        v22 = (Boolean)BaseHelper.evalorElse((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$29(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttps ), ()Ljava/lang/Boolean;)((ConnettoreConfigurazioneHttps)httpsConf), (Object)false);
        v23 = httpsConf != null ? !httpsConf.isTrustAllServerCerts().booleanValue() : true;
        v24 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststorePath(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v25 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$30(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsServer ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer));
        v26 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststorePassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v27 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAlgoritmo(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v28 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystorePath(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v29 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$31(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsClient ), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient));
        v30 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystorePassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v31 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeyPassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v32 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAlgoritmo(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v33 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeyAlias(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v34 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststoreCrl(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v35 = httpsServer != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getTruststoreOcspPolicy(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsServer)httpsServer)) : null;
        v36 = httpsClient != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getKeystoreByokPolicy(), ()Ljava/lang/String;)((ConnettoreConfigurazioneHttpsClient)httpsClient)) : null;
        v37 = asps.getVersione().toString();
        v38 = ServletUtils.boolToCheckBoxStatus((Boolean)http_stato);
        v39 = ServletUtils.boolToCheckBoxStatus((Boolean)proxy_enabled);
        v40 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getHostname(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v41 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$32(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneProxy ), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy));
        v42 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getUsername(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v43 = proxy != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getPassword(), ()Ljava/lang/String;)((ConnettoreConfigurazioneProxy)proxy)) : null;
        v44 = ServletUtils.boolToCheckBoxStatus((Boolean)tempiRisposta_enabled);
        v45 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$33(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v46 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$34(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v47 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$35(org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneTimeout ), ()Ljava/lang/String;)((ConnettoreConfigurazioneTimeout)timeoutConf));
        v48 = ServletUtils.boolToCheckBoxStatus((Boolean)false);
        v49 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$36(org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutenticazione ), ()Ljava/lang/String;)((OneOfAPIImplAutenticazione)authn));
        v50 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$37(org.openspcoop2.utils.BooleanNullable ), ()Ljava/lang/String;)((BooleanNullable)autenticazioneOpzionaleNullable));
        v51 = ServletUtils.boolToCheckBoxStatus((Boolean)isRichiedente);
        v52 = ServletUtils.boolToCheckBoxStatus((Boolean)isRuoli);
        v53 = Enums.ruoloTipologiaFromRest.get((Object)ruoliFonte).toString();
        v54 = ruoliRichiesti != null ? ruoliRichiesti.toString() : null;
        v55 = env.isSupportatoAutenticazioneSoggetti;
        v56 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$38(org.openspcoop2.core.config.rs.server.model.OneOfAPIImplAutenticazione ), ()Ljava/lang/String;)((OneOfAPIImplAutenticazione)authn));
        v57 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$39(org.openspcoop2.utils.BooleanNullable ), ()Ljava/lang/String;)((BooleanNullable)autenticazioneOpzionaleNullable));
        v58 = ServletUtils.boolToCheckBoxStatus((Boolean)isRichiedente);
        v59 = ServletUtils.boolToCheckBoxStatus((Boolean)isRuoli);
        v60 = Enums.ruoloTipologiaFromRest.get((Object)ruoliFonte).toString();
        v61 = ruoliRichiesti != null ? ruoliRichiesti.toString() : null;
        v62 = env.tipo_protocollo;
        v63 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$40(java.util.Optional ), ()Ljava/lang/String;)(fruitore));
        v64 = (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$serviziCheckData$41(java.util.Optional ), ()Ljava/lang/String;)(fruitore));
        v65 = apiKey != false ? "yes" : "no";
        if (!apiKey) ** GOTO lbl-1000
        v66 = env.erogazioniHelper;
        v67 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKeyHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        v68 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppIdHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        if (v66.isAutenticazioneApiKeyUseOAS3Names(v67, v68)) {
            v69 = true;
        } else lbl-1000:
        // 2 sources

        {
            v69 = false;
        }
        if (!apiKey) ** GOTO lbl-1000
        v70 = env.erogazioniHelper;
        v71 = httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppId(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null;
        if (v70.isAutenticazioneApiKeyUseAppId(v71)) {
            v72 = true;
        } else lbl-1000:
        // 2 sources

        {
            v72 = false;
        }
        if (!v1.serviziCheckData(tipoOp, soggettiCompatibili, accordiList, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, "no", endpointtype, v12, null, null, v13, v14, null, null, null, null, null, v15, v16, v17, v18, v19, ptArray, accordoPrivato, false, v20, v21, v22, v23, v24, v25, v26, v27, httpsstato, httpskeystore, "", v28, v29, v30, v31, v32, v33, v34, v35, v36, null, v37, false, null, v38, v39, v40, v41, v42, v43, v44, v45, v46, v47, v48, "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, erogazioneRuolo, v49, v50, autenticazionePrincipal, autenticazioneParametroList, statoAutorizzazione, v51, v52, v53, v54, v55, generaPortaApplicativa, listExtendedConnettore, null, null, v56, v57, autenticazionePrincipal, autenticazioneParametroList, statoAutorizzazione, v58, v59, v60, v61, v62, xamlPolicy, "", v63, v64, autenticazioneToken, tokenPolicy, v65, v69, v72, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKeyHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getApiKey(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppIdHeader(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, httpApiKey != null ? (String)BaseHelper.evalnull((BaseHelper.ThrowingSupplier)(BaseHelper.ThrowingSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAppId(), ()Ljava/lang/String;)((ConnettoreConfigurazioneApiKey)httpApiKey)) : null, false, null, canaleStato, canale, gestioneCanaliEnabled)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
    }

    public static final Connettore buildConnettoreRegistro(ErogazioniEnv env, BaseConnettoreHttp conn) throws Exception {
        Connettore regConnettore = new Connettore();
        ErogazioniApiHelper.fillConnettoreRegistro(regConnettore, env, conn, "");
        return regConnettore;
    }

    public static final void fillConnettoreRegistro(Connettore regConnettore, ErogazioniEnv env, BaseConnettoreHttp conn, String oldConnT) throws Exception {
        ConnettoreConfigurazioneHttpsClient httpsClient;
        boolean proxy_enabled = conn.getProxy() != null;
        boolean tempiRisposta_enabled = conn.getTempiRisposta() != null;
        ConnettoreConfigurazioneApiKey httpApiKey = conn.getAutenticazioneApikey();
        ConnettoreConfigurazioneHttps httpsConf = conn.getAutenticazioneHttps();
        ConnettoreConfigurazioneHttpBasic httpConf = conn.getAutenticazioneHttp();
        String endpointtype = httpsConf != null ? TipiConnettore.HTTPS.getNome() : TipiConnettore.HTTP.getNome();
        Properties parametersPOST = null;
        Connettore conTmp = null;
        List listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(conTmp, (ConnettoreServletType)ConnettoreServletType.ACCORDO_SERVIZIO_PARTE_SPECIFICA_ADD, (ConsoleHelper)env.apsHelper, parametersPOST, (boolean)false, (String)endpointtype);
        ConnettoreConfigurazioneHttpsClient connettoreConfigurazioneHttpsClient = httpsConf != null ? (ConnettoreConfigurazioneHttpsClient)BaseHelper.evalnull(httpsConf::getClient) : (httpsClient = null);
        ConnettoreConfigurazioneHttpsServer httpsServer = httpsConf != null ? (ConnettoreConfigurazioneHttpsServer)BaseHelper.evalnull(httpsConf::getServer) : null;
        ConnettoreConfigurazioneProxy proxy = conn.getProxy();
        ConnettoreConfigurazioneTimeout timeoutConf = conn.getTempiRisposta();
        String tokenPolicy = conn.getTokenPolicy();
        boolean httpsstato = httpsClient != null;
        String httpskeystore = ErogazioniCheckNotNull.getHttpskeystore(httpsClient);
        env.apsHelper.fillConnettore(regConnettore, conn.isDebug() != null && conn.isDebug() != false ? "true" : "false", endpointtype, oldConnT, "", conn.getEndpoint(), null, null, httpConf != null ? (String)BaseHelper.evalnull(httpConf::getUsername) : null, httpConf != null ? (String)BaseHelper.evalnull(httpConf::getPassword) : null, null, null, conn.getEndpoint(), null, null, conn.getEndpoint(), (String)BaseHelper.evalnull(() -> httpsConf.getTipologia().toString()), ((Boolean)BaseHelper.evalorElse(() -> (boolean)httpsConf.isHostnameVerifier(), (Object)false)).booleanValue(), httpsConf != null ? !httpsConf.isTrustAllServerCerts().booleanValue() : true, httpsServer != null ? (String)BaseHelper.evalnull(httpsServer::getTruststorePath) : null, (String)BaseHelper.evalnull(() -> ConnettoreHTTPApiHelper.getTruststoreType(httpsServer)), httpsServer != null ? (String)BaseHelper.evalnull(httpsServer::getTruststorePassword) : null, httpsServer != null ? (String)BaseHelper.evalnull(httpsServer::getAlgoritmo) : null, httpsstato, httpskeystore, "", httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getKeystorePath) : null, (String)BaseHelper.evalnull(() -> ConnettoreHTTPApiHelper.getKeystoreType(httpsClient)), httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getKeystorePassword) : null, httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getKeyPassword) : null, httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getAlgoritmo) : null, httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getKeyAlias) : null, httpsServer != null ? (String)BaseHelper.evalnull(httpsServer::getTruststoreCrl) : null, httpsServer != null ? (String)BaseHelper.evalnull(httpsServer::getTruststoreOcspPolicy) : null, httpsClient != null ? (String)BaseHelper.evalnull(httpsClient::getKeystoreByokPolicy) : null, ServletUtils.boolToCheckBoxStatus((Boolean)proxy_enabled), proxy != null ? (String)BaseHelper.evalnull(proxy::getHostname) : null, (String)BaseHelper.evalnull(() -> proxy.getPorta().toString()), proxy != null ? (String)BaseHelper.evalnull(proxy::getUsername) : null, proxy != null ? (String)BaseHelper.evalnull(proxy::getPassword) : null, ServletUtils.boolToCheckBoxStatus((Boolean)tempiRisposta_enabled), (String)BaseHelper.evalnull(() -> timeoutConf.getConnectionTimeout().toString()), (String)BaseHelper.evalnull(() -> timeoutConf.getConnectionReadTimeout().toString()), (String)BaseHelper.evalnull(() -> timeoutConf.getTempoMedioRisposta().toString()), "no", "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, tokenPolicy, httpApiKey != null ? (String)BaseHelper.evalnull(httpApiKey::getApiKeyHeader) : null, httpApiKey != null ? (String)BaseHelper.evalnull(httpApiKey::getApiKey) : null, httpApiKey != null ? (String)BaseHelper.evalnull(httpApiKey::getAppIdHeader) : null, httpApiKey != null ? (String)BaseHelper.evalnull(httpApiKey::getAppId) : null, null, listExtendedConnettore);
    }

    public static final void createAps(ErogazioniEnv env, AccordoServizioParteSpecifica asps, Connettore regConnettore, APIImpl impl, boolean alreadyExists, boolean generaPortaApplicativa) throws Exception {
        boolean generaPortaDelegata;
        boolean bl = generaPortaDelegata = !generaPortaApplicativa;
        if (impl.getAutenticazione() == null) {
            APIImplAutenticazioneHttps https = new APIImplAutenticazioneHttps();
            https.setTipo(TipoAutenticazioneEnum.HTTPS);
            https.setOpzionale(false);
            impl.setAutenticazione(https);
        }
        OneOfAPIImplAutorizzazione authz = impl.getAutorizzazione();
        OneOfAPIImplAutenticazione authn = impl.getAutenticazione();
        AccordoServizioParteComuneSintetico as = null;
        if (asps != null) {
            as = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        }
        FonteEnum ruoliFonte = FonteEnum.QUALSIASI;
        boolean isRichiedente = false;
        boolean isRuoli = false;
        String statoAutorizzazione = AutorizzazioneUtilities.STATO_DISABILITATO;
        String soggettoAutenticato = null;
        AllAnyEnum ruoliRichiesti = null;
        String ruolo = null;
        TipoAutenticazionePrincipal autenticazionePrincipal = null;
        List<String> autenticazioneParametroList = null;
        if (authn != null) {
            autenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(authn);
            autenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, authn.getTipo(), authn);
        }
        BooleanNullable autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(authn);
        if (BaseHelper.evalnull(() -> authz.getTipo()) != null) {
            switch (authz.getTipo()) {
                case ABILITATO: {
                    if (authz instanceof APIImplAutorizzazioneAbilitataNew) {
                        APIImplAutorizzazioneAbilitataNew authzAbilitata = (APIImplAutorizzazioneAbilitataNew)authz;
                        if (authzAbilitata.getRuoliFonte() != null) {
                            ruoliFonte = authzAbilitata.getRuoliFonte();
                        }
                        isRichiedente = authzAbilitata.isRichiedente();
                        isRuoli = authzAbilitata.isRuoli();
                        statoAutorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
                        if (authzAbilitata.getSoggetto() != null) {
                            soggettoAutenticato = new IDSoggetto(env.tipo_soggetto, authzAbilitata.getSoggetto()).toString();
                        }
                        ruoliRichiesti = authzAbilitata.getRuoliRichiesti();
                        ruolo = authzAbilitata.getRuolo();
                        break;
                    }
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                case XACML_POLICY: {
                    if (authz instanceof APIImplAutorizzazioneXACML) {
                        APIImplAutorizzazioneXACML authzXacml = (APIImplAutorizzazioneXACML)authz;
                        if (authzXacml.getPolicy() == null) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Campo obbligatorio 'policy' non presente nell'autorizzazione indicata");
                        }
                        if (authzXacml.getRuoliFonte() != null) {
                            ruoliFonte = authzXacml.getRuoliFonte();
                        }
                        statoAutorizzazione = "xacml-Policy";
                        break;
                    }
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                case DISABILITATO: {
                    statoAutorizzazione = AutorizzazioneUtilities.STATO_DISABILITATO;
                    break;
                }
                case CUSTOM: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo di autorizzazione '" + String.valueOf((Object)authz.getTipo()) + "' non utilizzabile");
                }
            }
        }
        IDServizio idServizio = null;
        if (asps != null) {
            idServizio = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
        }
        BinaryParameter xamlPolicy = new BinaryParameter();
        if (authz instanceof APIImplAutorizzazioneXACML) {
            APIImplAutorizzazioneXACML authzXacml = (APIImplAutorizzazioneXACML)authz;
            xamlPolicy.setValue(authzXacml.getPolicy());
        }
        xamlPolicy.setName("docSicXacmlPol");
        boolean gestioneCanaliEnabled = env.gestioneCanali;
        String canale = null;
        if (gestioneCanaliEnabled) {
            if (impl instanceof Erogazione) {
                canale = ((Erogazione)impl).getCanale();
            } else if (impl instanceof Fruizione) {
                canale = ((Fruizione)impl).getCanale();
            }
            if (canale != null && !env.canali.contains(canale)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il canale fornito '" + canale + "' non \u00e8 presente nel registro");
            }
        }
        String canaleStato = null;
        canaleStato = canale == null ? "default" : "ridefinito";
        ProtocolProperties p = null;
        if (generaPortaApplicativa) {
            p = ErogazioniApiHelper.getProtocolProperties(asps, env);
        } else {
            IDFruizione idFruizione = new IDFruizione();
            IDServizio idAps = new IDServizio();
            if (asps != null) {
                idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                idAps.setPortType(asps.getPortType());
            }
            idFruizione.setIdServizio(idAps);
            IDSoggetto idFruitore = new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome());
            idFruizione.setIdFruitore(idFruitore);
            Fruitore fruitore = ErogazioniApiHelper.getFruitore(asps, env.idSoggetto.getNome());
            if (fruitore == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il fruitore '" + env.idSoggetto.getNome() + "' non risulta definito");
            }
            p = ErogazioniApiHelper.getProtocolProperties(idFruizione, fruitore, env);
        }
        AccordiServizioParteSpecificaUtilities.create((String)env.userLogin, (AccordoServizioParteSpecifica)asps, (boolean)alreadyExists, (IDServizio)idServizio, (IDSoggetto)env.idSoggetto.toIDSoggetto(), (String)env.tipo_protocollo, (org.openspcoop2.message.constants.ServiceBinding)env.apcCore.toMessageServiceBinding(as.getServiceBinding()), (long)env.idSoggetto.getId(), (Connettore)regConnettore, (boolean)generaPortaApplicativa, (boolean)generaPortaDelegata, (String)((String)BaseHelper.evalnull(() -> Enums.tipoAutenticazioneFromRest.get((Object)authn.getTipo()).toString())), (String)((String)BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null)))), (TipoAutenticazionePrincipal)autenticazionePrincipal, autenticazioneParametroList, (String)statoAutorizzazione, (String)ServletUtils.boolToCheckBoxStatus((Boolean)isRichiedente), (String)ServletUtils.boolToCheckBoxStatus((Boolean)isRuoli), (String)Enums.ruoloTipologiaFromRest.get((Object)ruoliFonte).toString(), (String)(ruoliRichiesti != null ? ruoliRichiesti.toString() : null), null, (String)ruolo, (String)soggettoAutenticato, null, null, null, null, null, null, null, null, (BinaryParameter)xamlPolicy, (String)StatoFunzionalita.DISABILITATO.toString(), null, null, null, null, null, null, null, null, null, null, null, (ProtocolProperties)p, (ConsoleOperationType)ConsoleOperationType.ADD, (AccordiServizioParteSpecificaCore)env.apsCore, (ErogazioniHelper)env.erogazioniHelper, null, (String)canaleStato, (String)canale, (boolean)gestioneCanaliEnabled, null, null, null);
    }

    public static Fruitore getFruitore(AccordoServizioParteSpecifica asps, String nome) {
        if (asps != null && asps.getFruitoreList() != null) {
            for (Fruitore f : asps.getFruitoreList()) {
                if (!f.getNome().equals(nome)) continue;
                return f;
            }
        }
        return null;
    }

    public static final AccordoServizioParteSpecifica getServizio(String tipo, String nome, Integer versione, IDSoggetto idErogatore, ErogazioniEnv env) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipo == null) {
            tipo = (String)((List)env.protocolFactoryMgr._getServiceTypes().get(env.tipo_protocollo)).get(0);
        }
        IDServizio idAps = env.idServizioFactory.getIDServizioFromValues(tipo, nome, idErogatore, versione.intValue());
        return env.apsCore.getServizio(idAps, true);
    }

    public static final boolean isErogazione(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverConfigurazioneException, DriverRegistroServiziException {
        List pApplicative = env.paCore.getIDPorteApplicativeAssociate(env.idServizioFactory.getIDServizioFromAccordo(asps));
        return pApplicative != null && !pApplicative.isEmpty();
    }

    public static final boolean isFruizione(AccordoServizioParteSpecifica asps, IDSoggetto idFruitore, ErogazioniEnv env) throws DriverConfigurazioneException, DriverRegistroServiziException {
        List pDelegate = env.pdCore.getIDPorteDelegateAssociate(env.idServizioFactory.getIDServizioFromAccordo(asps), idFruitore);
        return pDelegate != null && !pDelegate.isEmpty();
    }

    public static final AccordoServizioParteSpecifica getServizioIfErogazione(String tipo, String nome, Integer versione, IDSoggetto idErogatore, ErogazioniEnv env) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica ret = ErogazioniApiHelper.getServizio(tipo, nome, versione, idErogatore, env);
        try {
            if (!ErogazioniApiHelper.isErogazione(ret, env)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public static final AccordoServizioParteSpecifica getServizioIfFruizione(String tipo, String nome, Integer versione, IDSoggetto idErogatore, IDSoggetto idFruitore, ErogazioniEnv env) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica ret = ErogazioniApiHelper.getServizio(tipo, nome, versione, idErogatore, env);
        try {
            if (!ErogazioniApiHelper.isFruizione(ret, idFruitore, env)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public static final Documento implAllegatoToDocumento(ApiImplAllegato body, AccordoServizioParteSpecifica asps) throws InstantiationException, IllegalAccessException {
        Documento documento = new Documento();
        documento.setIdProprietarioDocumento(asps.getId());
        RuoloAllegatoAPIImpl ruoloAllegato = body.getAllegato().getRuolo();
        documento.setRuolo(RuoliDocumento.valueOf((String)Enums.ruoliDocumentoFromApiImpl.get((Object)ruoloAllegato).toString()).toString());
        switch (ruoloAllegato) {
            case ALLEGATO: {
                if (!(body.getAllegato() instanceof ApiImplAllegatoGenerico)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'allegato fornito possiede una struttura dati '" + body.getAllegato().getClass().getName() + "' non compatibile con il ruolo '" + String.valueOf((Object)ruoloAllegato) + "'");
                }
                ApiImplAllegatoGenerico allegatoGenerico = (ApiImplAllegatoGenerico)body.getAllegato();
                documento.setFile(allegatoGenerico.getNome());
                documento.setByteContenuto(allegatoGenerico.getDocumento());
                documento.setTipo((String)BaseHelper.evalnull(() -> allegatoGenerico.getNome().substring(allegatoGenerico.getNome().lastIndexOf(46) + 1, allegatoGenerico.getNome().length())));
                break;
            }
            case SPECIFICASEMIFORMALE: {
                if (!(body.getAllegato() instanceof ApiImplAllegatoSpecificaSemiformale)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'allegato fornito possiede una struttura dati '" + body.getAllegato().getClass().getName() + "' non compatibile con il ruolo '" + String.valueOf((Object)ruoloAllegato) + "'");
                }
                ApiImplAllegatoSpecificaSemiformale allegatoSS = (ApiImplAllegatoSpecificaSemiformale)body.getAllegato();
                documento.setFile(allegatoSS.getNome());
                documento.setByteContenuto(allegatoSS.getDocumento());
                if (!ErogazioniCheckNotNull.isNotNullTipoSpecifica(allegatoSS, documento)) break;
                TipoSpecificaSemiformaleEnum tipoAllegato = allegatoSS.getTipoSpecifica();
                documento.setTipo(((TipiDocumentoSemiformale)BaseHelper.evalnull(() -> Enums.tipoDocumentoSemiFormaleFromSpecifica.get((Object)tipoAllegato))).toString());
                break;
            }
            case SPECIFICALIVELLOSERVIZIO: {
                if (!(body.getAllegato() instanceof ApiImplAllegatoSpecificaLivelloServizio)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'allegato fornito possiede una struttura dati '" + body.getAllegato().getClass().getName() + "' non compatibile con il ruolo '" + String.valueOf((Object)ruoloAllegato) + "'");
                }
                ApiImplAllegatoSpecificaLivelloServizio allegatoLS = (ApiImplAllegatoSpecificaLivelloServizio)body.getAllegato();
                documento.setFile(allegatoLS.getNome());
                documento.setByteContenuto(allegatoLS.getDocumento());
                if (!ErogazioniCheckNotNull.isNotNullTipoSpecifica(allegatoLS, documento)) break;
                TipoSpecificaLivelloServizioEnum tipoAllegato = allegatoLS.getTipoSpecifica();
                documento.setTipo((String)BaseHelper.evalnull(() -> Enums.tipoDocumentoLivelloServizioFromSpecifica.get((Object)tipoAllegato).toString()));
                break;
            }
            case SPECIFICASICUREZZA: {
                if (!(body.getAllegato() instanceof ApiImplAllegatoSpecificaSicurezza)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'allegato fornito possiede una struttura dati '" + body.getAllegato().getClass().getName() + "' non compatibile con il ruolo '" + String.valueOf((Object)ruoloAllegato) + "'");
                }
                ApiImplAllegatoSpecificaSicurezza allegatoSSec = (ApiImplAllegatoSpecificaSicurezza)body.getAllegato();
                documento.setFile(allegatoSSec.getNome());
                documento.setByteContenuto(allegatoSSec.getDocumento());
                if (!ErogazioniCheckNotNull.isNotNullTipoSpecifica(allegatoSSec, documento)) break;
                TipoSpecificaSicurezzaEnum tipoAllegato = allegatoSSec.getTipoSpecifica();
                documento.setTipo((String)BaseHelper.evalnull(() -> Enums.tipoDocumentoSicurezzaFromSpecifica.get((Object)tipoAllegato).toString()));
            }
        }
        return documento;
    }

    public static final ApiImplAllegato documentoToImplAllegato(Documento doc) {
        ApiImplAllegato ret = new ApiImplAllegato();
        RuoloAllegatoAPIImpl ruoloAllegato = Enums.ruoliApiImplFromDocumento.get(RuoliDocumento.valueOf((String)doc.getRuolo()));
        switch (ruoloAllegato) {
            case ALLEGATO: {
                ApiImplAllegatoGenerico allegatoGenerico = new ApiImplAllegatoGenerico();
                allegatoGenerico.setRuolo(ruoloAllegato);
                allegatoGenerico.setDocumento(doc.getByteContenuto());
                allegatoGenerico.setNome(doc.getFile());
                ret.setAllegato(allegatoGenerico);
                break;
            }
            case SPECIFICASEMIFORMALE: {
                ApiImplAllegatoSpecificaSemiformale allegatoSS = new ApiImplAllegatoSpecificaSemiformale();
                allegatoSS.setRuolo(ruoloAllegato);
                allegatoSS.setDocumento(doc.getByteContenuto());
                allegatoSS.setNome(doc.getFile());
                TipiDocumentoSemiformale tipo = TipiDocumentoSemiformale.toEnumConstant((String)doc.getTipo());
                allegatoSS.setTipoSpecifica(Helper.apiEnumToGovway(tipo, TipoSpecificaSemiformaleEnum.class));
                ret.setAllegato(allegatoSS);
                break;
            }
            case SPECIFICALIVELLOSERVIZIO: {
                ApiImplAllegatoSpecificaLivelloServizio allegatoSL = new ApiImplAllegatoSpecificaLivelloServizio();
                allegatoSL.setRuolo(ruoloAllegato);
                allegatoSL.setDocumento(doc.getByteContenuto());
                allegatoSL.setNome(doc.getFile());
                TipiDocumentoLivelloServizio tipo = TipiDocumentoLivelloServizio.toEnumConstant((String)doc.getTipo());
                allegatoSL.setTipoSpecifica(Helper.apiEnumToGovway(tipo, TipoSpecificaLivelloServizioEnum.class));
                ErogazioniCheckNotNull.documentoToImplAllegato(allegatoSL, tipo);
                ret.setAllegato(allegatoSL);
                break;
            }
            case SPECIFICASICUREZZA: {
                ApiImplAllegatoSpecificaSicurezza allegatoSSec = new ApiImplAllegatoSpecificaSicurezza();
                allegatoSSec.setRuolo(ruoloAllegato);
                allegatoSSec.setDocumento(doc.getByteContenuto());
                allegatoSSec.setNome(doc.getFile());
                TipiDocumentoSicurezza tipo = TipiDocumentoSicurezza.toEnumConstant((String)doc.getTipo());
                allegatoSSec.setTipoSpecifica(Helper.apiEnumToGovway(tipo, TipoSpecificaSicurezzaEnum.class));
                ErogazioniCheckNotNull.documentoToImplAllegato(allegatoSSec, tipo);
                ret.setAllegato(allegatoSSec);
                break;
            }
        }
        return ret;
    }

    public static final ApiImplAllegatoItem ImplAllegatoToItem(ApiImplAllegato allegato) {
        ApiImplAllegatoItem ret = new ApiImplAllegatoItem();
        RuoloAllegatoAPIImpl ruoloAllegato = allegato.getAllegato().getRuolo();
        switch (ruoloAllegato) {
            case ALLEGATO: {
                ApiImplAllegatoGenerico allegatoGenerico = (ApiImplAllegatoGenerico)allegato.getAllegato();
                ApiImplAllegatoItemGenerico allegatoGenericoItem = new ApiImplAllegatoItemGenerico();
                allegatoGenericoItem.setRuolo(ruoloAllegato);
                allegatoGenericoItem.setNome(allegatoGenerico.getNome());
                ret.setAllegato(allegatoGenericoItem);
                break;
            }
            case SPECIFICASEMIFORMALE: {
                ApiImplAllegatoSpecificaSemiformale allegatoSS = (ApiImplAllegatoSpecificaSemiformale)allegato.getAllegato();
                ApiImplAllegatoItemSpecificaSemiformale allegatoItemSS = new ApiImplAllegatoItemSpecificaSemiformale();
                allegatoItemSS.setRuolo(ruoloAllegato);
                allegatoItemSS.setNome(allegatoSS.getNome());
                allegatoItemSS.setTipoSpecifica(allegatoSS.getTipoSpecifica());
                ret.setAllegato(allegatoItemSS);
                break;
            }
            case SPECIFICALIVELLOSERVIZIO: {
                ApiImplAllegatoSpecificaLivelloServizio allegatoSL = (ApiImplAllegatoSpecificaLivelloServizio)allegato.getAllegato();
                ApiImplAllegatoItemSpecificaLivelloServizio allegatoItemSL = new ApiImplAllegatoItemSpecificaLivelloServizio();
                allegatoItemSL.setRuolo(ruoloAllegato);
                allegatoItemSL.setNome(allegatoSL.getNome());
                allegatoItemSL.setTipoSpecifica(allegatoSL.getTipoSpecifica());
                ret.setAllegato(allegatoItemSL);
                break;
            }
            case SPECIFICASICUREZZA: {
                ApiImplAllegatoSpecificaSicurezza allegatoSSec = (ApiImplAllegatoSpecificaSicurezza)allegato.getAllegato();
                ApiImplAllegatoItemSpecificaSicurezza allegatoItemSSec = new ApiImplAllegatoItemSpecificaSicurezza();
                allegatoItemSSec.setRuolo(ruoloAllegato);
                allegatoItemSSec.setNome(allegatoSSec.getNome());
                allegatoItemSSec.setTipoSpecifica(allegatoSSec.getTipoSpecifica());
                ret.setAllegato(allegatoItemSSec);
                break;
            }
        }
        return ret;
    }

    public static void createAllegatoAsps(ApiImplAllegato body, ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws Exception {
        Documento documento = ErogazioniApiHelper.implAllegatoToDocumento(body, asps);
        SerialiableFormFile filewrap = new SerialiableFormFile(documento.getFile(), documento.getByteContenuto());
        env.requestWrapper.overrideParameter("ruolo", documento.getRuolo());
        boolean documentoUnivocoIndipendentementeTipo = true;
        if (env.archiviCore.existsDocumento(documento, ProprietariDocumento.servizio, documentoUnivocoIndipendentementeTipo)) {
            throw FaultCode.CONFLITTO.toException("Allegato con nome " + documento.getFile() + " gi\u00e0 presente per l'erogazione");
        }
        if (!env.apsHelper.serviziAllegatiCheckData(TipoOperazione.ADD, (FormFile)filewrap, documento, env.protocolFactory)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
        switch (body.getAllegato().getRuolo()) {
            case ALLEGATO: {
                asps.addAllegato(documento);
                break;
            }
            case SPECIFICASEMIFORMALE: {
                asps.addSpecificaSemiformale(documento);
                break;
            }
            case SPECIFICASICUREZZA: {
                asps.addSpecificaSicurezza(documento);
                break;
            }
            case SPECIFICALIVELLOSERVIZIO: {
                asps.addSpecificaLivelloServizio(documento);
            }
        }
        env.apsCore.performUpdateOperation(env.userLogin, false, new Object[]{asps});
    }

    public static final Optional<Documento> getDocumento(List<Documento> list, String name) {
        return list.stream().filter(d -> d.getFile().equals(name)).findFirst();
    }

    public static final Optional<Long> getIdDocumento(List<Documento> list, String name) {
        return list.stream().filter(d -> d.getFile().equals(name)).findFirst().map(d -> d.getId());
    }

    public static final <T> Stream<T> mergeStreams(Stream<T>[] streams) {
        Stream<T> tmp = streams[0];
        for (int i = 1; i < streams.length; ++i) {
            tmp = Stream.concat(tmp, streams[i]);
        }
        return tmp;
    }

    public static final Optional<Long> getIdDocumento(String nomeAllegato, AccordoServizioParteSpecifica asps) {
        Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(asps.getSpecificaSemiformaleList(), nomeAllegato);
        if (!idDoc.isPresent()) {
            idDoc = ErogazioniApiHelper.getIdDocumento(asps.getSpecificaLivelloServizioList(), nomeAllegato);
        }
        if (!idDoc.isPresent()) {
            idDoc = ErogazioniApiHelper.getIdDocumento(asps.getAllegatoList(), nomeAllegato);
        }
        if (!idDoc.isPresent()) {
            idDoc = ErogazioniApiHelper.getIdDocumento(asps.getSpecificaSicurezzaList(), nomeAllegato);
        }
        return idDoc;
    }

    public static void updateAllegatoAsps(ApiImplAllegato body, String nomeAllegato, ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws Exception {
        Documento oldDoc = (Documento)BaseHelper.supplyOrNotFound(() -> env.archiviCore.getDocumento(nomeAllegato, null, null, asps.getId().longValue(), false, ProprietariDocumento.servizio), (String)("Allegato di nome " + nomeAllegato));
        Documento newDoc = ErogazioniApiHelper.implAllegatoToDocumento(body, asps);
        newDoc.setId(oldDoc.getId());
        newDoc.setOraRegistrazione(new Date());
        if (!Strings.CS.equals(newDoc.getRuolo(), oldDoc.getRuolo())) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non puoi modificare il ruolo di un allegato");
        }
        SerialiableFormFile filewrap = new SerialiableFormFile(newDoc.getFile(), newDoc.getByteContenuto());
        env.requestWrapper.overrideParameter("ruolo", newDoc.getRuolo());
        if (!env.apsHelper.serviziAllegatiCheckData(TipoOperazione.CHANGE, (FormFile)filewrap, newDoc, env.protocolFactory)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
        AccordiServizioParteSpecificaUtilities.sostituisciDocumentoAsps((AccordoServizioParteSpecifica)asps, (Documento)oldDoc, (Documento)newDoc);
        env.apsCore.performUpdateOperation(env.userLogin, false, new Object[]{asps});
    }

    public static final void updateInformazioniGenerali(ApiImplInformazioniGenerali body, ErogazioniEnv env, AccordoServizioParteSpecifica asps, boolean isErogazione) throws Exception {
        AccordoServizioParteComuneSintetico as = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        ServiceBinding tipoApi = as.getServiceBinding();
        IDServizio oldIDServizioForUpdate = env.idServizioFactory.getIDServizioFromAccordo(asps);
        asps.setOldIDServizioForUpdate(oldIDServizioForUpdate);
        asps.setNome(body.getNome());
        if (!StringUtils.isEmpty((CharSequence)body.getTipo())) {
            asps.setTipo(body.getTipo());
        }
        if (tipoApi == ServiceBinding.SOAP && !StringUtils.isEmpty((CharSequence)body.getApiSoapServizio())) {
            asps.setPortType(body.getApiSoapServizio());
        }
        ErogazioniApiHelper.serviziUpdateCheckData(as, asps, isErogazione, env);
        List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
        env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
    }

    public static final void overrideFruizioneUrlInvocazione(HttpRequestWrapper wrap, IDSoggetto idErogatore, IDServizio idServizio, PortaDelegata pd, PortaDelegataAzione pdAzione, boolean setPattern, long idAzione) {
        wrap.overrideParameter("id", pd.getId().toString());
        wrap.overrideParameter("nomePorta", pd.getNome());
        wrap.overrideParameter("idsogg", pd.getIdSoggetto().toString());
        wrap.overrideParameter("par_porte_azione", setPattern ? pdAzione.getPattern() : pdAzione.getNome());
        wrap.overrideParameter("azid", null);
        wrap.overrideParameter("modeaz", pdAzione.getIdentificazione().toString());
        wrap.overrideParameter("xsd", null);
        wrap.overrideParameter("integrazione", "");
        wrap.overrideParameter("soggid", idErogatore.toString());
        wrap.overrideParameter("servid", idServizio.toString());
        if (idAzione > 0L) {
            wrap.overrideParameter("azid", "" + idAzione);
        }
    }

    public static final void fillApiImplViewItemWithErogazione(ErogazioniEnv env, AccordoServizioParteSpecifica asps, ApiImplViewItem toFill) {
        try {
            IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            List listaMappingErogazionePortaApplicativa = env.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
            String nomePortaDefault = null;
            for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                if (mappinErogazione.isDefault()) {
                    nomePortaDefault = mappinErogazione.getIdPortaApplicativa().getNome();
                }
                listaPorteApplicativeAssociate.add(env.paCore.getPortaApplicativa(mappinErogazione.getIdPortaApplicativa()));
            }
            IDPortaApplicativa idPAdefault = new IDPortaApplicativa();
            idPAdefault.setNome(nomePortaDefault);
            PortaApplicativa paDefault = env.paCore.getPortaApplicativa(idPAdefault);
            int numeroAbilitate = 0;
            int numeroConfigurazioni = listaMappingErogazionePortaApplicativa.size();
            int numeroConfigurazioniSchedulingDisabilitato = -1;
            boolean allActionRedefined = false;
            if (listaMappingErogazionePortaApplicativa.size() > 1) {
                ArrayList azioniL = new ArrayList();
                Map azioni = env.paCore.getAzioniConLabel(asps, apc, false, true, new ArrayList());
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                allActionRedefined = env.erogazioniHelper.allActionsRedefinedMappingErogazione(azioniL, listaMappingErogazionePortaApplicativa);
            }
            boolean isRidefinito = false;
            for (PortaApplicativa paAssociata : listaPorteApplicativeAssociate) {
                boolean statoPA = paAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                if (!(!statoPA || allActionRedefined && paAssociata.getNome().equals(nomePortaDefault))) {
                    ++numeroAbilitate;
                }
                if (allActionRedefined && paAssociata.getNome().equals(nomePortaDefault)) continue;
                if (!paAssociata.getNome().equals(nomePortaDefault) && env.apsHelper.isConnettoreRidefinito(paDefault, (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0), paAssociata, (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0), paAssociata.getServizioApplicativoList())) {
                    isRidefinito = true;
                }
                if (paAssociata.getBehaviour() == null || paAssociata.sizeServizioApplicativoList() <= 0) continue;
                for (PortaApplicativaServizioApplicativo paSA : paAssociata.getServizioApplicativoList()) {
                    if (paSA == null || paSA.getDatiConnettore() == null || !StatoFunzionalita.DISABILITATO.equals((Object)paSA.getDatiConnettore().getScheduling())) continue;
                    ++numeroConfigurazioniSchedulingDisabilitato;
                }
            }
            StatoDescrizione stato = ErogazioniApiHelper.getStatoDescrizione(numeroAbilitate, allActionRedefined, numeroConfigurazioni, numeroConfigurazioniSchedulingDisabilitato);
            ApiCanale canale = ErogazioniApiHelper.toApiCanale(env, paDefault, apc, false);
            String urlConnettore = ConnettoreAPIHelper.getUrlConnettore(ErogazioniApiHelper.getServizioApplicativoErogazione(idServizio, env.saCore, env.paCore, env.paHelper), isRidefinito);
            ErogazioniApiHelper.fillApiImplViewItemWithAsps(env, asps, toFill, ErogazioniApiHelper.getUrlInvocazioneErogazione(asps, env), urlConnettore, ErogazioniApiHelper.getGestioneCorsFromErogazione(asps, env), idServizio.getSoggettoErogatore().getNome(), stato.stato, stato.descrizione, canale);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final StatoDescrizione getStatoDescrizione(int numeroAbilitate, boolean allActionRedefined, int numeroConfigurazioni, int numeroConfigurazioniSchedulingDisabilitato) {
        String stato_descrizione;
        StatoApiEnum statoApi;
        StatoDescrizione ret = new StatoDescrizione();
        if (numeroAbilitate == 0) {
            statoApi = StatoApiEnum.ERROR;
            stato_descrizione = "API disabilitata";
        } else if (!allActionRedefined && numeroAbilitate == numeroConfigurazioni || allActionRedefined && numeroAbilitate == numeroConfigurazioni - 1) {
            if (numeroConfigurazioniSchedulingDisabilitato > 0) {
                statoApi = StatoApiEnum.WARN;
                stato_descrizione = "Rilevati connettori multipli dell'API in cui \u00e8 stato disabilitato lo scheduling della consegna";
            } else {
                statoApi = StatoApiEnum.OK;
                stato_descrizione = "API attiva";
            }
        } else {
            statoApi = StatoApiEnum.WARN;
            stato_descrizione = "Alcuni gruppi dell'API sono disabilitati";
        }
        ret.stato = statoApi;
        ret.descrizione = stato_descrizione;
        return ret;
    }

    public static final void fillApiImplViewItemWithFruizione(ErogazioniEnv env, AccordoServizioParteSpecifica asps, IdSoggetto fruitore, ApiImplViewItem toFill) throws Exception {
        IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
        AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        long idFruizione = env.apsCore.getIdFruizioneAccordoServizioParteSpecifica(fruitore.toIDSoggetto(), idServizio);
        List listaMappingFruzionePortaDelegata = env.apsCore.serviziFruitoriMappingList(Long.valueOf(idFruizione), fruitore.toIDSoggetto(), idServizio, null);
        ArrayList<PortaDelegata> listaPorteDelegateAssociate = new ArrayList<PortaDelegata>();
        String nomePortaDefault = null;
        boolean isRidefinito = false;
        for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
            if (mappingFruizione.isDefault()) {
                nomePortaDefault = mappingFruizione.getIdPortaDelegata().getNome();
            } else {
                Optional fruit;
                PortaDelegata pd = env.pdCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata());
                List listaAzioniPDAssociataMappingNonDefault = pd.getAzione().getAzioneDelegataList();
                String azioneConnettore = null;
                if (listaAzioniPDAssociataMappingNonDefault != null && listaAzioniPDAssociataMappingNonDefault.size() > 0) {
                    azioneConnettore = (String)listaAzioniPDAssociataMappingNonDefault.get(0);
                }
                if ((fruit = BaseHelper.findFirst((Iterable)asps.getFruitoreList(), f -> f.getTipo().equals(mappingFruizione.getIdFruitore().getTipo()) && f.getNome().equals(mappingFruizione.getIdFruitore().getNome()))).isPresent() && azioneConnettore != null && !"".equals(azioneConnettore)) {
                    for (ConfigurazioneServizioAzione check : ((Fruitore)fruit.get()).getConfigurazioneAzioneList()) {
                        if (!check.getAzioneList().contains(azioneConnettore)) continue;
                        isRidefinito = true;
                    }
                }
            }
            listaPorteDelegateAssociate.add(env.pdCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata()));
        }
        int numeroAbilitate = 0;
        int numeroConfigurazioni = listaMappingFruzionePortaDelegata.size();
        boolean allActionRedefined = false;
        if (listaMappingFruzionePortaDelegata.size() > 1) {
            ArrayList azioniL = new ArrayList();
            Map azioni = env.pdCore.getAzioniConLabel(asps, apc, false, true, new ArrayList());
            if (azioni != null && azioni.size() > 0) {
                azioniL.addAll(azioni.keySet());
            }
            allActionRedefined = env.erogazioniHelper.allActionsRedefinedMappingFruizione((List)azioniL, listaMappingFruzionePortaDelegata);
        }
        for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
            boolean statoPD = pdAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
            if (!(!statoPD || allActionRedefined && pdAssociata.getNome().equals(nomePortaDefault))) {
                ++numeroAbilitate;
            }
            if (allActionRedefined && !pdAssociata.getNome().equals(nomePortaDefault)) continue;
        }
        StatoDescrizione stato = ErogazioniApiHelper.getStatoDescrizione(numeroAbilitate, allActionRedefined, numeroConfigurazioni, -1);
        IDPortaDelegata idPDdefault = new IDPortaDelegata();
        idPDdefault.setNome(nomePortaDefault);
        PortaDelegata pdDefault = env.pdCore.getPortaDelegata(idPDdefault);
        ApiCanale canale = ErogazioniApiHelper.toApiCanale(env, pdDefault, apc, false);
        try {
            String connettore = ConnettoreAPIHelper.getUrlConnettore((Connettore)BaseHelper.evalnull(() -> ErogazioniApiHelper.getConnettoreFruizione(asps, fruitore, env)), isRidefinito);
            ErogazioniApiHelper.fillApiImplViewItemWithAsps(env, asps, toFill, ErogazioniApiHelper.getUrlInvocazioneFruizione(asps, fruitore.toIDSoggetto(), env), connettore, ErogazioniApiHelper.getGestioneCorsFromFruizione(asps, fruitore.toIDSoggetto(), env), fruitore.getNome(), stato.stato, stato.descrizione, canale);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final void fillApiImplViewItemWithAsps(ErogazioniEnv env, AccordoServizioParteSpecifica asps, ApiImplViewItem toFill, String urlInvocazione, String urlConnettore, CorsConfigurazione gestioneCors, String nomeSoggetto, StatoApiEnum stato, String statoDescrizione, ApiCanale canale) {
        try {
            IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
            AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ProfiloEnum profilo = ProfiloUtils.toProfilo((String)asps.getTipo());
            toFill.setTipoServizio(idServizio.getTipo());
            toFill.setNome(asps.getNome());
            toFill.setVersione(asps.getVersione());
            toFill.setSoggetto(nomeSoggetto);
            toFill.setApiNome(aspc.getNome());
            toFill.setApiTipo(TipoApiEnum.valueOf(aspc.getServiceBinding().name()));
            toFill.setApiVersione(aspc.getVersione());
            toFill.setProfilo(Objects.requireNonNullElse(profilo, ProfiloEnum.APIGATEWAY));
            toFill.setConnettore(urlConnettore);
            toFill.setApiSoapServizio(asps.getPortType());
            toFill.setGestioneCors(Helper.boolToStatoFunzionalita(gestioneCors != null).toString());
            toFill.setUrlInvocazione(urlInvocazione);
            if (aspc.getGruppo() != null && !aspc.getGruppo().isEmpty()) {
                toFill.setApiTags(new ArrayList<String>());
                for (GruppoSintetico tag : aspc.getGruppo()) {
                    toFill.addApiTagsItem(tag.getNome());
                }
            }
            toFill.setStato(stato);
            toFill.setStatoDescrizione(statoDescrizione);
            toFill.setCanale(canale);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final ErogazioneViewItem aspsToErogazioneViewItem(ErogazioniEnv env, AccordoServizioParteSpecifica asps) {
        ErogazioneViewItem ret = new ErogazioneViewItem();
        ErogazioniApiHelper.fillApiImplViewItemWithErogazione(env, asps, ret);
        return ret;
    }

    public static final FruizioneViewItem aspsToFruizioneViewItem(ErogazioniEnv env, AccordoServizioParteSpecifica asps, IdSoggetto fruitore) {
        FruizioneViewItem ret = new FruizioneViewItem();
        try {
            ErogazioniApiHelper.fillApiImplViewItemWithFruizione(env, asps, fruitore, ret);
            IDSoggetto idErogatore = env.idServizioFactory.getIDServizioFromAccordo(asps).getSoggettoErogatore();
            ret.setErogatore(idErogatore.getNome());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static final void fillApiImplItemFromView(ApiImplViewItem impl, ApiImplItem toFill) {
        toFill.setApiNome(impl.getApiNome());
        toFill.setApiSoapServizio(impl.getApiSoapServizio());
        toFill.setApiTipo(impl.getApiTipo());
        toFill.setApiVersione(impl.getApiVersione());
        toFill.setNome(impl.getNome());
        toFill.setProfilo(impl.getProfilo());
        toFill.setSoggetto(impl.getSoggetto());
        toFill.setStato(impl.getStato());
        toFill.setStatoDescrizione(impl.getStatoDescrizione());
        toFill.setTipoServizio(impl.getTipoServizio());
        toFill.setVersione(impl.getVersione());
        toFill.setApiTags(impl.getApiTags());
        toFill.setCanale(impl.getCanale());
    }

    public static final FruizioneItem fruizioneViewItemToFruizioneItem(FruizioneViewItem fru) {
        FruizioneItem ret = new FruizioneItem();
        ErogazioniApiHelper.fillApiImplItemFromView(fru, ret);
        ret.setErogatore(fru.getErogatore());
        return ret;
    }

    public static final ErogazioneItem erogazioneViewItemToErogazioneItem(ErogazioneViewItem ero) {
        ErogazioneItem ret = new ErogazioneItem();
        ErogazioniApiHelper.fillApiImplItemFromView(ero, ret);
        return ret;
    }

    public static final void deleteAllegato(String nomeAllegato, ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws Exception {
        Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(nomeAllegato, asps);
        if (env.delete_404 && !idDoc.isPresent()) {
            throw FaultCode.NOT_FOUND.toException("Allegato di nome " + nomeAllegato + " non presente.");
        }
        if (idDoc.isPresent()) {
            AccordiServizioParteSpecificaUtilities.deleteAccordoServizioParteSpecificaAllegati((AccordoServizioParteSpecifica)asps, (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, Arrays.asList(idDoc.get()));
        }
    }

    public static final CorsConfigurazione getGestioneCorsFromErogazione(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws DriverConfigurazioneException, DriverRegistroServiziException, DriverConfigurazioneNotFound, CoreException {
        IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
        IDPortaApplicativa idPA = env.paCore.getIDPortaApplicativaAssociataDefault(idServizio);
        PortaApplicativa pa = env.paCore.getPortaApplicativa(idPA);
        return pa.getGestioneCors();
    }

    public static final CorsConfigurazione getGestioneCorsFromFruizione(AccordoServizioParteSpecifica asps, IDSoggetto fruitore, ErogazioniEnv env) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
        IDPortaDelegata idPD = env.pdCore.getIDPortaDelegataAssociataDefault(idServizio, fruitore);
        PortaDelegata pd = env.pdCore.getPortaDelegata(idPD);
        return pd.getGestioneCors();
    }

    public static final InvocazioneServizio getInvocazioneServizioErogazione(IDServizio idServizio, ServiziApplicativiCore saCore, PorteApplicativeCore paCore, PorteApplicativeHelper paHelper) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, CoreException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioApplicativo sa = ErogazioniApiHelper.getServizioApplicativoErogazione(idServizio, saCore, paCore, paHelper);
        return sa.getInvocazioneServizio();
    }

    public static final ServizioApplicativo getServizioApplicativoErogazione(IDServizio idServizio, ServiziApplicativiCore saCore, PorteApplicativeCore paCore, PorteApplicativeHelper paHelper) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, CoreException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDPortaApplicativa idPA = paCore.getIDPortaApplicativaAssociataDefault(idServizio);
        PortaApplicativa pa = paCore.getPortaApplicativa(idPA);
        String nomeSaDefault = idPA.getNome();
        if (pa.sizeServizioApplicativoList() > 0) {
            for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                if (!paHelper.isConnettoreDefault(pasa)) continue;
                nomeSaDefault = pasa.getNome();
                break;
            }
        }
        return saCore.getServizioApplicativo(saCore.getIdServizioApplicativo(idServizio.getSoggettoErogatore(), nomeSaDefault));
    }

    public static final InvocazioneServizio getInvocazioneServizioErogazioneGruppo(IdServizio idAsps, IDServizio idServizio, ErogazioniEnv env, String gruppo) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, CoreException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ServizioApplicativo sa = ErogazioniApiHelper.getServizioApplicativo(idAsps, idServizio, env, gruppo);
        return sa.getInvocazioneServizio();
    }

    public static final ServizioApplicativo getServizioApplicativo(IdServizio idAsps, IDServizio idServizio, ErogazioniEnv env, String gruppo) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, CoreException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDPortaApplicativa idPaDefault = env.paCore.getIDPortaApplicativaAssociataDefault(idServizio);
        PortaApplicativa paDefault = env.paCore.getPortaApplicativa(idPaDefault);
        IDPortaApplicativa idPA = gruppo != null ? (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(gruppo, idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta") : idPaDefault;
        PortaApplicativa pa = gruppo != null ? env.paCore.getPortaApplicativa(idPA) : paDefault;
        boolean isConnettoreRidefinito = false;
        try {
            if (gruppo != null) {
                isConnettoreRidefinito = env.apsHelper.isConnettoreRidefinito(paDefault, (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0), pa, (PortaApplicativaServizioApplicativo)pa.getServizioApplicativoList().get(0), pa.getServizioApplicativoList());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        ServizioApplicativo sa = gruppo != null && isConnettoreRidefinito ? env.saCore.getServizioApplicativo(env.saCore.getIdServizioApplicativo(idServizio.getSoggettoErogatore(), ((PortaApplicativaServizioApplicativo)pa.getServizioApplicativoList().get(0)).getNome())) : env.saCore.getServizioApplicativo(env.saCore.getIdServizioApplicativo(idServizio.getSoggettoErogatore(), ((PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0)).getNome()));
        return sa;
    }

    public static final Connettore getConnettoreFruizione(AccordoServizioParteSpecifica asps, IdSoggetto fruitore, ErogazioniEnv env) {
        return asps.getFruitoreList().stream().filter(f -> {
            try {
                return new IDSoggetto(f.getTipo(), f.getNome()).equals((Object)fruitore.toIDSoggetto()) && f.getConnettore() != null;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }).map(f -> {
            Connettore conn = f.getConnettore();
            return conn;
        }).findFirst().orElse(null);
    }

    public static final String getUrlInvocazioneErogazione(AccordoServizioParteSpecifica asps, ErogazioniEnv env) throws Exception {
        IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
        IDPortaApplicativa idPA = env.paCore.getIDPortaApplicativaAssociataDefault(idServizio);
        PortaApplicativa pa = env.paCore.getPortaApplicativa(idPA);
        AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        ConfigurazioneCore confCore = new ConfigurazioneCore(env.stationCore);
        Configurazione config = confCore.getConfigurazioneGenerale();
        ConfigurazioneUrlInvocazione configurazioneUrlInvocazione = null;
        if (config != null && config.getUrlInvocazione() != null) {
            configurazioneUrlInvocazione = config.getUrlInvocazione();
        }
        ArrayList<String> tags = new ArrayList<String>();
        if (aspc != null && aspc.getGruppo() != null && aspc.getGruppo().size() > 0) {
            for (int i = 0; i < aspc.getGruppo().size(); ++i) {
                tags.add(((GruppoSintetico)aspc.getGruppo().get(i)).getNome());
            }
        }
        String canaleApi = null;
        if (aspc != null) {
            canaleApi = aspc.getCanale();
        }
        String canale = null;
        if (config != null) {
            canale = CanaliUtils.getCanale((CanaliConfigurazione)config.getGestioneCanali(), (String)canaleApi, (String)pa.getCanale());
        }
        org.openspcoop2.message.constants.ServiceBinding sbMessage = org.openspcoop2.message.constants.ServiceBinding.SOAP;
        if (aspc != null) {
            sbMessage = ServiceBinding.REST.equals((Object)aspc.getServiceBinding()) ? org.openspcoop2.message.constants.ServiceBinding.REST : org.openspcoop2.message.constants.ServiceBinding.SOAP;
        }
        UrlInvocazioneAPI urlInvocazioneAPI = UrlInvocazioneAPI.getConfigurazioneUrlInvocazione((ConfigurazioneUrlInvocazione)configurazioneUrlInvocazione, (IProtocolFactory)env.protocolFactory, (RuoloContesto)RuoloContesto.PORTA_APPLICATIVA, (org.openspcoop2.message.constants.ServiceBinding)sbMessage, (String)pa.getNome(), (IDSoggetto)idServizio.getSoggettoErogatore(), tags, (String)canale);
        return urlInvocazioneAPI.getUrl();
    }

    public static final String getUrlInvocazioneFruizione(AccordoServizioParteSpecifica asps, IDSoggetto fruitore, ErogazioniEnv env) throws Exception {
        IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
        IDPortaDelegata idPD = env.pdCore.getIDPortaDelegataAssociataDefault(idServizio, fruitore);
        PortaDelegata pd = env.pdCore.getPortaDelegata(idPD);
        AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        ConfigurazioneCore confCore = new ConfigurazioneCore(env.stationCore);
        Configurazione config = confCore.getConfigurazioneGenerale();
        ConfigurazioneUrlInvocazione configurazioneUrlInvocazione = null;
        if (config != null && config.getUrlInvocazione() != null) {
            configurazioneUrlInvocazione = config.getUrlInvocazione();
        }
        ArrayList<String> tags = new ArrayList<String>();
        if (aspc != null && aspc.getGruppo() != null && aspc.getGruppo().size() > 0) {
            for (int i = 0; i < aspc.getGruppo().size(); ++i) {
                tags.add(((GruppoSintetico)aspc.getGruppo().get(i)).getNome());
            }
        }
        String canaleApi = null;
        if (aspc != null) {
            canaleApi = aspc.getCanale();
        }
        String canale = null;
        if (config != null) {
            canale = CanaliUtils.getCanale((CanaliConfigurazione)config.getGestioneCanali(), (String)canaleApi, (String)pd.getCanale());
        }
        org.openspcoop2.message.constants.ServiceBinding sbMessage = org.openspcoop2.message.constants.ServiceBinding.SOAP;
        if (aspc != null) {
            sbMessage = ServiceBinding.REST.equals((Object)aspc.getServiceBinding()) ? org.openspcoop2.message.constants.ServiceBinding.REST : org.openspcoop2.message.constants.ServiceBinding.SOAP;
        }
        UrlInvocazioneAPI urlInvocazioneAPI = UrlInvocazioneAPI.getConfigurazioneUrlInvocazione((ConfigurazioneUrlInvocazione)configurazioneUrlInvocazione, (IProtocolFactory)env.protocolFactory, (RuoloContesto)RuoloContesto.PORTA_DELEGATA, (org.openspcoop2.message.constants.ServiceBinding)sbMessage, (String)pd.getNome(), (IDSoggetto)fruitore, tags, (String)canale);
        return urlInvocazioneAPI.getUrl();
    }

    public static final void updateTracciamento(RegistrazioneDiagnosticiConfigurazione body, PortaApplicativa pa, ErogazioniEnv env) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        String tracciamentoStato = null;
        tracciamentoStato = pa.getTracciamento() != null && pa.getTracciamento().getStato() != null && StatoFunzionalita.ABILITATO.equals((Object)pa.getTracciamento().getStato()) ? "ridefinito" : "default";
        String statoDiagnostici = null;
        String severita = null;
        if (StatoDefaultRidefinitoEnum.RIDEFINITO.equals((Object)body.getStato())) {
            statoDiagnostici = "ridefinito";
            if (body.getSeverita() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Severit\u00e0 non indicata.");
            }
            switch (body.getSeverita()) {
                case ALL: {
                    severita = Severita.ALL.getValue();
                    break;
                }
                case DEBUG_HIGH: {
                    severita = Severita.DEBUG_HIGH.getValue();
                    break;
                }
                case DEBUG_MEDIUM: {
                    severita = Severita.DEBUG_MEDIUM.getValue();
                    break;
                }
                case DEBUG_LOW: {
                    severita = Severita.DEBUG_LOW.getValue();
                    break;
                }
                case INFO_PROTOCOL: {
                    severita = Severita.INFO_PROTOCOL.getValue();
                    break;
                }
                case INFO_INTEGRATION: {
                    severita = Severita.INFO_INTEGRATION.getValue();
                    break;
                }
                case ERROR_PROTOCOL: {
                    severita = Severita.ERROR_PROTOCOL.getValue();
                    break;
                }
                case ERROR_INTEGRATION: {
                    severita = Severita.ERROR_INTEGRATION.getValue();
                    break;
                }
                case FATAL: {
                    severita = Severita.FATAL.getValue();
                    break;
                }
                case OFF: {
                    severita = Severita.OFF.getValue();
                }
            }
        } else {
            statoDiagnostici = "default";
            if (body.getSeverita() != null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Severit\u00e0 non attesa.");
            }
        }
        PorteApplicativeUtilities.initTracciamento((PortaApplicativa)pa, (PorteApplicativeCore)env.paCore, null, (String)tracciamentoStato, (String)statoDiagnostici, severita);
    }

    public static final void updateTracciamento(RegistrazioneDiagnosticiConfigurazione body, PortaDelegata pd, ErogazioniEnv env) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        String tracciamentoStato = null;
        tracciamentoStato = pd.getTracciamento() != null && pd.getTracciamento().getStato() != null && StatoFunzionalita.ABILITATO.equals((Object)pd.getTracciamento().getStato()) ? "ridefinito" : "default";
        String statoDiagnostici = null;
        String severita = null;
        if (StatoDefaultRidefinitoEnum.RIDEFINITO.equals((Object)body.getStato())) {
            statoDiagnostici = "ridefinito";
            if (body.getSeverita() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Severit\u00e0 non indicata.");
            }
            switch (body.getSeverita()) {
                case ALL: {
                    severita = Severita.ALL.getValue();
                    break;
                }
                case DEBUG_HIGH: {
                    severita = Severita.DEBUG_HIGH.getValue();
                    break;
                }
                case DEBUG_MEDIUM: {
                    severita = Severita.DEBUG_MEDIUM.getValue();
                    break;
                }
                case DEBUG_LOW: {
                    severita = Severita.DEBUG_LOW.getValue();
                    break;
                }
                case INFO_PROTOCOL: {
                    severita = Severita.INFO_PROTOCOL.getValue();
                    break;
                }
                case INFO_INTEGRATION: {
                    severita = Severita.INFO_INTEGRATION.getValue();
                    break;
                }
                case ERROR_PROTOCOL: {
                    severita = Severita.ERROR_PROTOCOL.getValue();
                    break;
                }
                case ERROR_INTEGRATION: {
                    severita = Severita.ERROR_INTEGRATION.getValue();
                    break;
                }
                case FATAL: {
                    severita = Severita.FATAL.getValue();
                    break;
                }
                case OFF: {
                    severita = Severita.OFF.getValue();
                }
            }
        } else {
            statoDiagnostici = "default";
            if (body.getSeverita() != null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Severit\u00e0 non attesa.");
            }
        }
        PorteDelegateUtilities.initTracciamento((PortaDelegata)pd, (PorteDelegateCore)env.pdCore, null, (String)tracciamentoStato, (String)statoDiagnostici, severita);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void updateTracciamento(RegistrazioneTransazioniConfigurazione body, Object porta, ErogazioniEnv environment) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, ProtocolException {
        PortaApplicativa portaApplicativa = null;
        PortaDelegata portaDelegata = null;
        boolean applicativa = false;
        if (porta instanceof PortaApplicativa) {
            portaApplicativa = (PortaApplicativa)porta;
            applicativa = true;
        } else {
            if (!(porta instanceof PortaDelegata)) throw new ProtocolException("Oggetto '" + porta.getClass().getName() + "' non supportato");
            portaDelegata = (PortaDelegata)porta;
        }
        String statoDiagnostici = null;
        statoDiagnostici = applicativa ? (portaApplicativa.getTracciamento() != null && portaApplicativa.getTracciamento().getSeverita() != null ? "ridefinito" : "default") : (portaDelegata.getTracciamento() != null && portaDelegata.getTracciamento().getSeverita() != null ? "ridefinito" : "default");
        String severita = null;
        if ("ridefinito".equals(statoDiagnostici)) {
            if (applicativa && portaApplicativa.getTracciamento() != null && portaApplicativa.getTracciamento().getSeverita() != null) {
                severita = portaApplicativa.getTracciamento().getSeverita().getValue();
            } else if (portaDelegata.getTracciamento() != null && portaDelegata.getTracciamento().getSeverita() != null) {
                severita = portaDelegata.getTracciamento().getSeverita().getValue();
            }
            if (severita == null) {
                Configurazione config = environment.configCore.getConfigurazioneGenerale();
                severita = config.getMessaggiDiagnostici() != null && config.getMessaggiDiagnostici().getSeverita() != null ? config.getMessaggiDiagnostici().getSeverita().getValue() : null;
            }
        }
        String tracciamentoStato = null;
        boolean ridefinito = false;
        if (body.getStato() != null && StatoDefaultRidefinitoEnum.RIDEFINITO.equals((Object)body.getStato())) {
            tracciamentoStato = "ridefinito";
            ridefinito = true;
        } else {
            tracciamentoStato = "default";
        }
        if (applicativa) {
            PorteApplicativeUtilities.initTracciamento((PortaApplicativa)portaApplicativa, (PorteApplicativeCore)environment.paCore, null, (String)tracciamentoStato, (String)statoDiagnostici, (String)severita);
        } else {
            PorteDelegateUtilities.initTracciamento((PortaDelegata)portaDelegata, (PorteDelegateCore)environment.pdCore, null, (String)tracciamentoStato, (String)statoDiagnostici, (String)severita);
        }
        String dbStato = null;
        String dbStatoReqIn = null;
        String dbStatoReqOut = null;
        String dbStatoResOut = null;
        String dbStatoResOutComplete = null;
        boolean dbFiltroEsiti = false;
        if (body.getDatabase() != null) {
            if (!ridefinito) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Stato tracciamento su db consentito solo con stato ridefinito.");
            }
            if (body.getDatabase().getStato() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Stato tracciamento su db non indicato.");
            }
            String prefixDB = "Stato tracciamento su db '" + String.valueOf((Object)body.getDatabase().getStato()) + "'";
            boolean personalizzato = false;
            switch (body.getDatabase().getStato()) {
                case ABILITATO: {
                    dbStato = StatoFunzionalitaConPersonalizzazione.ABILITATO.getValue();
                    break;
                }
                case DISABILITATO: {
                    dbStato = StatoFunzionalitaConPersonalizzazione.DISABILITATO.getValue();
                    break;
                }
                case CONFIGURAZIONEESTERNA: {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " non valido.");
                }
                case PERSONALIZZATO: {
                    dbStato = StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue();
                    personalizzato = true;
                }
            }
            if (body.getDatabase().getFiltroEsiti() != null) {
                dbFiltroEsiti = TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getDatabase().getFiltroEsiti());
            }
            if (body.getDatabase().getFasi() != null) {
                if (!personalizzato) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " non prevede la definizione delle fasi.");
                if (body.getDatabase().getFasi().getRichiestaIngresso() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " richiede la definizione delle fasi; fase 'richiesta ingresso' non definita");
                switch (body.getDatabase().getFasi().getRichiestaIngresso()) {
                    case BLOCCANTE: {
                        dbStatoReqIn = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        dbStatoReqIn = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        dbStatoReqIn = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getDatabase().getFasi().getRichiestaUscita() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " richiede la definizione delle fasi; fase 'richiesta uscita' non definita");
                switch (body.getDatabase().getFasi().getRichiestaUscita()) {
                    case BLOCCANTE: {
                        dbStatoReqOut = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        dbStatoReqOut = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        dbStatoReqOut = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getDatabase().getFasi().getRispostaUscita() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " richiede la definizione delle fasi; fase 'risposta uscita' non definita");
                switch (body.getDatabase().getFasi().getRispostaUscita()) {
                    case BLOCCANTE: {
                        dbStatoResOut = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        dbStatoResOut = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        dbStatoResOut = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getDatabase().getFasi().getRispostaConsegnata() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " richiede la definizione delle fasi; fase 'risposta consegnata' non definita");
                dbStatoResOutComplete = TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getDatabase().getFasi().getRispostaConsegnata()) ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
            } else if (personalizzato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixDB + " richiede la definizione delle fasi.");
            }
        }
        String fsStato = null;
        String fsStatoReqIn = null;
        String fsStatoReqOut = null;
        String fsStatoResOut = null;
        String fsStatoResOutComplete = null;
        boolean fsFiltroEsiti = false;
        String fileTraceStato = null;
        String fileTraceConfigFile = null;
        String fileTraceClient = null;
        String fileTraceClientHdr = null;
        String fileTraceClientBody = null;
        String fileTraceServer = null;
        String fileTraceServerHdr = null;
        String fileTraceServerBody = null;
        if (body.getFiletrace() != null) {
            if (!ridefinito) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Stato tracciamento su filetrace consentito solo con stato ridefinito.");
            }
            if (body.getFiletrace().getStato() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Stato tracciamento su filetrace non indicato.");
            }
            String prefixFS = "Stato tracciamento su filetrace '" + String.valueOf((Object)body.getFiletrace().getStato()) + "'";
            boolean abilitataConf = false;
            boolean personalizzato = false;
            switch (body.getFiletrace().getStato()) {
                case ABILITATO: {
                    fsStato = StatoFunzionalitaConPersonalizzazione.ABILITATO.getValue();
                    abilitataConf = true;
                    break;
                }
                case DISABILITATO: {
                    fsStato = StatoFunzionalitaConPersonalizzazione.DISABILITATO.getValue();
                    break;
                }
                case CONFIGURAZIONEESTERNA: {
                    fsStato = StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.getValue();
                    break;
                }
                case PERSONALIZZATO: {
                    fsStato = StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue();
                    personalizzato = true;
                    abilitataConf = true;
                }
            }
            if (body.getFiletrace().getFiltroEsiti() != null) {
                fsFiltroEsiti = TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getFiletrace().getFiltroEsiti());
            }
            if (body.getFiletrace().getFasi() != null) {
                if (!personalizzato) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " non prevede la definizione delle fasi.");
                if (body.getFiletrace().getFasi().getRichiestaIngresso() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " richiede la definizione delle fasi; fase 'richiesta ingresso' non definita");
                switch (body.getFiletrace().getFasi().getRichiestaIngresso()) {
                    case BLOCCANTE: {
                        fsStatoReqIn = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        fsStatoReqIn = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        fsStatoReqIn = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getFiletrace().getFasi().getRichiestaUscita() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " richiede la definizione delle fasi; fase 'richiesta uscita' non definita");
                switch (body.getFiletrace().getFasi().getRichiestaUscita()) {
                    case BLOCCANTE: {
                        fsStatoReqOut = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        fsStatoReqOut = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        fsStatoReqOut = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getFiletrace().getFasi().getRispostaUscita() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " richiede la definizione delle fasi; fase 'risposta uscita' non definita");
                switch (body.getFiletrace().getFasi().getRispostaUscita()) {
                    case BLOCCANTE: {
                        fsStatoResOut = StatoFunzionalitaBloccante.ABILITATO.getValue();
                        break;
                    }
                    case NON_BLOCCANTE: {
                        fsStatoResOut = StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue();
                        break;
                    }
                    case DISABILITATO: {
                        fsStatoResOut = StatoFunzionalitaBloccante.DISABILITATO.getValue();
                    }
                }
                if (body.getFiletrace().getFasi().getRispostaConsegnata() == null) throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " richiede la definizione delle fasi; fase 'risposta consegnata' non definita");
                fsStatoResOutComplete = TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getFiletrace().getFasi().getRispostaConsegnata()) ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
            } else if (personalizzato) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " richiede la definizione delle fasi.");
            }
            if (abilitataConf) {
                if (body.getFiletrace().getConfigPath() != null || body.getFiletrace().getDumpClient() != null || body.getFiletrace().getDumpServer() != null) {
                    fileTraceStato = "ridefinito";
                    fileTraceConfigFile = body.getFiletrace().getConfigPath();
                    if (body.getFiletrace().getDumpClient() != null) {
                        fileTraceClient = ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO;
                        fileTraceClientHdr = body.getFiletrace().getDumpClient().isHeaders() != null && body.getFiletrace().getDumpClient().isHeaders() != false ? ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO : ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                        fileTraceClientBody = body.getFiletrace().getDumpClient().isPayload() != null && body.getFiletrace().getDumpClient().isPayload().booleanValue() ? ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO : ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                    } else {
                        fileTraceClient = ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                    }
                    if (body.getFiletrace().getDumpServer() != null) {
                        fileTraceServer = ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO;
                        fileTraceServerHdr = body.getFiletrace().getDumpServer().isHeaders() != null && body.getFiletrace().getDumpServer().isHeaders() != false ? ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO : ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                        fileTraceServerBody = body.getFiletrace().getDumpServer().isPayload() != null && body.getFiletrace().getDumpServer().isPayload().booleanValue() ? ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO : ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                    } else {
                        fileTraceServer = ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                    }
                } else {
                    fileTraceStato = "default";
                }
            } else {
                if (body.getFiletrace().getConfigPath() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " non consente la definizione del path della configurazione");
                }
                if (body.getFiletrace().getDumpClient() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " non consente la definizione del buffer dei messaggi scambiati con il client");
                }
                if (body.getFiletrace().getDumpServer() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(prefixFS + " non consente la definizione del buffer dei messaggi scambiati con il server");
                }
                fileTraceStato = "default";
            }
        }
        String nuovaConfigurazioneEsiti = null;
        if (body.getFiltro() != null && body.getFiltro().getEsiti() != null && !body.getFiltro().getEsiti().isEmpty()) {
            if (!ridefinito) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Filtro esiti consentito solo con stato ridefinito.");
            }
            Logger log = LoggerWrapperFactory.getLogger(ErogazioniApiHelper.class);
            EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)log, (IProtocolFactory)environment.protocolFactory);
            List esiti = esitiProperties.getEsitiCode();
            int codeErroreProtocollo = esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_PROTOCOLLO.name());
            int codeFaultPdd = esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_SERVER.name());
            esiti.add(codeErroreProtocollo);
            esiti.add(codeFaultPdd);
            StringBuilder sb = new StringBuilder();
            for (Integer esito : body.getFiltro().getEsiti()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(esito);
                if (ErogazioniApiHelper.existsEsito(esito, esiti)) continue;
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'esito '" + esito + "' indicato nel filtro non \u00e8 supportato");
            }
            nuovaConfigurazioneEsiti = sb.toString();
        }
        String transazioniTempiElaborazione = null;
        String transazioniToken = null;
        if (body.getInformazioni() != null) {
            if (!ridefinito) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Definizione delle informazioni sulle transazioni consentita solo con stato ridefinito.");
            }
            transazioniTempiElaborazione = body.getInformazioni().getTempiElaborazione() != null ? (TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getInformazioni().getTempiElaborazione()) ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue()) : StatoFunzionalita.DISABILITATO.getValue();
            transazioniToken = body.getInformazioni().getToken() != null ? (TracciamentoTransazioniStatoFase.ABILITATO.equals((Object)body.getInformazioni().getToken()) ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue()) : StatoFunzionalita.DISABILITATO.getValue();
        }
        if (applicativa) {
            PorteApplicativeUtilities.setTracciamentoTransazioni((PortaApplicativa)portaApplicativa, (PorteApplicativeCore)environment.paCore, (String)dbStato, (String)dbStatoReqIn, (String)dbStatoReqOut, dbStatoResOut, dbStatoResOutComplete, (boolean)dbFiltroEsiti, (String)fsStato, fsStatoReqIn, fsStatoReqOut, fsStatoResOut, fsStatoResOutComplete, (boolean)fsFiltroEsiti, nuovaConfigurazioneEsiti, (String)transazioniTempiElaborazione, (String)transazioniToken, (String)fileTraceStato, fileTraceConfigFile, fileTraceClient, fileTraceClientHdr, fileTraceClientBody, fileTraceServer, fileTraceServerHdr, fileTraceServerBody);
            return;
        } else {
            PorteDelegateUtilities.setTracciamentoTransazioni((PortaDelegata)portaDelegata, (PorteDelegateCore)environment.pdCore, (String)dbStato, (String)dbStatoReqIn, (String)dbStatoReqOut, dbStatoResOut, dbStatoResOutComplete, (boolean)dbFiltroEsiti, (String)fsStato, fsStatoReqIn, fsStatoReqOut, fsStatoResOut, fsStatoResOutComplete, (boolean)fsFiltroEsiti, nuovaConfigurazioneEsiti, (String)transazioniTempiElaborazione, (String)transazioniToken, (String)fileTraceStato, fileTraceConfigFile, fileTraceClient, fileTraceClientHdr, fileTraceClientBody, fileTraceServer, fileTraceServerHdr, fileTraceServerBody);
        }
    }

    private static boolean existsEsito(Integer esito, List<Integer> esiti) {
        if (esiti != null && esito != null) {
            for (Integer e : esiti) {
                if (e.intValue() != esito.intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static final DumpConfigurazione buildDumpConfigurazione(RegistrazioneMessaggi dumpConf, boolean isErogazione, ErogazioniEnv env) throws Exception {
        RegistrazioneMessaggiConfigurazione richiesta = dumpConf.getRichiesta();
        RegistrazioneMessaggiConfigurazione risposta = dumpConf.getRisposta();
        String statoDump = dumpConf.getStato().toString();
        String statoDumpRichiesta = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.isAbilitato())).toString();
        String statoDumpRisposta = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.isAbilitato())).toString();
        String dumpRichiestaIngressoHeader = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getIngresso().isHeaders())).toString();
        String dumpRichiestaIngressoPayload = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getIngresso().isPayload())).toString();
        String dumpRichiestaIngressoPayloadParsing = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRichiestaIngressoBody = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRichiestaIngressoAttachments = Helper.boolToStatoFunzionalitaConf(false).toString();
        if (richiesta != null && richiesta.getIngresso() != null && richiesta.getIngresso().isPayload() != null && richiesta.getIngresso().isPayload().booleanValue()) {
            dumpRichiestaIngressoPayloadParsing = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getIngresso().isPayloadParsing())).toString();
            if (richiesta.getIngresso().isPayloadParsing() != null && richiesta.getIngresso().isPayloadParsing().booleanValue()) {
                dumpRichiestaIngressoBody = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getIngresso().isBody())).toString();
                dumpRichiestaIngressoAttachments = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getIngresso().isAttachments())).toString();
            }
        }
        String dumpRichiestaUscitaHeader = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getUscita().isHeaders())).toString();
        String dumpRichiestaUscitaPayload = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getUscita().isPayload())).toString();
        String dumpRichiestaUscitaPayloadParsing = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRichiestaUscitaBody = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRichiestaUscitaAttachments = Helper.boolToStatoFunzionalitaConf(false).toString();
        if (richiesta != null && richiesta.getUscita() != null && richiesta.getUscita().isPayload() != null && richiesta.getUscita().isPayload().booleanValue()) {
            dumpRichiestaUscitaPayloadParsing = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getUscita().isPayloadParsing())).toString();
            if (richiesta.getUscita().isPayloadParsing() != null && richiesta.getUscita().isPayloadParsing().booleanValue()) {
                dumpRichiestaUscitaBody = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getUscita().isBody())).toString();
                dumpRichiestaUscitaAttachments = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> richiesta.getUscita().isAttachments())).toString();
            }
        }
        String dumpRispostaIngressoHeader = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getIngresso().isHeaders())).toString();
        String dumpRispostaIngressoPayload = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getIngresso().isPayload())).toString();
        String dumpRispostaIngressoPayloadParsing = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRispostaIngressoBody = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRispostaIngressoAttachments = Helper.boolToStatoFunzionalitaConf(false).toString();
        if (risposta != null && risposta.getIngresso() != null && risposta.getIngresso().isPayload() != null && risposta.getIngresso().isPayload().booleanValue()) {
            dumpRispostaIngressoPayloadParsing = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getIngresso().isPayloadParsing())).toString();
            if (risposta.getIngresso().isPayloadParsing() != null && risposta.getIngresso().isPayloadParsing().booleanValue()) {
                dumpRispostaIngressoBody = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getIngresso().isBody())).toString();
                dumpRispostaIngressoAttachments = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getIngresso().isAttachments())).toString();
            }
        }
        String dumpRispostaUscitaHeader = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getUscita().isHeaders())).toString();
        String dumpRispostaUscitaPayload = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getUscita().isPayload())).toString();
        String dumpRispostaUscitaPayloadParsing = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRispostaUscitaBody = Helper.boolToStatoFunzionalitaConf(false).toString();
        String dumpRispostaUscitaAttachments = Helper.boolToStatoFunzionalitaConf(false).toString();
        if (risposta != null && risposta.getUscita() != null && risposta.getUscita().isPayload() != null && risposta.getUscita().isPayload().booleanValue()) {
            dumpRispostaUscitaPayloadParsing = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getUscita().isPayloadParsing())).toString();
            if (risposta.getUscita().isPayloadParsing() != null && risposta.getUscita().isPayloadParsing().booleanValue()) {
                dumpRispostaUscitaBody = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getUscita().isBody())).toString();
                dumpRispostaUscitaAttachments = Helper.boolToStatoFunzionalitaConf((Boolean)BaseHelper.evalnull(() -> risposta.getUscita().isAttachments())).toString();
            }
        }
        DumpConfigurazione ret = new DumpConfigurazione();
        if (isErogazione) {
            if (!env.paHelper.checkDataConfigurazioneDump(TipoOperazione.OTHER, true, statoDump, false, StatoFunzionalita.ABILITATO.getValue(), statoDumpRichiesta, statoDumpRisposta, dumpRichiestaIngressoHeader, dumpRichiestaIngressoPayload, dumpRichiestaIngressoPayloadParsing, dumpRichiestaIngressoBody, dumpRichiestaIngressoAttachments, dumpRichiestaUscitaHeader, dumpRichiestaUscitaPayload, dumpRichiestaUscitaPayloadParsing, dumpRichiestaUscitaBody, dumpRichiestaUscitaAttachments, dumpRispostaIngressoHeader, dumpRispostaIngressoPayload, dumpRispostaIngressoPayloadParsing, dumpRispostaIngressoBody, dumpRispostaIngressoAttachments, dumpRispostaUscitaHeader, dumpRispostaUscitaPayload, dumpRispostaUscitaPayloadParsing, dumpRispostaUscitaBody, dumpRispostaUscitaAttachments)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ret = env.paHelper.getConfigurazioneDump(TipoOperazione.OTHER, true, statoDump, false, StatoFunzionalita.ABILITATO.getValue(), statoDumpRichiesta, statoDumpRisposta, dumpRichiestaIngressoHeader, dumpRichiestaIngressoPayload, dumpRichiestaIngressoPayloadParsing, dumpRichiestaIngressoBody, dumpRichiestaIngressoAttachments, dumpRichiestaUscitaHeader, dumpRichiestaUscitaPayload, dumpRichiestaUscitaPayloadParsing, dumpRichiestaUscitaBody, dumpRichiestaUscitaAttachments, dumpRispostaIngressoHeader, dumpRispostaIngressoPayload, dumpRispostaIngressoPayloadParsing, dumpRispostaIngressoBody, dumpRispostaIngressoAttachments, dumpRispostaUscitaHeader, dumpRispostaUscitaPayload, dumpRispostaUscitaPayloadParsing, dumpRispostaUscitaBody, dumpRispostaUscitaAttachments);
        } else {
            if (!env.pdHelper.checkDataConfigurazioneDump(TipoOperazione.OTHER, true, statoDump, false, StatoFunzionalita.ABILITATO.getValue(), statoDumpRichiesta, statoDumpRisposta, dumpRichiestaIngressoHeader, dumpRichiestaIngressoPayload, dumpRichiestaIngressoPayloadParsing, dumpRichiestaIngressoBody, dumpRichiestaIngressoAttachments, dumpRichiestaUscitaHeader, dumpRichiestaUscitaPayload, dumpRichiestaUscitaPayloadParsing, dumpRichiestaUscitaBody, dumpRichiestaUscitaAttachments, dumpRispostaIngressoHeader, dumpRispostaIngressoPayload, dumpRispostaIngressoPayloadParsing, dumpRispostaIngressoBody, dumpRispostaIngressoAttachments, dumpRispostaUscitaHeader, dumpRispostaUscitaPayload, dumpRispostaUscitaPayloadParsing, dumpRispostaUscitaBody, dumpRispostaUscitaAttachments)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ret = env.pdHelper.getConfigurazioneDump(TipoOperazione.OTHER, true, statoDump, false, StatoFunzionalita.ABILITATO.getValue(), statoDumpRichiesta, statoDumpRisposta, dumpRichiestaIngressoHeader, dumpRichiestaIngressoPayload, dumpRichiestaIngressoPayloadParsing, dumpRichiestaIngressoBody, dumpRichiestaIngressoAttachments, dumpRichiestaUscitaHeader, dumpRichiestaUscitaPayload, dumpRichiestaUscitaPayloadParsing, dumpRichiestaUscitaBody, dumpRichiestaUscitaAttachments, dumpRispostaIngressoHeader, dumpRispostaIngressoPayload, dumpRispostaIngressoPayloadParsing, dumpRispostaIngressoBody, dumpRispostaIngressoAttachments, dumpRispostaUscitaHeader, dumpRispostaUscitaPayload, dumpRispostaUscitaPayloadParsing, dumpRispostaUscitaBody, dumpRispostaUscitaAttachments);
        }
        return ret;
    }

    public static final List<MappingErogazionePortaApplicativa> getMappingGruppiPA(String nomeGruppo, IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return apsCore.mappingServiziPorteAppList((IDServizio)idAsps, idAsps.getId(), null).stream().filter(m -> m.getDescrizione().equals(nomeGruppo)).collect(Collectors.toList());
    }

    public static final List<MappingFruizionePortaDelegata> getMappingGruppiPD(String nomeGruppo, IDSoggetto idFruitore, IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return apsCore.serviziFruitoriMappingList(idFruitore, (IDServizio)idAsps, null).stream().filter(m -> m.getDescrizione().equals(nomeGruppo)).collect(Collectors.toList());
    }

    public static final IDPortaApplicativa getIDGruppoPA(String nome, IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return ErogazioniApiHelper.getMappingGruppiPA(nome, idAsps, apsCore).stream().map(m -> m.getIdPortaApplicativa()).findFirst().orElse(null);
    }

    public static final IDPortaApplicativa getIDGruppoPADefault(IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return AccordiServizioParteSpecificaUtilities.getDefaultMappingPA((List)apsCore.mappingServiziPorteAppList((IDServizio)idAsps, idAsps.getId(), null)).getIdPortaApplicativa();
    }

    public static final IDPortaDelegata getIDGruppoPDDefault(IDSoggetto idFruitore, IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return AccordiServizioParteSpecificaUtilities.getDefaultMappingPD((List)apsCore.serviziFruitoriMappingList(idFruitore, (IDServizio)idAsps, null)).getIdPortaDelegata();
    }

    public static final IDPortaDelegata getIDGruppoPD(String nome, IDSoggetto idFruitore, IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        return ErogazioniApiHelper.getMappingGruppiPD(nome, idFruitore, idAsps, apsCore).stream().map(m -> m.getIdPortaDelegata()).findFirst().orElse(null);
    }

    public static final List<String> getAzioniOccupateErogazione(IdServizio idAsps, AccordiServizioParteSpecificaCore apsCore, PorteApplicativeCore paCore) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return apsCore.mappingServiziPorteAppList((IDServizio)idAsps, idAsps.getId(), null).stream().map(m -> {
            try {
                return paCore.getPortaApplicativa(m.getIdPortaApplicativa());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).filter(pa -> pa.getAzione() != null && pa.getAzione().getAzioneDelegataList() != null).flatMap(pa -> pa.getAzione().getAzioneDelegataList().stream()).collect(Collectors.toList());
    }

    public static final List<String> getAzioniDisponibiliRateLimitingPortaApplicativa(IdServizio idAsps, PortaApplicativa pa) {
        return null;
    }

    public static final List<String> getAzioniDisponibiliRateLimitingPortaDelegata(PortaDelegata pd, ErogazioniEnv env) {
        if (pd.getAzione() != null && pd.getAzione().getAzioneDelegataList().size() > 0) {
            return pd.getAzione().getAzioneDelegataList();
        }
        return null;
    }

    public static final List<String> getAzioniOccupateFruizione(IdServizio idAsps, IDSoggetto idFruitore, AccordiServizioParteSpecificaCore apsCore, PorteDelegateCore pdCore) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return apsCore.serviziFruitoriMappingList(idFruitore, (IDServizio)idAsps, null).stream().map(m -> {
            try {
                return pdCore.getPortaDelegata(m.getIdPortaDelegata());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).filter(pa -> pa.getAzione() != null && pa.getAzione().getAzioneDelegataList() != null).flatMap(pa -> pa.getAzione().getAzioneDelegataList().stream()).collect(Collectors.toList());
    }

    public static final List<String> getDescrizioniMappingPA(List<MappingErogazionePortaApplicativa> listaMappingErogazione) {
        return listaMappingErogazione.stream().map(m -> m.getDescrizione()).collect(Collectors.toList());
    }

    public static final List<String> getDescrizioniMappingPD(List<MappingFruizionePortaDelegata> listaMappingErogazione) {
        return listaMappingErogazione.stream().map(m -> m.getDescrizione()).collect(Collectors.toList());
    }

    public static final ListaApiImplAllegati findAllAllegati(String q, Integer limit, Integer offset, UriInfo uriInfo, ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException, InstantiationException, IllegalAccessException, CoreException {
        int idLista = Liste.SERVIZI_ALLEGATI;
        ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
        List lista = env.apsCore.serviziAllegatiList((long)asps.getId().intValue(), (ISearch)ricerca);
        if (env.findall_404 && lista.isEmpty()) {
            throw FaultCode.NOT_FOUND.toException("Nessun allegato associato");
        }
        ListaApiImplAllegati ret = (ListaApiImplAllegati)ListaUtils.costruisciListaPaginata((UriInfo)uriInfo, (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaApiImplAllegati.class);
        lista.forEach(d -> ret.addItemsItem(ErogazioniApiHelper.ImplAllegatoToItem(ErogazioniApiHelper.documentoToImplAllegato(d))));
        return ret;
    }

    public static final ApiImplVersioneApiView aspsToApiImplVersioneApiView(ErogazioniEnv env, AccordoServizioParteSpecifica asps) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        ApiImplVersioneApiView ret = new ApiImplVersioneApiView();
        AccordoServizioParteComuneSintetico api = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
        ret.setApiNome(aspc.getNome());
        ret.setApiSoapServizio(asps.getPortType());
        ret.setApiVersione(aspc.getVersione());
        ret.setProfilo(env.profilo);
        ret.setSoggetto(aspc.getSoggettoReferente().getNome());
        ret.setTipoServizio(asps.getTipo());
        List asParteComuneCompatibili = env.apsCore.findAccordiParteComuneBySoggettoAndNome(api.getNome(), new IDSoggetto(api.getSoggettoReferente().getTipo(), api.getSoggettoReferente().getNome()));
        ret.setVersioni(asParteComuneCompatibili.stream().map(a -> a.getVersione()).collect(Collectors.toList()));
        return ret;
    }

    public static final ApiImplInformazioniGeneraliView erogazioneToApiImplInformazioniGeneraliView(ErogazioniEnv env, AccordoServizioParteSpecifica asps) {
        ErogazioneViewItem item = ErogazioniApiHelper.aspsToErogazioneViewItem(env, asps);
        ApiImplInformazioniGeneraliView ret = new ApiImplInformazioniGeneraliView();
        ret.setApiSoapServizio(item.getApiSoapServizio());
        ret.setNome(item.getNome());
        ret.setProfilo(item.getProfilo());
        ret.setTipo(item.getTipoServizio());
        return ret;
    }

    public static final ApiImplInformazioniGeneraliView fruizioneToApiImplInformazioniGeneraliView(ErogazioniEnv env, AccordoServizioParteSpecifica asps, IdSoggetto fruitore) {
        FruizioneViewItem item = ErogazioniApiHelper.aspsToFruizioneViewItem(env, asps, fruitore);
        ApiImplInformazioniGeneraliView ret = new ApiImplInformazioniGeneraliView();
        ret.setApiSoapServizio(item.getApiSoapServizio());
        ret.setNome(item.getNome());
        ret.setProfilo(item.getProfilo());
        ret.setTipo(item.getTipoServizio());
        return ret;
    }

    public static final CorsConfigurazione buildCorsConfigurazione(GestioneCors body, ErogazioniEnv env, CorsConfigurazione oldConf) throws Exception {
        String statoCorsPorta = body.isRidefinito() != false ? "ridefinito" : "default";
        GestioneCorsAccessControl c = body.getAccessControl();
        String corsStato = Helper.boolToStatoFunzionalita(body.getTipo() != TipoGestioneCorsEnum.DISABILITATO).toString();
        TipoGestioneCORS corsTipo = Enums.tipoGestioneCorsFromRest.get((Object)body.getTipo());
        String allowOrigins = String.join((CharSequence)",", (Iterable)BaseHelper.evalorElse(() -> c.getAllowOrigins(), new ArrayList()));
        String allowHeaders = String.join((CharSequence)",", (Iterable)BaseHelper.evalorElse(() -> c.getAllowHeaders(), new ArrayList()));
        String exposeHeaders = String.join((CharSequence)",", (Iterable)BaseHelper.evalorElse(() -> c.getExposeHeaders(), new ArrayList()));
        String allowMethods = String.join((CharSequence)",", ((List)BaseHelper.evalorElse(() -> c.getAllowMethods(), new ArrayList())).stream().map(m -> m.name()).collect(Collectors.toList()));
        env.requestWrapper.overrideParameter("corsStato", corsStato);
        env.requestWrapper.overrideParameter("corsTipo", corsTipo.toString());
        env.requestWrapper.overrideParameter("corsAAllOrig", ServletUtils.boolToCheckBoxStatus((Boolean)c.isAllAllowOrigins()));
        env.requestWrapper.overrideParameter("corsAllOrig", allowOrigins);
        env.requestWrapper.overrideParameter("corsAAllHdr", ServletUtils.boolToCheckBoxStatus((Boolean)c.isAllAllowHeaders()));
        env.requestWrapper.overrideParameter("corsAllHead", allowHeaders);
        env.requestWrapper.overrideParameter("corsAAllMeth", ServletUtils.boolToCheckBoxStatus((Boolean)c.isAllAllowMethods()));
        env.requestWrapper.overrideParameter("corsAllMeth", allowMethods);
        env.requestWrapper.overrideParameter("corsExpHead", exposeHeaders);
        env.requestWrapper.overrideParameter("corsMaxAge", ServletUtils.boolToCheckBoxStatus((Boolean)c.isMaxAge()));
        if (c.isMaxAge() != null && c.isMaxAge().booleanValue() && c.getMaxAgeSeconds() != null) {
            env.requestWrapper.overrideParameter("corsMaxAgeSec", c.getMaxAgeSeconds());
        }
        if (!env.paHelper.checkDataConfigurazioneCorsPorta(TipoOperazione.OTHER, true, statoCorsPorta)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
        return env.paHelper.getGestioneCors(body.getTipo() != TipoGestioneCorsEnum.DISABILITATO, corsTipo, c.isAllAllowOrigins().booleanValue(), c.isAllAllowHeaders().booleanValue(), c.isAllAllowMethods().booleanValue(), allowHeaders, allowOrigins, allowMethods, c.isAllowCredentials().booleanValue(), exposeHeaders, c.isMaxAge() != null ? c.isMaxAge() : false, c.getMaxAgeSeconds() != null ? c.getMaxAgeSeconds() : -1);
    }

    public static final GestioneToken buildGestioneToken(ControlloAccessiGestioneToken body, Object porta, boolean isPortaDelegata, ConsoleHelper coHelper, ErogazioniEnv env) throws Exception {
        GestioneToken ret = new GestioneToken();
        ret.setPolicy(body.getPolicy());
        ret.setTokenOpzionale(Helper.boolToStatoFunzionalitaConf(body.isTokenOpzionale()));
        ret.setValidazione(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getValidazioneJwt().toString()))));
        ret.setIntrospection(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getIntrospection().toString()))));
        ret.setUserInfo(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getUserInfo().toString()))));
        ret.setForward(Helper.boolToStatoFunzionalitaConf(body.isTokenForward()));
        return ret;
    }

    public static final void fillGestioneToken(GestioneToken ret, ControlloAccessiGestioneToken body) {
        ret.setPolicy(body.getPolicy());
        ret.setTokenOpzionale(Helper.boolToStatoFunzionalitaConf(body.isTokenOpzionale()));
        ret.setValidazione(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getValidazioneJwt().toString()))));
        ret.setIntrospection(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getIntrospection().toString()))));
        ret.setUserInfo(StatoFunzionalitaConWarning.toEnumConstant((String)((String)BaseHelper.evalnull(() -> body.getUserInfo().toString()))));
        ret.setForward(Helper.boolToStatoFunzionalitaConf(body.isTokenForward()));
    }

    public static final RegistrazioneMessaggiConfigurazioneRegola fromDumpConfigurazioneRegola(DumpConfigurazioneRegola r) {
        if (r == null) {
            return null;
        }
        RegistrazioneMessaggiConfigurazioneRegola ret = new RegistrazioneMessaggiConfigurazioneRegola();
        ret.setPayload(Helper.statoFunzionalitaConfToBool(r.getPayload()));
        ret.setHeaders(Helper.statoFunzionalitaConfToBool(r.getHeaders()));
        if (ret.isPayload() != null && ret.isPayload().booleanValue()) {
            ret.setPayloadParsing(Helper.statoFunzionalitaConfToBool(r.getPayloadParsing()));
            if (ret.isPayloadParsing() != null && ret.isPayloadParsing().booleanValue()) {
                ret.setBody(Helper.statoFunzionalitaConfToBool(r.getBody()));
                ret.setAttachments(Helper.statoFunzionalitaConfToBool(r.getAttachments()));
            }
        }
        return ret;
    }

    public static final ControlloAccessiAutenticazioneToken fromGestioneTokenAutenticazione(GestioneTokenAutenticazione tokAut) {
        ControlloAccessiAutenticazioneToken token = new ControlloAccessiAutenticazioneToken();
        token.setClientId(Helper.statoFunzionalitaConfToBool(tokAut.getClientId()));
        token.setEmail(Helper.statoFunzionalitaConfToBool(tokAut.getEmail()));
        token.setIssuer(Helper.statoFunzionalitaConfToBool(tokAut.getIssuer()));
        token.setSubject(Helper.statoFunzionalitaConfToBool(tokAut.getSubject()));
        token.setUsername(Helper.statoFunzionalitaConfToBool(tokAut.getUsername()));
        return token;
    }

    public static final RegistrazioneDiagnosticiConfigurazione fromDiagnosticiConfigurazione(PortaTracciamento paTracciamento) {
        RegistrazioneDiagnosticiConfigurazione ret = new RegistrazioneDiagnosticiConfigurazione();
        if (paTracciamento != null && paTracciamento.getSeverita() != null) {
            ret.setStato(StatoDefaultRidefinitoEnum.RIDEFINITO);
            switch (paTracciamento.getSeverita()) {
                case ALL: {
                    ret.setSeverita(DiagnosticiSeverita.ALL);
                    break;
                }
                case DEBUG_HIGH: {
                    ret.setSeverita(DiagnosticiSeverita.DEBUG_HIGH);
                    break;
                }
                case DEBUG_MEDIUM: {
                    ret.setSeverita(DiagnosticiSeverita.DEBUG_MEDIUM);
                    break;
                }
                case DEBUG_LOW: {
                    ret.setSeverita(DiagnosticiSeverita.DEBUG_LOW);
                    break;
                }
                case INFO_PROTOCOL: {
                    ret.setSeverita(DiagnosticiSeverita.INFO_PROTOCOL);
                    break;
                }
                case INFO_INTEGRATION: {
                    ret.setSeverita(DiagnosticiSeverita.INFO_INTEGRATION);
                    break;
                }
                case ERROR_PROTOCOL: {
                    ret.setSeverita(DiagnosticiSeverita.ERROR_PROTOCOL);
                    break;
                }
                case ERROR_INTEGRATION: {
                    ret.setSeverita(DiagnosticiSeverita.ERROR_INTEGRATION);
                    break;
                }
                case FATAL: {
                    ret.setSeverita(DiagnosticiSeverita.FATAL);
                    break;
                }
                case OFF: {
                    ret.setSeverita(DiagnosticiSeverita.OFF);
                }
            }
        } else {
            ret.setStato(StatoDefaultRidefinitoEnum.DEFAULT);
        }
        return ret;
    }

    public static final RegistrazioneTransazioniConfigurazione fromTransazioniConfigurazione(PortaTracciamento paTracciamento, Environment env) throws ProtocolException {
        RegistrazioneTransazioniConfigurazione ret = new RegistrazioneTransazioniConfigurazione();
        if (paTracciamento != null && (paTracciamento.getDatabase() != null || paTracciamento.getFiletrace() != null || paTracciamento.getEsiti() != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{paTracciamento.getEsiti()}) && (paTracciamento.getDatabase() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getDatabase().getFiltroEsiti()) || paTracciamento.getFiletrace() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletrace().getFiltroEsiti())) || paTracciamento.getFiletraceConfig() != null || paTracciamento.getTransazioni() != null)) {
            ret.setStato(StatoDefaultRidefinitoEnum.RIDEFINITO);
            if (paTracciamento.getDatabase() != null) {
                ret.setDatabase(ErogazioniApiHelper.fromTransazioniConfigurazioneBase(paTracciamento.getDatabase(), false));
            }
            if (paTracciamento.getFiletrace() != null) {
                RegistrazioneTransazioniConfigurazioneFiletrace f = (RegistrazioneTransazioniConfigurazioneFiletrace)ErogazioniApiHelper.fromTransazioniConfigurazioneBase(paTracciamento.getFiletrace(), true);
                if (paTracciamento.getFiletraceConfig() != null) {
                    f.setConfigPath(paTracciamento.getFiletraceConfig().getConfig());
                    if (paTracciamento.getFiletraceConfig().getDumpIn() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpIn().getStato())) {
                        f.setDumpClient(new RegistrazioneTransazioniConfigurazioneFiletraceMessaggio());
                        f.getDumpClient().setHeaders(StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpIn().getHeader()));
                        f.getDumpClient().setPayload(StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpIn().getPayload()));
                    }
                    if (paTracciamento.getFiletraceConfig().getDumpOut() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpOut().getStato())) {
                        f.setDumpServer(new RegistrazioneTransazioniConfigurazioneFiletraceMessaggio());
                        f.getDumpServer().setHeaders(StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpOut().getHeader()));
                        f.getDumpServer().setPayload(StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletraceConfig().getDumpOut().getPayload()));
                    }
                }
                ret.setFiletrace(f);
            }
            if (paTracciamento.getEsiti() != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{paTracciamento.getEsiti()}) && (paTracciamento.getDatabase() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getDatabase().getFiltroEsiti()) || paTracciamento.getFiletrace() != null && StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiletrace().getFiltroEsiti()))) {
                Logger log = LoggerWrapperFactory.getLogger(ErogazioniApiHelper.class);
                List esiti = EsitiConfigUtils.getRegistrazioneEsiti((String)paTracciamento.getEsiti(), (Logger)log, (StringBuilder)new StringBuilder(), (EsitiProperties)EsitiProperties.getInstance((Logger)log, env.protocolFactory));
                if (esiti != null && !esiti.isEmpty()) {
                    ret.setFiltro(new RegistrazioneTransazioniConfigurazioneFiltroEsiti());
                    for (String e : esiti) {
                        ret.getFiltro().addEsitiItem(Integer.valueOf(e));
                    }
                }
            }
            if (paTracciamento.getTransazioni() != null) {
                ret.setInformazioni(new RegistrazioneTransazioniConfigurazioneInformazioniRegistrate());
                if (paTracciamento.getTransazioni().getTempiElaborazione() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getTransazioni().getTempiElaborazione())) {
                        ret.getInformazioni().setTempiElaborazione(TracciamentoTransazioniStatoFase.ABILITATO);
                    } else {
                        ret.getInformazioni().setTempiElaborazione(TracciamentoTransazioniStatoFase.DISABILITATO);
                    }
                } else {
                    ret.getInformazioni().setTempiElaborazione(TracciamentoTransazioniStatoFase.DISABILITATO);
                }
                if (paTracciamento.getTransazioni().getToken() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getTransazioni().getToken())) {
                        ret.getInformazioni().setToken(TracciamentoTransazioniStatoFase.ABILITATO);
                    } else {
                        ret.getInformazioni().setToken(TracciamentoTransazioniStatoFase.DISABILITATO);
                    }
                } else {
                    ret.getInformazioni().setToken(TracciamentoTransazioniStatoFase.DISABILITATO);
                }
            }
            if (ret.getDatabase() == null && ret.getFiletrace() == null && ret.getFiltro() == null && ret.getInformazioni() == null) {
                ret.setStato(StatoDefaultRidefinitoEnum.DEFAULT);
            }
        } else {
            ret.setStato(StatoDefaultRidefinitoEnum.DEFAULT);
        }
        return ret;
    }

    private static final RegistrazioneTransazioniConfigurazioneBase fromTransazioniConfigurazioneBase(TracciamentoConfigurazione paTracciamento, boolean fileTrace) {
        RegistrazioneTransazioniConfigurazioneBase c = null;
        if (paTracciamento.getStato() != null) {
            c = fileTrace ? new RegistrazioneTransazioniConfigurazioneFiletrace() : new RegistrazioneTransazioniConfigurazioneBase();
            switch (paTracciamento.getStato()) {
                case ABILITATO: {
                    c.setStato(TracciamentoTransazioniStato.ABILITATO);
                    break;
                }
                case DISABILITATO: {
                    c.setStato(TracciamentoTransazioniStato.DISABILITATO);
                    break;
                }
                case CONFIGURAZIONE_ESTERNA: {
                    c.setStato(TracciamentoTransazioniStato.CONFIGURAZIONEESTERNA);
                    break;
                }
                case PERSONALIZZATO: {
                    c.setStato(TracciamentoTransazioniStato.PERSONALIZZATO);
                    c.setFasi(new RegistrazioneTransazioniConfigurazioneFasi());
                    if (paTracciamento.getRequestIn() != null) {
                        switch (paTracciamento.getRequestIn()) {
                            case ABILITATO: {
                                c.getFasi().setRichiestaIngresso(TracciamentoTransazioniStatoFaseBloccante.BLOCCANTE);
                                break;
                            }
                            case NON_BLOCCANTE: {
                                c.getFasi().setRichiestaIngresso(TracciamentoTransazioniStatoFaseBloccante.NON_BLOCCANTE);
                                break;
                            }
                            case DISABILITATO: {
                                c.getFasi().setRichiestaIngresso(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                            }
                        }
                    } else {
                        c.getFasi().setRichiestaIngresso(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                    }
                    if (paTracciamento.getRequestOut() != null) {
                        switch (paTracciamento.getRequestOut()) {
                            case ABILITATO: {
                                c.getFasi().setRichiestaUscita(TracciamentoTransazioniStatoFaseBloccante.BLOCCANTE);
                                break;
                            }
                            case NON_BLOCCANTE: {
                                c.getFasi().setRichiestaUscita(TracciamentoTransazioniStatoFaseBloccante.NON_BLOCCANTE);
                                break;
                            }
                            case DISABILITATO: {
                                c.getFasi().setRichiestaUscita(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                            }
                        }
                    } else {
                        c.getFasi().setRichiestaUscita(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                    }
                    if (paTracciamento.getResponseOut() != null) {
                        switch (paTracciamento.getResponseOut()) {
                            case ABILITATO: {
                                c.getFasi().setRispostaUscita(TracciamentoTransazioniStatoFaseBloccante.BLOCCANTE);
                                break;
                            }
                            case NON_BLOCCANTE: {
                                c.getFasi().setRispostaUscita(TracciamentoTransazioniStatoFaseBloccante.NON_BLOCCANTE);
                                break;
                            }
                            case DISABILITATO: {
                                c.getFasi().setRispostaUscita(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                            }
                        }
                    } else {
                        c.getFasi().setRispostaUscita(TracciamentoTransazioniStatoFaseBloccante.DISABILITATO);
                    }
                    if (paTracciamento.getResponseOutComplete() != null) {
                        if (StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getResponseOutComplete())) {
                            c.getFasi().setRispostaConsegnata(TracciamentoTransazioniStatoFase.ABILITATO);
                            break;
                        }
                        c.getFasi().setRispostaConsegnata(TracciamentoTransazioniStatoFase.DISABILITATO);
                        break;
                    }
                    c.getFasi().setRispostaConsegnata(TracciamentoTransazioniStatoFase.DISABILITATO);
                }
            }
            if (paTracciamento.getFiltroEsiti() != null) {
                if (StatoFunzionalita.ABILITATO.equals((Object)paTracciamento.getFiltroEsiti())) {
                    c.setFiltroEsiti(TracciamentoTransazioniStatoFase.ABILITATO);
                } else {
                    c.setFiltroEsiti(TracciamentoTransazioniStatoFase.DISABILITATO);
                }
            }
        }
        return c;
    }

    public static final RegistrazioneMessaggi fromDumpConfigurazione(DumpConfigurazione paDump) {
        RegistrazioneMessaggi ret = new RegistrazioneMessaggi();
        if (paDump != null) {
            ret.setStato(StatoDefaultRidefinitoEnum.RIDEFINITO);
            RegistrazioneMessaggiConfigurazione richiesta = new RegistrazioneMessaggiConfigurazione();
            richiesta.setAbilitato(ErogazioniApiHelper.isDumpConfigurazioneAbilitato(paDump, false));
            if (richiesta.isAbilitato().booleanValue()) {
                richiesta.setIngresso(ErogazioniApiHelper.fromDumpConfigurazioneRegola(paDump.getRichiestaIngresso()));
                richiesta.setUscita(ErogazioniApiHelper.fromDumpConfigurazioneRegola(paDump.getRichiestaUscita()));
            }
            ret.setRichiesta(richiesta);
            RegistrazioneMessaggiConfigurazione risposta = new RegistrazioneMessaggiConfigurazione();
            risposta.setAbilitato(ErogazioniApiHelper.isDumpConfigurazioneAbilitato(paDump, true));
            if (risposta.isAbilitato().booleanValue()) {
                risposta.setIngresso(ErogazioniApiHelper.fromDumpConfigurazioneRegola(paDump.getRispostaIngresso()));
                risposta.setUscita(ErogazioniApiHelper.fromDumpConfigurazioneRegola(paDump.getRispostaUscita()));
            }
            ret.setRisposta(risposta);
        } else {
            ret.setStato(StatoDefaultRidefinitoEnum.DEFAULT);
        }
        return ret;
    }

    public static final Validazione fromValidazioneContenutiApplicativi(ValidazioneContenutiApplicativi vx) {
        Validazione ret = new Validazione();
        if (vx == null) {
            ret.setStato(StatoFunzionalitaConWarningEnum.DISABILITATO);
        } else {
            ret.setMtom(Helper.statoFunzionalitaConfToBool(vx.getAcceptMtomMessage()));
            ret.setStato(StatoFunzionalitaConWarningEnum.valueOf(vx.getStato().name()));
            ret.setTipo(TipoValidazioneEnum.valueOf(vx.getTipo().name()));
        }
        return ret;
    }

    public static final String readHeadersResponseCaching(List<String> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        StringBuilder bf = new StringBuilder();
        for (String hdr : headers) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(hdr);
        }
        return bf.toString();
    }

    public static final List<ResponseCachingConfigurazioneRegola> getRegoleResponseCaching(List<CachingRispostaRegola> regole) {
        if (regole == null || regole.isEmpty()) {
            return null;
        }
        ArrayList<ResponseCachingConfigurazioneRegola> returnList = new ArrayList<ResponseCachingConfigurazioneRegola>();
        for (CachingRispostaRegola cachingRispostaRegola : regole) {
            ResponseCachingConfigurazioneRegola rule = new ResponseCachingConfigurazioneRegola();
            if (cachingRispostaRegola.getReturnCodeMin() != null) {
                rule.setReturnCodeMin(cachingRispostaRegola.getReturnCodeMin());
            }
            if (cachingRispostaRegola.getReturnCodeMax() != null) {
                rule.setReturnCodeMax(cachingRispostaRegola.getReturnCodeMax());
            }
            rule.setFault(cachingRispostaRegola.isFault().booleanValue());
            if (cachingRispostaRegola.getCacheTimeoutSeconds() != null) {
                rule.setCacheTimeoutSeconds(cachingRispostaRegola.getCacheTimeoutSeconds());
            }
            returnList.add(rule);
        }
        return returnList;
    }

    public static final ResponseCachingConfigurazione buildResponseCachingConfigurazione(CachingRisposta body, PorteApplicativeHelper paHelper) {
        ResponseCachingConfigurazione newConfigurazione = null;
        if (body.getStato() != StatoDefaultRidefinitoEnum.DEFAULT && body.getStato() == StatoDefaultRidefinitoEnum.RIDEFINITO) {
            newConfigurazione = paHelper.getResponseCaching(body.isAbilitato().booleanValue(), body.getCacheTimeoutSeconds().intValue(), body.isMaxResponseSize().booleanValue(), body.getMaxResponseSizeKb().longValue(), body.isHashRequestUri().booleanValue(), ErogazioniApiHelper.readHeadersResponseCaching(body.getHashHeaders()) != null, body.isHashPayload().booleanValue(), ErogazioniApiHelper.readHeadersResponseCaching(body.getHashHeaders()), ErogazioniApiHelper.convertToStatoFunzionalitaCacheDigestQueryParameter(body), ErogazioniApiHelper.readHeadersResponseCaching(body.getHashQueryParamaters()), body.isControlNoCache().booleanValue(), body.isControlMaxAge().booleanValue(), body.isControlNoStore().booleanValue(), ErogazioniApiHelper.getRegoleResponseCaching(body.getRegole()));
        }
        return newConfigurazione;
    }

    private static final StatoFunzionalitaCacheDigestQueryParameter convertToStatoFunzionalitaCacheDigestQueryParameter(CachingRisposta body) {
        if (body != null && body.isHashAllQueryParameters() != null) {
            if (body.isHashAllQueryParameters().booleanValue()) {
                return StatoFunzionalitaCacheDigestQueryParameter.ABILITATO;
            }
            if (body.getHashQueryParamaters() != null && !body.getHashQueryParamaters().isEmpty()) {
                return StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE;
            }
            return StatoFunzionalitaCacheDigestQueryParameter.DISABILITATO;
        }
        return StatoFunzionalitaCacheDigestQueryParameter.ABILITATO;
    }

    public static final CachingRisposta buildCachingRisposta(ResponseCachingConfigurazione conf) {
        CachingRisposta ret = new CachingRisposta();
        if (conf == null) {
            ret.setStato(StatoDefaultRidefinitoEnum.DEFAULT);
            ret.setAbilitato(false);
            ret.setHashHeaders(null);
            ret.setHashPayload(null);
            ret.setHashRequestUri(null);
            ret.setHashAllQueryParameters(null);
            return ret;
        }
        ret.setAbilitato(conf.getStato() == StatoFunzionalita.ABILITATO);
        ret.setStato(conf.getStato() == StatoFunzionalita.ABILITATO ? StatoDefaultRidefinitoEnum.RIDEFINITO : StatoDefaultRidefinitoEnum.DEFAULT);
        ret.setCacheTimeoutSeconds(conf.getCacheTimeoutSeconds());
        if (ret.isAbilitato().booleanValue()) {
            ret.setMaxResponseSize(conf.getMaxMessageSize() != null);
            ret.setMaxResponseSizeKb(conf.getMaxMessageSize());
            ResponseCachingConfigurazioneHashGenerator hashInfo = conf.getHashGenerator();
            if (hashInfo.getQueryParameters() != null) {
                switch (hashInfo.getQueryParameters()) {
                    case ABILITATO: {
                        ret.setHashAllQueryParameters(true);
                        break;
                    }
                    case DISABILITATO: {
                        ret.setHashAllQueryParameters(false);
                        break;
                    }
                    case SELEZIONE_PUNTUALE: {
                        ret.setHashAllQueryParameters(false);
                        if (hashInfo.sizeQueryParameterList() <= 0) break;
                        ret.setHashQueryParamaters(hashInfo.getQueryParameterList());
                    }
                }
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)hashInfo.getHeaders()) && hashInfo.sizeHeaderList() > 0) {
                ret.setHashHeaders(hashInfo.getHeaderList());
            }
            ret.setHashPayload(Helper.statoFunzionalitaConfToBool(hashInfo.getPayload()));
            ret.setHashRequestUri(Helper.statoFunzionalitaConfToBool(hashInfo.getRequestUri()));
            if (conf.getControl() != null) {
                ret.setControlNoCache(conf.getControl().isNoCache());
                ret.setControlMaxAge(conf.getControl().isMaxAge());
                ret.setControlNoStore(conf.getControl().isNoStore());
            }
            if (conf.sizeRegolaList() > 0) {
                ret.setRegole(new ArrayList<CachingRispostaRegola>());
                for (ResponseCachingConfigurazioneRegola regola : conf.getRegolaList()) {
                    CachingRispostaRegola cachingRispostaRegola = new CachingRispostaRegola();
                    if (regola.getReturnCodeMin() != null) {
                        cachingRispostaRegola.setReturnCodeMin(regola.getReturnCodeMin());
                    }
                    if (regola.getReturnCodeMax() != null) {
                        cachingRispostaRegola.setReturnCodeMax(regola.getReturnCodeMax());
                    }
                    cachingRispostaRegola.setFault(regola.isFault());
                    if (regola.getCacheTimeoutSeconds() != null) {
                        cachingRispostaRegola.setCacheTimeoutSeconds(regola.getCacheTimeoutSeconds());
                    }
                    ret.addRegoleItem(cachingRispostaRegola);
                }
            }
        }
        return ret;
    }

    @Deprecated
    public static final org.openspcoop2.core.registry.constants.RuoloTipologia ruoloTipologiaFromAutorizzazione(String autorizzazione) {
        org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = null;
        if (TipoAutorizzazione.isRolesRequired((String)autorizzazione)) {
            tipoRuoloFonte = TipoAutorizzazione.isExternalRolesRequired((String)autorizzazione) ? org.openspcoop2.core.registry.constants.RuoloTipologia.ESTERNO : (TipoAutorizzazione.isInternalRolesRequired((String)autorizzazione) ? org.openspcoop2.core.registry.constants.RuoloTipologia.INTERNO : org.openspcoop2.core.registry.constants.RuoloTipologia.QUALSIASI);
        }
        return tipoRuoloFonte;
    }

    public static final boolean controlloAccessiCheckPD(FruizioniConfEnv env, PortaDelegata oldPd, PortaDelegata newPd) throws Exception {
        boolean autorizzazioneScope;
        BinaryParameter allegatoXacmlPolicy = new BinaryParameter();
        allegatoXacmlPolicy.setValue(((String)BaseHelper.evalorElse(() -> newPd.getXacmlPolicy(), (Object)"")).getBytes());
        org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = AutorizzazioneUtilities.convertToRuoloTipologia((TipoAutorizzazione)TipoAutorizzazione.toEnumConstant((String)newPd.getAutorizzazione()));
        String stato_autorizzazione = null;
        if (TipoAutorizzazione.toEnumConstant((String)newPd.getAutorizzazione()) != null) {
            stato_autorizzazione = AutorizzazioneUtilities.convertToStato((String)newPd.getAutorizzazione());
        }
        boolean tokenAbilitato = newPd.getGestioneToken() != null;
        boolean bl = autorizzazioneScope = newPd.getScope() != null;
        if (autorizzazioneScope && !tokenAbilitato) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione per scope richiede una token policy abilitata");
        }
        TipoAutenticazionePrincipal autenticazionePrincipal = env.pdCore.getTipoAutenticazionePrincipal(newPd.getProprietaAutenticazioneList());
        List autenticazioneParametroList = env.pdCore.getParametroAutenticazione(newPd.getAutenticazione(), newPd.getProprietaAutenticazioneList());
        String autorizzazioneContenutiStato = null;
        String autorizzazioneContenuti = newPd.getAutorizzazioneContenuto();
        String autorizzazioneContenutiProperties = null;
        if (autorizzazioneContenuti == null) {
            autorizzazioneContenutiStato = StatoFunzionalita.DISABILITATO.getValue();
        } else if (autorizzazioneContenuti.equals("builtIn")) {
            autorizzazioneContenutiStato = StatoFunzionalita.ABILITATO.getValue();
            List proprietaAutorizzazioneContenutoList = newPd.getProprietaAutorizzazioneContenutoList();
            StringBuilder sb = new StringBuilder();
            for (Proprieta proprieta : proprietaAutorizzazioneContenutoList) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(proprieta.getNome()).append("=").append(proprieta.getValore());
            }
            autorizzazioneContenutiProperties = sb.toString();
        } else {
            autorizzazioneContenutiStato = "custom";
        }
        String identificazioneAttributiStato = newPd.sizeAttributeAuthorityList() > 0 ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
        String[] attributeAuthoritySelezionate = null;
        String attributeAuthorityAttributi = null;
        if (newPd.sizeAttributeAuthorityList() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (AttributeAuthority aa : newPd.getAttributeAuthorityList()) {
                l.add(aa.getNome());
            }
            attributeAuthoritySelezionate = l.toArray(new String[1]);
            attributeAuthorityAttributi = env.apsCore.buildAttributesStringFromAuthority(newPd.getAttributeAuthorityList());
        }
        String autorizzazioneAutenticatiToken = null;
        String autorizzazioneRuoliToken = null;
        if (newPd.getAutorizzazioneToken() != null) {
            autorizzazioneAutenticatiToken = ServletUtils.boolToCheckBoxStatus((Boolean)StatoFunzionalita.ABILITATO.equals((Object)newPd.getAutorizzazioneToken().getAutorizzazioneApplicativi()));
            autorizzazioneRuoliToken = ServletUtils.boolToCheckBoxStatus((Boolean)StatoFunzionalita.ABILITATO.equals((Object)newPd.getAutorizzazioneToken().getAutorizzazioneRuoli()));
        }
        return env.paHelper.controlloAccessiCheck(TipoOperazione.OTHER, newPd.getAutenticazione(), ServletUtils.boolToCheckBoxStatus((Boolean)Helper.statoFunzionalitaConfToBool(newPd.getAutenticazioneOpzionale())), autenticazionePrincipal, autenticazioneParametroList, stato_autorizzazione, ServletUtils.boolToCheckBoxStatus((Boolean)TipoAutorizzazione.isAuthenticationRequired((String)newPd.getAutorizzazione())), ServletUtils.boolToCheckBoxStatus((Boolean)TipoAutorizzazione.isRolesRequired((String)newPd.getAutorizzazione())), (String)BaseHelper.evalnull(() -> tipoRuoloFonte.toString()), (String)BaseHelper.evalnull(() -> newPd.getRuoli().getMatch().toString()), env.isSupportatoAutenticazioneSoggetti, true, (Object)oldPd, (List)BaseHelper.evalnull(() -> newPd.getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())), Helper.boolToStatoFunzionalita(tokenAbilitato).getValue(), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getPolicy()), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getValidazione().toString()), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getIntrospection().toString()), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getUserInfo().toString()), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getForward().toString()), autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, (String)BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)(newPd.getGestioneToken().getOptions() != null ? 1 : 0))), (String)BaseHelper.evalnull(() -> newPd.getGestioneToken().getOptions()), (String)BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)autorizzazioneScope)), (String)BaseHelper.evalnull(() -> newPd.getScope().getMatch().toString()), allegatoXacmlPolicy, autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, env.tipo_protocollo, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
    }

    public static final boolean controlloAccessiCheckPA(ErogazioniConfEnv env, PortaApplicativa oldPa, PortaApplicativa newPa) throws Exception {
        boolean autorizzazioneScope;
        BinaryParameter allegatoXacmlPolicy = new BinaryParameter();
        allegatoXacmlPolicy.setValue(((String)BaseHelper.evalorElse(() -> newPa.getXacmlPolicy(), (Object)"")).getBytes());
        org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = AutorizzazioneUtilities.convertToRuoloTipologia((TipoAutorizzazione)TipoAutorizzazione.toEnumConstant((String)newPa.getAutorizzazione()));
        String stato_autorizzazione = null;
        if (TipoAutorizzazione.toEnumConstant((String)newPa.getAutorizzazione()) != null) {
            stato_autorizzazione = AutorizzazioneUtilities.convertToStato((String)newPa.getAutorizzazione());
        }
        boolean tokenAbilitato = newPa.getGestioneToken() != null;
        boolean bl = autorizzazioneScope = newPa.getScope() != null;
        if (autorizzazioneScope && !tokenAbilitato) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione per scope richiede una token policy abilitata");
        }
        TipoAutenticazionePrincipal autenticazionePrincipal = env.paCore.getTipoAutenticazionePrincipal(newPa.getProprietaAutenticazioneList());
        List autenticazioneParametroList = env.paCore.getParametroAutenticazione(newPa.getAutenticazione(), newPa.getProprietaAutenticazioneList());
        String autorizzazioneContenutiStato = null;
        String autorizzazioneContenuti = newPa.getAutorizzazioneContenuto();
        String autorizzazioneContenutiProperties = null;
        if (autorizzazioneContenuti == null) {
            autorizzazioneContenutiStato = StatoFunzionalita.DISABILITATO.getValue();
        } else if (autorizzazioneContenuti.equals("builtIn")) {
            autorizzazioneContenutiStato = StatoFunzionalita.ABILITATO.getValue();
            List proprietaAutorizzazioneContenutoList = newPa.getProprietaAutorizzazioneContenutoList();
            StringBuilder sb = new StringBuilder();
            for (Proprieta proprieta : proprietaAutorizzazioneContenutoList) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(proprieta.getNome()).append("=").append(proprieta.getValore());
            }
            autorizzazioneContenutiProperties = sb.toString();
        } else {
            autorizzazioneContenutiStato = "custom";
        }
        String identificazioneAttributiStato = newPa.sizeAttributeAuthorityList() > 0 ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue();
        String[] attributeAuthoritySelezionate = null;
        String attributeAuthorityAttributi = null;
        if (newPa.sizeAttributeAuthorityList() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (AttributeAuthority aa : newPa.getAttributeAuthorityList()) {
                l.add(aa.getNome());
            }
            attributeAuthoritySelezionate = l.toArray(new String[1]);
            attributeAuthorityAttributi = env.apsCore.buildAttributesStringFromAuthority(newPa.getAttributeAuthorityList());
        }
        String autorizzazioneAutenticatiToken = null;
        String autorizzazioneRuoliToken = null;
        if (newPa.getAutorizzazioneToken() != null) {
            autorizzazioneAutenticatiToken = ServletUtils.boolToCheckBoxStatus((Boolean)StatoFunzionalita.ABILITATO.equals((Object)newPa.getAutorizzazioneToken().getAutorizzazioneApplicativi()));
            autorizzazioneRuoliToken = ServletUtils.boolToCheckBoxStatus((Boolean)StatoFunzionalita.ABILITATO.equals((Object)newPa.getAutorizzazioneToken().getAutorizzazioneRuoli()));
        }
        return env.paHelper.controlloAccessiCheck(TipoOperazione.OTHER, newPa.getAutenticazione(), ServletUtils.boolToCheckBoxStatus((Boolean)Helper.statoFunzionalitaConfToBool(newPa.getAutenticazioneOpzionale())), autenticazionePrincipal, autenticazioneParametroList, stato_autorizzazione, ServletUtils.boolToCheckBoxStatus((Boolean)TipoAutorizzazione.isAuthenticationRequired((String)newPa.getAutorizzazione())), ServletUtils.boolToCheckBoxStatus((Boolean)TipoAutorizzazione.isRolesRequired((String)newPa.getAutorizzazione())), (String)BaseHelper.evalnull(() -> tipoRuoloFonte.toString()), (String)BaseHelper.evalnull(() -> newPa.getRuoli().getMatch().toString()), env.isSupportatoAutenticazioneSoggetti, false, (Object)oldPa, (List)BaseHelper.evalnull(() -> newPa.getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())), Helper.boolToStatoFunzionalita(tokenAbilitato).getValue(), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getPolicy()), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getValidazione().toString()), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getIntrospection().toString()), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getUserInfo().toString()), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getForward().toString()), autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, (String)BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)(newPa.getGestioneToken().getOptions() != null ? 1 : 0))), (String)BaseHelper.evalnull(() -> newPa.getGestioneToken().getOptions()), (String)BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)autorizzazioneScope)), (String)BaseHelper.evalnull(() -> newPa.getScope().getMatch().toString()), allegatoXacmlPolicy, autorizzazioneContenutiStato, autorizzazioneContenuti, autorizzazioneContenutiProperties, env.tipo_protocollo, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
    }

    public static final void fillPortaDelegata(ControlloAccessiAutorizzazione body, PortaDelegata newPd) {
        OneOfControlloAccessiAutorizzazioneAutorizzazione authz = body.getAutorizzazione();
        newPd.setXacmlPolicy(null);
        switch (authz.getTipo()) {
            case DISABILITATO: {
                String tipoAutorString = TipoAutorizzazione.DISABILITATO.toString();
                newPd.setRuoli(null);
                newPd.setScope(null);
                newPd.setAutorizzazione(tipoAutorString);
                break;
            }
            case ABILITATO: {
                if (!(authz instanceof APIImplAutorizzazioneAbilitata)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneAbilitata authzAbilitata = (APIImplAutorizzazioneAbilitata)authz;
                if (authzAbilitata.isRuoli().booleanValue() && authzAbilitata.getRuoliFonte() == null) {
                    authzAbilitata.setRuoliFonte(FonteEnum.QUALSIASI);
                }
                String autorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
                String autorizzazioneAutenticati = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isRichiedente());
                String autorizzazioneRuoli = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isRuoli());
                org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = Enums.ruoloTipologiaFromRest.get((Object)authzAbilitata.getRuoliFonte());
                RuoloTipoMatch tipoRuoloMatch = null;
                if (authzAbilitata.getRuoliRichiesti() != null) {
                    tipoRuoloMatch = RuoloTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getRuoliRichiesti().toString())));
                }
                String autorizzazioneTokenAutenticati = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isTokenRichiedente());
                String autorizzazioneTokenRuoli = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isTokenRuoli());
                RuoloTipologia tipoTokenRuoloFonte = Enums.ruoloTipologiaConfigFromRest.get((Object)authzAbilitata.getTokenRuoliFonte());
                RuoloTipoMatch tipoTokenRuoloMatch = null;
                if (authzAbilitata.getTokenRuoliRichiesti() != null) {
                    tipoTokenRuoloMatch = RuoloTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getTokenRuoliRichiesti().toString())));
                }
                String autorizzazioneScope = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isScope());
                ScopeTipoMatch scopeTipoMatch = ScopeTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getScopeRichiesti().toString())));
                String autorizzazione_tokenOptions = null;
                if (authzAbilitata.getTokenClaims() != null && !authzAbilitata.getTokenClaims().isEmpty()) {
                    autorizzazione_tokenOptions = String.join((CharSequence)"\n", authzAbilitata.getTokenClaims());
                }
                String tipoAutorString = AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString((String)autorizzazione, (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneTokenAutenticati), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneTokenRuoli), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope), (String)autorizzazione_tokenOptions, (org.openspcoop2.core.registry.constants.RuoloTipologia)tipoRuoloFonte);
                newPd.setAutorizzazione(tipoAutorString);
                if (authzAbilitata.isRuoli().booleanValue()) {
                    if (newPd.getRuoli() == null) {
                        newPd.setRuoli(new AutorizzazioneRuoli());
                    }
                    newPd.getRuoli().setMatch(tipoRuoloMatch);
                } else {
                    newPd.setRuoli(null);
                }
                if (authzAbilitata.isTokenRichiedente().booleanValue() || authzAbilitata.isTokenRuoli().booleanValue()) {
                    newPd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
                    if (authzAbilitata.isTokenRichiedente().booleanValue()) {
                        newPd.getAutorizzazioneToken().setAutorizzazioneApplicativi(StatoFunzionalita.ABILITATO);
                    }
                    if (authzAbilitata.isTokenRuoli().booleanValue()) {
                        newPd.getAutorizzazioneToken().setAutorizzazioneRuoli(StatoFunzionalita.ABILITATO);
                        newPd.getAutorizzazioneToken().setTipologiaRuoli(tipoTokenRuoloFonte);
                        if (newPd.getAutorizzazioneToken().getRuoli() == null) {
                            newPd.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                        }
                        newPd.getAutorizzazioneToken().getRuoli().setMatch(tipoTokenRuoloMatch);
                    }
                }
                if (authzAbilitata.isScope().booleanValue()) {
                    if (newPd.getScope() == null) {
                        newPd.setScope(new AutorizzazioneScope());
                    }
                    newPd.getScope().setMatch(scopeTipoMatch);
                    newPd.getScope().setStato(StatoFunzionalita.ABILITATO);
                } else {
                    newPd.setScope(null);
                }
                if (authzAbilitata.isToken().booleanValue()) {
                    if (newPd.getGestioneToken() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessun token configurato per l'erogazione");
                    }
                    newPd.getGestioneToken().setOptions(autorizzazione_tokenOptions);
                    break;
                }
                BaseHelper.runNull(() -> newPd.getGestioneToken().setOptions(null));
                break;
            }
            case XACML_POLICY: {
                if (!(authz instanceof APIImplAutorizzazioneXACML)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneXACML authzXacml = (APIImplAutorizzazioneXACML)authz;
                if (authzXacml.getPolicy() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Campo obbligatorio 'policy' non presente nell'autorizzazione indicata");
                }
                if (authzXacml.getRuoliFonte() == null) {
                    authzXacml.setRuoliFonte(FonteEnum.QUALSIASI);
                }
                org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = Enums.ruoloTipologiaFromRest.get((Object)authzXacml.getRuoliFonte());
                String tipoAutorString = AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString((String)TipoAutorizzazioneEnum.XACML_POLICY.toString(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)"", (org.openspcoop2.core.registry.constants.RuoloTipologia)tipoRuoloFonte);
                newPd.setAutorizzazione(tipoAutorString);
                newPd.setXacmlPolicy((String)BaseHelper.evalnull(() -> new String(authzXacml.getPolicy())));
                break;
            }
            case CUSTOM: {
                if (!(authz instanceof APIImplAutorizzazioneCustom)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneCustom authzACustom = (APIImplAutorizzazioneCustom)authz;
                if (StringUtils.isEmpty((CharSequence)authzACustom.getNome())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(APIImplAutorizzazioneCustom.class.getName() + ": Indicare il campo obbligatorio 'nome' ");
                }
                newPd.setAutorizzazione(authzACustom.getNome());
            }
        }
    }

    public static final void fillPortaApplicativa(ControlloAccessiAutorizzazione body, PortaApplicativa newPa) {
        OneOfControlloAccessiAutorizzazioneAutorizzazione authz = body.getAutorizzazione();
        newPa.setXacmlPolicy(null);
        switch (authz.getTipo()) {
            case DISABILITATO: {
                String tipoAutorString = TipoAutorizzazione.DISABILITATO.toString();
                newPa.setSoggetti(null);
                newPa.setRuoli(null);
                newPa.setScope(null);
                newPa.setAutorizzazione(tipoAutorString);
                break;
            }
            case ABILITATO: {
                if (!(authz instanceof APIImplAutorizzazioneAbilitata)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneAbilitata authzAbilitata = (APIImplAutorizzazioneAbilitata)authz;
                if (authzAbilitata.isRuoli().booleanValue() && authzAbilitata.getRuoliFonte() == null) {
                    authzAbilitata.setRuoliFonte(FonteEnum.QUALSIASI);
                }
                String statoAutorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
                String autorizzazioneAutenticati = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isRichiedente());
                String autorizzazioneRuoli = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isRuoli());
                org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = Enums.ruoloTipologiaFromRest.get((Object)authzAbilitata.getRuoliFonte());
                RuoloTipoMatch tipoRuoloMatch = null;
                if (authzAbilitata.getRuoliRichiesti() != null) {
                    tipoRuoloMatch = RuoloTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getRuoliRichiesti().toString())));
                }
                String autorizzazioneTokenAutenticati = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isTokenRichiedente());
                String autorizzazioneTokenRuoli = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isTokenRuoli());
                RuoloTipologia tipoTokenRuoloFonte = Enums.ruoloTipologiaConfigFromRest.get((Object)authzAbilitata.getTokenRuoliFonte());
                RuoloTipoMatch tipoTokenRuoloMatch = null;
                if (authzAbilitata.getTokenRuoliRichiesti() != null) {
                    tipoTokenRuoloMatch = RuoloTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getTokenRuoliRichiesti().toString())));
                }
                String autorizzazioneScope = ServletUtils.boolToCheckBoxStatus((Boolean)authzAbilitata.isScope());
                ScopeTipoMatch scopeTipoMatch = ScopeTipoMatch.toEnumConstant((String)((String)BaseHelper.evalnull(() -> authzAbilitata.getScopeRichiesti().toString())));
                String autorizzazione_tokenOptions = null;
                if (authzAbilitata.getTokenClaims() != null && !authzAbilitata.getTokenClaims().isEmpty()) {
                    autorizzazione_tokenOptions = String.join((CharSequence)"\n", authzAbilitata.getTokenClaims());
                }
                String tipoAutorString = AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString((String)statoAutorizzazione, (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneTokenAutenticati), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneTokenRuoli), (boolean)ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope), (String)autorizzazione_tokenOptions, (org.openspcoop2.core.registry.constants.RuoloTipologia)tipoRuoloFonte);
                newPa.setAutorizzazione(tipoAutorString);
                if (authzAbilitata.isRuoli().booleanValue()) {
                    if (newPa.getRuoli() == null) {
                        newPa.setRuoli(new AutorizzazioneRuoli());
                    }
                    newPa.getRuoli().setMatch(tipoRuoloMatch);
                } else {
                    newPa.setRuoli(null);
                }
                if (authzAbilitata.isTokenRichiedente().booleanValue() || authzAbilitata.isTokenRuoli().booleanValue()) {
                    newPa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
                    if (authzAbilitata.isTokenRichiedente().booleanValue()) {
                        newPa.getAutorizzazioneToken().setAutorizzazioneApplicativi(StatoFunzionalita.ABILITATO);
                    }
                    if (authzAbilitata.isTokenRuoli().booleanValue()) {
                        newPa.getAutorizzazioneToken().setAutorizzazioneRuoli(StatoFunzionalita.ABILITATO);
                        newPa.getAutorizzazioneToken().setTipologiaRuoli(tipoTokenRuoloFonte);
                        if (newPa.getAutorizzazioneToken().getRuoli() == null) {
                            newPa.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                        }
                        newPa.getAutorizzazioneToken().getRuoli().setMatch(tipoTokenRuoloMatch);
                    }
                } else if (!authzAbilitata.isTokenRichiedente().booleanValue() && !authzAbilitata.isTokenRuoli().booleanValue() && authzAbilitata.isToken().booleanValue()) {
                    newPa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
                } else {
                    newPa.setAutorizzazioneToken(null);
                }
                if (authzAbilitata.isScope().booleanValue()) {
                    if (newPa.getScope() == null) {
                        newPa.setScope(new AutorizzazioneScope());
                    }
                    newPa.getScope().setMatch(scopeTipoMatch);
                    newPa.getScope().setStato(StatoFunzionalita.ABILITATO);
                } else {
                    newPa.setScope(null);
                }
                if (authzAbilitata.isToken().booleanValue()) {
                    if (newPa.getGestioneToken() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessun token configurato per l'erogazione");
                    }
                    newPa.getGestioneToken().setOptions(autorizzazione_tokenOptions);
                    break;
                }
                BaseHelper.runNull(() -> newPa.getGestioneToken().setOptions(null));
                break;
            }
            case XACML_POLICY: {
                if (!(authz instanceof APIImplAutorizzazioneXACML)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneXACML authzXacml = (APIImplAutorizzazioneXACML)authz;
                if (authzXacml.getPolicy() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Campo obbligatorio 'policy' non presente nell'autorizzazione indicata");
                }
                if (authzXacml.getRuoliFonte() == null) {
                    authzXacml.setRuoliFonte(FonteEnum.QUALSIASI);
                }
                org.openspcoop2.core.registry.constants.RuoloTipologia tipoRuoloFonte = Enums.ruoloTipologiaFromRest.get((Object)authzXacml.getRuoliFonte());
                String tipoAutorString = AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString((String)"xacml-Policy", (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String)"", (org.openspcoop2.core.registry.constants.RuoloTipologia)tipoRuoloFonte);
                newPa.setAutorizzazione(tipoAutorString);
                newPa.setXacmlPolicy((String)BaseHelper.evalnull(() -> new String(authzXacml.getPolicy())));
                break;
            }
            case CUSTOM: {
                if (!(authz instanceof APIImplAutorizzazioneCustom)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Configurazione dell'autorizzazione '" + authz.getClass().getName() + "' non compatibile con il tipo impostato '" + String.valueOf((Object)authz.getTipo()) + "'");
                }
                APIImplAutorizzazioneCustom authzACustom = (APIImplAutorizzazioneCustom)authz;
                if (StringUtils.isEmpty((CharSequence)authzACustom.getNome())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(APIImplAutorizzazioneCustom.class.getName() + ": Indicare il campo obbligatorio 'nome' ");
                }
                newPa.setAutorizzazione(authzACustom.getNome());
            }
        }
    }

    public static final TipoAutorizzazioneEnum getTipoAutorizzazione(String tipo_autorizzazione_pa) {
        TipoAutorizzazioneEnum tipoAuthz = null;
        if (TipoAutorizzazione.toEnumConstant((String)tipo_autorizzazione_pa) == null) {
            tipoAuthz = TipoAutorizzazioneEnum.CUSTOM;
        } else {
            String stato_auth = AutorizzazioneUtilities.convertToStato((String)tipo_autorizzazione_pa);
            if (AutorizzazioneUtilities.STATO_ABILITATO.equals(stato_auth)) {
                tipoAuthz = TipoAutorizzazioneEnum.ABILITATO;
            } else if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(stato_auth)) {
                tipoAuthz = TipoAutorizzazioneEnum.DISABILITATO;
            } else if ("xacml-Policy".equals(stato_auth)) {
                tipoAuthz = TipoAutorizzazioneEnum.XACML_POLICY;
            } else {
                throw FaultCode.ERRORE_INTERNO.toException("Stato autorizzazione " + stato_auth + " sconosciuto");
            }
        }
        return tipoAuthz;
    }

    public static final ControlloAccessiAutorizzazioneView controlloAccessiAutorizzazioneFromPA(PortaApplicativa pa) {
        ControlloAccessiAutorizzazioneView ret = new ControlloAccessiAutorizzazioneView();
        TipoAutorizzazioneEnum tipoAuthz = ErogazioniApiHelper.getTipoAutorizzazione(pa.getAutorizzazione());
        OneOfControlloAccessiAutorizzazioneViewAutorizzazione retAuthz = null;
        switch (tipoAuthz) {
            case ABILITATO: {
                String[] psplit;
                String pString;
                APIImplAutorizzazioneAbilitata authzAbilitata = new APIImplAutorizzazioneAbilitata();
                authzAbilitata.setTipo(tipoAuthz);
                retAuthz = authzAbilitata;
                authzAbilitata.setRichiedente(TipoAutorizzazione.isAuthenticationRequired((String)pa.getAutorizzazione()));
                authzAbilitata.setRuoli(TipoAutorizzazione.isRolesRequired((String)pa.getAutorizzazione()));
                if (authzAbilitata.isRuoli().booleanValue()) {
                    authzAbilitata.setRuoliRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pa.getRuoli().getMatch().toString()))));
                    authzAbilitata.setRuoliFonte((FonteEnum)((Object)BaseHelper.evalnull(() -> Enums.registroTipologiaToApiFonte(AutorizzazioneUtilities.convertToRuoloTipologia((String)pa.getAutorizzazione())))));
                }
                if (pa.getAutorizzazioneToken() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                        authzAbilitata.setTokenRichiedente(true);
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                        authzAbilitata.setTokenRuoli(true);
                        authzAbilitata.setTokenRuoliRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pa.getAutorizzazioneToken().getRuoli().getMatch().toString()))));
                        if (pa.getAutorizzazioneToken().getTipologiaRuoli() != null) {
                            switch (pa.getAutorizzazioneToken().getTipologiaRuoli()) {
                                case INTERNO: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.REGISTRO);
                                    break;
                                }
                                case ESTERNO: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.ESTERNA);
                                    break;
                                }
                                case QUALSIASI: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.QUALSIASI);
                                }
                            }
                        }
                    }
                }
                authzAbilitata.setScope(pa.getScope() != null);
                authzAbilitata.setScopeRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pa.getScope().getMatch().getValue()))));
                authzAbilitata.setToken(pa.getGestioneToken() != null && pa.getGestioneToken().getOptions() != null);
                if (pa.getGestioneToken() == null || (pString = pa.getGestioneToken().getOptions()) == null) break;
                ArrayList<String> proprieta = new ArrayList<String>();
                for (String pr : psplit = pString.split("\n")) {
                    proprieta.add(pr);
                }
                authzAbilitata.setTokenClaims(proprieta);
                break;
            }
            case XACML_POLICY: {
                APIImplAutorizzazioneXACMLView authzXacml = new APIImplAutorizzazioneXACMLView();
                authzXacml.setTipo(tipoAuthz);
                retAuthz = authzXacml;
                authzXacml.setRuoliFonte((FonteEnum)((Object)BaseHelper.evalnull(() -> Enums.registroTipologiaToApiFonte(AutorizzazioneUtilities.convertToRuoloTipologia((String)pa.getAutorizzazione())))));
                break;
            }
            case CUSTOM: {
                APIImplAutorizzazioneCustom authzCustom = new APIImplAutorizzazioneCustom();
                authzCustom.setTipo(tipoAuthz);
                retAuthz = authzCustom;
                authzCustom.setNome(pa.getAutorizzazione());
                break;
            }
            case DISABILITATO: {
                APIImplAutorizzazioneDisabilitata authzDisabilitata = new APIImplAutorizzazioneDisabilitata();
                authzDisabilitata.setTipo(tipoAuthz);
                retAuthz = authzDisabilitata;
                break;
            }
        }
        ret.setAutorizzazione(retAuthz);
        return ret;
    }

    public static final ControlloAccessiAutorizzazioneView controlloAccessiAutorizzazioneFromPD(PortaDelegata pd) {
        ControlloAccessiAutorizzazioneView ret = new ControlloAccessiAutorizzazioneView();
        TipoAutorizzazioneEnum tipoAuthz = ErogazioniApiHelper.getTipoAutorizzazione(pd.getAutorizzazione());
        OneOfControlloAccessiAutorizzazioneViewAutorizzazione retAuthz = null;
        switch (tipoAuthz) {
            case ABILITATO: {
                String[] psplit;
                String pString;
                APIImplAutorizzazioneAbilitata authzAbilitata = new APIImplAutorizzazioneAbilitata();
                authzAbilitata.setTipo(tipoAuthz);
                retAuthz = authzAbilitata;
                authzAbilitata.setRichiedente(TipoAutorizzazione.isAuthenticationRequired((String)pd.getAutorizzazione()));
                authzAbilitata.setRuoli(TipoAutorizzazione.isRolesRequired((String)pd.getAutorizzazione()));
                if (authzAbilitata.isRuoli().booleanValue()) {
                    authzAbilitata.setRuoliRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pd.getRuoli().getMatch().toString()))));
                    authzAbilitata.setRuoliFonte((FonteEnum)((Object)BaseHelper.evalnull(() -> Enums.registroTipologiaToApiFonte(AutorizzazioneUtilities.convertToRuoloTipologia((String)pd.getAutorizzazione())))));
                }
                if (pd.getAutorizzazioneToken() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                        authzAbilitata.setTokenRichiedente(true);
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                        authzAbilitata.setTokenRuoli(true);
                        authzAbilitata.setTokenRuoliRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pd.getAutorizzazioneToken().getRuoli().getMatch().toString()))));
                        if (pd.getAutorizzazioneToken().getTipologiaRuoli() != null) {
                            switch (pd.getAutorizzazioneToken().getTipologiaRuoli()) {
                                case INTERNO: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.REGISTRO);
                                    break;
                                }
                                case ESTERNO: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.ESTERNA);
                                    break;
                                }
                                case QUALSIASI: {
                                    authzAbilitata.setTokenRuoliFonte(FonteEnum.QUALSIASI);
                                }
                            }
                        }
                    }
                }
                authzAbilitata.setScope(pd.getScope() != null);
                authzAbilitata.setScopeRichiesti((AllAnyEnum)((Object)BaseHelper.evalnull(() -> AllAnyEnum.fromValue(pd.getScope().getMatch().getValue()))));
                authzAbilitata.setToken(pd.getGestioneToken() != null && pd.getGestioneToken().getOptions() != null);
                if (pd.getGestioneToken() == null || (pString = pd.getGestioneToken().getOptions()) == null) break;
                ArrayList<String> proprieta = new ArrayList<String>();
                for (String pr : psplit = pString.split("\n")) {
                    proprieta.add(pr);
                }
                authzAbilitata.setTokenClaims(proprieta);
                break;
            }
            case XACML_POLICY: {
                APIImplAutorizzazioneXACMLView authzXacml = new APIImplAutorizzazioneXACMLView();
                authzXacml.setTipo(tipoAuthz);
                retAuthz = authzXacml;
                authzXacml.setRuoliFonte((FonteEnum)((Object)BaseHelper.evalnull(() -> Enums.registroTipologiaToApiFonte(AutorizzazioneUtilities.convertToRuoloTipologia((String)pd.getAutorizzazione())))));
                break;
            }
            case CUSTOM: {
                APIImplAutorizzazioneCustom authzCustom = new APIImplAutorizzazioneCustom();
                authzCustom.setTipo(tipoAuthz);
                retAuthz = authzCustom;
                authzCustom.setNome(pd.getAutorizzazione());
                break;
            }
            case DISABILITATO: {
                APIImplAutorizzazioneDisabilitata authzDisabilitata = new APIImplAutorizzazioneDisabilitata();
                authzDisabilitata.setTipo(tipoAuthz);
                retAuthz = authzDisabilitata;
                break;
            }
        }
        ret.setAutorizzazione(retAuthz);
        return ret;
    }

    public static final void fillPortaApplicativa(ErogazioniEnv env, ControlloAccessiAutenticazione body, PortaApplicativa newPa) throws InstantiationException, IllegalAccessException {
        ControlloAccessiAutenticazioneToken gToken;
        OneOfControlloAccessiAutenticazioneAutenticazione auth = body.getAutenticazione();
        BooleanNullable autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(auth);
        newPa.setAutenticazioneOpzionale((StatoFunzionalita)BaseHelper.evalnull(() -> Helper.boolToStatoFunzionalitaConf(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null)));
        newPa.setAutenticazione((String)BaseHelper.evalnull(() -> Enums.tipoAutenticazioneFromRest.get((Object)auth.getTipo()).toString()));
        TipoAutenticazionePrincipal autenticazionePrincipal = null;
        List<String> autenticazioneParametroList = null;
        if (auth != null) {
            autenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(auth);
            autenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, auth.getTipo(), auth);
        }
        List proprietaAutenticazione = env.paCore.convertToAutenticazioneProprieta(newPa.getAutenticazione(), autenticazionePrincipal, autenticazioneParametroList);
        newPa.setProprietaAutenticazioneList(proprietaAutenticazione);
        if (BaseHelper.evalnull(() -> auth.getTipo()) == TipoAutenticazioneEnum.CUSTOM) {
            if (auth != null && auth instanceof APIImplAutenticazioneCustom) {
                APIImplAutenticazioneCustom authnCustom = (APIImplAutenticazioneCustom)auth;
                newPa.setAutenticazione(authnCustom.getNome());
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione '" + String.valueOf(auth != null ? auth.getTipo() : "null?") + "' non \u00e8 correttamente definita (trovata configurazione '" + (auth != null ? auth.getClass().getName() : "null?") + "')");
            }
        }
        if ((gToken = body.getToken()) != null) {
            boolean isGestioneToken;
            boolean bl = isGestioneToken = gToken.isClientId() != false || gToken.isEmail() != false || gToken.isIssuer() != false || gToken.isSubject() != false || gToken.isUsername() != false;
            if (isGestioneToken) {
                if (newPa.getGestioneToken() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("La gestione token non \u00e8 abilitata per il gruppo");
                }
                if (newPa.getGestioneToken().getAutenticazione() == null) {
                    newPa.getGestioneToken().setAutenticazione(new GestioneTokenAutenticazione());
                }
                newPa.getGestioneToken().getAutenticazione().setIssuer(Helper.boolToStatoFunzionalitaConf(gToken.isIssuer()));
                newPa.getGestioneToken().getAutenticazione().setClientId(Helper.boolToStatoFunzionalitaConf(gToken.isClientId()));
                newPa.getGestioneToken().getAutenticazione().setSubject(Helper.boolToStatoFunzionalitaConf(gToken.isSubject()));
                newPa.getGestioneToken().getAutenticazione().setUsername(Helper.boolToStatoFunzionalitaConf(gToken.isUsername()));
                newPa.getGestioneToken().getAutenticazione().setEmail(Helper.boolToStatoFunzionalitaConf(gToken.isEmail()));
            }
        }
    }

    public static final void fillPortaDelegata(ErogazioniEnv env, ControlloAccessiAutenticazione body, PortaDelegata newPd) {
        ControlloAccessiAutenticazioneToken gToken;
        OneOfControlloAccessiAutenticazioneAutenticazione auth = body.getAutenticazione();
        BooleanNullable autenticazioneOpzionaleNullable = ErogazioniApiHelper.getAutenticazioneOpzionale(auth);
        newPd.setAutenticazioneOpzionale((StatoFunzionalita)BaseHelper.evalnull(() -> Helper.boolToStatoFunzionalitaConf(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null)));
        newPd.setAutenticazione((String)BaseHelper.evalnull(() -> Enums.tipoAutenticazioneFromRest.get((Object)auth.getTipo()).toString()));
        TipoAutenticazionePrincipal autenticazionePrincipal = null;
        List<String> autenticazioneParametroList = null;
        if (auth != null) {
            autenticazionePrincipal = ErogazioniApiHelper.getTipoAutenticazionePrincipal(auth);
            autenticazioneParametroList = ErogazioniApiHelper.getAutenticazioneParametroList(env, auth.getTipo(), auth);
        }
        List proprietaAutenticazione = env.paCore.convertToAutenticazioneProprieta(newPd.getAutenticazione(), autenticazionePrincipal, autenticazioneParametroList);
        newPd.setProprietaAutenticazioneList(proprietaAutenticazione);
        if (BaseHelper.evalnull(() -> auth.getTipo()) == TipoAutenticazioneEnum.CUSTOM) {
            if (auth != null && auth instanceof APIImplAutenticazioneCustom) {
                APIImplAutenticazioneCustom authnCustom = (APIImplAutenticazioneCustom)auth;
                newPd.setAutenticazione(authnCustom.getNome());
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La configurazione dell'autenticazione '" + String.valueOf(auth != null ? auth.getTipo() : "null?") + "' non \u00e8 correttamente definita (trovata configurazione '" + (auth != null ? auth.getClass().getName() : "null?") + "')");
            }
        }
        if ((gToken = body.getToken()) != null) {
            boolean isGestioneToken;
            boolean bl = isGestioneToken = gToken.isClientId() != false || gToken.isEmail() != false || gToken.isIssuer() != false || gToken.isSubject() != false || gToken.isUsername() != false;
            if (isGestioneToken) {
                if (newPd.getGestioneToken() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("La gestione token non \u00e8 abilitata per il gruppo");
                }
                if (newPd.getGestioneToken().getAutenticazione() == null) {
                    newPd.getGestioneToken().setAutenticazione(new GestioneTokenAutenticazione());
                }
                newPd.getGestioneToken().getAutenticazione().setIssuer(Helper.boolToStatoFunzionalitaConf(gToken.isIssuer()));
                newPd.getGestioneToken().getAutenticazione().setClientId(Helper.boolToStatoFunzionalitaConf(gToken.isClientId()));
                newPd.getGestioneToken().getAutenticazione().setSubject(Helper.boolToStatoFunzionalitaConf(gToken.isSubject()));
                newPd.getGestioneToken().getAutenticazione().setUsername(Helper.boolToStatoFunzionalitaConf(gToken.isUsername()));
                newPd.getGestioneToken().getAutenticazione().setEmail(Helper.boolToStatoFunzionalitaConf(gToken.isEmail()));
            }
        }
    }

    public static final IDSoggetto getIdReferente(APIImpl body, ErogazioniEnv env) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        IDSoggetto idReferente = null;
        if (env.apcCore.isSupportatoSoggettoReferente(env.tipo_protocollo)) {
            if (body.getApiReferente() == null) {
                body.setApiReferente(env.idSoggetto.getNome());
            }
            idReferente = new IDSoggetto(env.tipo_soggetto, body.getApiReferente());
        } else {
            idReferente = env.soggettiCore.getSoggettoOperativoDefault(env.userLogin, env.tipo_protocollo);
        }
        return idReferente;
    }

    public static final GestioneCors convert(CorsConfigurazione paConf) {
        GestioneCors ret = new GestioneCors();
        if (paConf != null) {
            ret.setTipo(Enums.dualizeMap(Enums.tipoGestioneCorsFromRest).get(paConf.getTipo()));
            ret.setRidefinito(true);
            if (ret.getTipo() == TipoGestioneCorsEnum.GATEWAY) {
                GestioneCorsAccessControl opts = new GestioneCorsAccessControl();
                opts.setAllAllowOrigins(Helper.statoFunzionalitaConfToBool(paConf.getAccessControlAllAllowOrigins()));
                opts.setAllAllowHeaders(Helper.statoFunzionalitaConfToBool(paConf.getAccessControlAllAllowHeaders()));
                opts.setAllAllowMethods(Helper.statoFunzionalitaConfToBool(paConf.getAccessControlAllAllowMethods()));
                opts.setAllowCredentials(Helper.statoFunzionalitaConfToBool(paConf.getAccessControlAllowCredentials()));
                opts.setAllowHeaders((List)BaseHelper.evalnull(() -> paConf.getAccessControlAllowHeaders().getHeaderList()));
                opts.setAllowMethods((List)BaseHelper.evalnull(() -> paConf.getAccessControlAllowMethods().getMethodList().stream().map(HttpMethodEnum::valueOf).collect(Collectors.toList())));
                opts.setAllowOrigins((List)BaseHelper.evalnull(() -> paConf.getAccessControlAllowOrigins().getOriginList()));
                opts.setExposeHeaders((List)BaseHelper.evalnull(() -> paConf.getAccessControlExposeHeaders().getHeaderList()));
                if (paConf.getAccessControlMaxAge() != null) {
                    opts.setMaxAge(true);
                    opts.setMaxAgeSeconds(paConf.getAccessControlMaxAge());
                }
                ret.setAccessControl(opts);
            }
        } else {
            ret.setRidefinito(false);
        }
        return ret;
    }

    public static final RateLimitingPolicyGroupBy convert(AttivazionePolicyRaggruppamento src, RateLimitingPolicyGroupBy dest) {
        String[] tmp;
        dest.setAzione(src.isAzione());
        if (src.isServizioApplicativoFruitore() || src.isFruitore() || src.isIdentificativoAutenticato()) {
            dest.setRichiedente(true);
        }
        if (src.getToken() != null && (tmp = src.getToken().split(",")) != null && tmp.length > 0) {
            ArrayList<RateLimitingPolicyGroupByTokenClaimEnum> token = new ArrayList<RateLimitingPolicyGroupByTokenClaimEnum>();
            block12: for (int i = 0; i < tmp.length; ++i) {
                TipoCredenzialeMittente tipo = null;
                try {
                    tipo = TipoCredenzialeMittente.toEnumConstant((String)tmp[i], (boolean)true);
                }
                catch (Exception e) {
                    LoggerProperties.getLoggerCore().error(e.getMessage(), (Throwable)e);
                }
                if (tipo == null) continue;
                switch (tipo) {
                    case TOKEN_SUBJECT: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.SUBJECT);
                        continue block12;
                    }
                    case TOKEN_ISSUER: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.ISSUER);
                        continue block12;
                    }
                    case TOKEN_CLIENT_ID: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.CLIENT_ID);
                        continue block12;
                    }
                    case TOKEN_USERNAME: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.USERNAME);
                        continue block12;
                    }
                    case TOKEN_EMAIL: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.EMAIL);
                        continue block12;
                    }
                    case PDND_ORGANIZATION_NAME: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.PDND_ORGANIZATION_NAME);
                        continue block12;
                    }
                    case PDND_ORGANIZATION_EXTERNAL_ID: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.PDND_EXTERNAL_ID);
                        continue block12;
                    }
                    case PDND_ORGANIZATION_CONSUMER_ID: {
                        token.add(RateLimitingPolicyGroupByTokenClaimEnum.PDND_CONSUMER_ID);
                        continue block12;
                    }
                }
            }
            dest.setToken(token);
        }
        dest.setChiaveNome(src.getInformazioneApplicativaNome());
        dest.setChiaveTipo(Enums.rateLimitingChiaveEnum.get(TipoFiltroApplicativo.toEnumConstant((String)src.getInformazioneApplicativaTipo())));
        return dest;
    }

    public static final RateLimitingPolicyFiltro convert(AttivazionePolicyFiltro src, RateLimitingPolicyFiltro dest) {
        String[] tmp;
        dest.setApplicativoFruitore(src.getServizioApplicativoFruitore());
        if (src.getAzione() != null && !"".equals(src.getAzione()) && (tmp = src.getAzione().split(",")) != null && tmp.length > 0) {
            ArrayList<String> azione = new ArrayList<String>();
            for (int i = 0; i < tmp.length; ++i) {
                azione.add(tmp[i]);
            }
            dest.setAzione(azione);
        }
        dest.setRuoloRichiedente(src.getRuoloFruitore());
        if (src.getTokenClaims() != null && !"".equals(src.getTokenClaims())) {
            String[] psplit;
            ArrayList<String> proprieta = new ArrayList<String>();
            for (String pr : psplit = src.getTokenClaims().split("\n")) {
                proprieta.add(pr);
            }
            dest.setTokenClaims(proprieta);
        }
        dest.setChiaveNome(src.getInformazioneApplicativaNome());
        dest.setChiaveTipo(Enums.rateLimitingChiaveEnum.get(TipoFiltroApplicativo.toEnumConstant((String)src.getInformazioneApplicativaTipo())));
        dest.setFiltroChiaveValore(src.getInformazioneApplicativaValore());
        return dest;
    }

    public static final RateLimitingPolicyFiltroErogazione convert(AttivazionePolicyFiltro src, RateLimitingPolicyFiltroErogazione dest) {
        ErogazioniApiHelper.convert(src, (RateLimitingPolicyFiltro)dest);
        dest.setSoggettoFruitore(src.getNomeFruitore());
        return dest;
    }

    public static final RateLimitingPolicyFiltroFruizione convert(AttivazionePolicyFiltro src, RateLimitingPolicyFiltroFruizione dest) {
        ErogazioniApiHelper.convert(src, (RateLimitingPolicyFiltro)dest);
        return dest;
    }

    public static final RateLimitingPolicyFruizioneView convert(AttivazionePolicy src, InfoPolicy infoPolicy, RateLimitingPolicyFruizioneView dest) {
        ErogazioniApiHelper.convert(src, infoPolicy, (RateLimitingPolicyBase)dest);
        dest.setDescrizione(infoPolicy.getDescrizione());
        dest.setNome(PolicyUtilities.getNomeActivePolicy((String)src.getAlias(), (String)src.getIdActivePolicy()));
        dest.setRaggruppamento(ErogazioniApiHelper.convert(src.getGroupBy(), new RateLimitingPolicyGroupBy()));
        dest.setFiltro(ErogazioniApiHelper.convert(src.getFiltro(), new RateLimitingPolicyFiltroFruizione()));
        return dest;
    }

    public static final RateLimitingPolicyErogazioneView convert(AttivazionePolicy src, InfoPolicy infoPolicy, RateLimitingPolicyErogazioneView dest) {
        ErogazioniApiHelper.convert(src, infoPolicy, (RateLimitingPolicyBase)dest);
        dest.setDescrizione(infoPolicy.getDescrizione());
        dest.setNome(PolicyUtilities.getNomeActivePolicy((String)src.getAlias(), (String)src.getIdActivePolicy()));
        dest.setRaggruppamento(ErogazioniApiHelper.convert(src.getGroupBy(), new RateLimitingPolicyGroupBy()));
        dest.setFiltro(ErogazioniApiHelper.convert(src.getFiltro(), new RateLimitingPolicyFiltroErogazione()));
        return dest;
    }

    public static final RateLimitingPolicyBase convert(AttivazionePolicy src, InfoPolicy infoPolicy, RateLimitingPolicyBase dest) {
        dest.setNome(src.getAlias());
        if (src.isWarningOnly()) {
            dest.setStato(StatoFunzionalitaConWarningEnum.WARNINGONLY);
        }
        if (src.isEnabled()) {
            dest.setStato(StatoFunzionalitaConWarningEnum.ABILITATO);
        } else {
            dest.setStato(StatoFunzionalitaConWarningEnum.DISABILITATO);
        }
        boolean dimensioneMessaggio = false;
        if (dest instanceof RateLimitingPolicyBaseConIdentificazione) {
            RateLimitingPolicyBaseConIdentificazione destIdentificazione = (RateLimitingPolicyBaseConIdentificazione)dest;
            if (infoPolicy.isBuiltIn()) {
                RateLimitingPolicyCriteri criteri = new RateLimitingPolicyCriteri();
                criteri.setIdentificazione(RateLimitingIdentificazionePolicyEnum.CRITERI);
                boolean intervallo = true;
                switch (infoPolicy.getTipoRisorsa()) {
                    case NUMERO_RICHIESTE: {
                        if (infoPolicy.isCheckRichiesteSimultanee()) {
                            criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE_SIMULTANEE);
                            intervallo = false;
                            break;
                        }
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE);
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE_OK);
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE_FALLITE);
                        break;
                    }
                    case NUMERO_FAULT_APPLICATIVI: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_FAULT_APPLICATIVI);
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE_FALLITE_O_FAULT_APPLICATIVI);
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.NUMERO_RICHIESTE_OK_O_FAULT_APPLICATIVI);
                        break;
                    }
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.DIMENSIONE_MASSIMA);
                        dimensioneMessaggio = true;
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.OCCUPAZIONE_BANDA);
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.TEMPO_MEDIO_RISPOSTA);
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        criteri.setMetrica(RateLimitingCriteriMetricaEnum.TEMPO_COMPLESSIVO_RISPOSTA);
                    }
                }
                if (intervallo) {
                    switch (infoPolicy.getIntervalloUtilizzaRisorseRealtimeTipoPeriodo()) {
                        case MINUTI: {
                            criteri.setIntervallo(RateLimitingCriteriIntervalloEnum.MINUTI);
                            break;
                        }
                        case ORARIO: {
                            criteri.setIntervallo(RateLimitingCriteriIntervalloEnum.ORARIO);
                            break;
                        }
                        case GIORNALIERO: {
                            criteri.setIntervallo(RateLimitingCriteriIntervalloEnum.GIORNALIERO);
                            break;
                        }
                    }
                }
                criteri.setCongestione(infoPolicy.isControlloCongestione());
                criteri.setDegrado(infoPolicy.isDegradoPrestazione());
                destIdentificazione.setConfigurazione(criteri);
            } else {
                RateLimitingPolicyIdentificativo id = new RateLimitingPolicyIdentificativo();
                id.setIdentificazione(RateLimitingIdentificazionePolicyEnum.POLICY);
                id.setPolicy(infoPolicy.getIdPolicy());
                if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                    dimensioneMessaggio = true;
                }
                destIdentificazione.setConfigurazione(id);
            }
        }
        dest.setSogliaRidefinita(src.isRidefinisci());
        if (src.isRidefinisci()) {
            if (dimensioneMessaggio) {
                dest.setSogliaDimensioneRichiesta(src.getValore2().intValue());
                dest.setSogliaDimensioneRisposta(src.getValore().intValue());
            } else {
                dest.setSogliaValore(src.getValore().intValue());
            }
        } else if (dimensioneMessaggio) {
            dest.setSogliaDimensioneRichiesta(infoPolicy.getValore2().intValue());
            dest.setSogliaDimensioneRisposta(infoPolicy.getValore().intValue());
        } else {
            dest.setSogliaValore(infoPolicy.getValore().intValue());
        }
        return dest;
    }

    public static final void checkAzioniAdd(List<String> toAdd, List<String> occupate, List<String> presenti) {
        for (String azione : toAdd) {
            if (occupate.contains(azione)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)"L'azione scelta &egrave; gi&agrave; presente"));
            }
            if (presenti.contains(azione)) continue;
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Azione " + azione + " non presente fra le azioni dell'accordo");
        }
    }

    public static final String getDataElementModalita(RateLimitingIdentificazionePolicyEnum identificazione) {
        switch (identificazione) {
            case POLICY: {
                return "Selezione dal registro";
            }
            case CRITERI: {
                return "Scegli criteri";
            }
        }
        return null;
    }

    public static final String getDataElementModalita(boolean builtIt) {
        return builtIt ? ErogazioniApiHelper.getDataElementModalita(RateLimitingIdentificazionePolicyEnum.CRITERI) : ErogazioniApiHelper.getDataElementModalita(RateLimitingIdentificazionePolicyEnum.POLICY);
    }

    public static final String getIdPolicy(RateLimitingPolicyBaseConIdentificazione body, ConfigurazioneCore confCore, ConfigurazioneHelper confHelper) throws Exception {
        String idPolicy = null;
        switch (body.getConfigurazione().getIdentificazione()) {
            case POLICY: {
                RateLimitingPolicyIdentificativo identificativo = new RateLimitingPolicyIdentificativo();
                identificativo = (RateLimitingPolicyIdentificativo)BaseHelper.deserialize((Object)body.getConfigurazione(), RateLimitingPolicyIdentificativo.class);
                idPolicy = identificativo.getPolicy();
                break;
            }
            case CRITERI: {
                RateLimitingPolicyCriteri criteri = new RateLimitingPolicyCriteri();
                criteri = (RateLimitingPolicyCriteri)BaseHelper.deserialize((Object)body.getConfigurazione(), RateLimitingPolicyCriteri.class);
                String modalitaRisorsa = ErogazioniApiHelper.getDataElementModalitaRisorsa(criteri.getMetrica());
                boolean modalitaSimultaneeEnabled = confHelper.isTipoRisorsaNumeroRichiesteSimultanee(modalitaRisorsa);
                String modalitaEsiti = null;
                String modalitaIntervallo = null;
                if (criteri.getIntervallo() != null) {
                    modalitaIntervallo = ErogazioniApiHelper.getDataElementModalitaIntervallo(criteri.getIntervallo());
                }
                boolean modalitaCongestioneEnabled = criteri.isCongestione() != null ? criteri.isCongestione() : false;
                boolean modalitaDegradoEnabled = criteri.isDegrado() != null ? criteri.isDegrado() : false;
                boolean modalitaErrorRateEnabled = false;
                List infoPolicies = confCore.infoPolicyList(Boolean.valueOf(true));
                ArrayList idPoliciesSoddisfanoCriteri = new ArrayList();
                confHelper.findPolicyBuiltIn(infoPolicies, idPoliciesSoddisfanoCriteri, modalitaRisorsa, modalitaEsiti, modalitaSimultaneeEnabled, modalitaIntervallo, modalitaCongestioneEnabled, modalitaDegradoEnabled, modalitaErrorRateEnabled);
                if (idPoliciesSoddisfanoCriteri.size() <= 0) break;
                idPolicy = ((InfoPolicy)idPoliciesSoddisfanoCriteri.get(0)).getIdPolicy();
            }
        }
        return idPolicy;
    }

    public static String getDataElementModalitaRisorsa(RateLimitingCriteriMetricaEnum risorsa) {
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = null;
        switch (risorsa) {
            case NUMERO_RICHIESTE: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE;
                break;
            }
            case NUMERO_RICHIESTE_SIMULTANEE: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE;
                break;
            }
            case NUMERO_RICHIESTE_OK: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO;
                break;
            }
            case NUMERO_RICHIESTE_FALLITE: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_FALLITE;
                break;
            }
            case NUMERO_FAULT_APPLICATIVI: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_FAULT_APPLICATIVI;
                break;
            }
            case NUMERO_RICHIESTE_FALLITE_O_FAULT_APPLICATIVI: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI;
                break;
            }
            case NUMERO_RICHIESTE_OK_O_FAULT_APPLICATIVI: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI;
                break;
            }
            case DIMENSIONE_MASSIMA: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO;
                break;
            }
            case OCCUPAZIONE_BANDA: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.OCCUPAZIONE_BANDA;
                break;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.TEMPO_MEDIO_RISPOSTA;
                break;
            }
            case TEMPO_COMPLESSIVO_RISPOSTA: {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.TEMPO_COMPLESSIVO_RISPOSTA;
            }
        }
        return tipoRisorsaPolicyAttiva != null ? tipoRisorsaPolicyAttiva.getValue() : null;
    }

    private static String getDataElementModalitaIntervallo(RateLimitingCriteriIntervalloEnum intervallo) {
        String modalitaRisorsaEsiti = null;
        switch (intervallo) {
            case MINUTI: {
                modalitaRisorsaEsiti = TipoPeriodoRealtime.MINUTI.getValue();
                break;
            }
            case ORARIO: {
                modalitaRisorsaEsiti = TipoPeriodoRealtime.ORARIO.getValue();
                break;
            }
            case GIORNALIERO: {
                modalitaRisorsaEsiti = TipoPeriodoRealtime.GIORNALIERO.getValue();
            }
        }
        return modalitaRisorsaEsiti;
    }

    public static final void override(TipoRisorsa tipoRisorsa, String idPolicy, RateLimitingPolicyErogazione body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, body, protocollo, idPropietarioSa, wrap);
        wrap.overrideParameter("CTPolicyActiveId", idPolicy);
    }

    public static final void override(TipoRisorsa tipoRisorsa, String idPolicy, RateLimitingPolicyFruizione body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, body, protocollo, idPropietarioSa, wrap);
        wrap.overrideParameter("CTPolicyActiveId", idPolicy);
    }

    public static final void override(RateLimitingPolicyFiltro body, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        if (body.getAzione() != null && !body.getAzione().isEmpty()) {
            wrap.overrideParameterValues("CTPolicyActiveFiltroAzione", body.getAzione().toArray(new String[1]));
        }
        wrap.overrideParameter("CTPolicyActiveFiltroSAFruitore", body.getApplicativoFruitore());
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloFruitore", BaseHelper.evalnull(() -> body.getRuoloRichiedente()));
        String tokenClaims = null;
        if (body.getTokenClaims() != null && !body.getTokenClaims().isEmpty()) {
            tokenClaims = String.join((CharSequence)"\n", body.getTokenClaims());
        }
        if (tokenClaims != null) {
            wrap.overrideParameter("CTPolicyActiveFiltroTokenClaims", tokenClaims);
        }
        wrap.overrideParameter("CTPolicyActiveFiltroPerChiaveEnabled", BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)(body.getChiaveTipo() != null ? 1 : 0))));
        wrap.overrideParameter("CTPolicyActiveFiltroPerChiaveTipo", BaseHelper.evalnull(() -> Enums.tipoFiltroApplicativo.get((Object)body.getChiaveTipo()).toString()));
        wrap.overrideParameter("CTPolicyActiveFiltroPerChiaveNome", BaseHelper.evalnull(() -> body.getChiaveNome()));
        wrap.overrideParameter("CTPolicyActiveFiltroPerChiaveValore", BaseHelper.evalnull(() -> body.getFiltroChiaveValore()));
    }

    private static final void override(RateLimitingPolicyGroupBy body, HttpRequestWrapper wrap, String protocollo, boolean applicativa) {
        if (body == null) {
            return;
        }
        wrap.overrideParameter("CTPolicyActiveGroupByEnabled", body != null ? "Raggruppamento Per" : "Nessuno Raggruppamento");
        wrap.overrideParameter("CTPolicyActiveGroupByAzione", BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)body.isAzione())));
        wrap.overrideParameter("CTPolicyActiveGroupByRichiedente", BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)body.isRichiedente())));
        if (body.getToken() != null && !body.getToken().isEmpty()) {
            wrap.overrideParameter("CTPolicyActiveGroupByToken", BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)true)));
            boolean modiPdnd = applicativa && "modipa".equals(protocollo);
            ArrayList<String> values = new ArrayList<String>();
            for (RateLimitingPolicyGroupByTokenClaimEnum tokenClaim : body.getToken()) {
                switch (tokenClaim) {
                    case SUBJECT: {
                        values.add(TipoCredenzialeMittente.TOKEN_SUBJECT.getRawValue());
                        break;
                    }
                    case ISSUER: {
                        values.add(TipoCredenzialeMittente.TOKEN_ISSUER.getRawValue());
                        break;
                    }
                    case CLIENT_ID: {
                        values.add(TipoCredenzialeMittente.TOKEN_CLIENT_ID.getRawValue());
                        break;
                    }
                    case USERNAME: {
                        values.add(TipoCredenzialeMittente.TOKEN_USERNAME.getRawValue());
                        break;
                    }
                    case EMAIL: {
                        values.add(TipoCredenzialeMittente.TOKEN_EMAIL.getRawValue());
                        break;
                    }
                    case PDND_ORGANIZATION_NAME: {
                        if (!modiPdnd) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il criterio di raggruppamento per nome organizzazione PDND \u00e8 utilizzabile solamente per erogazioni con profilo di interoperabilit\u00e0 ModI");
                        }
                        values.add(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.getRawValue());
                        break;
                    }
                    case PDND_EXTERNAL_ID: {
                        if (!modiPdnd) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il criterio di raggruppamento per identificativo esterno dell'organizzazione \u00e8 utilizzabile solamente per erogazioni con profilo di interoperabilit\u00e0 ModI");
                        }
                        values.add(TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.getRawValue());
                        break;
                    }
                    case PDND_CONSUMER_ID: {
                        if (!modiPdnd) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il criterio di raggruppamento per consumerId dell'organizzazione PDND \u00e8 utilizzabile solamente per erogazioni con profilo di interoperabilit\u00e0 ModI");
                        }
                        values.add(TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.getRawValue());
                        break;
                    }
                }
            }
            if (!values.isEmpty()) {
                wrap.overrideParameterValues("CTPolicyActiveGroupByTokenClaims", values.toArray(new String[1]));
            }
        }
        wrap.overrideParameter("CTPolicyActiveGroupByPerChiaveEnabled", BaseHelper.evalnull(() -> ServletUtils.boolToCheckBoxStatus((Boolean)(body.getChiaveTipo() != null ? 1 : 0))));
        wrap.overrideParameter("CTPolicyActiveGroupByPerChiaveTipo", BaseHelper.evalnull(() -> Enums.tipoFiltroApplicativo.get((Object)body.getChiaveTipo()).toString()));
        wrap.overrideParameter("CTPolicyActiveGroupByPerChiaveNome", BaseHelper.evalnull(() -> body.getChiaveNome()));
    }

    public static final void override(TipoRisorsa tipoRisorsa, RateLimitingPolicyErogazioneUpdate body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, (RateLimitingPolicyBase)body, protocollo, idPropietarioSa, wrap);
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloPdd", RuoloPolicy.APPLICATIVA.toString());
        RateLimitingPolicyFiltroErogazione filtro = body.getFiltro();
        ErogazioniApiHelper.override(filtro, idPropietarioSa, wrap);
        if (filtro != null) {
            String filtroFruitore = BaseHelper.evalnull(() -> filtro.getSoggettoFruitore()) != null ? new IDSoggetto(idPropietarioSa.getTipo(), filtro.getSoggettoFruitore()).toString() : null;
            wrap.overrideParameter("CTPolicyActiveFiltroFruitore", filtroFruitore);
        }
        RateLimitingPolicyGroupBy groupCriteria = body.getRaggruppamento();
        ErogazioniApiHelper.override(groupCriteria, wrap, protocollo, true);
    }

    public static final void override(TipoRisorsa tipoRisorsa, RateLimitingPolicyErogazione body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, (RateLimitingPolicyBase)body, protocollo, idPropietarioSa, wrap);
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloPdd", RuoloPolicy.APPLICATIVA.toString());
        RateLimitingPolicyFiltroErogazione filtro = body.getFiltro();
        ErogazioniApiHelper.override(filtro, idPropietarioSa, wrap);
        if (filtro != null) {
            String filtroFruitore = BaseHelper.evalnull(() -> filtro.getSoggettoFruitore()) != null ? new IDSoggetto(idPropietarioSa.getTipo(), filtro.getSoggettoFruitore()).toString() : null;
            wrap.overrideParameter("CTPolicyActiveFiltroFruitore", filtroFruitore);
        }
        RateLimitingPolicyGroupBy groupCriteria = body.getRaggruppamento();
        ErogazioniApiHelper.override(groupCriteria, wrap, protocollo, true);
    }

    public static final void override(TipoRisorsa tipoRisorsa, RateLimitingPolicyFruizioneUpdate body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, (RateLimitingPolicyBase)body, protocollo, idPropietarioSa, wrap);
        ErogazioniApiHelper.override(body.getFiltro(), idPropietarioSa, wrap);
        ErogazioniApiHelper.override(body.getRaggruppamento(), wrap, protocollo, false);
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloPdd", RuoloPolicy.DELEGATA.toString());
    }

    public static final void override(TipoRisorsa tipoRisorsa, RateLimitingPolicyFruizione body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        ErogazioniApiHelper.override(tipoRisorsa, (RateLimitingPolicyBase)body, protocollo, idPropietarioSa, wrap);
        ErogazioniApiHelper.override(body.getFiltro(), idPropietarioSa, wrap);
        ErogazioniApiHelper.override(body.getRaggruppamento(), wrap, protocollo, false);
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloPdd", RuoloPolicy.DELEGATA.toString());
    }

    public static final void override(TipoRisorsa tipoRisorsa, RateLimitingPolicyBase body, String protocollo, IDSoggetto idPropietarioSa, HttpRequestWrapper wrap) {
        if (body == null) {
            return;
        }
        wrap.overrideParameter("CTPolicyActiveAlias", body.getNome());
        wrap.overrideParameter("CTPolicyActiveEnabled", body.getStato().toString());
        wrap.overrideParameter("CTPolicyActiveRidefinisci", ServletUtils.boolToCheckBoxStatus((Boolean)body.isSogliaRidefinita()));
        if (body.isSogliaRidefinita().booleanValue()) {
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                if (body.getSogliaDimensioneRichiesta() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Soglia relativa alla dimensione della richiesta non fornita");
                }
                if (body.getSogliaDimensioneRisposta() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Soglia relativa alla dimensione della risposta non fornita");
                }
                if (body.getSogliaValore() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Valore di Soglia non utilizzabile con una policy di tipo '" + RateLimitingCriteriMetricaEnum.DIMENSIONE_MASSIMA.toString() + "'");
                }
                wrap.overrideParameter("CTPolicyActiveValore2", BaseHelper.evalnull(() -> body.getSogliaDimensioneRichiesta().toString()));
                wrap.overrideParameter("CTPolicyActiveValore", BaseHelper.evalnull(() -> body.getSogliaDimensioneRisposta().toString()));
            } else {
                if (body.getSogliaDimensioneRichiesta() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Soglia relativa alla dimensione della richiesta non utilizzabile con una policy di tipo diverso da '" + RateLimitingCriteriMetricaEnum.DIMENSIONE_MASSIMA.toString() + "'");
                }
                if (body.getSogliaDimensioneRisposta() != null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Soglia relativa alla dimensione della risposta non utilizzabile con una policy di tipo diverso da '" + RateLimitingCriteriMetricaEnum.DIMENSIONE_MASSIMA.toString() + "'");
                }
                if (body.getSogliaValore() == null) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Valore di Soglia non fornito");
                }
                wrap.overrideParameter("CTPolicyActiveValore", BaseHelper.evalnull(() -> body.getSogliaValore().toString()));
            }
        }
        wrap.overrideParameter("CTPolicyActiveFiltroEnabled", StatoFunzionalita.ABILITATO.toString());
        wrap.overrideParameter("CTPolicyActiveFiltroRuoloProtocollo", protocollo);
    }

    public static final boolean correlazioneApplicativaRichiestaCheckData(TipoOperazione tipoOp, HttpRequestWrapper wrap, ConsoleHelper paHelper, boolean isDelegata, CorrelazioneApplicativaRichiesta body, Long idPorta, Long idCorrelazione, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws Exception {
        wrap.overrideParameter("id", idPorta.toString());
        wrap.overrideParameter("elemxml", body.getElemento());
        wrap.overrideParameter("mode", CorrelazioneApplicativaRichiestaIdentificazione.valueOf((String)body.getIdentificazioneTipo().name()).toString());
        wrap.overrideParameter("pattern", body.getIdentificazione());
        wrap.overrideParameter("idcorr", BaseHelper.evalnull(() -> idCorrelazione.toString()));
        return paHelper.correlazioneApplicativaRichiestaCheckData(tipoOp, isDelegata, serviceBinding);
    }

    public static final CorrelazioneApplicativaElemento convert(CorrelazioneApplicativaRichiesta body) {
        CorrelazioneApplicativaElemento cae = new CorrelazioneApplicativaElemento();
        cae.setNome(body.getElemento());
        cae.setIdentificazione(CorrelazioneApplicativaRichiestaIdentificazione.valueOf((String)body.getIdentificazioneTipo().name()));
        if (body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.URL_BASED || body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.HEADER_BASED || body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.CONTENT_BASED || body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.TEMPLATE || body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.FREEMARKER_TEMPLATE || body.getIdentificazioneTipo() == CorrelazioneApplicativaRichiestaEnum.VELOCITY_TEMPLATE) {
            cae.setPattern(body.getIdentificazione());
        }
        if (body.getIdentificazioneTipo() != CorrelazioneApplicativaRichiestaEnum.DISABILITATO) {
            cae.setIdentificazioneFallita(body.isGenerazioneErroreIdentificazioneFallita() != false ? CorrelazioneApplicativaGestioneIdentificazioneFallita.BLOCCA : CorrelazioneApplicativaGestioneIdentificazioneFallita.ACCETTA);
        }
        return cae;
    }

    public static final CorrelazioneApplicativaRispostaElemento convert(CorrelazioneApplicativaRisposta body) {
        CorrelazioneApplicativaRispostaElemento cae = new CorrelazioneApplicativaRispostaElemento();
        cae.setNome(body.getElemento());
        cae.setIdentificazione(CorrelazioneApplicativaRispostaIdentificazione.valueOf((String)body.getIdentificazioneTipo().name()));
        if (body.getIdentificazioneTipo() == CorrelazioneApplicativaRispostaEnum.HEADER_BASED || body.getIdentificazioneTipo() == CorrelazioneApplicativaRispostaEnum.CONTENT_BASED || body.getIdentificazioneTipo() == CorrelazioneApplicativaRispostaEnum.TEMPLATE || body.getIdentificazioneTipo() == CorrelazioneApplicativaRispostaEnum.FREEMARKER_TEMPLATE || body.getIdentificazioneTipo() == CorrelazioneApplicativaRispostaEnum.VELOCITY_TEMPLATE) {
            cae.setPattern(body.getIdentificazione());
        }
        if (body.getIdentificazioneTipo() != CorrelazioneApplicativaRispostaEnum.DISABILITATO) {
            cae.setIdentificazioneFallita(body.isGenerazioneErroreIdentificazioneFallita() != false ? CorrelazioneApplicativaGestioneIdentificazioneFallita.BLOCCA : CorrelazioneApplicativaGestioneIdentificazioneFallita.ACCETTA);
        }
        return cae;
    }

    public static final boolean correlazioneApplicativaRispostaCheckData(TipoOperazione tipoOp, HttpRequestWrapper wrap, ConsoleHelper paHelper, boolean isDelegata, CorrelazioneApplicativaRisposta body, Long idPorta, Long idCorrelazione, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws Exception {
        wrap.overrideParameter("id", idPorta.toString());
        wrap.overrideParameter("elemxml", body.getElemento());
        wrap.overrideParameter("mode", CorrelazioneApplicativaRichiestaIdentificazione.valueOf((String)body.getIdentificazioneTipo().name()).toString());
        wrap.overrideParameter("pattern", body.getIdentificazione());
        wrap.overrideParameter("idcorr", BaseHelper.evalnull(() -> idCorrelazione.toString()));
        return paHelper.correlazioneApplicativaRichiestaCheckData(TipoOperazione.ADD, isDelegata, serviceBinding);
    }

    public static final CorrelazioneApplicativaRichiesta convert(CorrelazioneApplicativaElemento src) {
        CorrelazioneApplicativaRichiesta ret = new CorrelazioneApplicativaRichiesta();
        ret.setElemento(StringUtils.isEmpty((CharSequence)src.getNome()) ? "*" : src.getNome());
        ret.setGenerazioneErroreIdentificazioneFallita(src.getIdentificazioneFallita() != CorrelazioneApplicativaGestioneIdentificazioneFallita.ACCETTA);
        ret.setIdentificazione(src.getPattern());
        ret.setIdentificazioneTipo(CorrelazioneApplicativaRichiestaEnum.valueOf(src.getIdentificazione().name()));
        return ret;
    }

    public static final CorrelazioneApplicativaRisposta convert(CorrelazioneApplicativaRispostaElemento src) {
        CorrelazioneApplicativaRisposta ret = new CorrelazioneApplicativaRisposta();
        ret.setElemento(StringUtils.isEmpty((CharSequence)src.getNome()) ? "*" : src.getNome());
        ret.setGenerazioneErroreIdentificazioneFallita(src.getIdentificazioneFallita() != CorrelazioneApplicativaGestioneIdentificazioneFallita.ACCETTA);
        ret.setIdentificazione(src.getPattern());
        ret.setIdentificazioneTipo(CorrelazioneApplicativaRispostaEnum.valueOf(src.getIdentificazione().name()));
        return ret;
    }

    public static final boolean isDumpConfigurazioneAbilitato(DumpConfigurazione configurazione, boolean isRisposta) {
        boolean abilitato = false;
        if (configurazione == null) {
            return false;
        }
        if (isRisposta) {
            DumpConfigurazioneRegola rispostaUscita;
            DumpConfigurazioneRegola rispostaIngresso = configurazione.getRispostaIngresso();
            if (rispostaIngresso != null) {
                if (rispostaIngresso.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (rispostaIngresso.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (rispostaIngresso.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
            }
            if ((rispostaUscita = configurazione.getRispostaUscita()) != null) {
                if (rispostaUscita.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (rispostaUscita.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (rispostaUscita.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
            }
        } else {
            DumpConfigurazioneRegola richiestaUscita;
            DumpConfigurazioneRegola richiestaIngresso = configurazione.getRichiestaIngresso();
            if (richiestaIngresso != null) {
                if (richiestaIngresso.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (richiestaIngresso.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (richiestaIngresso.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
            }
            if ((richiestaUscita = configurazione.getRichiestaUscita()) != null) {
                if (richiestaUscita.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (richiestaUscita.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (richiestaUscita.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
            }
        }
        return abilitato;
    }

    public static final void attivazionePolicyCheckData(TipoOperazione tipoOperazione, PortaApplicativa pa, AttivazionePolicy policy, InfoPolicy infoPolicy, ErogazioniConfEnv env, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String modalita) throws Exception {
        String[] tmp;
        List azioniSupportate;
        RuoloPolicy ruoloPorta = RuoloPolicy.APPLICATIVA;
        String nomePorta = pa.getNome();
        boolean hasAzioni = pa.getAzione() != null && pa.getAzione().getAzioneDelegataList().size() > 0;
        List list = azioniSupportate = hasAzioni ? pa.getAzione().getAzioneDelegataList() : env.confCore.getAzioni(env.asps, env.apcCore.getAccordoServizioSintetico(env.asps.getIdAccordo().longValue()), false, true, ErogazioniApiHelper.getAzioniOccupateErogazione(env.idAsps, env.apsCore, env.paCore));
        if (policy.getFiltro().getAzione() != null && !policy.getFiltro().getAzione().isEmpty() && (tmp = policy.getFiltro().getAzione().split(",")) != null && tmp.length > 0) {
            for (String azCheck : tmp) {
                if (azioniSupportate.contains(azCheck)) continue;
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'azione " + azCheck + " non \u00e8 assegnabile a una policy di rate limiting per il gruppo scelto. le azioni supportare sono: " + azioniSupportate.toString());
            }
        }
        if (policy.getFiltro().getRuoloFruitore() != null) {
            FiltroRicercaRuoli filtroRicercaRuoli = new FiltroRicercaRuoli();
            filtroRicercaRuoli.setTipologia(org.openspcoop2.core.registry.constants.RuoloTipologia.INTERNO);
            List listIdRuoli = env.ruoliCore.getAllIdRuoli(filtroRicercaRuoli);
            ArrayList<String> ruoli = new ArrayList<String>();
            if (listIdRuoli != null && !listIdRuoli.isEmpty()) {
                for (IDRuolo idRuolo : listIdRuoli) {
                    ruoli.add(idRuolo.getNome());
                }
            }
            if (!ruoli.contains(policy.getFiltro().getRuoloFruitore())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il ruolo " + policy.getFiltro().getRuoloFruitore() + " non esiste.");
            }
        }
        if (policy.getFiltro().getServizioApplicativoFruitore() != null && !env.confCore.getServiziApplicativiFruitore(env.tipo_protocollo, null, env.idSoggetto.getTipo(), env.idSoggetto.getNome()).stream().filter(id -> id.getNome().equals(policy.getFiltro().getServizioApplicativoFruitore())).findAny().isPresent()) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il servizio applicativo fruitore " + policy.getFiltro().getServizioApplicativoFruitore() + " scelto non \u00e8 assegnabile alla policy di rate limiting");
        }
        ConfigurazioneGenerale configurazioneControlloTraffico = env.confCore.getConfigurazioneControlloTraffico();
        if (!env.confHelper.attivazionePolicyCheckData(new StringBuilder(), tipoOperazione, configurazioneControlloTraffico, policy, infoPolicy, ruoloPorta, nomePorta, serviceBinding, modalita)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
        }
        if (policy.getFiltro().getTipoFruitore() != null && policy.getFiltro().getNomeFruitore() != null) {
            ArrayList<IDSoggetto> soggettiSupportati = new ArrayList<IDSoggetto>();
            boolean multitenant = env.confCore.getConfigurazioneGenerale().getMultitenant().getStato() == StatoFunzionalita.ABILITATO;
            PddCore pddCore = new PddCore(env.stationCore);
            List listSoggetti = env.confCore.getSoggetti(env.tipo_protocollo, null);
            for (IDSoggetto idSoggetto : listSoggetti) {
                if (!multitenant && policy.getFiltro().getRuoloPorta() != null && (policy.getFiltro().getRuoloPorta().equals((Object)RuoloPolicy.APPLICATIVA) || policy.getFiltro().getRuoloPorta().equals((Object)RuoloPolicy.DELEGATA))) {
                    Soggetto s = env.soggettiCore.getSoggettoRegistro(idSoggetto);
                    boolean isPddEsterna = pddCore.isPddEsterna(s.getPortaDominio());
                    if (policy.getFiltro().getRuoloPorta().equals((Object)RuoloPolicy.APPLICATIVA)) {
                        if (!isPddEsterna) continue;
                        soggettiSupportati.add(idSoggetto);
                        continue;
                    }
                    if (isPddEsterna) continue;
                    soggettiSupportati.add(idSoggetto);
                    continue;
                }
                soggettiSupportati.add(idSoggetto);
            }
            IDSoggetto idSoggettoScelto = new IDSoggetto(policy.getFiltro().getTipoFruitore(), policy.getFiltro().getNomeFruitore());
            if (!soggettiSupportati.contains(idSoggettoScelto)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il soggetto fruitore " + idSoggettoScelto.toString() + " scelto non \u00e8 assegnabile alla policy di rate limiting.\n I soggetti supportati sono: " + ((Object)soggettiSupportati).toString());
            }
        }
    }

    public static ApiCanale toApiCanale(ErogazioniEnv env, PortaApplicativa pa, AccordoServizioParteComuneSintetico apc, boolean throwException) throws Exception {
        return ErogazioniApiHelper._toApiCanale(env, pa.getCanale(), apc, throwException);
    }

    public static ApiCanale toApiCanale(ErogazioniEnv env, PortaDelegata pd, AccordoServizioParteComuneSintetico apc, boolean throwException) throws Exception {
        return ErogazioniApiHelper._toApiCanale(env, pd.getCanale(), apc, throwException);
    }

    private static ApiCanale _toApiCanale(ErogazioniEnv env, String canalePorta, AccordoServizioParteComuneSintetico apc, boolean throwException) throws Exception {
        ApiCanale canale = null;
        if (env.gestioneCanali) {
            canale = new ApiCanale();
            if (canalePorta != null && !"".equals(canalePorta)) {
                canale.setNome(canalePorta);
                canale.setConfigurazione(CanaleEnum.IMPLEMENTAZIONE_API);
            } else if (apc.getCanale() != null && !"".equals(apc.getCanale())) {
                canale.setNome(apc.getCanale());
                canale.setConfigurazione(CanaleEnum.API);
            } else {
                canale.setNome(env.canaleDefault);
                canale.setConfigurazione(CanaleEnum.DEFAULT);
            }
        } else if (throwException) {
            throw new Exception("Gestione dei canali non abilitata");
        }
        return canale;
    }

    public static final void setFiltroApiImplementata(String uriApiImplementata, int idLista, ConsoleSearch ricerca, ErogazioniEnv env) throws Exception {
        String pattern1 = "^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$";
        String pattern2 = "^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$";
        try {
            IDAccordo idAccordo = null;
            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
            if (RegularExpressionEngine.isMatch((String)uriApiImplementata, (String)pattern1)) {
                idAccordo = idAccordoFactory.getIDAccordoFromUri(uriApiImplementata);
            } else if (RegularExpressionEngine.isMatch((String)uriApiImplementata, (String)pattern2)) {
                String uriCompleto = env.idSoggetto.getTipo() + "/" + env.idSoggetto.getNome() + ":" + uriApiImplementata;
                idAccordo = idAccordoFactory.getIDAccordoFromUri(uriCompleto);
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La uri fornita '" + uriApiImplementata + "' non rispetta il formato atteso '" + pattern1 + "|" + pattern2 + "'");
            }
            ricerca.addFilter(idLista, "filtroApi", idAccordoFactory.getUriFromIDAccordo(idAccordo));
        }
        catch (RegExpNotFoundException e) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("La uri fornita '" + uriApiImplementata + "' non rispetta il formato atteso '" + pattern1 + "|" + pattern2 + "': " + e.getMessage());
        }
    }

    public static boolean isConnettoreApplicativoServer(IdServizio idAsps, IDServizio idServizioFromAccordo, ErogazioniEnv env, String gruppo) throws DriverConfigurazioneNotFound, DriverConfigurazioneException, CoreException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return ErogazioniApiHelper.isConnettoreApplicativoServer(ErogazioniApiHelper.getServizioApplicativo(idAsps, idServizioFromAccordo, env, gruppo));
    }

    public static boolean isConnettoreApplicativoServer(ServizioApplicativo sa) {
        return sa.getTipo() != null && sa.getTipo().equals("server");
    }

    public static void addInfoTokenPolicyForModI(Connettore regConnettore, ErogazioniEnv env, boolean checkEsistenzaTokenPolicy) throws Exception {
        if (regConnettore.getPropertyList() != null && regConnettore.getPropertyList().size() > 0) {
            for (Property p : regConnettore.getPropertyList()) {
                if (!"tokenPolicy".equals(p.getNome()) || p.getValore() == null || !StringUtils.isNotEmpty((CharSequence)p.getValore())) continue;
                if (checkEsistenzaTokenPolicy) {
                    try {
                        env.configCore.getGenericProperties(p.getValore(), "retrievePolicyToken", false);
                    }
                    catch (DriverConfigurazioneNotFound notFound) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Token policy di negoziazione '" + p.getValore() + "' non esistente");
                    }
                }
                env.requestWrapper.overrideParameter("connettore_token_policy_via_api", p.getValore());
            }
        }
    }

    private static /* synthetic */ String lambda$serviziCheckData$41(Optional fruitore) throws Exception {
        return ((IdSoggetto)fruitore.get()).getNome();
    }

    private static /* synthetic */ String lambda$serviziCheckData$40(Optional fruitore) throws Exception {
        return ((IdSoggetto)fruitore.get()).getTipo();
    }

    private static /* synthetic */ String lambda$serviziCheckData$39(BooleanNullable autenticazioneOpzionaleNullable) throws Exception {
        return ServletUtils.boolToCheckBoxStatus((Boolean)(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null));
    }

    private static /* synthetic */ String lambda$serviziCheckData$38(OneOfAPIImplAutenticazione authn) throws Exception {
        return Enums.tipoAutenticazioneFromRest.get((Object)authn.getTipo()).toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$37(BooleanNullable autenticazioneOpzionaleNullable) throws Exception {
        return ServletUtils.boolToCheckBoxStatus((Boolean)(autenticazioneOpzionaleNullable != null ? autenticazioneOpzionaleNullable.getValue() : null));
    }

    private static /* synthetic */ String lambda$serviziCheckData$36(OneOfAPIImplAutenticazione authn) throws Exception {
        return Enums.tipoAutenticazioneFromRest.get((Object)authn.getTipo()).toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$35(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getTempoMedioRisposta().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$34(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getConnectionReadTimeout().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$33(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getConnectionTimeout().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$32(ConnettoreConfigurazioneProxy proxy) throws Exception {
        return proxy.getPorta().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$31(ConnettoreConfigurazioneHttpsClient httpsClient) throws Exception {
        return ConnettoreHTTPApiHelper.getKeystoreType(httpsClient);
    }

    private static /* synthetic */ String lambda$serviziCheckData$30(ConnettoreConfigurazioneHttpsServer httpsServer) throws Exception {
        return ConnettoreHTTPApiHelper.getTruststoreType(httpsServer);
    }

    private static /* synthetic */ Boolean lambda$serviziCheckData$29(ConnettoreConfigurazioneHttps httpsConf) throws Exception {
        return (boolean)httpsConf.isHostnameVerifier();
    }

    private static /* synthetic */ String lambda$serviziCheckData$28(ConnettoreConfigurazioneHttps httpsConf) throws Exception {
        return httpsConf.getTipologia().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$27(AccordoServizioParteSpecifica asps) throws Exception {
        return asps.getId().toString();
    }

    private static /* synthetic */ String lambda$serviziCheckData$26(Optional fruitore) throws Exception {
        return ((IdSoggetto)fruitore.get()).getNome();
    }

    private static /* synthetic */ String lambda$serviziCheckData$25(Optional fruitore) throws Exception {
        return ((IdSoggetto)fruitore.get()).getTipo();
    }

    private static /* synthetic */ boolean lambda$serviziCheckData$24(APIImplAutorizzazioneAbilitataNew configAuthzFinal, String s) {
        return s.equals(configAuthzFinal.getSoggetto());
    }

    private static /* synthetic */ CredenzialeTipo lambda$serviziCheckData$23(OneOfAPIImplAutenticazione authn) throws Exception {
        return Enums.credenzialeTipoFromTipoAutenticazione.get((Object)authn.getTipo());
    }

    private static /* synthetic */ String[] lambda$serviziCheckData$22(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziCheckData$21(IDAccordoDB a) {
        return a.getId().toString();
    }

    private static /* synthetic */ String[] lambda$serviziCheckData$20(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziCheckData$19(Soggetto s) {
        return s.getId().toString();
    }

    private static /* synthetic */ boolean lambda$serviziCheckData$18(boolean generaPortaApplicativa, boolean escludiFruitore, Optional fruitore, Soggetto s) {
        return generaPortaApplicativa || !escludiFruitore || s.getId().longValue() != ((IdSoggetto)fruitore.get()).getId().longValue();
    }

    private static /* synthetic */ String[] lambda$serviziCheckData$17(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziCheckData$16(PortTypeSintetico p) {
        return p.getNome();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$15(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getTempoMedioRisposta().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$14(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getConnectionReadTimeout().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$13(ConnettoreConfigurazioneTimeout timeoutConf) throws Exception {
        return timeoutConf.getConnectionTimeout().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$12(ConnettoreConfigurazioneProxy proxy) throws Exception {
        return proxy.getPorta().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$11(ConnettoreConfigurazioneHttpsClient httpsClient) throws Exception {
        return ConnettoreHTTPApiHelper.getKeystoreType(httpsClient);
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$10(ConnettoreConfigurazioneHttpsServer httpsServer) throws Exception {
        return ConnettoreHTTPApiHelper.getTruststoreType(httpsServer);
    }

    private static /* synthetic */ Boolean lambda$serviziUpdateCheckData$9(ConnettoreConfigurazioneHttps httpsConf) throws Exception {
        return (boolean)httpsConf.isHostnameVerifier();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$8(ConnettoreConfigurazioneHttps httpsConf) throws Exception {
        return httpsConf.getTipologia().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$7(PortaDelegata pd) throws Exception {
        return pd.getRuoli().getMatch().toString();
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$6(PortaApplicativa pa) throws Exception {
        return pa.getRuoli().getMatch().toString();
    }

    private static /* synthetic */ String[] lambda$serviziUpdateCheckData$5(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$4(PortTypeSintetico p) {
        return p.getNome();
    }

    private static /* synthetic */ String[] lambda$serviziUpdateCheckData$3(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$2(IDAccordoDB a) {
        return a.getId().toString();
    }

    private static /* synthetic */ String[] lambda$serviziUpdateCheckData$1(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String lambda$serviziUpdateCheckData$0(Soggetto s) {
        return s.getId().toString();
    }
}

