/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni.configurazione;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;

public class ErogazioniConfEnv
extends ErogazioniEnv {
    public final ConfigurazioneCore confCore;
    public final ConfigurazioneHelper confHelper;
    public final AccordoServizioParteSpecifica asps;
    public final IdServizio idAsps;
    public final IDPortaApplicativa idPa;

    public ErogazioniConfEnv(HttpServletRequest req, ProfiloEnum profilo, String soggetto, IContext context, String nome, Integer versione, String gruppo, String tipoServizio) throws Exception {
        super(req, profilo, soggetto, context);
        this.confCore = new ConfigurazioneCore(this.stationCore);
        this.confHelper = new ConfigurazioneHelper(this.stationCore, (HttpServletRequest)this.requestWrapper, this.pd, req.getSession());
        this.asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfErogazione(tipoServizio, nome, versione, this.idSoggetto.toIDSoggetto(), this), (String)"Erogazione");
        this.idAsps = new IdServizio(this.idServizioFactory.getIDServizioFromAccordo(this.asps), this.asps.getId());
        if (tipoServizio != null && !((List)this.protocolFactoryMgr._getServiceTypes().get(this.tipo_protocollo)).contains(tipoServizio)) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Tipo Servizio: " + tipoServizio + " sconosciuto ");
        }
        this.idPa = StringUtils.isEmpty((CharSequence)gruppo) ? (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPADefault(this.idAsps, this.apsCore), (String)"Gruppo default per l'erogazione scelta") : (IDPortaApplicativa)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getIDGruppoPA(gruppo, this.idAsps, this.apsCore), (String)"Gruppo per l'erogazione scelta");
    }

    public boolean isSicurezzaMessaggioRiferimentoX509Required(AccordoServizioParteComune aspc, String portType) throws DriverControlStationException {
        try {
            Class<?> modiPropertiesClass = Class.forName("org.openspcoop2.protocol.utils.ModISecurityUtils");
            Method mGetMethod = modiPropertiesClass.getMethod("isSicurezzaMessaggioRiferimentoX509Required", AccordoServizioParteComune.class, String.class);
            Object oValue = mGetMethod.invoke(null, aspc, portType);
            if (oValue instanceof Boolean) {
                return (Boolean)oValue;
            }
            throw new DriverControlStationException("Type '" + oValue.getClass().getName() + "' not expected");
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), (Throwable)e);
        }
    }
}

