/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonStream;
import org.redisson.api.RFuture;
import org.redisson.api.RReliableTopic;
import org.redisson.api.RStream;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.stream.StreamMessageId;
import org.redisson.api.stream.StreamReadGroupArgs;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedissonReliableTopic
extends RedissonExpirable
implements RReliableTopic {
    private static final Logger log = LoggerFactory.getLogger(RedissonReliableTopic.class);
    private final Map<String, Entry> listeners = new ConcurrentHashMap<String, Entry>();
    private final String subscriberId;
    private volatile RFuture<Map<StreamMessageId, Map<String, Object>>> readFuture;
    private volatile Timeout timeoutTask;
    private final RStream<String, Object> stream;
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final String timeoutName;

    RedissonReliableTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.stream = new RedissonStream<String, Object>(new CompositeCodec(StringCodec.INSTANCE, codec), commandExecutor, name);
        this.subscriberId = this.getServiceManager().generateId();
        this.timeoutName = this.getTimeout(this.getRawName());
    }

    RedissonReliableTopic(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, name);
    }

    private String getTimeout(String name) {
        return RedissonReliableTopic.suffixName(name, "timeout");
    }

    @Override
    public long publish(Object message) {
        return this.get(this.publishAsync(message));
    }

    @Override
    public <M> String addListener(Class<M> type, MessageListener<M> listener) {
        return this.get(this.addListenerAsync(type, listener));
    }

    @Override
    public void removeListener(String ... listenerIds) {
        this.get(this.removeListenerAsync(listenerIds));
    }

    @Override
    public void removeAllListeners() {
        this.get(this.removeAllListenersAsync());
    }

    @Override
    public RFuture<Void> removeAllListenersAsync() {
        this.listeners.clear();
        return this.removeSubscriber();
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.stream.sizeAsync();
    }

    @Override
    public int countListeners() {
        return this.listeners.size();
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "redis.call('xadd', KEYS[1], '*', 'm', ARGV[1]); local v = redis.call('xinfo', 'groups', KEYS[1]); return #v;", Arrays.asList(this.getRawName()), this.encode(message));
    }

    @Override
    public <M> RFuture<String> addListenerAsync(Class<M> type, MessageListener<M> listener) {
        String id = this.getServiceManager().generateId();
        this.listeners.put(id, new Entry(type, listener));
        if (!this.subscribed.compareAndSet(false, true)) {
            return new CompletableFutureWrapper<String>(id);
        }
        RFuture addFuture = this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "redis.call('zadd', KEYS[2], ARGV[3], ARGV[2]);redis.call('xgroup', 'create', KEYS[1], ARGV[2], ARGV[1], 'MKSTREAM'); ", Arrays.asList(this.getRawName(), this.timeoutName), StreamMessageId.ALL, this.subscriberId, System.currentTimeMillis() + this.getServiceManager().getCfg().getReliableTopicWatchdogTimeout());
        CompletionStage<String> f = addFuture.thenApply(r -> {
            this.renewExpiration();
            this.poll(this.subscriberId);
            return id;
        });
        return new CompletableFutureWrapper<String>(f);
    }

    private void poll(String id) {
        RFuture f = this.stream.pendingRangeAsync(id, StreamMessageId.MIN, StreamMessageId.MAX, 100);
        CompletionStage ff = f.thenCompose(r -> {
            if (!this.subscribed.get()) {
                return CompletableFuture.completedFuture(r);
            }
            if (r.isEmpty()) {
                this.readFuture = this.stream.readGroupAsync(id, "consumer", StreamReadGroupArgs.neverDelivered().timeout(Duration.ofSeconds(0L)));
                return this.readFuture;
            }
            return CompletableFuture.completedFuture(r);
        });
        ff.whenComplete((res, ex) -> {
            if (ex != null) {
                if (this.getServiceManager().isShuttingDown((Throwable)ex)) {
                    return;
                }
                if (ex.getCause() != null && ex.getCause().getMessage().contains("NOGROUP")) {
                    return;
                }
                log.error("Unable to poll a new element. Subscriber id: {}", (Object)id, (Object)ex.getCause());
                this.getServiceManager().newTimeout(task -> {
                    if (this.getServiceManager().isShuttingDown()) {
                        return;
                    }
                    this.poll(id);
                }, 1L, TimeUnit.SECONDS);
                return;
            }
            CompletableFuture done = new CompletableFuture();
            if (!this.listeners.isEmpty()) {
                this.getServiceManager().getExecutor().execute(() -> {
                    for (Map.Entry entry : res.entrySet()) {
                        Object m = ((Map)entry.getValue()).get("m");
                        this.listeners.values().forEach(e -> {
                            if (e.getType().isInstance(m)) {
                                e.getListener().onMessage(this.getRawName(), m);
                                this.stream.ack(id, (StreamMessageId)entry.getKey());
                            }
                        });
                    }
                    done.complete(null);
                });
            } else {
                done.complete(null);
            }
            done.thenAccept(r -> {
                long time = System.currentTimeMillis();
                RFuture updateFuture = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expired = redis.call('zrangebyscore', KEYS[2], 0, tonumber(ARGV[2]) - 1); for i, v in ipairs(expired) do redis.call('xgroup', 'destroy', KEYS[1], v); redis.call('zrem', KEYS[2], v); end; local r = redis.call('zscore', KEYS[2], ARGV[1]); local score = 92233720368547758;local groups = redis.call('xinfo', 'groups', KEYS[1]); for i, v in ipairs(groups) do local id1, id2 = string.match(v[8], '(.*)%-(.*)'); score = math.min(tonumber(id1), score); end; score = tostring(score) .. '-0';local range = redis.call('xrange', KEYS[1], score, '+'); if #range == 0 or (#range == 1 and range[1][1] == score) then redis.call('xtrim', KEYS[1], 'maxlen', 0); else redis.call('xtrim', KEYS[1], 'maxlen', #range); end;return r ~= false; ", Arrays.asList(this.getRawName(), this.timeoutName), id, time);
                updateFuture.whenComplete((re, exc) -> {
                    if (exc != null) {
                        if (this.getServiceManager().isShuttingDown((Throwable)exc)) {
                            return;
                        }
                        log.error("Unable to update subscriber status", exc);
                        return;
                    }
                    if (!re.booleanValue() || !this.subscribed.get()) {
                        return;
                    }
                    this.poll(id);
                });
            });
        });
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return super.sizeInMemoryAsync(Arrays.asList(this.getRawName(), this.timeoutName));
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        String newName = (String)keys.get(1);
        List<Object> kks = Arrays.asList(this.getRawName(), this.timeoutName, newName, this.getTimeout(newName));
        return super.copyAsync(kks, database, replace);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.timeoutName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Void> removeListenerAsync(String ... listenerIds) {
        this.listeners.keySet().removeAll(Arrays.asList(listenerIds));
        if (this.listeners.isEmpty()) {
            return this.removeSubscriber();
        }
        return new CompletableFutureWrapper<Void>((Void)null);
    }

    private RFuture<Void> removeSubscriber() {
        this.subscribed.set(false);
        this.readFuture.cancel(false);
        this.timeoutTask.cancel();
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "redis.call('xgroup', 'destroy', KEYS[1], ARGV[1]); redis.call('zrem', KEYS[2], ARGV[1]); ", Arrays.asList(this.getRawName(), this.timeoutName), this.subscriberId);
    }

    @Override
    public int countSubscribers() {
        return this.get(this.countSubscribersAsync());
    }

    @Override
    public RFuture<Integer> countSubscribersAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local v = redis.call('xinfo', 'groups', KEYS[1]); return #v;", Arrays.asList(this.getRawName()), new Object[0]);
    }

    private void renewExpiration() {
        this.timeoutTask = this.getServiceManager().newTimeout(t -> {
            if (!this.subscribed.get() || this.getServiceManager().isShuttingDown()) {
                return;
            }
            RFuture future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('zscore', KEYS[1], ARGV[2]) == false then return 0; end; redis.call('zadd', KEYS[1], ARGV[1], ARGV[2]); return 1; ", Arrays.asList(this.timeoutName), System.currentTimeMillis() + this.getServiceManager().getCfg().getReliableTopicWatchdogTimeout(), this.subscriberId);
            future.whenComplete((res, e) -> {
                if (e != null) {
                    log.error("Can't update reliable topic {} expiration time", (Object)this.getRawName(), e);
                    return;
                }
                if (res.booleanValue()) {
                    this.renewExpiration();
                }
            });
        }, this.getServiceManager().getCfg().getReliableTopicWatchdogTimeout() / 3L, TimeUnit.MILLISECONDS);
    }

    private static class Entry {
        private final Class<?> type;
        private final MessageListener<?> listener;

        Entry(Class<?> type, MessageListener<?> listener) {
            this.type = type;
            this.listener = listener;
        }

        public Class<?> getType() {
            return this.type;
        }

        public MessageListener<?> getListener() {
            return this.listener;
        }
    }
}

