/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.bucket;

import java.util.Objects;
import org.redisson.api.bucket.CompareAndDeleteParams;
import org.redisson.api.bucket.ConditionType;

public interface CompareAndDeleteArgs<V> {
    public static <V> CompareAndDeleteArgs<V> unexpected(V object) {
        return new CompareAndDeleteParams<V>(ConditionType.UNEXPECTED, object);
    }

    public static <V> CompareAndDeleteArgs<V> expected(V object) {
        return new CompareAndDeleteParams<V>(ConditionType.EXPECTED, object);
    }

    public static <V> CompareAndDeleteArgs<V> expectedDigest(String value) {
        Objects.requireNonNull(value, "Digest value can't be null");
        return new CompareAndDeleteParams(ConditionType.EXPECTED_DIGEST, value);
    }

    public static <V> CompareAndDeleteArgs<V> unexpectedDigest(String value) {
        Objects.requireNonNull(value, "Digest value can't be null");
        return new CompareAndDeleteParams(ConditionType.UNEXPECTED_DIGEST, value);
    }
}

