/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search;

import org.redisson.api.SortOrder;
import org.redisson.api.search.ReducerParams;

public interface Reducer {
    public static Reducer avg(String fieldName) {
        return new ReducerParams("AVG", fieldName);
    }

    public static Reducer sum(String fieldName) {
        return new ReducerParams("SUM", fieldName);
    }

    public static Reducer max(String fieldName) {
        return new ReducerParams("MAX", fieldName);
    }

    public static Reducer min(String fieldName) {
        return new ReducerParams("MIN", fieldName);
    }

    public static Reducer quantile(String fieldName, Double percent) {
        return new ReducerParams("QUANTILE", fieldName, percent.toString());
    }

    public static Reducer count() {
        return new ReducerParams("COUNT", new String[0]);
    }

    public static Reducer countDistinct(String fieldName) {
        return new ReducerParams("COUNT", fieldName);
    }

    public static Reducer countDistinctish(String fieldName) {
        return new ReducerParams("COUNT_DISTINCTISH", fieldName);
    }

    public static Reducer firstValue(String fieldName) {
        return new ReducerParams("FIRST_VALUE", fieldName);
    }

    public static Reducer firstValue(String fieldName, String sortFieldName, SortOrder sortOrder) {
        return new ReducerParams("FIRST_VALUE", fieldName, "BY", sortFieldName, sortOrder.toString());
    }

    public static Reducer randomSample(String fieldName, int size) {
        return new ReducerParams("FIRST_VALUE", fieldName, Integer.toString(size));
    }

    public static Reducer stddev(String fieldName) {
        return new ReducerParams("STDDEV", fieldName);
    }

    public static Reducer toList(String fieldName) {
        return new ReducerParams("TOLIST", fieldName);
    }

    public static Reducer custom(String functionName, String ... args) {
        return new ReducerParams(functionName, args);
    }

    public Reducer as(String var1);
}

