/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.query.hybrid;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.redisson.api.SortOrder;
import org.redisson.api.search.Expression;
import org.redisson.api.search.GroupBy;
import org.redisson.api.search.query.hybrid.Combine;
import org.redisson.api.search.query.hybrid.HybridQueryArgs;
import org.redisson.api.search.query.hybrid.ParamsStep;
import org.redisson.api.search.query.hybrid.QueryStep;
import org.redisson.api.search.query.hybrid.SortStep;
import org.redisson.api.search.query.hybrid.VectorSimilarity;
import org.redisson.api.search.query.hybrid.VectorSimilarityParams;

public final class HybridQueryParams
implements QueryStep,
ParamsStep,
SortStep,
HybridQueryArgs {
    private final String query;
    private String scorer;
    private String queryScoreAlias;
    private VectorSimilarityParams vectorSimilarityParams;
    private Map<String, Object> params;
    private Combine combine;
    private String sortFieldName;
    private SortOrder sortOrder;
    private boolean noSort;
    private List<String> loadFields;
    private Integer limitOffset;
    private Integer limitCount;
    private List<GroupBy> groupBy;
    private List<Expression> expressions;
    private Duration timeout;
    private String postFilter;

    HybridQueryParams(String query) {
        this.query = query;
    }

    @Override
    public QueryStep scorer(String scorer) {
        this.scorer = scorer;
        return this;
    }

    @Override
    public QueryStep scoreAlias(String alias) {
        this.queryScoreAlias = alias;
        return this;
    }

    @Override
    public ParamsStep vectorSimilarity(VectorSimilarity value) {
        this.vectorSimilarityParams = (VectorSimilarityParams)value;
        return this;
    }

    @Override
    public SortStep params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Override
    public HybridQueryArgs sortBy(String fieldName, SortOrder order) {
        this.sortFieldName = fieldName;
        this.sortOrder = order;
        return this;
    }

    @Override
    public HybridQueryArgs noSort() {
        this.noSort = true;
        return this;
    }

    @Override
    public HybridQueryArgs combine(Combine value) {
        this.combine = value;
        return this;
    }

    @Override
    public HybridQueryArgs load(String ... fields) {
        this.loadFields = Arrays.asList(fields);
        return this;
    }

    @Override
    public HybridQueryArgs limit(int offset, int count) {
        this.limitOffset = offset;
        this.limitCount = count;
        return this;
    }

    @Override
    public HybridQueryArgs groupBy(GroupBy ... groups) {
        this.groupBy = Arrays.asList(groups);
        return this;
    }

    @Override
    public HybridQueryArgs apply(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
        return this;
    }

    @Override
    public HybridQueryArgs timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public HybridQueryArgs filter(String value) {
        this.postFilter = value;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public String getScorer() {
        return this.scorer;
    }

    public String getQueryScoreAlias() {
        return this.queryScoreAlias;
    }

    public VectorSimilarityParams getVectorSimilarityParams() {
        return this.vectorSimilarityParams;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Combine getCombine() {
        return this.combine;
    }

    public String getSortFieldName() {
        return this.sortFieldName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isNoSort() {
        return this.noSort;
    }

    public List<String> getLoadFields() {
        return this.loadFields;
    }

    public Integer getLimitOffset() {
        return this.limitOffset;
    }

    public Integer getLimitCount() {
        return this.limitCount;
    }

    public List<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getPostFilter() {
        return this.postFilter;
    }
}

