/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.cache.StdCachedValue;
import org.redisson.misc.WrappedLock;

public class LFUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final WrappedLock lock = new WrappedLock();
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentNavigableMap<MapKey, LFUCachedValue<K, V>> accessMap = new ConcurrentSkipListMap<MapKey, LFUCachedValue<K, V>>();

    public LFUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected CachedValue<K, V> create(K key, V value, long ttl, long maxIdleTime) {
        return new LFUCachedValue<K, V>(this.idGenerator.incrementAndGet(), key, value, ttl, maxIdleTime);
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        MapKey key = this.toKey((LFUCachedValue)value);
        this.accessMap.put(key, (LFUCachedValue)value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        this.addAccessCount((LFUCachedValue)value, 1L);
    }

    private MapKey toKey(LFUCachedValue<K, V> value) {
        return new MapKey(((LFUCachedValue)value).accessCount, value);
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        value.getLock().execute(() -> {
            MapKey key = this.toKey((LFUCachedValue)value);
            this.accessMap.remove(key);
        });
        super.onValueRemove(value);
    }

    private void addAccessCount(LFUCachedValue<K, V> value, long c) {
        value.getLock().execute(() -> {
            long count = c;
            if (count < 0L && ((LFUCachedValue)value).accessCount == 0L) {
                return;
            }
            MapKey key = this.toKey(value);
            if (this.accessMap.remove(key) == null) {
                return;
            }
            if (count < 0L) {
                count = -Math.min(((LFUCachedValue)value).accessCount, -count);
            }
            value.addAccessCount(count);
            key = this.toKey(value);
            this.accessMap.put(key, value);
        });
    }

    @Override
    protected void onMapFull() {
        this.lock.execute(() -> {
            Map.Entry entry = this.accessMap.pollFirstEntry();
            if (entry == null) {
                return;
            }
            if (this.map.remove(((LFUCachedValue)entry.getValue()).getKey(), entry.getValue())) {
                super.onValueRemove((CachedValue)entry.getValue());
            }
            if (((LFUCachedValue)entry.getValue()).accessCount == 0L) {
                return;
            }
            for (LFUCachedValue value : this.accessMap.values()) {
                this.addAccessCount(value, -((LFUCachedValue)entry.getValue()).accessCount);
            }
        });
    }

    @Override
    public void clear() {
        this.accessMap.clear();
        super.clear();
    }

    public static class LFUCachedValue<K, V>
    extends StdCachedValue<K, V> {
        private final Long id;
        private long accessCount;

        public LFUCachedValue(long id, K key, V value, long ttl, long maxIdleTime) {
            super(key, value, ttl, maxIdleTime);
            this.id = id;
        }

        public void addAccessCount(long value) {
            this.accessCount += value;
        }
    }

    public static class MapKey
    implements Comparable<MapKey> {
        private Long accessCount;
        private LFUCachedValue cachedValue;

        public MapKey(Long accessCount, LFUCachedValue cachedValue) {
            this.accessCount = accessCount;
            this.cachedValue = cachedValue;
        }

        @Override
        public int compareTo(MapKey o) {
            int compare = this.accessCount.compareTo(o.accessCount);
            if (compare == 0) {
                return this.cachedValue.id.compareTo(o.cachedValue.id);
            }
            return compare;
        }

        public String toString() {
            return "MapKey [accessCount=" + this.accessCount + "]";
        }
    }
}

