/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.Kryo5Codec;

public class ZStdCodec
extends BaseCodec {
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            int size = buf.readInt();
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer(size);
            try {
                ZstdInputStream in = new ZstdInputStream((InputStream)new ByteBufInputStream(buf));
                out.writeBytes((InputStream)in, size);
                in.close();
                Object object = ZStdCodec.this.innerCodec.getValueDecoder().decode(out, state);
                return object;
            }
            finally {
                out.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf encoded = ZStdCodec.this.innerCodec.getValueEncoder().encode(in);
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            ZstdOutputStream o = new ZstdOutputStream((OutputStream)new ByteBufOutputStream(out));
            int size = encoded.readableBytes();
            out.writeInt(size);
            encoded.readBytes((OutputStream)o, size);
            encoded.release();
            o.flush();
            o.close();
            return out;
        }
    };

    public ZStdCodec() {
        this(new Kryo5Codec());
    }

    public ZStdCodec(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public ZStdCodec(ClassLoader classLoader) {
        this(new Kryo5Codec(classLoader));
    }

    public ZStdCodec(ClassLoader classLoader, ZStdCodec codec) throws ReflectiveOperationException {
        this(ZStdCodec.copy(classLoader, codec.innerCodec));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

