/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.util.Timeout;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.BatchOptions;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandBatchService;
import org.redisson.command.RedisExecutor;
import org.redisson.config.DelayStrategy;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCommonBatchExecutor
extends RedisExecutor<Object, Void> {
    static final Logger log = LoggerFactory.getLogger(RedisCommonBatchExecutor.class);
    private final CommandBatchService.Entry entry;
    private final AtomicInteger slots;
    private final BatchOptions options;

    public RedisCommonBatchExecutor(NodeSource source, CompletableFuture<Void> mainPromise, ConnectionManager connectionManager, BatchOptions options, CommandBatchService.Entry entry, AtomicInteger slots, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry) {
        super(entry.isReadOnlyMode(), source, null, null, null, mainPromise, false, connectionManager, null, referenceType, noRetry, RedisCommonBatchExecutor.retryAttempts(connectionManager, options), RedisCommonBatchExecutor.retryInterval(connectionManager, options), RedisCommonBatchExecutor.timeout(connectionManager, options), false);
        this.options = options;
        this.entry = entry;
        this.slots = slots;
    }

    private static int timeout(ConnectionManager connectionManager, BatchOptions options) {
        int result = connectionManager.getServiceManager().getConfig().getTimeout();
        if (options.getResponseTimeout() > 0L) {
            result = (int)options.getResponseTimeout();
        }
        if (options.getSyncSlaves() > 0) {
            result += (int)options.getSyncTimeout();
        }
        return result;
    }

    private static DelayStrategy retryInterval(ConnectionManager connectionManager, BatchOptions options) {
        if (options.getRetryDelay() != null) {
            return options.getRetryDelay();
        }
        return connectionManager.getServiceManager().getConfig().getRetryDelay();
    }

    private static int retryAttempts(ConnectionManager connectionManager, BatchOptions options) {
        if (options.getRetryAttempts() >= 0) {
            return options.getRetryAttempts();
        }
        return connectionManager.getServiceManager().getConfig().getRetryAttempts();
    }

    @Override
    protected void onException() {
        this.entry.clearErrors();
    }

    @Override
    protected void free() {
        this.free(this.entry);
    }

    private void free(CommandBatchService.Entry entry) {
        for (CommandData commandData : entry.getCommands()) {
            this.free(commandData.getParams());
        }
    }

    @Override
    protected CompletableFuture<RedisConnection> getConnection(CompletableFuture<Void> attemptPromise) {
        CompletableFuture<RedisConnection> f = super.getConnection(attemptPromise);
        f.whenComplete((r, e) -> {
            if (e != null && this.source.getEntry().getReplacedBy() != null) {
                this.source = new NodeSource(this.source.getEntry().getReplacedBy());
            }
        });
        return f;
    }

    @Override
    protected void sendCommand(CompletableFuture<Void> attemptPromise, RedisConnection connection) {
        boolean isAtomic = this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY;
        boolean isQueued = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        ArrayList list = new ArrayList(this.entry.getCommands().size());
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            CompletableFuture promise = new CompletableFuture();
            list.add(new CommandData(promise, StringCodec.INSTANCE, RedisCommands.ASKING, new Object[0]));
        }
        for (CommandData commandData : this.entry.getCommands()) {
            if ((commandData.getPromise().isCancelled() || commandData.getPromise().isDone() && !commandData.getPromise().isCompletedExceptionally()) && !this.isWaitCommand(commandData) && !isAtomic) continue;
            list.add(commandData);
        }
        if (list.isEmpty()) {
            this.writeFuture = connection.getChannel().newPromise();
            attemptPromise.complete(null);
            this.timeout.ifPresent(Timeout::cancel);
            return;
        }
        this.sendCommand(connection, attemptPromise, list);
    }

    private void sendCommand(RedisConnection connection, CompletableFuture<Void> attemptPromise, List<CommandData<?, ?>> list) {
        boolean isAtomic = this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY;
        boolean isQueued = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        CommandData<?, ?> lastCommand = connection.getLastCommand();
        if (lastCommand != null && this.options.isSkipResult()) {
            this.writeFuture = connection.getChannel().newPromise();
            lastCommand.getPromise().whenComplete((r, e) -> {
                CommandData<?, ?> currentLastCommand = connection.getLastCommand();
                if (lastCommand != currentLastCommand && currentLastCommand != null) {
                    this.sendCommand(connection, attemptPromise, list);
                    return;
                }
                ChannelFuture wf = connection.send(new CommandsData(attemptPromise, list, this.options.isSkipResult(), isAtomic, isQueued, this.options.getSyncSlaves() > 0));
                wf.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (future.isSuccess()) {
                        ((ChannelPromise)this.writeFuture).trySuccess((Object)((Void)future.getNow()));
                    } else {
                        ((ChannelPromise)this.writeFuture).tryFailure(future.cause());
                    }
                }));
            });
            return;
        }
        this.writeFuture = connection.send(new CommandsData(attemptPromise, list, this.options.isSkipResult(), isAtomic, isQueued, this.options.getSyncSlaves() > 0));
    }

    protected boolean isWaitCommand(CommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName()) || c.getCommand().getName().equals(RedisCommands.WAITAOF.getName());
    }

    @Override
    protected void handleResult(CompletableFuture<Void> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) throws ReflectiveOperationException {
        if (attemptPromise.isDone() && !attemptPromise.isCompletedExceptionally()) {
            if (this.slots.decrementAndGet() == 0) {
                this.handleSuccess(this.mainPromise, connectionFuture, null);
            }
        } else {
            this.handleError(connectionFuture, this.cause(attemptPromise));
        }
    }
}

