/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.client.DefaultCredentialsResolver;
import org.redisson.client.DefaultNettyHook;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.codec.Kryo5Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.CommandMapper;
import org.redisson.config.ConfigSupport;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.NameMapper;
import org.redisson.config.Protocol;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SslProvider;
import org.redisson.config.SslVerificationMode;
import org.redisson.config.TransportMode;
import org.redisson.config.ValkeyCapability;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.SequentialDnsAddressResolverFactory;

public class Config {
    private SentinelServersConfig sentinelServersConfig;
    private MasterSlaveServersConfig masterSlaveServersConfig;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private ReplicatedServersConfig replicatedServersConfig;
    private String password;
    private String username;
    private CredentialsResolver credentialsResolver = new DefaultCredentialsResolver();
    private int threads = 16;
    private int nettyThreads = 32;
    private Executor nettyExecutor;
    private Codec codec;
    private ExecutorService executor;
    private boolean referenceEnabled = true;
    private TransportMode transportMode = TransportMode.NIO;
    private EventLoopGroup eventLoopGroup;
    private long lockWatchdogTimeout = 30000L;
    private int lockWatchdogBatchSize = 100;
    private long fairLockWaitTimeout = 300000L;
    private boolean checkLockSyncedSlaves = true;
    private long slavesSyncTimeout = 1000L;
    private long reliableTopicWatchdogTimeout = TimeUnit.MINUTES.toMillis(10L);
    private boolean keepPubSubOrder = true;
    private boolean useScriptCache = true;
    private int minCleanUpDelay = 5;
    private int maxCleanUpDelay = 1800;
    private int cleanUpKeysAmount = 100;
    private NettyHook nettyHook = new DefaultNettyHook();
    private ConnectionListener connectionListener;
    private boolean useThreadClassLoader = true;
    private AddressResolverGroupFactory addressResolverGroupFactory = new SequentialDnsAddressResolverFactory();
    private boolean lazyInitialization;
    private Protocol protocol = Protocol.RESP2;
    private Set<ValkeyCapability> valkeyCapabilities = Collections.emptySet();
    private NameMapper nameMapper = NameMapper.direct();
    private CommandMapper commandMapper = CommandMapper.direct();
    private SslVerificationMode sslVerificationMode = SslVerificationMode.STRICT;
    private String sslKeystoreType;
    private SslProvider sslProvider = SslProvider.JDK;
    private URL sslTruststore;
    private String sslTruststorePassword;
    private URL sslKeystore;
    private String sslKeystorePassword;
    private String[] sslProtocols;
    private String[] sslCiphers;
    private TrustManagerFactory sslTrustManagerFactory;
    private KeyManagerFactory sslKeyManagerFactory;
    private boolean tcpKeepAlive;
    private int tcpKeepAliveCount;
    private int tcpKeepAliveIdle;
    private int tcpKeepAliveInterval;
    private int tcpUserTimeout;
    private boolean tcpNoDelay = true;

    public Config() {
    }

    public Config(Config oldConf) {
        this.setNettyHook(oldConf.getNettyHook());
        this.setNettyExecutor(oldConf.getNettyExecutor());
        this.setExecutor(oldConf.getExecutor());
        if (oldConf.getCodec() == null) {
            oldConf.setCodec(new Kryo5Codec());
        }
        this.setConnectionListener(oldConf.getConnectionListener());
        this.setUseThreadClassLoader(oldConf.isUseThreadClassLoader());
        this.setMinCleanUpDelay(oldConf.getMinCleanUpDelay());
        this.setMaxCleanUpDelay(oldConf.getMaxCleanUpDelay());
        this.setCleanUpKeysAmount(oldConf.getCleanUpKeysAmount());
        this.setUseScriptCache(oldConf.isUseScriptCache());
        this.setKeepPubSubOrder(oldConf.isKeepPubSubOrder());
        this.setLockWatchdogTimeout(oldConf.getLockWatchdogTimeout());
        this.setLockWatchdogBatchSize(oldConf.getLockWatchdogBatchSize());
        this.setFairLockWaitTimeout(oldConf.getFairLockWaitTimeout());
        this.setCheckLockSyncedSlaves(oldConf.isCheckLockSyncedSlaves());
        this.setSlavesSyncTimeout(oldConf.getSlavesSyncTimeout());
        this.setNettyThreads(oldConf.getNettyThreads());
        this.setThreads(oldConf.getThreads());
        this.setUsername(oldConf.getUsername());
        this.setPassword(oldConf.getPassword());
        this.setCredentialsResolver(oldConf.getCredentialsResolver());
        this.setCodec(oldConf.getCodec());
        this.setReferenceEnabled(oldConf.isReferenceEnabled());
        this.setEventLoopGroup(oldConf.getEventLoopGroup());
        this.setTransportMode(oldConf.getTransportMode());
        this.setAddressResolverGroupFactory(oldConf.getAddressResolverGroupFactory());
        this.setReliableTopicWatchdogTimeout(oldConf.getReliableTopicWatchdogTimeout());
        this.setLazyInitialization(oldConf.isLazyInitialization());
        this.setProtocol(oldConf.getProtocol());
        this.setValkeyCapabilities(oldConf.getValkeyCapabilities());
        this.setNameMapper(oldConf.getNameMapper());
        this.setCommandMapper(oldConf.getCommandMapper());
        this.setSslProvider(oldConf.getSslProvider());
        this.setSslTruststore(oldConf.getSslTruststore());
        this.setSslTruststorePassword(oldConf.getSslTruststorePassword());
        this.setSslKeystoreType(oldConf.getSslKeystoreType());
        this.setSslKeystore(oldConf.getSslKeystore());
        this.setSslKeystorePassword(oldConf.getSslKeystorePassword());
        this.setSslProtocols(oldConf.getSslProtocols());
        this.setSslCiphers(oldConf.getSslCiphers());
        this.setSslKeyManagerFactory(oldConf.getSslKeyManagerFactory());
        this.setSslTrustManagerFactory(oldConf.getSslTrustManagerFactory());
        this.setSslVerificationMode(oldConf.getSslVerificationMode());
        if (oldConf.getSingleServerConfig() != null) {
            this.setSingleServerConfig(new SingleServerConfig(oldConf.getSingleServerConfig()));
        }
        if (oldConf.getMasterSlaveServersConfig() != null) {
            this.setMasterSlaveServersConfig(new MasterSlaveServersConfig(oldConf.getMasterSlaveServersConfig()));
        }
        if (oldConf.getSentinelServersConfig() != null) {
            this.setSentinelServersConfig(new SentinelServersConfig(oldConf.getSentinelServersConfig()));
        }
        if (oldConf.getClusterServersConfig() != null) {
            this.setClusterServersConfig(new ClusterServersConfig(oldConf.getClusterServersConfig()));
        }
        if (oldConf.getReplicatedServersConfig() != null) {
            this.setReplicatedServersConfig(new ReplicatedServersConfig(oldConf.getReplicatedServersConfig()));
        }
    }

    public NettyHook getNettyHook() {
        return this.nettyHook;
    }

    public Config setNettyHook(NettyHook nettyHook) {
        this.nettyHook = nettyHook;
        return this;
    }

    public Config setCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public boolean isReferenceEnabled() {
        return this.referenceEnabled;
    }

    public void setReferenceEnabled(boolean redissonReferenceEnabled) {
        this.referenceEnabled = redissonReferenceEnabled;
    }

    public ClusterServersConfig useClusterServers() {
        return this.useClusterServers(new ClusterServersConfig());
    }

    ClusterServersConfig useClusterServers(ClusterServersConfig config) {
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        this.checkReplicatedServersConfig();
        if (this.clusterServersConfig == null) {
            this.clusterServersConfig = config;
        }
        return this.clusterServersConfig;
    }

    protected ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    protected void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public ReplicatedServersConfig useReplicatedServers() {
        return this.useReplicatedServers(new ReplicatedServersConfig());
    }

    ReplicatedServersConfig useReplicatedServers(ReplicatedServersConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        if (this.replicatedServersConfig == null) {
            this.replicatedServersConfig = config;
        }
        return this.replicatedServersConfig;
    }

    protected ReplicatedServersConfig getReplicatedServersConfig() {
        return this.replicatedServersConfig;
    }

    protected void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
        this.replicatedServersConfig = replicatedServersConfig;
    }

    public SingleServerConfig useSingleServer() {
        return this.useSingleServer(new SingleServerConfig());
    }

    SingleServerConfig useSingleServer(SingleServerConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkReplicatedServersConfig();
        if (this.singleServerConfig == null) {
            this.singleServerConfig = config;
        }
        return this.singleServerConfig;
    }

    protected SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    protected void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
        this.singleServerConfig = singleConnectionConfig;
    }

    public SentinelServersConfig useSentinelServers() {
        return this.useSentinelServers(new SentinelServersConfig());
    }

    SentinelServersConfig useSentinelServers(SentinelServersConfig sentinelServersConfig) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkMasterSlaveServersConfig();
        this.checkReplicatedServersConfig();
        if (this.sentinelServersConfig == null) {
            this.sentinelServersConfig = sentinelServersConfig;
        }
        return this.sentinelServersConfig;
    }

    protected SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    protected void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
        this.sentinelServersConfig = sentinelConnectionConfig;
    }

    public MasterSlaveServersConfig useMasterSlaveServers() {
        return this.useMasterSlaveServers(new MasterSlaveServersConfig());
    }

    MasterSlaveServersConfig useMasterSlaveServers(MasterSlaveServersConfig config) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkSentinelServersConfig();
        this.checkReplicatedServersConfig();
        if (this.masterSlaveServersConfig == null) {
            this.masterSlaveServersConfig = config;
        }
        return this.masterSlaveServersConfig;
    }

    protected MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    protected void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
        this.masterSlaveServersConfig = masterSlaveConnectionConfig;
    }

    public boolean isClusterConfig() {
        return this.clusterServersConfig != null;
    }

    public boolean isSentinelConfig() {
        return this.sentinelServersConfig != null;
    }

    public boolean isSingleConfig() {
        return this.singleServerConfig != null;
    }

    public Config setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public Config setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public CredentialsResolver getCredentialsResolver() {
        return this.credentialsResolver;
    }

    public Config setCredentialsResolver(CredentialsResolver credentialsResolver) {
        this.credentialsResolver = credentialsResolver;
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    public Config setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    private void checkClusterServersConfig() {
        if (this.clusterServersConfig != null) {
            throw new IllegalStateException("cluster servers config already used!");
        }
    }

    private void checkSentinelServersConfig() {
        if (this.sentinelServersConfig != null) {
            throw new IllegalStateException("sentinel servers config already used!");
        }
    }

    private void checkMasterSlaveServersConfig() {
        if (this.masterSlaveServersConfig != null) {
            throw new IllegalStateException("master/slave servers already used!");
        }
    }

    private void checkSingleServerConfig() {
        if (this.singleServerConfig != null) {
            throw new IllegalStateException("single server config already used!");
        }
    }

    private void checkReplicatedServersConfig() {
        if (this.replicatedServersConfig != null) {
            throw new IllegalStateException("Replication servers config already used!");
        }
    }

    public Config setTransportMode(TransportMode transportMode) {
        this.transportMode = transportMode;
        return this;
    }

    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    public Config setNettyThreads(int nettyThreads) {
        this.nettyThreads = nettyThreads;
        return this;
    }

    public int getNettyThreads() {
        return this.nettyThreads;
    }

    public Executor getNettyExecutor() {
        return this.nettyExecutor;
    }

    public Config setNettyExecutor(Executor nettyExecutor) {
        this.nettyExecutor = nettyExecutor;
        return this;
    }

    public Config setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Config setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public Config setLockWatchdogTimeout(long lockWatchdogTimeout) {
        this.lockWatchdogTimeout = lockWatchdogTimeout;
        return this;
    }

    public long getLockWatchdogTimeout() {
        return this.lockWatchdogTimeout;
    }

    public Config setFairLockWaitTimeout(long fairLockWaitTimeout) {
        this.fairLockWaitTimeout = fairLockWaitTimeout;
        return this;
    }

    public long getFairLockWaitTimeout() {
        return this.fairLockWaitTimeout;
    }

    public Config setLockWatchdogBatchSize(int lockWatchdogBatchSize) {
        this.lockWatchdogBatchSize = lockWatchdogBatchSize;
        return this;
    }

    public int getLockWatchdogBatchSize() {
        return this.lockWatchdogBatchSize;
    }

    public Config setCheckLockSyncedSlaves(boolean checkLockSyncedSlaves) {
        this.checkLockSyncedSlaves = checkLockSyncedSlaves;
        return this;
    }

    public boolean isCheckLockSyncedSlaves() {
        return this.checkLockSyncedSlaves;
    }

    public Config setKeepPubSubOrder(boolean keepPubSubOrder) {
        this.keepPubSubOrder = keepPubSubOrder;
        return this;
    }

    public boolean isKeepPubSubOrder() {
        return this.keepPubSubOrder;
    }

    public Config setAddressResolverGroupFactory(AddressResolverGroupFactory addressResolverGroupFactory) {
        this.addressResolverGroupFactory = addressResolverGroupFactory;
        return this;
    }

    public AddressResolverGroupFactory getAddressResolverGroupFactory() {
        return this.addressResolverGroupFactory;
    }

    public static Config fromYAML(String content) {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(content, Config.class);
    }

    public static Config fromYAML(InputStream inputStream) {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(inputStream, Config.class);
    }

    public static Config fromYAML(File file) throws IOException {
        return Config.fromYAML(file, null);
    }

    public static Config fromYAML(File file, ClassLoader classLoader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(file, Config.class, classLoader);
    }

    public static Config fromYAML(URL url) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(url, Config.class);
    }

    public static Config fromYAML(Reader reader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(reader, Config.class);
    }

    public String toYAML() throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.toYAML(this);
    }

    public Config setUseScriptCache(boolean useScriptCache) {
        this.useScriptCache = useScriptCache;
        return this;
    }

    public boolean isUseScriptCache() {
        return this.useScriptCache;
    }

    public int getMinCleanUpDelay() {
        return this.minCleanUpDelay;
    }

    public Config setMinCleanUpDelay(int minCleanUpDelay) {
        this.minCleanUpDelay = minCleanUpDelay;
        return this;
    }

    public int getMaxCleanUpDelay() {
        return this.maxCleanUpDelay;
    }

    public Config setMaxCleanUpDelay(int maxCleanUpDelay) {
        this.maxCleanUpDelay = maxCleanUpDelay;
        return this;
    }

    public int getCleanUpKeysAmount() {
        return this.cleanUpKeysAmount;
    }

    public Config setCleanUpKeysAmount(int cleanUpKeysAmount) {
        this.cleanUpKeysAmount = cleanUpKeysAmount;
        return this;
    }

    public boolean isUseThreadClassLoader() {
        return this.useThreadClassLoader;
    }

    public Config setUseThreadClassLoader(boolean useThreadClassLoader) {
        this.useThreadClassLoader = useThreadClassLoader;
        return this;
    }

    public long getReliableTopicWatchdogTimeout() {
        return this.reliableTopicWatchdogTimeout;
    }

    public Config setReliableTopicWatchdogTimeout(long timeout) {
        this.reliableTopicWatchdogTimeout = timeout;
        return this;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public Config setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    public long getSlavesSyncTimeout() {
        return this.slavesSyncTimeout;
    }

    public Config setSlavesSyncTimeout(long timeout) {
        this.slavesSyncTimeout = timeout;
        return this;
    }

    public boolean isLazyInitialization() {
        return this.lazyInitialization;
    }

    public Config setLazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Config setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Set<ValkeyCapability> getValkeyCapabilities() {
        return this.valkeyCapabilities;
    }

    public Config setValkeyCapabilities(Set<ValkeyCapability> valkeyCapabilities) {
        this.valkeyCapabilities = valkeyCapabilities;
        return this;
    }

    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    public Config setNameMapper(NameMapper nameMapper) {
        this.nameMapper = nameMapper;
        return this;
    }

    public CommandMapper getCommandMapper() {
        return this.commandMapper;
    }

    public Config setCommandMapper(CommandMapper commandMapper) {
        this.commandMapper = commandMapper;
        return this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public Config setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    public Config setSslTruststore(URL sslTruststore) {
        this.sslTruststore = sslTruststore;
        return this;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public Config setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return this;
    }

    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    public Config setSslKeystore(URL sslKeystore) {
        this.sslKeystore = sslKeystore;
        return this;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public Config setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
        return this;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public Config setSslProtocols(String[] sslProtocols) {
        this.sslProtocols = sslProtocols;
        return this;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public Config setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
        return this;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public Config setSslCiphers(String[] sslCiphers) {
        this.sslCiphers = sslCiphers;
        return this;
    }

    public TrustManagerFactory getSslTrustManagerFactory() {
        return this.sslTrustManagerFactory;
    }

    public Config setSslTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.sslTrustManagerFactory = trustManagerFactory;
        return this;
    }

    public KeyManagerFactory getSslKeyManagerFactory() {
        return this.sslKeyManagerFactory;
    }

    public Config setSslKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.sslKeyManagerFactory = keyManagerFactory;
        return this;
    }

    public SslVerificationMode getSslVerificationMode() {
        return this.sslVerificationMode;
    }

    public Config setSslVerificationMode(SslVerificationMode sslVerificationMode) {
        this.sslVerificationMode = sslVerificationMode;
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public Config setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public int getTcpKeepAliveCount() {
        return this.tcpKeepAliveCount;
    }

    public Config setTcpKeepAliveCount(int tcpKeepAliveCount) {
        this.tcpKeepAliveCount = tcpKeepAliveCount;
        return this;
    }

    public int getTcpKeepAliveIdle() {
        return this.tcpKeepAliveIdle;
    }

    public Config setTcpKeepAliveIdle(int tcpKeepAliveIdle) {
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
        return this;
    }

    public int getTcpKeepAliveInterval() {
        return this.tcpKeepAliveInterval;
    }

    public Config setTcpKeepAliveInterval(int tcpKeepAliveInterval) {
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
        return this;
    }

    public int getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    public Config setTcpUserTimeout(int tcpUserTimeout) {
        this.tcpUserTimeout = tcpUserTimeout;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public Config setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }
}

