/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.client.FailedNodeDetector;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.CommandMapper;
import org.redisson.config.Config;
import org.redisson.config.ConstantDelay;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.DecorrelatedJitterDelay;
import org.redisson.config.DelayStrategy;
import org.redisson.config.EqualJitterDelay;
import org.redisson.config.FullJitterDelay;
import org.redisson.config.NameMapper;
import org.redisson.config.NatMapper;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.balancer.LoadBalancer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigSupport {
    private final ClassLoader classLoader;
    private final boolean useCaseInsensitive;
    private static final Pattern ENV_PARAM_PATTERN = Pattern.compile("\\$\\{([\\w\\.]+(:-.+?)?)\\}");
    private static final Pattern TAG_FIX_PATTERN = Pattern.compile("!([a-zA-Z0-9_.]+)");
    private static final Pattern TAG_UNFIX_PATTERN = Pattern.compile("!<([a-zA-Z0-9_.]+)>");

    public ConfigSupport() {
        this(false);
    }

    public ConfigSupport(boolean useCaseInsensitive) {
        this(null, useCaseInsensitive);
    }

    public ConfigSupport(ClassLoader classLoader, boolean useCaseInsensitive) {
        this.classLoader = classLoader;
        this.useCaseInsensitive = useCaseInsensitive;
    }

    private Yaml createYamlParser(ClassLoader classLoader, boolean useCaseInsensitive) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setTagInspector(tag -> true);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumperOptions.setIndent(2);
        DelayConstructor constructor = new DelayConstructor(classLoader, loaderOptions, useCaseInsensitive);
        CustomRepresenter representer = new CustomRepresenter(dumperOptions, useCaseInsensitive);
        return new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions);
    }

    private String resolveEnvParams(Readable in) {
        try (Scanner s = new Scanner(in).useDelimiter("\\A");){
            if (s.hasNext()) {
                String string = this.resolveEnvParams(s.next());
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String resolveEnvParams(String content) {
        Matcher m = ENV_PARAM_PATTERN.matcher(content);
        while (m.find()) {
            String[] parts = m.group(1).split(":-");
            String v = System.getenv(parts[0]);
            if ((v = System.getProperty(parts[0], v)) != null) {
                content = content.replace(m.group(), v);
                continue;
            }
            if (parts.length != 2) continue;
            content = content.replace(m.group(), parts[1]);
        }
        return content;
    }

    public <T> T fromYAML(String content, Class<T> configType) {
        content = this.resolveEnvParams(content);
        content = this.unfixTagFormat(content);
        Yaml yaml = this.createYamlParser(this.classLoader, this.useCaseInsensitive);
        return (T)yaml.loadAs(content, configType);
    }

    public <T> T fromYAML(File file, Class<T> configType) throws IOException {
        return this.fromYAML(file, configType, null);
    }

    public <T> T fromYAML(File file, Class<T> configType, ClassLoader classLoader) throws IOException {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setTagInspector(tag -> true);
        DumperOptions dumperOptions = new DumperOptions();
        Yaml yamlParser = new Yaml((BaseConstructor)new DelayConstructor(classLoader, loaderOptions, this.useCaseInsensitive), (Representer)new CustomRepresenter(dumperOptions, this.useCaseInsensitive), dumperOptions, loaderOptions);
        String content = this.resolveEnvParams(new FileReader(file));
        content = this.unfixTagFormat(content);
        return (T)yamlParser.loadAs(content, configType);
    }

    public <T> T fromYAML(URL url, Class<T> configType) throws IOException {
        String content = this.resolveEnvParams(new InputStreamReader(url.openStream()));
        content = this.unfixTagFormat(content);
        Yaml yaml = this.createYamlParser(this.classLoader, this.useCaseInsensitive);
        return (T)yaml.loadAs(content, configType);
    }

    public <T> T fromYAML(Reader reader, Class<T> configType) throws IOException {
        String content = this.resolveEnvParams(reader);
        content = this.unfixTagFormat(content);
        Yaml yaml = this.createYamlParser(this.classLoader, this.useCaseInsensitive);
        return (T)yaml.loadAs(content, configType);
    }

    public <T> T fromYAML(InputStream inputStream, Class<T> configType) {
        String content = this.resolveEnvParams(new InputStreamReader(inputStream));
        content = this.unfixTagFormat(content);
        Yaml yaml = this.createYamlParser(this.classLoader, this.useCaseInsensitive);
        return (T)yaml.loadAs(content, configType);
    }

    public String toYAML(Config config) {
        Yaml yaml = this.createYamlParser(this.classLoader, this.useCaseInsensitive);
        String yamlStr = yaml.dump((Object)config);
        return this.fixTagFormat(yamlStr);
    }

    private String fixTagFormat(String yaml) {
        Matcher matcher = TAG_FIX_PATTERN.matcher(yaml);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String className = matcher.group(1);
            matcher.appendReplacement(result, "!<" + className + ">");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String unfixTagFormat(String yaml) {
        Matcher matcher = TAG_UNFIX_PATTERN.matcher(yaml);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String className = matcher.group(1);
            matcher.appendReplacement(result, "!!" + className);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static BaseConfig<?> getConfig(Config configCopy) {
        if (configCopy.getMasterSlaveServersConfig() != null) {
            ConfigSupport.validate(configCopy.getMasterSlaveServersConfig());
            return configCopy.getMasterSlaveServersConfig();
        }
        if (configCopy.getSingleServerConfig() != null) {
            ConfigSupport.validate(configCopy.getSingleServerConfig());
            return configCopy.getSingleServerConfig();
        }
        if (configCopy.getSentinelServersConfig() != null) {
            ConfigSupport.validate(configCopy.getSentinelServersConfig());
            return configCopy.getSentinelServersConfig();
        }
        if (configCopy.getClusterServersConfig() != null) {
            ConfigSupport.validate(configCopy.getClusterServersConfig());
            return configCopy.getClusterServersConfig();
        }
        if (configCopy.getReplicatedServersConfig() != null) {
            ConfigSupport.validate(configCopy.getReplicatedServersConfig());
            return configCopy.getReplicatedServersConfig();
        }
        throw new IllegalArgumentException("server(s) address(es) not defined!");
    }

    private static void validate(SingleServerConfig config) {
        if (config.getConnectionPoolSize() < config.getConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("connectionPoolSize can't be lower than connectionMinimumIdleSize");
        }
    }

    private static void validate(BaseMasterSlaveServersConfig<?> config) {
        if (config.getSlaveConnectionPoolSize() < config.getSlaveConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveConnectionPoolSize can't be lower than slaveConnectionMinimumIdleSize");
        }
        if (config.getMasterConnectionPoolSize() < config.getMasterConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("masterConnectionPoolSize can't be lower than masterConnectionMinimumIdleSize");
        }
        if (config.getSubscriptionConnectionPoolSize() < config.getSubscriptionConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveSubscriptionConnectionMinimumIdleSize can't be lower than slaveSubscriptionConnectionPoolSize");
        }
    }

    private static class DelayConstructor
    extends Constructor {
        private final ClassLoader classLoader;

        DelayConstructor(ClassLoader classLoader, LoaderOptions loaderOptions, boolean useCaseInsensitive) {
            super(loaderOptions);
            this.classLoader = classLoader;
            this.setPropertyUtils(new CustomPropertyUtils(useCaseInsensitive));
            ConstructDelayStrategy delayConstructor = new ConstructDelayStrategy();
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.redisson.config.EqualJitterDelay"), delayConstructor);
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.redisson.config.FullJitterDelay"), delayConstructor);
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.redisson.config.DecorrelatedJitterDelay"), delayConstructor);
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.redisson.config.ConstantDelay"), delayConstructor);
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            if (this.classLoader != null) {
                return Class.forName(name, true, this.classLoader);
            }
            return super.getClassForName(name);
        }

        private final class ConstructDelayStrategy
        extends Constructor.ConstructMapping {
            private ConstructDelayStrategy() {
                super((Constructor)DelayConstructor.this);
            }

            public Object construct(Node node) {
                Class<?> clazz;
                MappingNode mappingNode = (MappingNode)node;
                try {
                    String className = node.getTag().getValue().replace("tag:yaml.org,2002:", "");
                    clazz = DelayConstructor.this.getClassForName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                Duration baseDelay = null;
                Duration maxDelay = null;
                Duration delay = null;
                List tuples = mappingNode.getValue();
                if (tuples.isEmpty()) {
                    DelayConstructor.this.flattenMapping(mappingNode);
                    tuples = mappingNode.getValue();
                }
                if (tuples.isEmpty()) {
                    try {
                        if (clazz.getName().contains("ConstantDelay")) {
                            java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(Duration.class);
                            return constructor.newInstance(Duration.ofMillis(100L));
                        }
                        java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(Duration.class, Duration.class);
                        return constructor.newInstance(Duration.ofMillis(100L), Duration.ofSeconds(1L));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot construct " + clazz.getName() + " with empty mapping", e);
                    }
                }
                for (NodeTuple tuple : tuples) {
                    Node keyNode = tuple.getKeyNode();
                    String key = null;
                    if (keyNode instanceof ScalarNode) {
                        key = ((ScalarNode)keyNode).getValue();
                    }
                    if (key == null) continue;
                    Object value = DelayConstructor.this.constructObject(tuple.getValueNode());
                    if ("delay".equals(key)) {
                        if (value instanceof String) {
                            delay = Duration.parse((String)value);
                            continue;
                        }
                        if (!(value instanceof Duration)) continue;
                        delay = (Duration)value;
                        continue;
                    }
                    if ("baseDelay".equals(key)) {
                        if (value instanceof String) {
                            baseDelay = Duration.parse((String)value);
                            continue;
                        }
                        if (!(value instanceof Duration)) continue;
                        baseDelay = (Duration)value;
                        continue;
                    }
                    if (!"maxDelay".equals(key)) continue;
                    if (value instanceof String) {
                        maxDelay = Duration.parse((String)value);
                        continue;
                    }
                    if (!(value instanceof Duration)) continue;
                    maxDelay = (Duration)value;
                }
                try {
                    java.lang.reflect.Constructor<?> constructor;
                    if (clazz.getName().contains("ConstantDelay")) {
                        if (delay == null) {
                            throw new IllegalStateException("Missing delay for " + clazz.getName());
                        }
                        constructor = clazz.getConstructor(Duration.class);
                        return constructor.newInstance(delay);
                    }
                    if (baseDelay == null || maxDelay == null) {
                        throw new IllegalStateException("Missing baseDelay or maxDelay for " + clazz.getName() + ". Got: baseDelay=" + baseDelay + ", maxDelay=" + maxDelay);
                    }
                    constructor = clazz.getConstructor(Duration.class, Duration.class);
                    return constructor.newInstance(baseDelay, maxDelay);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to construct " + clazz.getName(), e);
                }
            }
        }
    }

    private static class CustomRepresenter
    extends Representer {
        private final Set<Class<?>> classTypedClasses = new HashSet<Class>(Arrays.asList(ReferenceCodecProvider.class, AddressResolverGroupFactory.class, Codec.class, RedissonNodeInitializer.class, LoadBalancer.class, NatMapper.class, NameMapper.class, NettyHook.class, CredentialsResolver.class, EventLoopGroup.class, ConnectionListener.class, ExecutorService.class, CommandMapper.class, FailedNodeDetector.class, DelayStrategy.class, EqualJitterDelay.class, FullJitterDelay.class, DecorrelatedJitterDelay.class, ConstantDelay.class));

        CustomRepresenter(DumperOptions dumperOptions, boolean useCaseInsensitive) {
            super(dumperOptions);
            CustomPropertyUtils propUtils = new CustomPropertyUtils(useCaseInsensitive);
            this.setPropertyUtils(propUtils);
            this.setDefaultFlowStyle(dumperOptions.getDefaultFlowStyle());
            this.multiRepresenters.remove(Set.class);
            this.addClassTag(Duration.class, Tag.STR);
            this.representers.put(Duration.class, data -> {
                Duration duration = (Duration)data;
                return this.representScalar(Tag.STR, duration.toString());
            });
            this.multiRepresenters.put(Set.class, data -> {
                Set set = (Set)data;
                ArrayList list = new ArrayList(set);
                return this.representSequence(Tag.SEQ, list, DumperOptions.FlowStyle.AUTO);
            });
            this.multiRepresenters.put(Enum.class, data -> this.representScalar(Tag.STR, ((Enum)data).name(), DumperOptions.ScalarStyle.DOUBLE_QUOTED));
            this.addClassTag(Config.class, Tag.MAP);
        }

        public Node represent(Object data) {
            if (!(data == null || data.getClass().isPrimitive() || data.getClass().isArray() || data instanceof String || data instanceof Number || data instanceof Boolean || data instanceof Duration || data instanceof Enum || data instanceof Collection || data instanceof Map)) {
                Set properties = this.getProperties(data.getClass());
                return this.representJavaBean(properties, data);
            }
            return super.represent(data);
        }

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode node = super.representJavaBean(properties, javaBean);
            if (this.shouldIncludeClassName(javaBean.getClass()) && !(javaBean instanceof Config)) {
                node.setTag(new Tag("!" + javaBean.getClass().getName()));
            }
            if (javaBean instanceof EqualJitterDelay || javaBean instanceof FullJitterDelay || javaBean instanceof DecorrelatedJitterDelay || javaBean instanceof ConstantDelay) {
                node.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            } else if (this.shouldIncludeClassName(javaBean.getClass()) && !(javaBean instanceof Config) && properties.size() <= 2 && this.hasOnlySimpleProperties(javaBean, properties)) {
                node.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            }
            return node;
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            boolean isDelayStrategy;
            if (propertyValue == null) {
                return null;
            }
            boolean bl = isDelayStrategy = javaBean instanceof EqualJitterDelay || javaBean instanceof FullJitterDelay || javaBean instanceof DecorrelatedJitterDelay || javaBean instanceof ConstantDelay;
            if (!property.isWritable() && !isDelayStrategy) {
                return null;
            }
            if (propertyValue instanceof String) {
                Node valueNode = this.representScalar(Tag.STR, (String)propertyValue, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
                Node keyNode = this.representData(property.getName());
                return new NodeTuple(keyNode, valueNode);
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        private boolean hasOnlySimpleProperties(Object javaBean, Set<Property> properties) {
            try {
                for (Property property : properties) {
                    Object value = property.get(javaBean);
                    if (value == null || this.isSimpleType(value.getClass())) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private boolean isSimpleType(Class<?> clazz) {
            return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || Duration.class.isAssignableFrom(clazz);
        }

        boolean shouldIncludeClassName(Class<?> clazz) {
            for (Class<?> classTyped : this.classTypedClasses) {
                if (!classTyped.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MethodProperty
    extends Property {
        private final Method getter;
        private final Method setter;

        MethodProperty(String name, Method getter, Method setter) {
            super(name, MethodProperty.getType(getter, setter));
            this.getter = getter;
            this.setter = setter;
            if (getter != null) {
                getter.setAccessible(true);
            }
            if (setter != null) {
                setter.setAccessible(true);
            }
        }

        private static Class<?> getType(Method getter, Method setter) {
            if (getter != null) {
                return getter.getReturnType();
            }
            if (setter != null) {
                return setter.getParameterTypes()[0];
            }
            return Object.class;
        }

        public Class<?>[] getActualTypeArguments() {
            Type returnType;
            if (this.getter != null && (returnType = this.getter.getGenericReturnType()) instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)returnType).getActualTypeArguments();
                Class[] classes = new Class[types.length];
                for (int i = 0; i < types.length; ++i) {
                    classes[i] = types[i] instanceof Class ? (Class)types[i] : Object.class;
                }
                return classes;
            }
            return new Class[0];
        }

        public void set(Object object, Object value) throws Exception {
            if (this.setter != null) {
                this.setter.invoke(object, value);
            }
        }

        public Object get(Object object) {
            if (this.getter != null) {
                try {
                    return this.getter.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to get property: " + this.getName() + " from " + object.getClass(), e);
                }
            }
            return null;
        }

        public List<Annotation> getAnnotations() {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            if (this.getter != null) {
                annotations.addAll(Arrays.asList(this.getter.getAnnotations()));
            }
            if (this.setter != null) {
                annotations.addAll(Arrays.asList(this.setter.getAnnotations()));
            }
            return annotations;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            A annotation;
            if (this.getter != null && (annotation = this.getter.getAnnotation(annotationType)) != null) {
                return annotation;
            }
            if (this.setter != null) {
                return this.setter.getAnnotation(annotationType);
            }
            return null;
        }

        public boolean isWritable() {
            return this.setter != null;
        }

        public boolean isReadable() {
            return this.getter != null;
        }
    }

    private static class CustomPropertyUtils
    extends PropertyUtils {
        private final Set<String> ignoredProperties = new HashSet<String>(Arrays.asList("slaveNotUsed", "clusterConfig", "sentinelConfig", "singleConfig", "retryInterval"));
        private final Set<Class<?>> ignoredClasses = new HashSet<Class>(Arrays.asList(KeyManagerFactory.class, TrustManagerFactory.class));
        private final boolean useCaseInsensitive;
        private final Map<Class<?>, Set<Property>> propertiesCache = new HashMap();
        private final Map<Class<?>, Set<Property>> protectedPropertiesCache = new HashMap();

        CustomPropertyUtils(boolean useCaseInsensitive) {
            this.useCaseInsensitive = useCaseInsensitive;
            this.setSkipMissingProperties(!useCaseInsensitive);
            this.setAllowReadOnlyProperties(true);
        }

        protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) {
            try {
                return super.getPropertiesMap(type, bAccess);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("No JavaBean properties found")) {
                    return new LinkedHashMap<String, Property>();
                }
                throw e;
            }
        }

        public Property getProperty(Class<?> type, String name) {
            if (this.isIgnoredProperty(name)) {
                return null;
            }
            Property property = this.findProperty(type, name, false);
            if (property == null && this.useCaseInsensitive) {
                property = this.findProperty(type, name, true);
            }
            return property;
        }

        public Property getProperty(Class<?> type, String name, BeanAccess bAccess) {
            return this.getProperty(type, name);
        }

        private boolean isIgnoredProperty(String name) {
            if (this.ignoredProperties.contains(name)) {
                return true;
            }
            if (this.useCaseInsensitive) {
                for (String ignored : this.ignoredProperties) {
                    if (!ignored.equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private Property findProperty(Class<?> type, String name, boolean caseInsensitive) {
            Set<Property> protectedProps = this.getProtectedProperties(type);
            ArrayList<Property> props = new ArrayList<Property>(protectedProps);
            Set<Property> standardProps = this.getStandardProperties(type);
            props.addAll(standardProps);
            for (Property property : props) {
                boolean matches = caseInsensitive ? property.getName().equalsIgnoreCase(name) : property.getName().equals(name);
                if (!matches || this.ignoredClasses.contains(property.getType())) continue;
                return property;
            }
            return null;
        }

        private Set<Property> getStandardProperties(Class<?> type) {
            return this.propertiesCache.computeIfAbsent(type, t -> super.createPropertySet(type, BeanAccess.DEFAULT));
        }

        private Set<Property> getProtectedProperties(Class<?> type) {
            return this.protectedPropertiesCache.computeIfAbsent(type, t -> this.discoverProtectedProperties((Class<?>)t));
        }

        protected Set<Property> createPropertySet(Class<?> type, BeanAccess bAccess) {
            LinkedHashMap<String, Property> propertyMap = new LinkedHashMap<String, Property>();
            try {
                Set properties = super.createPropertySet(type, BeanAccess.DEFAULT);
                Iterator<Object> iterator = properties.iterator();
                while (iterator.hasNext()) {
                    Property prop = (Property)iterator.next();
                    propertyMap.put(prop.getName(), prop);
                }
            }
            catch (Exception properties) {
                // empty catch block
            }
            for (Property prop : this.getProtectedProperties(type)) {
                propertyMap.putIfAbsent(prop.getName(), prop);
            }
            LinkedHashSet<Property> filtered = new LinkedHashSet<Property>();
            for (Property property : propertyMap.values()) {
                String name = property.getName();
                Class propType = property.getType();
                if (this.ignoredProperties.contains(name) || this.ignoredClasses.contains(propType) || !property.isReadable() && !property.isWritable()) continue;
                filtered.add(property);
            }
            return filtered;
        }

        private Set<Property> discoverProtectedProperties(Class<?> type) {
            LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap<String, Method> setters = new HashMap<String, Method>();
            for (Class<?> currentClass = type; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Method[] methods = currentClass.getDeclaredMethods();
                for (Method method : methods) {
                    String propertyName;
                    int modifiers = method.getModifiers();
                    boolean isAccessible = Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !Modifier.isPrivate(modifiers);
                    String name = method.getName();
                    if (name.startsWith("get") && name.length() > 3 && method.getParameterCount() == 0 && !method.getReturnType().equals(Void.TYPE) && isAccessible) {
                        propertyName = this.decapitalize(name.substring(3));
                        getters.putIfAbsent(propertyName, method);
                        continue;
                    }
                    if (name.startsWith("is") && name.length() > 2 && method.getParameterCount() == 0 && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class)) && isAccessible) {
                        propertyName = this.decapitalize(name.substring(2));
                        getters.putIfAbsent(propertyName, method);
                        continue;
                    }
                    if (!name.startsWith("set") || name.length() <= 3 || method.getParameterCount() != 1) continue;
                    propertyName = this.decapitalize(name.substring(3));
                    setters.putIfAbsent(propertyName, method);
                }
            }
            HashSet allPropertyNames = new HashSet();
            allPropertyNames.addAll(getters.keySet());
            allPropertyNames.addAll(setters.keySet());
            for (String propertyName : allPropertyNames) {
                Method getter = (Method)getters.get(propertyName);
                Method setter = (Method)setters.get(propertyName);
                if (getter == null && setter == null) continue;
                properties.add(new MethodProperty(propertyName, getter, setter));
            }
            return properties;
        }

        private String decapitalize(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            char[] chars = string.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
    }
}

