/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.client.codec.Codec;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RedissonListReactive<V> {
    private final RList<V> instance;

    public RedissonListReactive(RList<V> instance) {
        this.instance = instance;
    }

    public RedissonListReactive(CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(commandExecutor, name, null);
    }

    public RedissonListReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(codec, commandExecutor, name, null);
    }

    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        return Flux.create((Consumer)new Consumer<FluxSink<V>>(){

            @Override
            public void accept(final FluxSink<V> emitter) {
                emitter.onRequest(new LongConsumer(){
                    int currentIndex;
                    volatile boolean maxAccepted;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    public void accept(long value) {
                        if (Long.MAX_VALUE == value) {
                            this.maxAccepted = true;
                        }
                        if (this.maxAccepted && value != Long.MAX_VALUE) {
                            return;
                        }
                        this.onRequest(forward, emitter, value);
                    }

                    private void onRequest(boolean forward, FluxSink<V> emitter2, long n) {
                        RedissonListReactive.this.getAsync(this.currentIndex).whenComplete((value, e) -> {
                            if (e != null) {
                                emitter2.error(e);
                                return;
                            }
                            if (value != null) {
                                emitter2.next(value);
                                this.currentIndex = forward ? ++this.currentIndex : --this.currentIndex;
                            }
                            if (value == null) {
                                emitter2.complete();
                                return;
                            }
                            if (n - 1L == 0L) {
                                return;
                            }
                            this.onRequest(forward, emitter2, n - 1L);
                        });
                    }
                });
            }
        });
    }

    RFuture<V> getAsync(int currentIndex) {
        return this.instance.getAsync(currentIndex);
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonListReactive.this.addAsync(o);
            }
        }.addAll(c);
    }

    RFuture<Boolean> addAsync(V o) {
        return this.instance.addAsync(o);
    }
}

