/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiResourceLocator;

@PreMatching
@Priority(value=5000)
class SwaggerUiResourceFilter
implements ContainerRequestFilter {
    private static final Pattern PATTERN = Pattern.compile(".*[.]js|.*[.]gz|.*[.]map|oauth2*[.]html|.*[.]png|.*[.]css|.*[.]ico|/css/.*|/images/.*|/lib/.*|/fonts/.*");
    private final SwaggerUiResourceLocator locator;

    SwaggerUiResourceFilter(SwaggerUiResourceLocator locator) {
        this.locator = locator;
    }

    public void filter(ContainerRequestContext rc) throws IOException {
        UriInfo ui;
        String path;
        if ("GET".equals(rc.getRequest().getMethod()) && PATTERN.matcher(path = "/" + (ui = rc.getUriInfo()).getPath()).matches() && this.locator.exists(path)) {
            rc.setRequestUri(URI.create("api-docs" + path));
        }
    }
}

