/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.loader.cli;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.dynamic.CorePluginLoader;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.monitor.engine.dynamic.PluginLoader;
import org.openspcoop2.pdd.config.loader.cli.LoaderDatabaseProperties;
import org.openspcoop2.pdd.config.loader.cli.LoaderOperationType;
import org.openspcoop2.pdd.config.loader.cli.LoaderProperties;
import org.openspcoop2.pdd.config.loader.cli.LoaderRegistroPluginsService;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.registry.ConfigIntegrationReader;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ArchiveValidator;
import org.openspcoop2.protocol.engine.archive.DeleterArchiveUtils;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImporterArchiveUtils;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.core.Connettori;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiveEngine;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.slf4j.Logger;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class Loader {
    private static Logger logCore = LoggerWrapperFactory.getLogger(Loader.class);
    private static Logger logSql = LoggerWrapperFactory.getLogger(Loader.class);
    private static boolean delete = false;
    private static boolean updateAbilitato = true;
    private static ArchiveMode mode = Costanti.OPENSPCOOP_ARCHIVE_MODE;
    public static final String DS_JNDI_NAME = "org.govway.datasource.console";

    private static void logCoreDebug(String msg) {
        logCore.debug(msg);
    }

    private static void logCoreInfo(String msg) {
        logCore.info(msg);
    }

    private static void logCoreError(String msg, Exception e) {
        logCore.error(msg, (Throwable)e);
    }

    public static void main(String[] args) throws CoreException, SQLException {
        try (Connection connectionSQL = null;){
            Loader.initLogger();
            logCore = LoggerWrapperFactory.getLogger((String)"config_loader.core");
            logSql = LoggerWrapperFactory.getLogger((String)"config_loader.sql");
            Loader.logCoreDebug("Raccolta parametri in corso...");
            ArchiveModeType modeType = Costanti.OPENSPCOOP_ARCHIVE_MODE_TYPE;
            boolean validateDocuments = true;
            MapPlaceholder importInformationMissingGlobalPlaceholder = new MapPlaceholder();
            boolean showCorrelazioneAsincronaInAccordi = true;
            boolean smista = false;
            LoaderProperties loaderProperties = LoaderProperties.getInstance(logCore);
            String confDir = null;
            String protocolloDefault = loaderProperties.getProtocolloDefault();
            String userLogin = loaderProperties.getUtente();
            String utilizzoErrato = "Usage error: Loader <operationType> <archivePath>";
            if (args.length < 2 || args[0] == null || args[1] == null) {
                throw new CoreException(utilizzoErrato);
            }
            LoaderOperationType opType = Loader.parseOperationType(utilizzoErrato, args);
            switch (opType) {
                case CREATE: {
                    delete = false;
                    updateAbilitato = false;
                    break;
                }
                case CREATE_UPDATE: {
                    delete = false;
                    updateAbilitato = true;
                    break;
                }
                case DELETE: {
                    delete = true;
                    updateAbilitato = false;
                }
            }
            String filePath = args[1].trim();
            File fFilePath = new File(filePath);
            String prefix = "L'archivio indicato (" + fFilePath.getAbsolutePath() + ") ";
            if (!fFilePath.exists()) {
                throw new CoreException(prefix + "non esiste");
            }
            if (!fFilePath.canRead()) {
                throw new CoreException(prefix + "non \u00e8 accessibile");
            }
            if (!fFilePath.isFile()) {
                throw new CoreException(prefix + "non \u00e8 un file");
            }
            byte[] archiveFile = FileSystemUtilities.readBytesFromFile((File)fFilePath);
            Loader.logCoreDebug("Raccolta parametri terminata");
            Loader.initConnectorExternalResources(loaderProperties);
            Loader.disableCheckSingleConnectionDataSource();
            Loader.initMap(loaderProperties);
            if (loaderProperties.isSecurityLoadBouncyCastleProvider()) {
                Loader.initBouncyCastle();
            }
            Loader.initHsm(loaderProperties);
            BYOKManager byokManager = Loader.initBYOK(loaderProperties);
            Loader.initSecrets(loaderProperties, byokManager);
            Loader.logCoreDebug("Inizializzazione connessione database in corso...");
            LoaderDatabaseProperties databaseProperties = LoaderDatabaseProperties.getInstance();
            String tipoDatabase = databaseProperties.getTipoDatabase();
            String driver = databaseProperties.getDriver();
            String username = databaseProperties.getUsername();
            String password = databaseProperties.getPassword();
            String connectionURL = databaseProperties.getConnectionUrl();
            org.openspcoop2.utils.resources.Loader.getInstance().newInstance(driver);
            connectionSQL = username != null && password != null ? DriverManager.getConnection(connectionURL, username, password) : DriverManager.getConnection(connectionURL);
            try (SingleConnectionDataSource ds = new SingleConnectionDataSource(connectionSQL, true);){
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
                Loader.bindDatasource((DataSource)ds, DS_JNDI_NAME);
                Loader.logCoreDebug("Inizializzazione connessione database terminata");
                Loader.logCoreDebug("Inizializzazione risorse libreria in corso...");
                ConfigurazionePdD configPdD = Loader.initProtocolFactory(protocolloDefault);
                Loader.initExtendedInfoManager();
                Loader.initCorePluginLoader(configPdD, loaderProperties, databaseProperties);
                Properties p = new Properties();
                p.put("dataSource", DS_JNDI_NAME);
                p.put("tipoDatabase", tipoDatabase);
                if (!DatasourceProperties.initialize((Properties)p, (Logger)logCore)) {
                    throw new CoreException("Inizializzazione fallita");
                }
                Loader.initUtenze(loaderProperties);
                Loader.initConnettori(confDir, protocolloDefault);
                Loader.logCoreDebug("Inizializzazione risorse libreria terminata");
                Loader.logCoreDebug("Inizializzazione driver ...");
                DriverConfigurazioneDB driverConfigDB = new DriverConfigurazioneDB(connectionSQL, logSql, tipoDatabase);
                DriverRegistroServiziDB driverRegistroDB = new DriverRegistroServiziDB(connectionSQL, logSql, tipoDatabase);
                RegistryReader registryReader = new RegistryReader((IDriverRegistroServiziGet)driverRegistroDB, logSql);
                ConfigIntegrationReader configReader = new ConfigIntegrationReader((IDriverConfigurazioneGet)driverConfigDB, logSql);
                ServiceManagerProperties propertiesPlugins = new ServiceManagerProperties();
                propertiesPlugins.setDatabaseType(tipoDatabase);
                propertiesPlugins.setShowSql(true);
                JDBCServiceManager jdbcServiceManagerPlugins = new JDBCServiceManager(connectionSQL, propertiesPlugins, logSql);
                ServiceManagerProperties propertiesControlloTraffico = new ServiceManagerProperties();
                propertiesControlloTraffico.setDatabaseType(tipoDatabase);
                propertiesControlloTraffico.setShowSql(true);
                org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager jdbcServiceManagerControlloTraffico = new org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager(connectionSQL, propertiesControlloTraffico, logSql);
                ServiceManagerProperties propertiesAllarmi = new ServiceManagerProperties();
                propertiesAllarmi.setDatabaseType(tipoDatabase);
                propertiesAllarmi.setShowSql(true);
                org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager jdbcServiceManagerAllarmi = new org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager(connectionSQL, propertiesAllarmi, logSql);
                ControlStationCore core = new ControlStationCore(true, null, protocolloDefault);
                ArchiviCore archiviCore = new ArchiviCore(core);
                ArchiveEngine importerEngine = new ArchiveEngine(driverRegistroDB, driverConfigDB, jdbcServiceManagerPlugins, jdbcServiceManagerControlloTraffico, jdbcServiceManagerAllarmi, archiviCore, smista, userLogin);
                Loader.logCoreDebug("Inizializzazione driver terminata");
                Loader.logCoreInfo("Inizializzazione engine terminata");
                Loader.logCoreInfo("Lettura archivio ...");
                IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloDefault);
                IArchive archiveEngine = pf.createArchive();
                Archive archive = archiveEngine.importArchive(archiveFile, mode, modeType, (IRegistryReader)registryReader, (IConfigIntegrationReader)configReader, validateDocuments, importInformationMissingGlobalPlaceholder);
                Loader.logCoreInfo("Lettura archivio effettuata");
                Loader.logCoreInfo("Validazione archivio ...");
                ArchiveValidator validator = new ArchiveValidator((IRegistryReader)registryReader);
                ImportInformationMissingCollection importInformationMissingCollection = new ImportInformationMissingCollection();
                validator.validateArchive(archive, protocolloDefault, validateDocuments, importInformationMissingCollection, userLogin, showCorrelazioneAsincronaInAccordi, delete);
                Loader.logCoreInfo("Validazione archivio effettuata");
                Loader.logCoreInfo("Finalizzazione archivio ...");
                archiveEngine.finalizeImportArchive(archive, mode, modeType, (IRegistryReader)registryReader, (IConfigIntegrationReader)configReader, validateDocuments, importInformationMissingGlobalPlaceholder);
                Loader.logCoreInfo("Finalizzazione archivio effettuata");
                Loader.process(importerEngine, userLogin, loaderProperties, archiveEngine, archive);
            }
        }
    }

    private static void process(ArchiveEngine importerEngine, String userLogin, LoaderProperties loaderProperties, IArchive archiveEngine, Archive archive) throws Exception {
        boolean importDeletePolicyConfig = loaderProperties.isPolicyEnable();
        boolean importDeletePluginConfig = loaderProperties.isPluginEnable();
        boolean importCheckPluginReferences = loaderProperties.isPluginCheckReferences();
        boolean importConfig = loaderProperties.isConfigurazioneGeneraleEnable();
        boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto = loaderProperties.isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto();
        boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto = loaderProperties.isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto();
        boolean isSoggettiApplicativiCredenzialiBasicPermitSameCredentials = loaderProperties.isSoggettiApplicativiCredenzialiBasicPermitSameCredentials();
        boolean isSoggettiApplicativiCredenzialiSslPermitSameCredentials = loaderProperties.isSoggettiApplicativiCredenzialiSslPermitSameCredentials();
        boolean isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials = loaderProperties.isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials();
        String importNomePddOperativa = loaderProperties.getNomePddOperativa();
        String importTipoPddArchivi = loaderProperties.getTipoPddArchivio();
        boolean isShowGestioneWorkflowStatoDocumenti = false;
        boolean isShowAccordiColonnaAzioni = false;
        String esito = null;
        if (delete) {
            Loader.logCoreInfo("Eliminazione in corso ...");
            DeleterArchiveUtils deleterArchiveUtils = new DeleterArchiveUtils((AbstractArchiveEngine)importerEngine, logCore, userLogin, importDeletePolicyConfig, importDeletePluginConfig);
            ArchiveEsitoDelete esitoDelete = deleterArchiveUtils.deleteArchive(archive, userLogin);
            esito = archiveEngine.toString(esitoDelete, mode);
            Loader.logCoreInfo("Eliminazione completata");
        } else {
            Loader.logCoreInfo("Importazione (aggiornamento:" + updateAbilitato + ") in corso ...");
            ImporterArchiveUtils importerArchiveUtils = new ImporterArchiveUtils((AbstractArchiveEngine)importerEngine, logCore, userLogin, importNomePddOperativa, importTipoPddArchivi, isShowGestioneWorkflowStatoDocumenti, updateAbilitato, importDeletePolicyConfig, importDeletePluginConfig, importCheckPluginReferences, importConfig);
            ArchiveEsitoImport esitoImport = importerArchiveUtils.importArchive(archive, userLogin, isShowAccordiColonnaAzioni, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, isSoggettiApplicativiCredenzialiSslPermitSameCredentials, isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials);
            esito = archiveEngine.toString(esitoImport, mode);
            Loader.logCoreInfo("Importazione (aggiornamento:" + updateAbilitato + ") completata");
        }
        Loader.logCoreInfo("Operazione terminata con esito:\n" + esito);
    }

    private static void initLogger() throws CoreException {
        Properties propertiesLog4j = new Properties();
        try (InputStream inPropLog4j = Loader.class.getResourceAsStream("/config_loader.cli.log4j2.properties");){
            propertiesLog4j.load(inPropLog4j);
            PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)propertiesLog4j);
            LoggerWrapperFactory.setLogConfiguration((Properties)propertiesLog4j);
        }
        catch (Exception e) {
            throw new CoreException("Impossibile leggere i dati dal file 'config_loader.cli.log4j2.properties': " + e.getMessage());
        }
    }

    private static LoaderOperationType parseOperationType(String utilizzoErrato, String[] args) throws CoreException {
        LoaderOperationType opType = null;
        try {
            opType = LoaderOperationType.toEnumConstant(args[0].trim(), true);
        }
        catch (Exception e) {
            throw new CoreException(utilizzoErrato + "\nIl tipo di operazione indicato (" + args[0].trim() + ") non \u00e8 gestito, valori ammessi: " + LoaderOperationType.CREATE.getValue() + "," + LoaderOperationType.CREATE_UPDATE.getValue() + "," + LoaderOperationType.DELETE.getValue());
        }
        return opType;
    }

    private static InitialContext bindDatasource(DataSource ds, String jndiName) throws NamingException {
        InitialContext ic = new InitialContext();
        try {
            ic.bind(jndiName, (Object)ds);
        }
        catch (NameAlreadyBoundException already) {
            logSql.debug("Bind failed: " + already.getMessage(), (Throwable)already);
        }
        boolean notFoundJava = false;
        try {
            ic.createSubcontext("java:");
        }
        catch (NameNotFoundException notFound) {
            notFoundJava = true;
            logSql.debug("CreateSubcontex java notFound: " + notFound.getMessage(), (Throwable)notFound);
        }
        catch (NameAlreadyBoundException already) {
            logSql.debug("CreateSubcontext java failed: " + already.getMessage(), (Throwable)already);
        }
        try {
            ic.createSubcontext("java:/comp");
        }
        catch (NameNotFoundException notFound) {
            notFoundJava = true;
            logSql.debug("CreateSubcontex comp notFound: " + notFound.getMessage(), (Throwable)notFound);
        }
        catch (NameAlreadyBoundException already) {
            logSql.debug("CreateSubcontext comp failed: " + already.getMessage(), (Throwable)already);
        }
        try {
            ic.createSubcontext("java:/comp/env");
        }
        catch (NameNotFoundException notFound) {
            notFoundJava = true;
            logSql.debug("CreateSubcontext comp/env notFound: " + notFound.getMessage(), (Throwable)notFound);
        }
        catch (NameAlreadyBoundException already) {
            logSql.debug("CreateSubcontext comp/env failed: " + already.getMessage(), (Throwable)already);
        }
        if (!notFoundJava) {
            try {
                ic.bind("java:/comp/env/" + jndiName, (Object)ds);
            }
            catch (NameAlreadyBoundException already) {
                logSql.debug("Bind comp failed: " + already.getMessage(), (Throwable)already);
            }
        }
        return ic;
    }

    private static void initBouncyCastle() throws CoreException {
        try {
            ProviderUtils.addBouncyCastleAfterSun((boolean)true);
            Loader.logCoreInfo("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private static void initConnectorExternalResources(LoaderProperties properties) throws CoreException {
        try {
            if (properties.getHttpLibrary() != null) {
                HttpLibraryConnection.setDefaultLibrary((HttpLibrary)properties.getHttpLibrary());
            }
            logCore.info("HttpLibraryConnection: {}", (Object)HttpLibraryConnection.getDefaultLibrary());
        }
        catch (Exception e) {
            Loader.doError("Inizializzazione libreria accesso risorse esterne non riuscita", e);
        }
    }

    private static void disableCheckSingleConnectionDataSource() throws CoreException {
        try {
            Logger logR = logSql;
            ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)false, (boolean)false);
            DriverControlStationDB.setCheckLogger((Logger)logR);
            DriverControlStationDB.setCheckIsClosed((boolean)false);
            DriverControlStationDB.setCheckAutocommit((boolean)false);
            DBManager.setCheckLogger((Logger)logR);
            DBManager.setCheckIsClosed((boolean)false);
            DBManager.setCheckAutocommit((boolean)false);
        }
        catch (Exception e) {
            Loader.doError("Inizializzazione controlli connessione non riuscita", e);
        }
    }

    private static void initMap(LoaderProperties loaderProperties) throws CoreException {
        try {
            String mapConfig = loaderProperties.getEnvMapConfig();
            if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
                Loader.logCoreInfo("Inizializzazione environment in corso...");
                MapProperties.initialize((Logger)logCore, (String)mapConfig, (boolean)loaderProperties.isEnvMapConfigRequired());
                MapProperties mapProperties = MapProperties.getInstance();
                mapProperties.initEnvironment();
                String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
                Loader.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            Loader.doError("Errore durante l'inizializzazione dell'ambiente", e);
        }
    }

    private static void initHsm(LoaderProperties loaderProperties) throws CoreException {
        try {
            String hsmConfig = loaderProperties.getHSMConfigurazione();
            if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
                Loader.logCoreInfo("Inizializzazione HSM in corso...");
                File f = new File(hsmConfig);
                HSMManager.init((File)f, (boolean)loaderProperties.isHSMRequired(), (Logger)logCore, (boolean)false);
                HSMUtils.setHsmConfigurableKeyPassword((boolean)loaderProperties.isHSMKeyPasswordConfigurable());
                Loader.logCoreInfo("Inizializzazione HSM effettuata con successo");
            }
        }
        catch (Exception e) {
            Loader.doError("Errore durante l'inizializzazione del manager HSM", e);
        }
    }

    private static BYOKManager initBYOK(LoaderProperties loaderProperties) throws CoreException {
        BYOKManager byokManager = null;
        try {
            String byokConfig = loaderProperties.getBYOKConfigurazione();
            if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
                Loader.logCoreInfo("Inizializzazione BYOK in corso...");
                File f = new File(byokConfig);
                BYOKManager.init((File)f, (boolean)loaderProperties.isBYOKRequired(), (Logger)logCore);
                byokManager = BYOKManager.getInstance();
                String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                Loader.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            Loader.doError("Errore durante l'inizializzazione del manager BYOK", e);
        }
        return byokManager;
    }

    private static void initSecrets(LoaderProperties loaderProperties, BYOKManager byokManager) throws CoreException {
        try {
            String secretsConfig = loaderProperties.getBYOKEnvSecretsConfig();
            if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
                Loader.logCoreInfo("Inizializzazione secrets in corso...");
                HashMap dynamicMap = new HashMap();
                DynamicInfo dynamicInfo = new DynamicInfo();
                DynamicUtils.fillDynamicMap((Logger)logCore, dynamicMap, (DynamicInfo)dynamicInfo);
                BYOKMapProperties.initialize((Logger)logCore, (String)secretsConfig, (boolean)loaderProperties.isBYOKEnvSecretsConfigRequired(), (boolean)true, dynamicMap, (boolean)true);
                BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                secretsProperties.initEnvironment();
                String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                Loader.logCoreInfo(msgInit);
            }
        }
        catch (Exception e) {
            Loader.doError("Errore durante l'inizializzazione dell'ambiente (secrets)", e);
        }
    }

    private static ConfigurazionePdD initProtocolFactory(String protocolloDefault) throws CoreException {
        ConfigurazionePdD configPdD = null;
        try {
            configPdD = new ConfigurazionePdD();
            configPdD.setAttesaAttivaJDBC(-1L);
            configPdD.setCheckIntervalJDBC(-1);
            configPdD.setLoader(new org.openspcoop2.utils.resources.Loader(Loader.class.getClassLoader()));
            configPdD.setLog(logCore);
            ProtocolFactoryManager.initialize((Logger)logCore, (ConfigurazionePdD)configPdD, (String)protocolloDefault);
        }
        catch (Exception e) {
            throw new CoreException("Errore (InitConfigurazione - ProtocolFactoryManager): " + e.getMessage(), (Throwable)e);
        }
        return configPdD;
    }

    private static void initExtendedInfoManager() throws CoreException {
        try {
            ExtendedInfoManager.initialize((org.openspcoop2.utils.resources.Loader)new org.openspcoop2.utils.resources.Loader(Loader.class.getClassLoader()), null, null, null);
        }
        catch (Exception e) {
            throw new CoreException("Inizializzazione [ExtendedInfoManager] fallita", (Throwable)e);
        }
    }

    private static void initCorePluginLoader(ConfigurazionePdD configPdD, LoaderProperties loaderProperties, LoaderDatabaseProperties databaseProperties) throws CoreException {
        try {
            CorePluginLoader.initialize((org.openspcoop2.utils.resources.Loader)configPdD.getLoader(), (Logger)logSql, PluginLoader.class, (IRegistroPluginsReader)new LoaderRegistroPluginsService(logSql, databaseProperties), (int)loaderProperties.getPluginSeconds());
        }
        catch (Exception e) {
            throw new CoreException("Inizializzazione [PluginManager] fallita", (Throwable)e);
        }
    }

    private static void initUtenze(LoaderProperties loaderProperties) throws CoreException {
        try {
            CryptConfig utenzeCryptConfig = new CryptConfig(loaderProperties.getUtenzePassword());
            CryptConfig applicativiCryptConfig = new CryptConfig(loaderProperties.getApplicativiPassword());
            int applicativiApiKeyPasswordGeneratedLength = loaderProperties.getApplicativiApiKeyPasswordGeneratedLength();
            boolean applicativiBasicPasswordEnableConstraints = loaderProperties.isApplicativiBasicPasswordEnableConstraints();
            CryptConfig soggettiCryptConfig = new CryptConfig(loaderProperties.getSoggettiPassword());
            int soggettiApiKeyPasswordGeneratedLength = loaderProperties.getSoggettiApiKeyPasswordGeneratedLength();
            boolean soggettiBasicPasswordEnableConstraints = loaderProperties.isSoggettiBasicPasswordEnableConstraints();
            ControlStationCore.setUtenzePasswordEncryptEngineApiMode((CryptConfig)utenzeCryptConfig);
            ControlStationCore.setApplicativiPasswordEncryptEngineApiMode((CryptConfig)applicativiCryptConfig);
            ControlStationCore.setApplicativiApiKeyPasswordGeneratedLengthApiMode((Integer)applicativiApiKeyPasswordGeneratedLength);
            if (applicativiBasicPasswordEnableConstraints) {
                PasswordVerifier applicativiPasswordVerifier = new PasswordVerifier("/org/openspcoop2/utils/crypt/consolePassword.properties");
                ControlStationCore.setApplicativiPasswordVerifierEngineApiMode((PasswordVerifier)applicativiPasswordVerifier);
            }
            ControlStationCore.setSoggettiPasswordEncryptEngineApiMode((CryptConfig)soggettiCryptConfig);
            ControlStationCore.setSoggettiApiKeyPasswordGeneratedLengthApiMode((Integer)soggettiApiKeyPasswordGeneratedLength);
            if (soggettiBasicPasswordEnableConstraints) {
                PasswordVerifier soggettiPasswordVerifier = new PasswordVerifier("/org/openspcoop2/utils/crypt/consolePassword.properties");
                ControlStationCore.setSoggettiPasswordVerifierEngineApiMode((PasswordVerifier)soggettiPasswordVerifier);
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private static void initConnettori(String confDir, String protocolloDefault) throws CoreException {
        try {
            Connettori.initialize((Logger)logCore, (boolean)true, (String)confDir, (String)protocolloDefault);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    private static void doError(String msg, Exception e) throws CoreException {
        String msgErrore = msg + ": " + e.getMessage();
        Loader.logCoreError(msgErrore, e);
        throw new CoreException(msgErrore, (Throwable)e);
    }
}

