/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.loader.cli;

import java.sql.Connection;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.dynamic.IRegistroPluginsReader;
import org.openspcoop2.pdd.config.loader.cli.LoaderDatabaseProperties;
import org.slf4j.Logger;

public class LoaderRegistroPluginsService
implements IRegistroPluginsReader {
    private static final String ERROR_PREFIX = "Errore durante la creazione del Service: ";
    private DriverConfigurazioneDB driverConfigDB = null;

    public LoaderRegistroPluginsService(Logger log, LoaderDatabaseProperties databaseProperties) {
        try {
            this.initEngine(null, databaseProperties, null, log);
        }
        catch (Exception e) {
            String msgError = ERROR_PREFIX + e.getMessage();
            log.error(msgError, (Throwable)e);
        }
    }

    public LoaderRegistroPluginsService(Connection con, boolean autoCommit, LoaderDatabaseProperties databaseProperties, Logger log) {
        try {
            if (autoCommit) {
                // empty if block
            }
            this.initEngine(con, databaseProperties, null, log);
        }
        catch (Exception e) {
            log.error(ERROR_PREFIX + e.getMessage(), (Throwable)e);
        }
    }

    public LoaderRegistroPluginsService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            if (autoCommit) {
                // empty if block
            }
            this.initEngine(con, null, serviceManagerProperties, log);
        }
        catch (Exception e) {
            log.error(ERROR_PREFIX + e.getMessage(), (Throwable)e);
        }
    }

    private void initEngine(Connection con, LoaderDatabaseProperties databaseProperties, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            String tipoDatabase = null;
            tipoDatabase = serviceManagerProperties != null ? serviceManagerProperties.getDatabaseType() : databaseProperties.getTipoDatabase();
            if (con != null) {
                this.driverConfigDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
            } else {
                Properties datasourceJNDIContext = new Properties();
                datasourceJNDIContext.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                datasourceJNDIContext.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
                this.driverConfigDB = new DriverConfigurazioneDB("org.govway.datasource.console", datasourceJNDIContext, log, tipoDatabase);
            }
        }
        catch (Exception e) {
            log.error(ERROR_PREFIX + e.getMessage(), (Throwable)e);
        }
    }

    public RegistroPlugins getRegistroPlugins() throws NotFoundException, CoreException {
        try {
            return this.driverConfigDB.getRegistroPlugins();
        }
        catch (DriverConfigurazioneNotFound notFound) {
            throw new NotFoundException(notFound.getMessage(), (Throwable)notFound);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }
}

