/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;

public class VaultEncDecConfig {
    public static final String SYSTEM_IN = "-system_in";
    public static final String SYSTEM_OUT = "-system_out";
    public static final String FILE_IN = "-file_in";
    public static final String FILE_OUT = "-file_out";
    public static final String SECURITY = "-sec";
    public static final String KMS = "-kms";
    public static final String KSM_DEPRECATED = "-ksm";
    private static final String UNKNOW_OPTION = "(unknown option '";
    private boolean encodingMode = false;
    private boolean inSystemMode = false;
    private String inText = null;
    private boolean inFileMode = false;
    private String inFilePath = null;
    private boolean outSystemMode = false;
    private boolean outFileMode = false;
    private String outFilePath = null;
    private boolean securityMode = true;
    private boolean kmsMode = false;
    private String id = null;

    public static String getUsage() {
        return "-system_in|-file_in=text|path -system_out|-file_out=path [-sec|-kms=id]";
    }

    public VaultEncDecConfig(String[] args, String utilizzoErrato, boolean encodingMode) throws CoreException {
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new CoreException(utilizzoErrato);
        }
        this.encodingMode = encodingMode;
        this.parseFirstArgument(args, utilizzoErrato);
        this.parseSecondArgument(args, utilizzoErrato);
        if (args.length > 2 && args[2] != null) {
            this.parseThirdArgument(args, utilizzoErrato);
        }
    }

    private void parseFirstArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[0].contains("=")) {
            throw new CoreException("(= not found in first param '" + args[0] + "') " + utilizzoErrato);
        }
        if (args[0].startsWith("-system_in=") && args[0].length() > "-system_in=".length()) {
            this.inSystemMode = true;
            this.inText = args[0].substring("-system_in=".length());
        } else if (args[0].startsWith("-file_in=") && args[0].length() > "-file_in=".length()) {
            this.parseFirstArgumentFile(args, utilizzoErrato);
        } else {
            throw new CoreException(UNKNOW_OPTION + args[0] + "') " + utilizzoErrato);
        }
    }

    private void parseFirstArgumentFile(String[] args, String utilizzoErrato) throws CoreException {
        this.inFileMode = true;
        this.inFilePath = args[0].substring("-file_in=".length());
        File fFilePath = new File(this.inFilePath);
        String prefix = "(File '" + fFilePath.getAbsolutePath() + "' ";
        if (!fFilePath.exists()) {
            throw new CoreException(prefix + "not exists) " + utilizzoErrato);
        }
        if (!fFilePath.canRead()) {
            throw new CoreException(prefix + "cannot read) " + utilizzoErrato);
        }
        if (!fFilePath.isFile()) {
            throw new CoreException(prefix + "is not a file) " + utilizzoErrato);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSecondArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[1].contains("=")) {
            if (!SYSTEM_OUT.equals(args[1])) throw new CoreException("(= not found in second param '" + args[1] + "') " + utilizzoErrato);
            this.outSystemMode = true;
            return;
        } else {
            if (!args[1].startsWith("-file_out=") || args[1].length() <= "-file_out=".length()) throw new CoreException(UNKNOW_OPTION + args[1] + "') " + utilizzoErrato);
            this.outFileMode = true;
            this.outFilePath = args[1].substring("-file_out=".length());
            File fFilePath = new File(this.outFilePath);
            String prefix = "(File '" + fFilePath.getAbsolutePath() + "' ";
            if (!fFilePath.exists()) return;
            throw new CoreException(prefix + "already exists) " + utilizzoErrato);
        }
    }

    private void parseThirdArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[2].contains("=")) {
            throw new CoreException("(= not found in third param '" + args[2] + "') " + utilizzoErrato);
        }
        if (args[2].startsWith("-sec=") && args[2].length() > "-sec=".length()) {
            this.securityMode = true;
            this.id = args[2].substring("-sec=".length());
        } else if (args[2].startsWith("-kms=") && args[2].length() > "-kms=".length()) {
            this.securityMode = false;
            this.kmsMode = true;
            this.id = args[2].substring("-kms=".length());
        } else if (args[2].startsWith("-ksm=") && args[2].length() > "-ksm=".length()) {
            this.securityMode = false;
            this.kmsMode = true;
            this.id = args[2].substring("-ksm=".length());
        } else {
            throw new CoreException(UNKNOW_OPTION + args[2] + "') " + utilizzoErrato);
        }
    }

    public boolean isEncode() {
        return this.encodingMode;
    }

    public boolean isInSystemMode() {
        return this.inSystemMode;
    }

    public String getInText() {
        return this.inText;
    }

    public boolean isInFileMode() {
        return this.inFileMode;
    }

    public String getInFilePath() {
        return this.inFilePath;
    }

    public boolean isOutSystemMode() {
        return this.outSystemMode;
    }

    public boolean isOutFileMode() {
        return this.outFileMode;
    }

    public String getOutFilePath() {
        return this.outFilePath;
    }

    public boolean isSecurityMode() {
        return this.securityMode;
    }

    public boolean isKmsMode() {
        return this.kmsMode;
    }

    public String getId() {
        return this.id;
    }

    public void validate(BYOKManager byokManager) throws CoreException {
        String kmsPrefix = "Kms '";
        if (this.securityMode) {
            this.validateSecurityMode(byokManager);
        }
        if (this.kmsMode && !byokManager.existsKMSConfigByType(this.id)) {
            throw new CoreException(kmsPrefix + this.id + "' not exists");
        }
        if (this.kmsMode && !this.encodingMode && !byokManager.getUnwrapTypes().contains(this.id)) {
            throw new CoreException(kmsPrefix + this.id + "' unusable for unwrap operation");
        }
        if (this.kmsMode && this.encodingMode && !byokManager.getWrapTypes().contains(this.id)) {
            throw new CoreException(kmsPrefix + this.id + "' unusable for wrap operation");
        }
    }

    public void validateSecurityMode(BYOKManager byokManager) throws CoreException {
        String policy = this.id;
        if (policy == null || StringUtils.isEmpty((CharSequence)policy)) {
            policy = BYOKManager.getSecurityRemoteEngineGovWayPolicy();
        }
        if (policy == null || StringUtils.isEmpty((CharSequence)policy)) {
            policy = BYOKManager.getSecurityEngineGovWayPolicy();
        }
        if (policy == null || StringUtils.isEmpty((CharSequence)policy)) {
            throw new CoreException("Security policy default undefined (BYOK Disabled?)");
        }
        if (!byokManager.existsSecurityEngineByType(policy)) {
            throw new CoreException("Security policy '" + policy + "' not found");
        }
    }
}

