/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.template_scan.cli;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.template_scan.cli.ScanResult;
import org.openspcoop2.pdd.template_scan.cli.TemplateScanProperties;
import org.openspcoop2.pdd.template_scan.cli.TreePath;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class TemplateScan {
    private static Logger log = LoggerWrapperFactory.getLogger(TemplateScan.class);
    private static Logger logSql = LoggerWrapperFactory.getLogger(TemplateScan.class);
    private static final String TEMPLATE_ATTR = "template";
    private static final String NAME_ATTR = "name";
    private static final String TRANS_NAME = "trans_name";
    private static final String SERVICE_NAME = "service_name";
    private static final String SERVICE_VERSION = "service_version";
    private static final String SUBJECT_NAME = "subject_name";
    private static final String EROGATOR_NAME = "erogator_name";
    private static final String IS_DEFAULT = "is_default";
    private static final String GROUP_NAME = "group_name";
    public static final String DS_JNDI_NAME = "org.govway.datasource.console";
    private TreeMap<TreePath, ScanResult> results = new TreeMap();

    public static void main(String[] args) throws CoreException, SQLException {
        try (Connection con = null;){
            TemplateScan.initLogger();
            log = LoggerWrapperFactory.getLogger((String)"template_scan.core");
            logSql = LoggerWrapperFactory.getLogger((String)"template_scan.sql");
            log.debug("Raccolta parametri in corso...");
            TemplateScanProperties properties = TemplateScanProperties.getInstance();
            if (args.length < 1) {
                throw new IllegalStateException("Richiesto almeno un parametro, il pattern da ricercare");
            }
            Pattern regex = Pattern.compile(args[0]);
            log.debug("Raccolta parametri terminata");
            log.debug("Inizializzazione connessione database in corso...");
            String driver = properties.getDbDriver();
            String username = properties.getDbUsername();
            String password = properties.getDbPassword();
            String connectionURL = properties.getDbUrl();
            Loader.getInstance().newInstance(driver);
            con = username != null && password != null ? DriverManager.getConnection(connectionURL, username, password) : DriverManager.getConnection(connectionURL);
            log.info("Inizializzazione effettuata avvio la ricerca...");
            TemplateScan instance = new TemplateScan();
            instance.process(regex, properties, con);
            log.info("completato con successo");
        }
    }

    private void process(Pattern regex, TemplateScanProperties properties, Connection con) throws SQLQueryObjectException, SQLException, DriverRegistroServiziException {
        log.info("Ricerca del pattern: {}, all'interno del db", (Object)regex);
        if (properties.isEnableTransformationRequest()) {
            this.processTemplateRequest(false, regex, properties, con);
            this.processTemplateRequest(true, regex, properties, con);
        }
        if (properties.isEnableTransformationResponse()) {
            this.processTemplateResponse(false, regex, properties, con);
            this.processTemplateResponse(true, regex, properties, con);
        }
        if (properties.isEnableConnectors()) {
            this.processTemplatePAConnectors(regex, properties, con);
        }
        if (properties.isEnableTokenPolicy() || properties.isEnableAtttributeAuthority()) {
            this.processTemplateGenericProperties(regex, properties, con);
        }
        log.info("Risultati individuati: {}", (Object)this.results.size());
        this.print();
    }

    private void print() {
        this.results.forEach((k, v) -> System.out.println(String.valueOf(k) + ": {" + String.valueOf(v) + "}"));
    }

    private String color(String text) {
        return "\u001b[1;34m" + text + "\u001b[0m";
    }

    private TreePath convertPortName(IDServizio idServizio, IDSoggetto fruitore, String group) {
        TreePath path = TreePath.of(this.color((String)(fruitore == null ? "" : fruitore.getNome() + "->") + idServizio.getNome() + "@" + idServizio.getSoggettoErogatore().getNome() + " v" + idServizio.getVersione()));
        path.add("Configurazione");
        if (group != null) {
            path.add(group);
        }
        return path;
    }

    private void processTemplateRequest(boolean isPA, Pattern regex, TemplateScanProperties props, Connection con) throws SQLQueryObjectException, SQLException, DriverRegistroServiziException {
        log.debug("Eseguo ricerca dei template sulle trasformazioni della richiesta, porta applicativa: {}", (Object)isPA);
        String portTable = isPA ? "porte_applicative" : "porte_delegate";
        String transformTable = isPA ? "pa_transform" : "pd_transform";
        String columnTemplate = isPA ? "req_conversione_template" : "req_conversione_template";
        String columnName = isPA ? "nome_porta" : "nome_porta";
        String columnPortId = isPA ? "id_porta" : "id_porta";
        String consoleSegment = isPA ? "Erogazioni" : "Fruizioni";
        String mappingPort = isPA ? "mapping_erogazione_pa" : "mapping_fruizione_pd";
        String columnService = isPA ? "servizio" : "nome_servizio";
        ISQLQueryObject sqlObject = SQLObjectFactory.createSQLQueryObject((String)props.getDbType());
        sqlObject.addSelectAliasField("p." + columnName, NAME_ATTR);
        sqlObject.addSelectAliasField("t.nome", TRANS_NAME);
        sqlObject.addSelectAliasField("t." + columnTemplate, TEMPLATE_ATTR);
        sqlObject.addSelectAliasField("p." + columnService, SERVICE_NAME);
        sqlObject.addSelectAliasField("p.tipo_servizio", "tipo");
        sqlObject.addSelectAliasField("p.versione_servizio", SERVICE_VERSION);
        sqlObject.addSelectAliasField("sogg.nome_soggetto", SUBJECT_NAME);
        sqlObject.addSelectAliasField("mapp.nome", GROUP_NAME);
        sqlObject.addSelectAliasField("mapp.is_default", IS_DEFAULT);
        if (!isPA) {
            sqlObject.addSelectAliasField("p.nome_soggetto_erogatore", EROGATOR_NAME);
        } else {
            sqlObject.addSelectAliasField("sogg.nome_soggetto", EROGATOR_NAME);
        }
        sqlObject.addFromTable(portTable, "p");
        sqlObject.addFromTable(transformTable, "t");
        sqlObject.addFromTable("soggetti", "sogg");
        sqlObject.addFromTable(mappingPort, "mapp");
        sqlObject.setANDLogicOperator(true);
        sqlObject.addWhereIsNotNullCondition("t." + columnTemplate);
        sqlObject.addWhereCondition("p.id = t." + columnPortId);
        sqlObject.addWhereCondition("sogg.id = p.id_soggetto");
        sqlObject.addWhereCondition("p.id = mapp.id_porta");
        String query = sqlObject.createSQLQuery();
        logSql.debug("Eseguo query, porta applicativa: {}, Trasformazioni richiesta, query: {}", (Object)isPA, (Object)query);
        try (PreparedStatement stmt = con.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String nomeErogatore = rs.getString(EROGATOR_NAME);
                String nomeSoggetto = rs.getString(SUBJECT_NAME);
                String tipo = rs.getString("tipo");
                String group = rs.getBoolean(IS_DEFAULT) ? null : rs.getString(GROUP_NAME);
                IDSoggetto erogatore = new IDSoggetto(tipo, nomeErogatore);
                IDSoggetto fruitore = new IDSoggetto(tipo, nomeSoggetto);
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo, rs.getString(SERVICE_NAME), erogatore, rs.getInt(SERVICE_VERSION));
                InputStream template = rs.getBinaryStream(TEMPLATE_ATTR);
                TreePath key = TreePath.of("Registro", consoleSegment).add(this.convertPortName(idServizio, isPA ? null : fruitore, group)).add("Transformazioni").add(this.color(rs.getString(TRANS_NAME))).add("Richiesta").add("Contenuto");
                ScanResult.parse(template, regex).ifPresent(sc -> this.results.put(key, (ScanResult)sc));
            }
        }
    }

    private void parseTemplateResponseResultSet(Pattern regex, boolean isPA, ISQLQueryObject sqlObject, Connection con) throws SQLException, SQLQueryObjectException, DriverRegistroServiziException {
        String query = sqlObject.createSQLQuery();
        String consoleSegment = isPA ? "Erogazioni" : "Fruizioni";
        logSql.debug("Eseguo query, porta applicativa: {}, Trasformazioni risposta, query: {}", (Object)isPA, (Object)query);
        try (PreparedStatement stmt = con.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String nomeErogatore = rs.getString(EROGATOR_NAME);
                String nomeSoggetto = rs.getString(SUBJECT_NAME);
                String tipo = rs.getString("tipo");
                String group = rs.getBoolean(IS_DEFAULT) ? null : rs.getString(GROUP_NAME);
                IDSoggetto erogatore = new IDSoggetto(tipo, nomeErogatore);
                IDSoggetto fruitore = new IDSoggetto(tipo, nomeSoggetto);
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo, rs.getString(SERVICE_NAME), erogatore, rs.getInt(SERVICE_VERSION));
                InputStream template = rs.getBinaryStream(TEMPLATE_ATTR);
                TreePath key = TreePath.of("Registro", consoleSegment).add(this.convertPortName(idServizio, isPA ? null : fruitore, group)).add("Transformazioni").add(this.color(rs.getString(TRANS_NAME))).add("Risposte").add(this.color(rs.getString("resp_name"))).add("Contenuto");
                ScanResult.parse(template, regex).ifPresent(sc -> this.results.put(key, (ScanResult)sc));
            }
        }
    }

    private void processTemplateResponse(boolean isPA, Pattern regex, TemplateScanProperties props, Connection con) throws SQLQueryObjectException, SQLException, DriverRegistroServiziException {
        log.debug("Eseguo ricerca dei template sulle trasformazioni della risposta, porta applicativa: {}", (Object)isPA);
        String portTable = isPA ? "porte_applicative" : "porte_delegate";
        String transformTable = isPA ? "pa_transform" : "pd_transform";
        String responseTable = isPA ? "pa_transform_risp" : "pd_transform_risp";
        String columnTemplate = isPA ? "conversione_template" : "conversione_template";
        String columnName = isPA ? "nome_porta" : "nome_porta";
        String columnPortId = isPA ? "id_porta" : "id_porta";
        String columnTransId = isPA ? "id_trasformazione" : "id_trasformazione";
        String mappingPort = isPA ? "mapping_erogazione_pa" : "mapping_fruizione_pd";
        String columnService = isPA ? "servizio" : "nome_servizio";
        ISQLQueryObject sqlObject = SQLObjectFactory.createSQLQueryObject((String)props.getDbType());
        sqlObject.addSelectAliasField("p." + columnName, NAME_ATTR);
        sqlObject.addSelectAliasField("r." + columnTemplate, TEMPLATE_ATTR);
        sqlObject.addSelectAliasField("p." + columnService, SERVICE_NAME);
        sqlObject.addSelectAliasField("t.nome", TRANS_NAME);
        sqlObject.addSelectAliasField("r.nome", "resp_name");
        sqlObject.addSelectAliasField("p.tipo_servizio", "tipo");
        sqlObject.addSelectAliasField("p.versione_servizio", SERVICE_VERSION);
        sqlObject.addSelectAliasField("sog.nome_soggetto", SUBJECT_NAME);
        sqlObject.addSelectAliasField("m.nome", GROUP_NAME);
        sqlObject.addSelectAliasField("m.is_default", IS_DEFAULT);
        if (!isPA) {
            sqlObject.addSelectAliasField("p.nome_soggetto_erogatore", EROGATOR_NAME);
        } else {
            sqlObject.addSelectAliasField("sog.nome_soggetto", EROGATOR_NAME);
        }
        sqlObject.addFromTable(portTable, "p");
        sqlObject.addFromTable(transformTable, "t");
        sqlObject.addFromTable(responseTable, "r");
        sqlObject.addFromTable("soggetti", "sog");
        sqlObject.addFromTable(mappingPort, "m");
        sqlObject.setANDLogicOperator(true);
        sqlObject.addWhereIsNotNullCondition("r." + columnTemplate);
        sqlObject.addWhereCondition("p.id = t." + columnPortId);
        sqlObject.addWhereCondition("t.id = r." + columnTransId);
        sqlObject.addWhereCondition("sog.id = p.id_soggetto");
        sqlObject.addWhereCondition("p.id = m.id_porta");
        this.parseTemplateResponseResultSet(regex, isPA, sqlObject, con);
    }

    private void processTemplatePAConnectors(Pattern regex, TemplateScanProperties props, Connection con) throws SQLQueryObjectException, SQLException, DriverRegistroServiziException {
        log.debug("Eseguo ricerca dei template sui connettori condizionali, porta applicativa: {}", (Object)true);
        ISQLQueryObject sqlObject = SQLObjectFactory.createSQLQueryObject((String)props.getDbType());
        sqlObject.addSelectAliasField("p.valore", TEMPLATE_ATTR);
        sqlObject.addSelectAliasField("pa.nome_porta", NAME_ATTR);
        sqlObject.addSelectAliasField("pa.servizio", SERVICE_NAME);
        sqlObject.addSelectAliasField("pa.tipo_servizio", "tipo");
        sqlObject.addSelectAliasField("pa.versione_servizio", SERVICE_VERSION);
        sqlObject.addSelectAliasField("so.nome_soggetto", SUBJECT_NAME);
        sqlObject.addSelectAliasField("m.nome", GROUP_NAME);
        sqlObject.addSelectAliasField("so.nome_soggetto", EROGATOR_NAME);
        sqlObject.addSelectAliasField("m.is_default", IS_DEFAULT);
        sqlObject.addFromTable("porte_applicative", "pa");
        sqlObject.addFromTable("pa_behaviour_props", "p");
        sqlObject.addFromTable("soggetti", "so");
        sqlObject.addFromTable("mapping_erogazione_pa", "m");
        sqlObject.setANDLogicOperator(true);
        sqlObject.addWhereCondition("p.nome=?");
        sqlObject.addWhereCondition("pa.id= p.id_porta");
        sqlObject.addWhereCondition("so.id = pa.id_soggetto");
        sqlObject.addWhereCondition("pa.id = m.id_porta");
        String query = sqlObject.createSQLQuery();
        logSql.debug("Eseguo query, porta applicativa: true, Connettori condizionali, query: {}", (Object)query);
        try (PreparedStatement stmt = con.prepareStatement(query);){
            int i = 1;
            stmt.setString(i++, "c_pattern");
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String nomeErogatore = rs.getString(EROGATOR_NAME);
                    String tipo = rs.getString("tipo");
                    IDSoggetto erogatore = new IDSoggetto(tipo, nomeErogatore);
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo, rs.getString(SERVICE_NAME), erogatore, rs.getInt(SERVICE_VERSION));
                    String group = rs.getBoolean(IS_DEFAULT) ? null : rs.getString(GROUP_NAME);
                    InputStream template = rs.getBinaryStream(TEMPLATE_ATTR);
                    TreePath key = TreePath.of("Registro", "Erogazioni").add(this.convertPortName(idServizio, null, group)).add("Connettori Multipli");
                    ScanResult.parse(template, regex).ifPresent(sc -> this.results.put(key, (ScanResult)sc));
                }
            }
        }
    }

    private void processTemplateGenericProperties(Pattern regex, TemplateScanProperties props, Connection con) throws SQLQueryObjectException, SQLException {
        log.debug("Eseguo ricerca dei template sulle generic property");
        ISQLQueryObject sqlObject = SQLObjectFactory.createSQLQueryObject((String)props.getDbType());
        sqlObject.addSelectAliasField("ps.nome", NAME_ATTR);
        sqlObject.addSelectAliasField("ps.tipo", "type");
        sqlObject.addSelectAliasField("p.valore", TEMPLATE_ATTR);
        sqlObject.addFromTable("generic_properties", "ps");
        sqlObject.addFromTable("generic_property", "p");
        sqlObject.setANDLogicOperator(true);
        sqlObject.addWhereCondition("ps.id = p.id_props");
        sqlObject.addWhereCondition("(p.nome = ? OR p.nome = ?)");
        String query = sqlObject.createSQLQuery();
        logSql.debug("Eseguo query, token policy e attribute authority, query: {}", (Object)query);
        try (PreparedStatement stmt = con.prepareStatement(query);){
            int i = 1;
            stmt.setString(i++, "policy.attributeAuthority.request.template");
            stmt.setString(i++, "policy.retrieveToken.httpPayload");
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(NAME_ATTR);
                    String type = rs.getString("type");
                    InputStream template = rs.getBinaryStream(TEMPLATE_ATTR);
                    TreePath key = null;
                    key = type.equals("attributeAuthority") ? TreePath.of("Configurazione", "Attribute Authority", this.color(name), "Richiesta") : (type.equals("retrieveToken") ? TreePath.of("Configurazione", "Token Policy", this.color(name), "Token Endpoint") : TreePath.of("misc", this.color(name)));
                    TreePath fKey = key;
                    ScanResult.parse(template, regex).ifPresent(sc -> this.results.put(fKey, (ScanResult)sc));
                }
            }
        }
    }

    private static void initLogger() throws CoreException {
        Properties propertiesLog4j = new Properties();
        try (InputStream inPropLog4j = TemplateScan.class.getResourceAsStream("/template_scan.cli.log4j2.properties");){
            propertiesLog4j.load(inPropLog4j);
            PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)propertiesLog4j);
            LoggerWrapperFactory.setLogConfiguration((Properties)propertiesLog4j);
        }
        catch (Exception e) {
            throw new CoreException("Impossibile leggere i dati dal file '/template_scan.cli.log4j2.properties': " + e.getMessage());
        }
    }
}

