/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.trasparente.builder;

import java.util.Date;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.basic.BasicEmptyRawContent;
import org.openspcoop2.protocol.basic.builder.BustaBuilder;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProperties;

public class TrasparenteBustaBuilder
extends BustaBuilder<BasicEmptyRawContent> {
    private TrasparenteProperties trasparenteProperties = TrasparenteProperties.getInstance();

    public TrasparenteBustaBuilder(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
    }

    public ProtocolMessage imbustamento(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments, FaseImbustamento faseImbustamento) throws ProtocolException {
        if (FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO.equals((Object)faseImbustamento)) {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            protocolMessage.setPhaseUnsupported(true);
            return protocolMessage;
        }
        ProtocolMessage protocolMessage = super.imbustamento(msg, context, busta, bustaRichiesta, ruoloMessaggio, proprietaManifestAttachments, faseImbustamento);
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && busta.sizeListaEccezioni() > 0) {
            boolean ignoraEccezioniNonGravi = this.protocolFactory.createProtocolManager().isIgnoraEccezioniNonGravi();
            if (ignoraEccezioniNonGravi) {
                if (busta.containsEccezioniGravi()) {
                    this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.trasparenteProperties.isPortaApplicativaBustaErrore_personalizzaElementiFault(), this.trasparenteProperties.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo());
                }
            } else {
                this.enrichFault(msg, busta, ignoraEccezioniNonGravi, this.trasparenteProperties.isPortaApplicativaBustaErrore_personalizzaElementiFault(), this.trasparenteProperties.isPortaApplicativaBustaErrore_aggiungiErroreApplicativo());
            }
        }
        return protocolMessage;
    }

    public String newID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        return super.newID(idSoggetto, idTransazione, ruoloMessaggio, this.trasparenteProperties.generateIDasUUID().booleanValue());
    }

    public Date extractDateFromID(String id) throws ProtocolException {
        return this.extractDateFromID(id, this.trasparenteProperties.generateIDasUUID());
    }
}

