/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.UUID;
import org.joda.time.DateTime;
import org.openspcoop2.core.monitor.rs.server.model.DetailTransazione;
import org.openspcoop2.core.monitor.rs.server.model.EsitoTransazioneSimpleSearchEnum;
import org.openspcoop2.core.monitor.rs.server.model.Evento;
import org.openspcoop2.core.monitor.rs.server.model.FiltroRicercaRuoloTransazioneEnum;
import org.openspcoop2.core.monitor.rs.server.model.ListaEventi;
import org.openspcoop2.core.monitor.rs.server.model.ListaTransazioni;
import org.openspcoop2.core.monitor.rs.server.model.Problem;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIdApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIntervalloTemporale;
import org.openspcoop2.core.monitor.rs.server.model.TipoIdApplicativoEnum;
import org.openspcoop2.core.monitor.rs.server.model.TipoMessaggioEnum;
import org.openspcoop2.utils.service.beans.DiagnosticoSeveritaEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface MonitoraggioApi {
    @GET
    @Path(value="/monitoraggio/eventi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca di Eventi", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eventi completata con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaEventi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaEventi findAllEventi(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="offset") @DefaultValue(value="0") Integer var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="severita") DiagnosticoSeveritaEnum var5, @QueryParam(value="tipo") String var6, @QueryParam(value="codice") String var7, @QueryParam(value="origine") String var8, @QueryParam(value="ricerca_esatta") @DefaultValue(value="true") Boolean var9, @QueryParam(value="case_sensitive") @DefaultValue(value="true") Boolean var10);

    @POST
    @Path(value="/monitoraggio/transazioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca completa delle transazioni per intervallo temporale", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ricerca completata con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByFullSearch(@Valid RicercaIntervalloTemporale var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/monitoraggio/transazioni/id-applicativo/{id}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca delle transazioni in base all'identificativo dell'applicativo", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="dettaglio transazione restituito correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByIdApplicativo(@QueryParam(value="tipo_identificativo") @NotNull TipoIdApplicativoEnum var1, @PathParam(value="id") String var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="offset") @DefaultValue(value="0") Integer var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="sort") String var7);

    @POST
    @Path(value="/monitoraggio/transazioni/id-applicativo")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca completa delle transazioni in base all'identificativo applicativo", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ricerca completata con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByIdApplicativoFullSearch(@Valid RicercaIdApplicativo var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/monitoraggio/transazioni/id-applicativo")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca semplificata delle transazioni in base all'identificativo applicativo", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ricerca completata con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByIdApplicativoSimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="id_applicativo") @NotNull String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="offset") @DefaultValue(value="0") Integer var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="sort") String var9, @QueryParam(value="id_cluster") String var10, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var13, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var14, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var16, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var17, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var18, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var19, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var20, @QueryParam(value="ricerca_esatta") @DefaultValue(value="true") Boolean var21, @QueryParam(value="case_sensitive") @DefaultValue(value="true") Boolean var22);

    @GET
    @Path(value="/monitoraggio/transazioni/id-messaggio")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca semplificata delle transazioni in base all'identificativo messaggio", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="dettaglio transazione restituito correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByIdMessaggio(@QueryParam(value="tipo_messaggio") @NotNull TipoMessaggioEnum var1, @QueryParam(value="id") @NotNull String var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="offset") @DefaultValue(value="0") Integer var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="sort") String var7);

    @GET
    @Path(value="/monitoraggio/transazioni/id-token")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca semplificata delle transazioni in base all'identificativo del token", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="dettaglio transazione restituito correttamente", content={@Content(schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByIdToken(@QueryParam(value="id") @NotNull String var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="offset") @DefaultValue(value="0") Integer var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="sort") String var6);

    @GET
    @Path(value="/monitoraggio/transazioni/purpose-id")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca semplificata delle transazioni in base all'identificativo finalita", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="dettaglio transazione restituito correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniByPurposeId(@QueryParam(value="purpose_id") @NotNull String var1, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="offset") @DefaultValue(value="0") Integer var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="sort") String var5);

    @GET
    @Path(value="/monitoraggio/transazioni")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca semplificata delle transazioni in base ai parametri di uso pi\u00f9 comune", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="ricerca completata con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListaTransazioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public ListaTransazioni findAllTransazioniBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="offset") @DefaultValue(value="0") Integer var6, @QueryParam(value="limit") Integer var7, @QueryParam(value="sort") String var8, @QueryParam(value="id_cluster") String var9, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var13, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var14, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var15, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var16, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var17, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var18, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var19);

    @GET
    @Path(value="/monitoraggio/eventi/{id}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Dettaglio di un evento", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Recupero evento completato con successo", content={@Content(mediaType="application/json", schema=@Schema(implementation=Evento.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public Evento getEvento(@PathParam(value="id") Long var1);

    @GET
    @Path(value="/monitoraggio/transazioni/{id}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Dettaglio della transazione", tags={"Monitoraggio"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="dettaglio transazione restituito correttamente", content={@Content(mediaType="application/json", schema=@Schema(implementation=DetailTransazione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public DetailTransazione getTransazione(@PathParam(value="id") UUID var1);
}

