/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.core.monitor.rs.server.config.DatasourceProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerInstanceProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.context.ContextConfig;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.web.monitor.core.config.ApplicationProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.slf4j.Logger;

public class ServerProperties {
    private Logger log = null;
    private ServerInstanceProperties reader;
    private static ServerProperties serverProperties = null;
    private static final String ENV_PROPERTIES_PREFIX = "env.";
    private AuthorizationConfig authConfig = null;
    private static CryptConfig utenzeCryptConfig = null;

    private ServerProperties(String confDir, Logger log) throws UtilsException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(ServerProperties.class);
        Properties propertiesReader = new Properties();
        try (InputStream properties = DatasourceProperties.class.getResourceAsStream("/rs-api-monitor.properties");){
            if (properties == null) {
                throw new UtilsException("File '/rs-api-monitor.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.logAndThrow("Riscontrato errore durante la lettura del file 'rs-api-monitor.properties': " + e.getMessage(), e);
        }
        this.reader = new ServerInstanceProperties(propertiesReader, this.log, confDir);
        this.log.info("Inizializzazione ApplicationProperties in corso...");
        try {
            ApplicationProperties.initialize((Logger)log, (String)"/rs-api-monitor.properties", (String)"OPENSPCOOP2_RSMONITOR_PROPERTIES", (String)"rs-api-monitor_local.properties");
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
        this.log.info("Inizializzazione ApplicationProperties effettuata con successo");
    }

    private void logAndThrow(String msg, Exception e) throws UtilsException {
        this.log.error(msg, (Throwable)e);
        throw new UtilsException(msg, (Throwable)e);
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            serverProperties = new ServerProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            log.error("Errore durante l'inizializzazione del ServerProperties: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static ServerProperties getInstance() throws UtilsException {
        if (serverProperties == null) {
            Class<ServerProperties> clazz = ServerProperties.class;
            synchronized (ServerProperties.class) {
                throw new UtilsException("ServerProperties non inizializzato");
            }
        }
        return serverProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        ServerProperties.serverProperties.reader.setLocalObjectImplementation(prop);
    }

    public Properties getEnvProperties() throws UtilsException {
        try {
            return this.reader.readProperties(ENV_PROPERTIES_PREFIX);
        }
        catch (Exception e) {
            throw new UtilsException("Error reading environment properties: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean parse(BooleanNullable b, boolean defaultValue) {
        return b != null && b.getValue() != null ? b.getValue() : defaultValue;
    }

    public String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private BooleanNullable readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (tmp == null && !required) {
            return BooleanNullable.NULL();
        }
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (true/value expected)");
        }
        return Boolean.parseBoolean(tmp) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    public Properties getProperties() throws UtilsException {
        Properties p = new Properties();
        Enumeration names = this.reader.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            p.put(name, this.reader.getValueConvertEnvProperties(name));
        }
        return p;
    }

    private synchronized void initAuthorizationConfig() throws UtilsException {
        if (this.authConfig == null) {
            this.authConfig = new AuthorizationConfig(this.getProperties());
        }
    }

    public AuthorizationConfig getAuthorizationConfig() throws UtilsException {
        if (this.authConfig == null) {
            this.initAuthorizationConfig();
        }
        return this.authConfig;
    }

    public String getConfDirectory() throws UtilsException {
        return this.readProperty(false, "confDirectory");
    }

    public String getProtocolloDefault() throws UtilsException {
        return this.readProperty(true, "protocolloDefault");
    }

    public boolean isJdbcCloseConnectionCheckIsClosed() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(true, "jdbc.closeConnection.checkIsClosed");
        return this.parse(b, true);
    }

    public boolean isJdbcCloseConnectionCheckAutocommit() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(true, "jdbc.closeConnection.checkAutocommit");
        return this.parse(b, true);
    }

    public HttpLibrary getConnettoriRemoteAccessUtilityLibrary() throws UtilsException {
        String lib = this.readProperty(false, "connettori.remoteAccessUtility.library");
        if (lib != null) {
            lib = lib.trim();
            return HttpLibrary.getHttpLibrary((String)lib);
        }
        return null;
    }

    public boolean isFindall404() throws UtilsException {
        return Boolean.parseBoolean(this.readProperty(true, "findall_404"));
    }

    public boolean useSoggettoDefault() throws UtilsException {
        if (Utility.isMultitenantAbilitato()) {
            return Boolean.parseBoolean(this.readProperty(true, "multitenant.forzaSoggettoDefault"));
        }
        return true;
    }

    public String getSoggettoDefaultIfEnabled(String protocollo) throws UtilsException {
        if (this.useSoggettoDefault()) {
            String p = this.readProperty(false, protocollo + ".soggetto");
            if (p != null) {
                return p;
            }
            return this.readProperty(true, "soggetto");
        }
        throw new UtilsException("Utilizzo del soggetto di default non abilitato");
    }

    public ContextConfig getContextConfig() throws UtilsException {
        ContextConfig config = new ContextConfig();
        config.setClusterId(this.readProperty(false, "clusterId"));
        config.setDump(Boolean.parseBoolean(this.readProperty(true, "dump")));
        config.setEmitTransaction(Boolean.parseBoolean(this.readProperty(true, "transaction")));
        config.setServiceType(this.readProperty(false, "service.type"));
        config.setServiceName(this.readProperty(false, "service.name"));
        config.setServiceVersion(Integer.valueOf(Integer.parseInt(this.readProperty(false, "service.version"))));
        return config;
    }

    public String getUtenzePassword() throws UtilsException {
        return this.readProperty(true, "utenti.password");
    }

    private static synchronized void initUtenzeCryptConfig(String p) throws UtilsException {
        if (utenzeCryptConfig == null) {
            utenzeCryptConfig = new CryptConfig(p);
        }
    }

    public CryptConfig getUtenzeCryptConfig() throws UtilsException {
        if (utenzeCryptConfig == null) {
            ServerProperties.initUtenzeCryptConfig(this.getUtenzePassword());
        }
        return utenzeCryptConfig;
    }

    public String getLoginRetryDelays() throws UtilsException {
        return this.readProperty(true, "login.retry.delayS");
    }

    public int getTransazioniDettaglioVisualizzazioneMessaggiThreshold() throws UtilsException {
        return Integer.valueOf(this.readProperty(true, "transazioni.dettaglio.visualizzazioneMessaggi.threshold"));
    }

    public boolean isSecurityLoadBouncyCastleProvider() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "security.addBouncyCastleProvider");
        return this.parse(b, false);
    }

    public String getEnvMapConfig() throws UtilsException {
        return this.readProperty(false, "env.map.config");
    }

    public boolean isEnvMapConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "env.map.required");
        return this.parse(b, false);
    }

    public String getHSMConfigurazione() throws UtilsException {
        return this.readProperty(false, "hsm.config");
    }

    public boolean isHSMRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.required");
        return this.parse(b, false);
    }

    public boolean isHSMKeyPasswordConfigurable() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.keyPassword");
        return this.parse(b, false);
    }

    public String getBYOKConfigurazione() throws UtilsException {
        return this.readProperty(false, "byok.config");
    }

    public boolean isBYOKRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.required");
        return this.parse(b, false);
    }

    public String getBYOKEnvSecretsConfig() throws UtilsException {
        return this.readProperty(false, "byok.env.secrets.config");
    }

    public boolean isBYOKEnvSecretsConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.env.secrets.required");
        return this.parse(b, false);
    }

    public String getConfigurazioneNodiRuntime() throws UtilsException {
        return this.readProperty(false, "configurazioni.configurazioneNodiRun");
    }

    public Properties getConsoleSecurityConfiguration() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("console.security.");
    }

    public Properties getConsoleInputSanitizerConfiguration() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("console.inputSanitizer.");
    }
}

