/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.DatasourceProperties;
import org.openspcoop2.core.monitor.rs.server.config.InitRuntimeConfigReader;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.lib.mvc.security.InputSanitizerProperties;
import org.openspcoop2.web.lib.mvc.security.SecurityProperties;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.slf4j.Logger;

public class Startup
implements ServletContextListener {
    private static Logger log = null;
    private static InitRuntimeConfigReader initRuntimeConfigReader;
    private static boolean initializedLog;
    private static boolean initializedResources;

    public static Logger getLog() {
        return log;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log != null) {
            log.info("Undeploy webService in corso...");
        }
        if (initRuntimeConfigReader != null) {
            initRuntimeConfigReader.setStop(true);
        }
        if (log != null) {
            log.info("Undeploy webService effettuato.");
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        Startup.initLog();
        Startup.initResources();
    }

    public static boolean isInitializedLog() {
        return initializedLog;
    }

    public static synchronized String initLog() {
        String confDir = null;
        try (InputStream is2 = Startup.class.getResourceAsStream("/rs-api-monitor.properties");){
            if (is2 != null) {
                Properties p = new Properties();
                p.load(is2);
                confDir = p.getProperty("confDirectory");
                if (confDir != null) {
                    confDir = confDir.trim();
                }
            }
        }
        catch (Exception is2) {
            // empty catch block
        }
        if (!initializedLog) {
            try {
                log = LoggerWrapperFactory.getLogger(Startup.class);
                LoggerProperties.initialize(log, confDir, null);
                initializedLog = true;
                log = LoggerProperties.getLoggerCore();
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return confDir;
    }

    public static boolean isInitializedResources() {
        return initializedResources;
    }

    public static synchronized void initResources() {
        if (!initializedResources) {
            String confDir = Startup.initLog();
            log.info("Inizializzazione rs api monitor in corso...");
            if (!ServerProperties.initialize(confDir, log)) {
                return;
            }
            ServerProperties serverProperties = null;
            try {
                serverProperties = ServerProperties.getInstance();
                PropertiesEnvUtils.checkRequiredEnvProperties((Properties)serverProperties.getEnvProperties(), (Logger)log, (String)"govwayAPIMonitor");
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del serverProperties", e);
            }
            try {
                if (serverProperties.getConnettoriRemoteAccessUtilityLibrary() != null) {
                    HttpLibraryConnection.setDefaultLibrary((HttpLibrary)serverProperties.getConnettoriRemoteAccessUtilityLibrary());
                }
                log.info("HttpLibraryConnection: {}", (Object)HttpLibraryConnection.getDefaultLibrary());
            }
            catch (Exception e) {
                Startup.doError("Inizializzazione libreria accesso risorse esterne non riuscita", e);
            }
            try {
                Logger logR = log;
                ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
                DBManager.setCheckLogger(logR);
                DBManager.setCheckIsClosed(serverProperties.isJdbcCloseConnectionCheckIsClosed());
                DBManager.setCheckAutocommit(serverProperties.isJdbcCloseConnectionCheckAutocommit());
            }
            catch (Exception e) {
                Startup.doError("Inizializzazione controlli connessione non riuscita", e);
            }
            try {
                String mapConfig = serverProperties.getEnvMapConfig();
                if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
                    log.info("Inizializzazione environment in corso...");
                    MapProperties.initialize((Logger)log, (String)mapConfig, (boolean)serverProperties.isEnvMapConfigRequired());
                    MapProperties mapProperties = MapProperties.getInstance();
                    mapProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente", e);
            }
            log.info("Inizializzazione security provider...");
            try {
                if (serverProperties.isSecurityLoadBouncyCastleProvider()) {
                    ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                    log.info("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dei security provider", e);
            }
            log.info("Inizializzazione security provider effettuata con successo");
            try {
                String hsmConfig = serverProperties.getHSMConfigurazione();
                if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
                    log.info("Inizializzazione HSM in corso...");
                    File f = new File(hsmConfig);
                    HSMManager.init((File)f, (boolean)serverProperties.isHSMRequired(), (Logger)log, (boolean)false);
                    HSMUtils.setHsmConfigurableKeyPassword((boolean)serverProperties.isHSMKeyPasswordConfigurable());
                    log.info("Inizializzazione HSM effettuata con successo");
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del manager HSM", e);
            }
            BYOKManager byokManager = null;
            try {
                String byokConfig = serverProperties.getBYOKConfigurazione();
                if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
                    log.info("Inizializzazione BYOK in corso...");
                    File f = new File(byokConfig);
                    BYOKManager.init((File)f, (boolean)serverProperties.isBYOKRequired(), (Logger)log);
                    byokManager = BYOKManager.getInstance();
                    String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del manager BYOK", e);
            }
            boolean reInitSecretMaps = false;
            try {
                String secretsConfig = serverProperties.getBYOKEnvSecretsConfig();
                if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
                    log.info("Inizializzazione secrets in corso...");
                    boolean useSecurityEngine = true;
                    HashMap dynamicMap = new HashMap();
                    DynamicInfo dynamicInfo = new DynamicInfo();
                    DynamicUtils.fillDynamicMap((Logger)log, dynamicMap, (DynamicInfo)dynamicInfo);
                    if (byokManager.isBYOKRemoteGovWayNodeUnwrapConfig()) {
                        reInitSecretMaps = true;
                        useSecurityEngine = false;
                    }
                    BYOKMapProperties.initialize((Logger)log, (String)secretsConfig, (boolean)serverProperties.isBYOKEnvSecretsConfigRequired(), (boolean)useSecurityEngine, dynamicMap, (boolean)true);
                    BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                    secretsProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente (secrets)", e);
            }
            if (!DatasourceProperties.initialize(confDir, log)) {
                return;
            }
            log.info("Inizializzazione DBManager in corso...");
            try {
                DatasourceProperties dbProperties = DatasourceProperties.getInstance();
                DBManager.initialize(dbProperties.getConfigDataSource(), dbProperties.getConfigDataSourceContext(), dbProperties.getConfigTipoDatabase(), dbProperties.getTracceDataSource(), dbProperties.getTracceDataSourceContext(), dbProperties.getTracceTipoDatabase(), dbProperties.getStatisticheDataSource(), dbProperties.getStatisticheDataSourceContext(), dbProperties.getStatisticheTipoDatabase(), dbProperties.isShowSql());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione DBManager effettuata con successo");
            log.info("Inizializzazione ExtendedInfoManager in corso...");
            try {
                ExtendedInfoManager.initialize((Loader)new Loader(), null, null, null);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione ExtendedInfoManager effettuata con successo");
            log.info("Inizializzazione NodiRuntime in corso...");
            try {
                boolean configFileRequired = false;
                ConfigurazioneNodiRuntime.initialize((String)serverProperties.getConfigurazioneNodiRuntime(), (boolean)configFileRequired, (ConfigurazioneNodiRuntimeProperties[])new ConfigurazioneNodiRuntimeProperties[0]);
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del gestore dei nodi run", e);
            }
            log.info("Inizializzazione NodiRuntime effettuata con successo");
            log.info("Inizializzazione ProtocolFactoryManager in corso...");
            ServerProperties properties = null;
            try {
                properties = ServerProperties.getInstance();
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setAttesaAttivaJDBC(-1L);
                configPdD.setCheckIntervalJDBC(-1);
                configPdD.setLoader(new Loader(Startup.class.getClassLoader()));
                configPdD.setLog(log);
                ProtocolFactoryManager.initialize((Logger)log, (ConfigurazionePdD)configPdD, (String)properties.getProtocolloDefault());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("ProtocolFactoryManager DBManager effettuata con successo");
            Startup.initResourceConsole(properties);
            Startup.initSogliaDimensioneMessaggi(properties);
            if (reInitSecretMaps) {
                try {
                    initRuntimeConfigReader = new InitRuntimeConfigReader(serverProperties, ConfigurazioneNodiRuntime.getConfigurazioneNodiRuntime(), reInitSecretMaps);
                    initRuntimeConfigReader.start();
                    log.info("RuntimeConfigReader avviato con successo.");
                }
                catch (Exception e) {
                    log.error("Errore durante l'inizializzazione del RuntimeConfigReader: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                FailedAttempts.createInstance((String)serverProperties.getLoginRetryDelays());
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del FailedAttempts", e);
            }
            initializedResources = true;
            log.info("Inizializzazione rs api monitor effettuata con successo.");
        }
    }

    private static void initResourceConsole(ServerProperties properties) {
        log.info("Inizializzazione Risorse Statiche Console in corso...");
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionConfig();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesConfig();
            Logger logSql = LoggerProperties.getLoggerDAO();
            LoginBean lb = new LoginBean(connection, true, smp, logSql);
            Utility.setStaticConfigurazioneGenerale((Configurazione)lb.getConfigurazioneGenerale());
            boolean multitenantAbilitato = Utility.isMultitenantAbilitato();
            Utility.setStaticFiltroDominioAbilitato((boolean)multitenantAbilitato);
            DriverRegistroServiziDB driverDB = new DriverRegistroServiziDB(connection, logSql, DatasourceProperties.getInstance().getConfigTipoDatabase());
            List<String> idsPdd = Startup.getAllIdPorteDominioTipoOperativo(driverDB);
            if (idsPdd != null && !idsPdd.isEmpty()) {
                for (String idPdd : idsPdd) {
                    List<IDSoggetto> idsSoggetti = Startup.getAllSoggettiByPdd(driverDB, idPdd);
                    if (idsSoggetti == null || idsSoggetti.isEmpty()) continue;
                    for (IDSoggetto idSoggetto : idsSoggetti) {
                        Utility.putIdentificativoPorta((String)idSoggetto.getTipo(), (String)idSoggetto.getNome(), (String)driverDB.getSoggetto(idSoggetto).getIdentificativoPorta());
                    }
                }
            }
            Properties consoleSecurityConfiguration = properties.getConsoleSecurityConfiguration();
            SecurityProperties.init((Properties)consoleSecurityConfiguration, (Logger)log);
            Properties consoleInputSanitizerConfiguration = properties.getConsoleInputSanitizerConfiguration();
            InputSanitizerProperties.init((Properties)consoleInputSanitizerConfiguration, (Logger)log);
            Validatore.init((SecurityProperties)SecurityProperties.getInstance(), (InputSanitizerProperties)InputSanitizerProperties.getInstance(), (Logger)log);
            log.info("Inizializzazione Risorse Statiche Console effettuata con successo");
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
        finally {
            dbManager.releaseConnectionConfig(connection);
        }
    }

    private static List<String> getAllIdPorteDominioTipoOperativo(DriverRegistroServiziDB driverDB) throws DriverRegistroServiziException {
        FiltroRicerca filtroRicercaPdd = new FiltroRicerca();
        filtroRicercaPdd.setTipo(PddTipologia.OPERATIVO.toString());
        List idsPdd = null;
        try {
            idsPdd = driverDB.getAllIdPorteDominio(filtroRicercaPdd);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return idsPdd;
    }

    private static List<IDSoggetto> getAllSoggettiByPdd(DriverRegistroServiziDB driverDB, String idPdd) throws DriverRegistroServiziException {
        FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
        filtroSoggetti.setNomePdd(idPdd);
        List idsSoggetti = null;
        try {
            idsSoggetti = driverDB.getAllIdSoggetti(filtroSoggetti);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return idsSoggetti;
    }

    private static void initSogliaDimensioneMessaggi(ServerProperties properties) {
        log.info("Inizializzazione Soglia per Dimensione Messaggi in corso...");
        try {
            DumpUtils.setThreshold_readInMemory((int)properties.getTransazioniDettaglioVisualizzazioneMessaggiThreshold());
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
        log.info("Inizializzazione Soglia per Dimensione Messaggi effettuata con successo");
    }

    private static void doError(String msg, Exception e) {
        String msgErrore = msg + ": " + e.getMessage();
        log.error(msgErrore, (Throwable)e);
        throw new UtilsRuntimeException(msgErrore, (Throwable)e);
    }

    static {
        initializedLog = false;
        initializedResources = false;
    }
}

