/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.archive;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.protocol.as4.archive.XMLWriteUtils;
import org.openspcoop2.protocol.as4.archive.ZIPWriteUtils;
import org.openspcoop2.protocol.as4.constants.AS4Costanti;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.archive.BasicArchive;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.MappingModeTypesExtensions;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;

public class AS4Archive
extends BasicArchive {
    public AS4Archive(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    public MappingModeTypesExtensions getMappingTypesExtensions(ArchiveMode mode) throws ProtocolException {
        return this._getMappingTypesExtensions(mode, null, null);
    }

    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune) throws ProtocolException {
        super.setProtocolInfo(accordoServizioParteComune);
        try {
            if (ServiceBinding.SOAP.equals((Object)accordoServizioParteComune.getServiceBinding())) {
                for (Azione azione : accordoServizioParteComune.getAzioneList()) {
                    ProtocolProperty pp;
                    azione.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
                    boolean found = false;
                    boolean foundBinding = false;
                    for (ProtocolProperty pp2 : azione.getProtocolPropertyList()) {
                        if ("ebmsUserMessageCollaborationInfoAction".equals(pp2.getName())) {
                            if (pp2.getValue() == null || "".equals(pp2.getValue())) {
                                pp2.setValue(azione.getNome());
                            }
                            found = true;
                            break;
                        }
                        if (!"ebmsUserMessageCollaborationInfoActionBinding".equals(pp2.getName())) continue;
                        if (pp2.getValue() == null || "".equals(pp2.getValue())) {
                            pp2.setValue("push");
                        }
                        foundBinding = true;
                        break;
                    }
                    if (!found) {
                        pp = new ProtocolProperty();
                        pp.setName("ebmsUserMessageCollaborationInfoAction");
                        pp.setValue(azione.getNome());
                        azione.addProtocolProperty(pp);
                    }
                    if (foundBinding) continue;
                    pp = new ProtocolProperty();
                    pp.setName("ebmsUserMessageCollaborationInfoActionBinding");
                    pp.setValue("push");
                    azione.addProtocolProperty(pp);
                }
                for (PortType pt : accordoServizioParteComune.getPortTypeList()) {
                    pt.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
                    for (Operation azione : pt.getAzioneList()) {
                        ProtocolProperty pp;
                        azione.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
                        boolean found = false;
                        boolean foundBinding = false;
                        for (ProtocolProperty pp3 : azione.getProtocolPropertyList()) {
                            if ("ebmsUserMessageCollaborationInfoAction".equals(pp3.getName())) {
                                if (pp3.getValue() == null || "".equals(pp3.getValue())) {
                                    pp3.setValue(azione.getNome());
                                }
                                found = true;
                                break;
                            }
                            if (!"ebmsUserMessageCollaborationInfoActionBinding".equals(pp3.getName())) continue;
                            if (pp3.getValue() == null || "".equals(pp3.getValue())) {
                                pp3.setValue("push");
                            }
                            foundBinding = true;
                            break;
                        }
                        if (!found) {
                            pp = new ProtocolProperty();
                            pp.setName("ebmsUserMessageCollaborationInfoAction");
                            pp.setValue(azione.getNome());
                            azione.addProtocolProperty(pp);
                        }
                        if (foundBinding) continue;
                        pp = new ProtocolProperty();
                        pp.setName("ebmsUserMessageCollaborationInfoActionBinding");
                        pp.setValue("push");
                        azione.addProtocolProperty(pp);
                    }
                }
            } else {
                for (Resource resource : accordoServizioParteComune.getResourceList()) {
                    ProtocolProperty pp;
                    boolean found = false;
                    boolean foundBinding = false;
                    for (ProtocolProperty pp4 : resource.getProtocolPropertyList()) {
                        if ("ebmsUserMessageCollaborationInfoAction".equals(pp4.getName())) {
                            if (pp4.getValue() == null || "".equals(pp4.getValue())) {
                                pp4.setValue(resource.getNome());
                            }
                            found = true;
                            break;
                        }
                        if (!"ebmsUserMessageCollaborationInfoActionBinding".equals(pp4.getName())) continue;
                        if (pp4.getValue() == null || "".equals(pp4.getValue())) {
                            pp4.setValue("push");
                        }
                        foundBinding = true;
                        break;
                    }
                    if (!found) {
                        pp = new ProtocolProperty();
                        pp.setName("ebmsUserMessageCollaborationInfoAction");
                        pp.setValue(resource.getNome());
                        resource.addProtocolProperty(pp);
                    }
                    if (foundBinding) continue;
                    pp = new ProtocolProperty();
                    pp.setName("ebmsUserMessageCollaborationInfoActionBinding");
                    pp.setValue("push");
                    resource.addProtocolProperty(pp);
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public List<ExportMode> getExportModes(ArchiveType archiveType) throws ProtocolException {
        List list = super.getExportModes(archiveType);
        switch (archiveType) {
            case SOGGETTO: {
                ExportMode exportPMode = new ExportMode(AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_SOGGETTI);
                list.add(exportPMode);
                break;
            }
            case CONFIGURAZIONE: 
            case ALL: 
            case ALL_WITHOUT_CONFIGURAZIONE: {
                ExportMode exportPModeConfig = new ExportMode(AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG);
                list.add(exportPModeConfig);
                break;
            }
        }
        return list;
    }

    public MappingModeTypesExtensions getExportMappingTypesExtensions(Archive archive, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        return this._getMappingTypesExtensions(mode, archive, registroReader);
    }

    public byte[] exportArchive(Archive archive, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        if (Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.equals((Object)mode)) {
            return super.exportArchive(archive, mode, registroReader, configIntegrationReader);
        }
        if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_SOGGETTI.equals((Object)mode) || AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode)) {
            try {
                ByteArrayOutputStream bot = new ByteArrayOutputStream();
                this.exportArchive(archive, bot, mode, registroReader, configIntegrationReader);
                bot.flush();
                bot.close();
                return bot.toByteArray();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        throw new ProtocolException("Mode [" + String.valueOf(mode) + "] unknown");
    }

    public void exportArchive(Archive archive, OutputStream out, ArchiveMode mode, IRegistryReader registroReader, IConfigIntegrationReader configIntegrationReader) throws ProtocolException {
        if (Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.equals((Object)mode)) {
            super.exportArchive(archive, out, mode, registroReader, configIntegrationReader);
        } else if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_SOGGETTI.equals((Object)mode)) {
            if (archive.getSoggetti().size() <= 0) {
                throw new ProtocolException("Non risulta selezionato alcun soggetto");
            }
            ArrayList<ArchiveSoggetto> listArchive = new ArrayList<ArchiveSoggetto>();
            for (int i = 0; i < archive.getSoggetti().size(); ++i) {
                ArchiveSoggetto soggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
                this.checkSoggetto(soggetto, registroReader, mode);
                listArchive.add(soggetto);
            }
            if (listArchive.size() > 1) {
                ZIPWriteUtils zipUtils = new ZIPWriteUtils(this.log, this.protocolFactory, registroReader, configIntegrationReader);
                zipUtils.generate(out, listArchive);
            } else {
                XMLWriteUtils writeUtils = new XMLWriteUtils(this.log, this.protocolFactory, registroReader, configIntegrationReader);
                writeUtils.generate(out, ((ArchiveSoggetto)listArchive.get(0)).getIdSoggetto().getNome());
            }
        } else if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode)) {
            if (archive.getSoggetti().size() <= 0) {
                throw new ProtocolException("Non risultano configurati soggetti");
            }
            List<ArchiveSoggetto> listArchive = this._listSoggettiOperativi(archive, registroReader);
            if (listArchive.size() > 1) {
                ZIPWriteUtils zipUtils = new ZIPWriteUtils(this.log, this.protocolFactory, registroReader, configIntegrationReader);
                zipUtils.generate(out, listArchive);
            } else {
                XMLWriteUtils writeUtils = new XMLWriteUtils(this.log, this.protocolFactory, registroReader, configIntegrationReader);
                writeUtils.generate(out, listArchive.get(0).getIdSoggetto().getNome());
            }
        } else {
            throw new ProtocolException("Mode [" + String.valueOf(mode) + "] unknown");
        }
    }

    private List<ArchiveSoggetto> _listSoggettiOperativi(Archive archive, IRegistryReader registryReader) throws ProtocolException {
        ArrayList<ArchiveSoggetto> listArchive = new ArrayList<ArchiveSoggetto>();
        if (archive != null && archive.getSoggetti() != null && archive.getSoggetti().size() > 0) {
            List listPddOperative = null;
            try {
                listPddOperative = registryReader.findIdPorteDominio(Boolean.valueOf(true));
            }
            catch (Exception notFound) {
                throw new ProtocolException("Non risultano configurate porte di dominio di tipo 'operativo'");
            }
            for (int i = 0; i < archive.getSoggetti().size(); ++i) {
                ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
                boolean soggettoOperativo = false;
                if (archiveSoggetto.getSoggettoRegistro().getPortaDominio() != null) {
                    soggettoOperativo = listPddOperative.contains(archiveSoggetto.getSoggettoRegistro().getPortaDominio());
                }
                if (!soggettoOperativo) continue;
                listArchive.add(archiveSoggetto);
            }
        }
        return listArchive;
    }

    private MappingModeTypesExtensions _getMappingTypesExtensions(ArchiveMode mode, Archive archive, IRegistryReader registryReader) throws ProtocolException {
        if (AS4Costanti.DOMIBUS_MODE.equals((Object)mode) || AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_SOGGETTI.equals((Object)mode) || AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode)) {
            MappingModeTypesExtensions m = new MappingModeTypesExtensions();
            List<ArchiveSoggetto> listSoggetti = null;
            if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode)) {
                listSoggetti = this._listSoggettiOperativi(archive, registryReader);
            }
            boolean preferExtXmlSingleObject = false;
            if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_SOGGETTI.equals((Object)mode)) {
                preferExtXmlSingleObject = true;
            } else if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode) && listSoggetti != null && listSoggetti.size() == 1) {
                preferExtXmlSingleObject = true;
            }
            m.add("xml", preferExtXmlSingleObject, AS4Costanti.PMODE_ARCHIVE_MODE_TYPE_XML);
            boolean preferExtZipSingleObject = false;
            if (AS4Costanti.EXPORT_MODE_DOMIBUS_FROM_CONFIG.equals((Object)mode) && listSoggetti != null && listSoggetti.size() > 1) {
                preferExtZipSingleObject = true;
            }
            m.add("zip", preferExtZipSingleObject, AS4Costanti.PMODE_ARCHIVE_MODE_TYPE_ZIP);
            return m;
        }
        return super.getMappingTypesExtensions(mode);
    }

    private void checkSoggetto(ArchiveSoggetto soggetto, IRegistryReader registroReader, ArchiveMode mode) throws ProtocolException {
        if (soggetto.getSoggettoRegistro().getPortaDominio() == null) {
            throw new ProtocolException("Con l'esportazione '" + String.valueOf(mode) + "' deve essere selezionato un soggetto di dominio 'interno'; il soggetto " + soggetto.getSoggettoRegistro().getNome() + " risulta di dominio 'esterno'");
        }
        List pddOperative = null;
        try {
            pddOperative = registroReader.findIdPorteDominio(Boolean.valueOf(true));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (!pddOperative.contains(soggetto.getSoggettoRegistro().getPortaDominio())) {
            throw new ProtocolException("Con l'esportazione '" + String.valueOf(mode) + "' deve essere selezionato un soggetto di dominio 'interno'; il soggetto " + soggetto.getSoggettoRegistro().getNome() + " risulta di dominio 'esterno'");
        }
    }
}

