/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode;

import eu.domibus.configuration.Payload;
import eu.domibus.configuration.PayloadProfile;
import eu.domibus.configuration.utils.ProjectInfo;
import eu.domibus.configuration.utils.serializer.JaxbDeserializer;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.protocol.as4.config.AS4Properties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.resources.TemplateUtils;

public class TranslatorPayloadProfilesDefault {
    private static TranslatorPayloadProfilesDefault translatorInstance;
    private byte[] payloadDefault = null;
    private Template templatePayloadDefault;
    private byte[] payloadProfileDefault = null;
    private Template templatePayloadProfileDefault;

    private static synchronized void initTranslator() throws ProtocolException {
        if (translatorInstance == null) {
            translatorInstance = new TranslatorPayloadProfilesDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranslatorPayloadProfilesDefault getTranslator() throws ProtocolException {
        if (translatorInstance != null) return translatorInstance;
        Class<TranslatorPayloadProfilesDefault> clazz = TranslatorPayloadProfilesDefault.class;
        synchronized (TranslatorPayloadProfilesDefault.class) {
            TranslatorPayloadProfilesDefault.initTranslator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return translatorInstance;
        }
    }

    private TranslatorPayloadProfilesDefault() throws ProtocolException {
        try {
            AS4Properties props = AS4Properties.getInstance();
            this.payloadDefault = props.getPayloadProfilesDefaultPayloads();
            if (this.payloadDefault == null) {
                this.templatePayloadDefault = TemplateUtils.getTemplate((String)"/org/openspcoop2/protocol/as4/pmode", (String)"pmode-payloadDefault.ftl");
            }
            this.payloadProfileDefault = props.getPayloadProfilesDefaultPayloadProfiles();
            if (this.payloadProfileDefault == null) {
                this.templatePayloadProfileDefault = TemplateUtils.getTemplate((String)"/org/openspcoop2/protocol/as4/pmode", (String)"pmode-payloadProfileDefault.ftl");
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPayloadDefault() throws ProtocolException {
        try {
            if (this.payloadDefault == null) {
                HashMap map = new HashMap();
                StringWriter writer = new StringWriter();
                this.templatePayloadDefault.process(map, (Writer)writer);
                return writer.toString();
            }
            return new String(this.payloadDefault);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Payload> getListPayloadDefault() throws ProtocolException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(this.getPayloadDefault()));
            ArrayList<Payload> list = new ArrayList<Payload>();
            StringBuilder bf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(line);
                if (!line.contains("/>") && !line.contains("</payload>")) continue;
                String finalString = bf.toString();
                if (finalString != null && !"".equals(finalString)) {
                    String sWithNamespace = finalString.replace("<payload>", "<ns:payload xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                    sWithNamespace = sWithNamespace.replace("<payload ", "<ns:payload xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\" ");
                    sWithNamespace = sWithNamespace.replace("</payload", "</ns:payload");
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    Payload p = deserializer.readPayload(sWithNamespace.getBytes());
                    list.add(p);
                }
                bf = new StringBuilder();
            }
            return list;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPayloadProfileDefault() throws ProtocolException {
        try {
            if (this.payloadProfileDefault == null) {
                HashMap map = new HashMap();
                StringWriter writer = new StringWriter();
                this.templatePayloadProfileDefault.process(map, (Writer)writer);
                return writer.toString();
            }
            return new String(this.payloadProfileDefault);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public List<PayloadProfile> getListPayloadProfileDefault() throws ProtocolException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(this.getPayloadProfileDefault()));
            ArrayList<PayloadProfile> list = new ArrayList<PayloadProfile>();
            StringBuilder bf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(line);
                if (!line.contains("</payloadProfile>")) continue;
                String finalString = bf.toString();
                if (finalString != null && !"".equals(finalString)) {
                    String sWithNamespace = finalString.replace("<payloadProfile>", "<ns:payloadProfile xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\">");
                    sWithNamespace = sWithNamespace.replace("<payloadProfile ", "<ns:payloadProfile xmlns:ns=\"" + ProjectInfo.getInstance().getProjectNamespace() + "\" ");
                    sWithNamespace = sWithNamespace.replace("</payloadProfile", "</ns:payloadProfile");
                    JaxbDeserializer deserializer = new JaxbDeserializer();
                    PayloadProfile p = deserializer.readPayloadProfile(sWithNamespace.getBytes());
                    list.add(p);
                }
                bf = new StringBuilder();
            }
            return list;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String getAsStringPayloadProfilesDefaultAsCompleteXml() throws ProtocolException {
        try {
            StringBuilder bf = new StringBuilder();
            bf.append("\t<payloadProfiles>\n\n");
            bf.append(this.getPayloadDefault());
            bf.append("\n\n");
            bf.append(this.getPayloadProfileDefault());
            bf.append("\n\n");
            bf.append("\t</payloadProfiles>");
            return bf.toString();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public byte[] getPayloadProfilesDefaultAsCompleteXml() throws ProtocolException {
        try {
            return this.getAsStringPayloadProfilesDefaultAsCompleteXml().getBytes();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

