/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.as4.pmode.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.as4.pmode.beans.API;
import org.openspcoop2.protocol.as4.pmode.beans.Azione;
import org.openspcoop2.protocol.as4.pmode.beans.Fruitore;
import org.openspcoop2.protocol.as4.pmode.beans.Index;
import org.openspcoop2.protocol.as4.pmode.beans.Soggetto;

public class APS {
    private AccordoServizioParteSpecifica base;
    private Map<String, Azione> azioni;
    private API api;
    private String ebmsSecurityProfile;
    private Boolean ebmsReliabilityNonRepudiation;
    private String ebmsReliabilityReplyPattern;
    private String ebmsBinding;
    private String ebmsMep;
    private String id;
    private List<String> cnFruitori = new ArrayList<String>();

    private APS() {
    }

    public APS newInstance() {
        APS aps = new APS();
        aps.base = this.base;
        aps.azioni = new HashMap<String, Azione>();
        for (String key : this.azioni.keySet()) {
            aps.azioni.put(key, this.azioni.get(key));
        }
        aps.api = this.api;
        aps.ebmsSecurityProfile = this.ebmsSecurityProfile;
        aps.ebmsReliabilityNonRepudiation = this.ebmsReliabilityNonRepudiation;
        aps.ebmsReliabilityReplyPattern = this.ebmsReliabilityReplyPattern;
        aps.id = this.id;
        aps.cnFruitori = this.cnFruitori;
        return aps;
    }

    public APS(AccordoServizioParteSpecifica base, API api, Index index, String id) throws Exception {
        this.base = base;
        this.api = api;
        this.id = id;
        for (ProtocolProperty prop : base.getProtocolPropertyList()) {
            if (prop.getName().equals("ebmsSecurityProfile")) {
                this.ebmsSecurityProfile = prop.getValue();
                continue;
            }
            if (prop.getName().equals("ebmsReliabilityNonRepudiation")) {
                if (prop.getBooleanValue() != null) {
                    this.ebmsReliabilityNonRepudiation = prop.getBooleanValue();
                    continue;
                }
                if (prop.getValue() == null) continue;
                this.ebmsReliabilityNonRepudiation = Boolean.parseBoolean(prop.getValue());
                continue;
            }
            if (!prop.getName().equals("ebmsReliabilityReplyPattern")) continue;
            this.ebmsReliabilityReplyPattern = prop.getValue();
        }
        Map<String, Azione> azioniAPI = null;
        azioniAPI = ServiceBinding.REST.equals((Object)api.getBase().getServiceBinding()) ? api.getActions() : (base.getPortType() == null ? api.getActionsWithoutPortType() : api.getActions(base.getPortType()));
        this.azioni = new HashMap<String, Azione>();
        for (Azione azione : azioniAPI.values()) {
            this.azioni.put("Leg_" + index.getNextLegId(), azione);
        }
    }

    public AccordoServizioParteSpecifica getBase() {
        return this.base;
    }

    public void setBase(AccordoServizioParteSpecifica base) {
        this.base = base;
    }

    public API getApi() {
        return this.api;
    }

    public void setApi(API pt) {
        this.api = pt;
    }

    public Map<String, Azione> getAzioni() {
        return this.azioni;
    }

    public void setAzioni(Map<String, Azione> azioniMap) {
        this.azioni = azioniMap;
    }

    public String getEbmsSecurityProfile() {
        return this.ebmsSecurityProfile;
    }

    public void setEbmsSecurityProfile(String ebmsSecurityProfile) {
        this.ebmsSecurityProfile = ebmsSecurityProfile;
    }

    public Boolean getEbmsReliabilityNonRepudiation() {
        return this.ebmsReliabilityNonRepudiation;
    }

    public void setEbmsReliabilityNonRepudiation(Boolean ebmsReliabilityNonRepudiation) {
        this.ebmsReliabilityNonRepudiation = ebmsReliabilityNonRepudiation;
    }

    public String getEbmsReliabilityReplyPattern() {
        return this.ebmsReliabilityReplyPattern;
    }

    public void setEbmsReliabilityReplyPattern(String ebmsReliabilityReplyPattern) {
        this.ebmsReliabilityReplyPattern = ebmsReliabilityReplyPattern;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEbmsBinding() {
        return this.ebmsBinding;
    }

    public void setEbmsBinding(String ebmsBinding) {
        this.ebmsBinding = ebmsBinding;
        if ("push".equals(ebmsBinding)) {
            this.ebmsMep = "oneway";
        } else if ("pushAndPush".equals(ebmsBinding)) {
            this.ebmsMep = "twoway";
        } else {
            throw new RuntimeException("Binding [" + ebmsBinding + "] unsupported");
        }
    }

    public String getEbmsMep() {
        return this.ebmsMep;
    }

    public void setEbmsMep(String ebmsMep) {
        this.ebmsMep = ebmsMep;
    }

    public List<String> getCnFruitori() {
        return this.cnFruitori;
    }

    public void setCnFruitori(List<String> cnFruitori) {
        this.cnFruitori = cnFruitori;
    }

    public void initCNFruitori(List<Soggetto> soggetti) throws Exception {
        block0: for (org.openspcoop2.core.registry.Fruitore fruitore : this.base.getFruitoreList()) {
            for (Soggetto soggetto : soggetti) {
                if (!soggetto.getBase().getNome().equals(fruitore.getNome())) continue;
                if (this.cnFruitori.contains(soggetto.getEbmsUserMessagePartyCN())) continue block0;
                this.cnFruitori.add(soggetto.getEbmsUserMessagePartyCN());
                Fruitore fruitoreBuild = new Fruitore(fruitore, this.base, soggetto.getEbmsUserMessagePartyCN());
                String oggettoFruizione = "fruizione da parte del soggetto '" + fruitore.getNome() + "' dell'api '" + this.base.getNome() + "' erogata dal soggetto '" + this.base.getNomeSoggettoErogatore() + "'";
                if (this.ebmsSecurityProfile == null) {
                    this.ebmsSecurityProfile = fruitoreBuild.getEbmsSecurityProfile();
                } else if (!this.ebmsSecurityProfile.equals(fruitoreBuild.getEbmsSecurityProfile())) {
                    throw new Exception("Property ebmsSecurityProfile (" + fruitoreBuild.getEbmsSecurityProfile() + ") definita definita per la " + oggettoFruizione + " differente dal valore (" + this.ebmsSecurityProfile + ") indicato per l'erogazione della medesima API da parte del soggetto " + this.base.getNomeSoggettoErogatore());
                }
                if (this.ebmsReliabilityNonRepudiation == null) {
                    this.ebmsReliabilityNonRepudiation = fruitoreBuild.getEbmsReliabilityNonRepudiation();
                } else if (!this.ebmsReliabilityNonRepudiation.equals(fruitoreBuild.getEbmsReliabilityNonRepudiation())) {
                    throw new Exception("Property ebmsReliabilityNonRepudiation (" + fruitoreBuild.getEbmsReliabilityNonRepudiation() + ") definita definita per la " + oggettoFruizione + " differente dal valore (" + this.ebmsReliabilityNonRepudiation + ") indicato per l'erogazione della medesima API da parte del soggetto " + this.base.getNomeSoggettoErogatore());
                }
                if (this.ebmsReliabilityReplyPattern == null) {
                    this.ebmsReliabilityReplyPattern = fruitoreBuild.getEbmsReliabilityReplyPattern();
                    continue block0;
                }
                if (this.ebmsReliabilityReplyPattern.equals(fruitoreBuild.getEbmsReliabilityReplyPattern())) continue block0;
                throw new Exception("Property ebmsReliabilityReplyPattern (" + fruitoreBuild.getEbmsReliabilityReplyPattern() + ") definita definita per la " + oggettoFruizione + " differente dal valore (" + this.ebmsReliabilityReplyPattern + ") indicato per l'erogazione della medesima API da parte del soggetto " + this.base.getNomeSoggettoErogatore());
            }
        }
    }

    public void initCNFruitori(List<Soggetto> soggetti, List<IDSoggetto> soggettiAutorizzati) throws Exception {
        if (this.ebmsSecurityProfile == null) {
            throw new Exception("Property ebmsSecurityProfile non definita per l'erogazione dell'API [" + this.base.getNome() + "] erogata dal soggetto [" + this.base.getNomeSoggettoErogatore() + "]");
        }
        if (this.ebmsReliabilityNonRepudiation == null) {
            throw new Exception("Property ebmsReliabilityNonRepudiation non definita per l'erogazione dell'API [" + this.base.getNome() + "] erogata dal soggetto [" + this.base.getNomeSoggettoErogatore() + "]");
        }
        if (this.ebmsReliabilityReplyPattern == null) {
            throw new Exception("Property ebmsReliabilityReplyPattern non definita per l'erogazione dell'API [" + this.base.getNome() + "] erogata dal soggetto [" + this.base.getNomeSoggettoErogatore() + "]");
        }
        block0: for (IDSoggetto soggettoAutorizzato : soggettiAutorizzati) {
            for (Soggetto soggetto : soggetti) {
                if (!soggetto.getBase().getNome().equals(soggettoAutorizzato.getNome())) continue;
                if (this.cnFruitori.contains(soggetto.getEbmsUserMessagePartyCN())) continue block0;
                this.cnFruitori.add(soggetto.getEbmsUserMessagePartyCN());
                continue block0;
            }
        }
    }

    public void checkCNFruitori() throws Exception {
        if (this.cnFruitori.size() <= 0) {
            throw new Exception("Non sono stati definiti soggetto autorizzati a fruire del servizio " + IDServizioFactory.getInstance().getUriFromAccordo(this.base));
        }
    }
}

