/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.statistiche.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class StatisticheServerDBManager {
    private static Logger checkLogger = null;
    private static volatile boolean checkIsClosed = true;
    private static volatile boolean checkAutocommit = true;
    private static StatisticheServerDBManager instance = null;
    private final Logger log;
    private final DAOFactoryProperties daoFactoryProperties;
    private DataSource dataSource;
    private String connectionUrl;
    private String connectionUsername;
    private String connectionPassword;
    private boolean useDatasource;

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        StatisticheServerDBManager.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        StatisticheServerDBManager.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        StatisticheServerDBManager.checkLogger = checkLogger;
    }

    private StatisticheServerDBManager(Logger log) throws Exception {
        this.log = log;
        this.daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)log);
        ProjectInfo projectInfo = ProjectInfo.getInstance();
        this.useDatasource = this.daoFactoryProperties.isTipoAccessoTramiteDatasource((IProjectInfo)projectInfo);
        if (this.useDatasource) {
            this.initDatasource((IProjectInfo)projectInfo);
        } else {
            this.initConnection((IProjectInfo)projectInfo);
        }
    }

    private void initDatasource(IProjectInfo projectInfo) throws Exception {
        String jndiName = this.daoFactoryProperties.getDatasourceJNDIName(projectInfo);
        Properties jndiContext = this.daoFactoryProperties.getDatasourceJNDIContext(projectInfo);
        this.log.info("Inizializzazione DataSource tramite JNDI: {}", (Object)jndiName);
        try {
            InitialContext ctx = jndiContext != null && !jndiContext.isEmpty() ? new InitialContext(jndiContext) : new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(jndiName);
            this.log.info("DataSource inizializzato con successo");
        }
        catch (NamingException e) {
            throw new IllegalStateException("Errore durante il lookup JNDI del DataSource [" + jndiName + "]: " + e.getMessage(), e);
        }
    }

    private void initConnection(IProjectInfo projectInfo) throws Exception {
        this.connectionUrl = this.daoFactoryProperties.getConnectionUrl(projectInfo);
        String connectionDriver = this.daoFactoryProperties.getConnectionDriverJDBC(projectInfo);
        this.connectionUsername = this.daoFactoryProperties.getConnectionAuthUsername(projectInfo);
        this.connectionPassword = this.daoFactoryProperties.getConnectionAuthPassword(projectInfo);
        this.log.info("Inizializzazione connessione JDBC diretta: {}", (Object)this.connectionUrl);
        try {
            Class.forName(connectionDriver);
            this.log.info("Driver JDBC caricato: {}", (Object)connectionDriver);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Driver JDBC non trovato [" + connectionDriver + "]: " + e.getMessage(), e);
        }
    }

    public static synchronized StatisticheServerDBManager getInstance(Logger log) throws Exception {
        if (instance == null) {
            instance = new StatisticheServerDBManager(log);
        }
        return instance;
    }

    public static StatisticheServerDBManager getInstance() {
        if (instance == null) {
            Class<StatisticheServerDBManager> clazz = StatisticheServerDBManager.class;
            synchronized (StatisticheServerDBManager.class) {
                throw new IllegalStateException("StatisticheServerDBManager non inizializzato. Chiamare prima getInstance(Logger)");
            }
        }
        return instance;
    }

    public Connection getConnection() throws SQLException {
        if (this.useDatasource) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.connectionUrl, this.connectionUsername, this.connectionPassword);
    }

    public void releaseConnection(Connection connection) {
        if (connection != null) {
            try {
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connection, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
            catch (SQLException e) {
                this.log.error("closeConnection config db", (Throwable)e);
            }
        }
    }

    public boolean isUsingDatasource() {
        return this.useDatasource;
    }
}

