/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.statistiche.server;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsLibrary;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerDBManager;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerLogger;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerProperties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class StatisticheServerExecutor {
    private final Logger logCore = StatisticheServerLogger.getInstance().getLoggerServer();
    private final StatisticheServerProperties serverProperties;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> timerStatisticheOrarie;
    private ScheduledFuture<?> timerStatisticheGiornaliere;
    private ScheduledFuture<?> timerStatisticheSettimanali;
    private ScheduledFuture<?> timerStatisticheMensili;
    private ScheduledFuture<?> timerPdndGenerazione;
    private ScheduledFuture<?> timerPdndPubblicazione;
    private Map<TipoIntervalloStatistico, Semaphore> semaphores;
    private Map<TipoIntervalloStatistico, InfoStatistics> semaphoreStatistics;

    public StatisticheServerExecutor(StatisticheServerProperties serverProperties) {
        this.serverProperties = serverProperties;
        this.semaphores = new EnumMap<TipoIntervalloStatistico, Semaphore>(TipoIntervalloStatistico.class);
        this.semaphoreStatistics = new EnumMap<TipoIntervalloStatistico, InfoStatistics>(TipoIntervalloStatistico.class);
    }

    public void start() {
        this.logCore.info("Avvio scheduler statistiche...");
        int numTimers = this.countEnabledTimers();
        if (numTimers == 0) {
            this.logCore.warn("Nessun timer statistiche abilitato");
            return;
        }
        if (this.serverProperties.isSemaphoreEnabled()) {
            this.initSemaphores();
        }
        this.scheduler = Executors.newScheduledThreadPool(numTimers);
        if (this.serverProperties.isTimerStatisticheOrarieEnabled()) {
            this.timerStatisticheOrarie = this.scheduleTimer(TipoIntervalloStatistico.STATISTICHE_ORARIE, this.serverProperties.getTimerStatisticheOrarieDelayInizialeSecondi(), this.serverProperties.getTimerStatisticheOrarieIntervalloSecondi());
        }
        if (this.serverProperties.isTimerStatisticheGiornaliereEnabled()) {
            this.timerStatisticheGiornaliere = this.scheduleTimer(TipoIntervalloStatistico.STATISTICHE_GIORNALIERE, this.serverProperties.getTimerStatisticheGiornaliereDelayInizialeSecondi(), this.serverProperties.getTimerStatisticheGiornaliereIntervalloSecondi());
        }
        if (this.serverProperties.isTimerStatisticheSettimanaliEnabled()) {
            this.timerStatisticheSettimanali = this.scheduleTimer(TipoIntervalloStatistico.STATISTICHE_SETTIMANALI, this.serverProperties.getTimerStatisticheSettimanaliDelayInizialeSecondi(), this.serverProperties.getTimerStatisticheSettimanaliIntervalloSecondi());
        }
        if (this.serverProperties.isTimerStatisticheMensiliEnabled()) {
            this.timerStatisticheMensili = this.scheduleTimer(TipoIntervalloStatistico.STATISTICHE_MENSILI, this.serverProperties.getTimerStatisticheMensiliDelayInizialeSecondi(), this.serverProperties.getTimerStatisticheMensiliIntervalloSecondi());
        }
        if (this.serverProperties.isTimerPdndGenerazioneEnabled()) {
            this.timerPdndGenerazione = this.scheduleTimer(TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, this.serverProperties.getTimerPdndGenerazioneDelayInizialeSecondi(), this.serverProperties.getTimerPdndGenerazioneIntervalloSecondi());
        }
        if (this.serverProperties.isTimerPdndPubblicazioneEnabled()) {
            this.timerPdndPubblicazione = this.scheduleTimer(TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO, this.serverProperties.getTimerPdndPubblicazioneDelayInizialeSecondi(), this.serverProperties.getTimerPdndPubblicazioneIntervalloSecondi());
        }
        String msg = "Scheduler statistiche avviato con " + numTimers + " timer";
        this.logCore.info(msg);
    }

    public void stop() {
        this.logCore.info("Arresto scheduler statistiche...");
        if (this.scheduler != null) {
            this.cancelTimer(this.timerStatisticheOrarie, "statistiche orarie");
            this.cancelTimer(this.timerStatisticheGiornaliere, "statistiche giornaliere");
            this.cancelTimer(this.timerStatisticheSettimanali, "statistiche settimanali");
            this.cancelTimer(this.timerStatisticheMensili, "statistiche mensili");
            this.cancelTimer(this.timerPdndGenerazione, "PDND generazione");
            this.cancelTimer(this.timerPdndPubblicazione, "PDND pubblicazione");
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.logCore.warn("Timeout attesa terminazione scheduler, forzo shutdown...");
                    this.scheduler.shutdownNow();
                    if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.logCore.error("Scheduler non terminato correttamente");
                    }
                }
            }
            catch (InterruptedException e) {
                this.logCore.warn("Interruzione durante attesa terminazione scheduler");
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.logCore.info("Scheduler statistiche arrestato");
    }

    private int countEnabledTimers() {
        int count = 0;
        if (this.serverProperties.isTimerStatisticheOrarieEnabled()) {
            ++count;
        }
        if (this.serverProperties.isTimerStatisticheGiornaliereEnabled()) {
            ++count;
        }
        if (this.serverProperties.isTimerStatisticheSettimanaliEnabled()) {
            ++count;
        }
        if (this.serverProperties.isTimerStatisticheMensiliEnabled()) {
            ++count;
        }
        if (this.serverProperties.isTimerPdndGenerazioneEnabled()) {
            ++count;
        }
        if (this.serverProperties.isTimerPdndPubblicazioneEnabled()) {
            ++count;
        }
        return count;
    }

    private void initSemaphores() {
        this.logCore.info("Inizializzazione semafori per lock distribuito...");
        try {
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)DAOFactoryProperties.getInstance((Logger)this.logCore).getTipoDatabase((IProjectInfo)ProjectInfo.getInstance()));
            SemaphoreConfiguration config = new SemaphoreConfiguration();
            config.setIdNode(this.serverProperties.getSemaphoreNodeId());
            config.setMaxLife(this.serverProperties.getSemaphoreLockMaxLife());
            config.setMaxIdleTime(this.serverProperties.getSemaphoreLockIdleTime());
            config.setSerializableTimeWaitMs(this.serverProperties.getSemaphoreSerializableTimeWaitMs());
            config.setSerializableNextIntervalTimeMs(this.serverProperties.getSemaphoreSerializableNextIntervalTimeMs());
            config.setEmitEvent(false);
            config.setSerializableLevel(false);
            for (TipoIntervalloStatistico tipo : TipoIntervalloStatistico.values()) {
                if (!this.isTimerEnabledForType(tipo)) continue;
                String lockId = this.getLockIdForStatistica(tipo);
                InfoStatistics infoStats = new InfoStatistics();
                Semaphore semaphore = new Semaphore(infoStats, SemaphoreMapping.newInstance((String)lockId), config, databaseType, this.logCore);
                this.semaphores.put(tipo, semaphore);
                this.semaphoreStatistics.put(tipo, infoStats);
                this.logCore.info("Semaforo creato per {} con lockId={}", (Object)tipo.getValue(), (Object)lockId);
            }
            this.logCore.info("Inizializzazione semafori completata");
        }
        catch (Exception e) {
            this.logCore.error("Errore durante inizializzazione semafori: " + e.getMessage(), (Throwable)e);
            this.semaphores.clear();
            this.semaphoreStatistics.clear();
        }
    }

    private String getLockIdForStatistica(TipoIntervalloStatistico tipo) {
        if (TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO.equals((Object)tipo) || TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO.equals((Object)tipo)) {
            return tipo.getValue();
        }
        return "Generazione" + tipo.getValue();
    }

    private boolean isTimerEnabledForType(TipoIntervalloStatistico tipo) {
        switch (tipo) {
            case STATISTICHE_ORARIE: {
                return this.serverProperties.isTimerStatisticheOrarieEnabled();
            }
            case STATISTICHE_GIORNALIERE: {
                return this.serverProperties.isTimerStatisticheGiornaliereEnabled();
            }
            case STATISTICHE_SETTIMANALI: {
                return this.serverProperties.isTimerStatisticheSettimanaliEnabled();
            }
            case STATISTICHE_MENSILI: {
                return this.serverProperties.isTimerStatisticheMensiliEnabled();
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: {
                return this.serverProperties.isTimerPdndGenerazioneEnabled();
            }
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                return this.serverProperties.isTimerPdndPubblicazioneEnabled();
            }
        }
        return false;
    }

    private ScheduledFuture<?> scheduleTimer(TipoIntervalloStatistico tipo, long delayMinuti, long intervalloMinuti) {
        this.logCore.info("Scheduling timer {} - delay iniziale: {} secondi, intervallo: {} secondi", new Object[]{tipo.getValue(), delayMinuti, intervalloMinuti});
        return this.scheduler.scheduleAtFixedRate(() -> this.eseguiJob(tipo), delayMinuti, intervalloMinuti, TimeUnit.SECONDS);
    }

    private void cancelTimer(ScheduledFuture<?> timer, String nome) {
        if (timer != null && !timer.isCancelled()) {
            timer.cancel(false);
            this.logCore.debug("Timer {} cancellato", (Object)nome);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void eseguiJob(TipoIntervalloStatistico tipoStatistica) {
        String tipoStr = tipoStatistica.getValue();
        StatisticheServerLogger serverLogger = StatisticheServerLogger.getInstance();
        this.logCore.info("Avvio job statistiche: {}", (Object)tipoStr);
        StatisticsLibrary sLibrary = null;
        StatisticheServerDBManager dbManager = null;
        boolean lockAcquired = false;
        Semaphore semaphore = this.semaphores.get(tipoStatistica);
        Logger logStatistica = null;
        try {
            boolean debug = this.serverProperties.isStatisticheGenerazioneDebug();
            logStatistica = serverLogger.getLoggerStatistiche(tipoStatistica, debug);
            Logger logStatisticaSql = serverLogger.getLoggerStatisticheSql(tipoStatistica, debug);
            StatisticsConfig statisticsConfig = this.createStatisticsConfig(tipoStatistica, logStatistica, logStatisticaSql);
            if (!this.isJobEnabled(tipoStatistica)) {
                this.logCore.info("Job {} non abilitato, skip", (Object)tipoStr);
                return;
            }
            dbManager = StatisticheServerDBManager.getInstance(logStatisticaSql);
            if (semaphore != null) {
                Connection connection = null;
                try {
                    if (dbManager != null) {
                        connection = dbManager.getConnection();
                    }
                    if (connection == null) {
                        throw new CoreException("Connessione al database non disponibile");
                    }
                    connection.setAutoCommit(true);
                    lockAcquired = this.acquireLock(semaphore, connection, tipoStr);
                    if (!lockAcquired) {
                        this.logCore.info("Lock non acquisito per {}, job gi\u00e0 in esecuzione su altro nodo", (Object)tipoStr);
                        return;
                    }
                    logStatistica.debug("Lock acquisito per {}", (Object)tipoStr);
                }
                finally {
                    if (dbManager != null && connection != null) {
                        dbManager.releaseConnection(connection);
                    }
                }
            }
            DAOFactory daoFactory = DAOFactory.getInstance((Logger)logStatisticaSql);
            DAOFactoryProperties daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)logStatisticaSql);
            ServiceManagerProperties smPropertiesStatistiche = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            smPropertiesStatistiche.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
            ServiceManagerProperties smPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance());
            smPropertiesTransazioni.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
            org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM = (org.openspcoop2.core.statistiche.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), logStatisticaSql);
            org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM = (org.openspcoop2.core.transazioni.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance(), logStatisticaSql);
            org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM = null;
            IServiceManager pluginsBaseSM = null;
            org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM = null;
            org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM = null;
            if (this.serverProperties.isGenerazioneStatisticheCustom() || statisticsConfig.isPdndTracciamentoGenerazione() || statisticsConfig.isPdndTracciamentoPubblicazione()) {
                ServiceManagerProperties smPropertiesPluginsStatistiche = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance());
                smPropertiesPluginsStatistiche.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
                ServiceManagerProperties smPropertiesPluginsBase = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance());
                smPropertiesPluginsBase.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
                ServiceManagerProperties smPropertiesUtils = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                smPropertiesUtils.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
                pluginsStatisticheSM = (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance(), logStatisticaSql);
                pluginsBaseSM = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), logStatisticaSql);
                utilsSM = (org.openspcoop2.core.commons.search.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), logStatisticaSql);
                if (this.serverProperties.isAnalisiTransazioniCustom()) {
                    ServiceManagerProperties smPropertiesPluginsTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance());
                    smPropertiesPluginsTransazioni.setShowSql(this.serverProperties.isStatisticheGenerazioneDebug());
                    pluginsTransazioniSM = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), logStatisticaSql);
                }
            }
            sLibrary = new StatisticsLibrary(statisticsConfig, statisticheSM, transazioniSM, pluginsStatisticheSM, pluginsBaseSM, utilsSM, pluginsTransazioniSM);
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    sLibrary.generateStatisticaOraria();
                    break;
                }
                case STATISTICHE_GIORNALIERE: {
                    sLibrary.generateStatisticaGiornaliera();
                    break;
                }
                case STATISTICHE_SETTIMANALI: {
                    sLibrary.generateStatisticaSettimanale();
                    break;
                }
                case STATISTICHE_MENSILI: {
                    sLibrary.generateStatisticaMensile();
                    break;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    sLibrary.generatePdndGenerazioneTracciamento();
                    break;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    sLibrary.generatePdndPubblicazioneTracciamento();
                    break;
                }
            }
            this.logCore.info("Job statistiche {} completato con successo", (Object)tipoStr);
            return;
        }
        catch (Exception e) {
            this.logCore.error("Errore durante esecuzione job statistiche " + tipoStr + ": " + e.getMessage(), (Throwable)e);
            if (logStatistica == null) return;
            logStatistica.error("Errore durante esecuzione job statistiche " + tipoStr + ": " + e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            block56: {
                if (lockAcquired && semaphore != null) {
                    Connection connection = null;
                    try {
                        if (dbManager != null) {
                            connection = dbManager.getConnection();
                        }
                        if (connection == null) {
                            String msg = "Errore durante rilascio lock per " + tipoStr + ": connessione al database non disponibile";
                            this.logCore.error(msg);
                            if (logStatistica != null) {
                                logStatistica.error(msg);
                            }
                            break block56;
                        }
                        connection.setAutoCommit(true);
                        this.releaseLock(semaphore, connection, tipoStr);
                        this.logCore.debug("Lock rilasciato per {}", (Object)tipoStr);
                    }
                    catch (Exception e) {
                        String msg = "Errore durante rilascio lock per " + tipoStr + ": " + e.getMessage();
                        this.logCore.error(msg, (Throwable)e);
                        if (logStatistica != null) {
                            logStatistica.error(msg, (Throwable)e);
                        }
                    }
                    finally {
                        if (dbManager != null && connection != null) {
                            dbManager.releaseConnection(connection);
                        }
                    }
                }
            }
            if (sLibrary != null) {
                sLibrary.close();
            }
        }
    }

    private boolean acquireLock(Semaphore semaphore, Connection connection, String details) {
        try {
            long startTime = System.currentTimeMillis();
            long timeout = this.serverProperties.getSemaphoreLockAttesaAttiva();
            int checkInterval = this.serverProperties.getSemaphoreLockCheckInterval();
            while (System.currentTimeMillis() - startTime < timeout) {
                boolean acquired = semaphore.newLock(connection, details);
                if (acquired) {
                    return true;
                }
                Thread.sleep(checkInterval);
            }
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logCore.error("Errore durante acquisizione lock: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (UtilsException e) {
            return false;
        }
    }

    private void releaseLock(Semaphore semaphore, Connection connection, String details) {
        try {
            semaphore.releaseLock(connection, details);
        }
        catch (Exception e) {
            this.logCore.error("Errore durante rilascio lock: " + e.getMessage(), (Throwable)e);
        }
    }

    private StatisticsConfig createStatisticsConfig(TipoIntervalloStatistico tipoStatistica, Logger logStatistica, Logger logStatisticaSql) throws EngineException, UtilsException {
        StatisticsConfig statisticsConfig = new StatisticsConfig(false);
        statisticsConfig.setLogCore(logStatistica);
        statisticsConfig.setLogSql(logStatisticaSql);
        statisticsConfig.setPdndTracciamentoRequestConfig(this.serverProperties.getPdndTracingRequestConfig());
        statisticsConfig.setPdndTracciamentoSoggettiEnabled(this.serverProperties.getPdndTracingSoggettiEnabled());
        statisticsConfig.setPdndTracciamentoSoggettiDisabled(this.serverProperties.isPdndTracingSoggettiDisabled());
        statisticsConfig.setGenerazioneStatisticheCustom(this.serverProperties.isGenerazioneStatisticheCustom());
        statisticsConfig.setAnalisiTransazioniCustom(this.serverProperties.isAnalisiTransazioniCustom());
        statisticsConfig.setDebug(this.serverProperties.isStatisticheGenerazioneDebug());
        statisticsConfig.setUseUnionForLatency(this.serverProperties.isGenerazioneStatisticheUseUnionForLatency());
        statisticsConfig.setPdndTracciamentoFruizioniEnabled(this.serverProperties.isPdndTracingFruizioniEnabled());
        statisticsConfig.setPdndTracciamentoErogazioniEnabled(this.serverProperties.isPdndTracingErogazioniEnabled());
        statisticsConfig.setPdndTracciamentoMaxAttempt(this.serverProperties.getPdndTracingMaxAttempt());
        statisticsConfig.setPdndTracciamentoPendingCheck(this.serverProperties.getPdndTracingPendingCheck());
        statisticsConfig.setPdndTracciamentoGenerazioneDelayMinutes(this.serverProperties.getPdndTracingGenerazioneDelayMinutes());
        statisticsConfig.setPdndTracciamentoGenerazioneDbBatchSize(this.serverProperties.getPdndTracciamentoGenerazioneDbBatchSize());
        statisticsConfig.setPdndTracciamentoPubblicazioneDbBatchSize(this.serverProperties.getPdndTracciamentoPubblicazioneDbBatchSize());
        switch (tipoStatistica) {
            case STATISTICHE_ORARIE: {
                statisticsConfig.setStatisticheOrarie(true);
                statisticsConfig.setStatisticheOrarieGestioneUltimoIntervallo(this.serverProperties.isStatisticheGenerazioneBaseOrariaGestioneUltimaOra());
                break;
            }
            case STATISTICHE_GIORNALIERE: {
                statisticsConfig.setStatisticheGiornaliere(true);
                statisticsConfig.setStatisticheGiornaliereGestioneUltimoIntervallo(this.serverProperties.isStatisticheGenerazioneBaseGiornalieraGestioneUltimoGiorno());
                break;
            }
            case STATISTICHE_SETTIMANALI: {
                statisticsConfig.setStatisticheSettimanali(true);
                statisticsConfig.setStatisticheSettimanaliGestioneUltimoIntervallo(this.serverProperties.isStatisticheGenerazioneBaseSettimanaleGestioneUltimaSettimana());
                break;
            }
            case STATISTICHE_MENSILI: {
                statisticsConfig.setStatisticheMensili(true);
                statisticsConfig.setStatisticheMensiliGestioneUltimoIntervallo(this.serverProperties.isStatisticheGenerazioneBaseMensileGestioneUltimoMese());
                break;
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: {
                statisticsConfig.setPdndTracciamentoGenerazione(true);
                break;
            }
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                statisticsConfig.setPdndTracciamentoPubblicazione(true);
            }
        }
        statisticsConfig.setWaitMsBeforeNextInterval(this.serverProperties.getGenerazioneTradeOffMs());
        statisticsConfig.setWaitStatiInConsegna(this.serverProperties.isGenerazioneAttendiCompletamentoTransazioniInFasiIntermedie());
        statisticsConfig.setForceIndexConfig(this.serverProperties.getStatisticheGenerazioneForceIndexConfig());
        statisticsConfig.setGroupByConfig(this.serverProperties.getStatisticheGenerazioneGroupByConfig());
        return statisticsConfig;
    }

    private boolean isJobEnabled(TipoIntervalloStatistico tipoStatistica) throws ProtocolException {
        switch (tipoStatistica) {
            case PDND_GENERAZIONE_TRACCIAMENTO: 
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                return ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa") && ModIUtils.isTracingPDNDEnabled();
            }
        }
        return true;
    }
}

