/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.statistiche.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class StatisticheServerLogger {
    private static StatisticheServerLogger instance;
    private Logger loggerStatisticheOrarie = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione");
    private Logger loggerStatisticheOrarieError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.error");
    private Logger loggerStatisticheOrarieSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.sql");
    private Logger loggerStatisticheOrarieSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.sql.error");
    private Logger loggerStatisticheGiornaliere = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione");
    private Logger loggerStatisticheGiornaliereError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.error");
    private Logger loggerStatisticheGiornaliereSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.sql");
    private Logger loggerStatisticheGiornaliereSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.sql.error");
    private Logger loggerStatisticheSettimanali = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione");
    private Logger loggerStatisticheSettimanaliError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.error");
    private Logger loggerStatisticheSettimanaliSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.sql");
    private Logger loggerStatisticheSettimanaliSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.sql.error");
    private Logger loggerStatisticheMensili = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione");
    private Logger loggerStatisticheMensiliError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.error");
    private Logger loggerStatisticheMensiliSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.sql");
    private Logger loggerStatisticheMensiliSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.sql.error");
    private Logger loggerStatistichePdndGenerazione = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione");
    private Logger loggerStatistichePdndGenerazioneError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.error");
    private Logger loggerStatistichePdndGenerazioneSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.sql");
    private Logger loggerStatistichePdndGenerazioneSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.sql.error");
    private Logger loggerStatistichePdndPubblicazione = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione");
    private Logger loggerStatistichePdndPubblicazioneError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.error");
    private Logger loggerStatistichePdndPubblicazioneSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.sql");
    private Logger loggerStatistichePdndPubblicazioneSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.sql.error");
    private Logger loggerServer = LoggerWrapperFactory.getLogger((String)"govway.statistiche.server");
    private Logger loggerServerError = LoggerWrapperFactory.getLogger((String)"govway.statistiche.server.error");

    private StatisticheServerLogger() {
    }

    public static void initialize(Logger logConsole, String rootDirectory, Properties objectProperties) throws IOException, UtilsException {
        Properties loggerProperties = new Properties();
        File loggerFile = null;
        loggerFile = rootDirectory != null ? new File(rootDirectory + "timer-statistiche.log4j2.properties") : new File("timer-statistiche.log4j2.properties");
        if (!loggerFile.exists()) {
            loggerProperties.load(StatisticheServerLogger.class.getResourceAsStream("/timer-statistiche.log4j2.properties"));
        } else {
            try (FileInputStream fin = new FileInputStream(loggerFile);){
                loggerProperties.load(fin);
            }
        }
        StatisticheServerLogger.readLocalImplementation(logConsole, rootDirectory, loggerProperties);
        StatisticheServerLogger.readObjectImplementation(objectProperties, loggerProperties);
        PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)loggerProperties);
        LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_API_CONFIG, Map.of("appName", "govwayStats"));
        LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
    }

    private static void readLocalImplementation(Logger logConsole, String rootDirectory, Properties loggerProperties) {
        CollectionProperties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)logConsole, (String)"TIMER_STATISTICHE_LOG_PROPERTIES", (String)"timer-statistiche_local.log4j2.properties", (String)rootDirectory);
        if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
            Enumeration ridefinito = loggerPropertiesRidefinito.keys();
            while (ridefinito.hasMoreElements()) {
                String key = (String)ridefinito.nextElement();
                String value = loggerPropertiesRidefinito.get(key);
                loggerProperties.put(key, value);
            }
        }
    }

    private static void readObjectImplementation(Properties objectProperties, Properties loggerProperties) {
        if (objectProperties != null && objectProperties.size() > 0) {
            Enumeration<Object> ridefinito = objectProperties.keys();
            while (ridefinito.hasMoreElements()) {
                String key = (String)ridefinito.nextElement();
                String value = (String)objectProperties.get(key);
                loggerProperties.put(key, value);
            }
        }
    }

    public static synchronized StatisticheServerLogger getInstance() {
        if (instance == null) {
            instance = new StatisticheServerLogger();
        }
        return instance;
    }

    public Logger getLoggerStatistiche(TipoIntervalloStatistico tipoStatistica, boolean debug) {
        if (debug) {
            if (tipoStatistica != null) {
                switch (tipoStatistica) {
                    case STATISTICHE_ORARIE: {
                        return this.loggerStatisticheOrarie;
                    }
                    case STATISTICHE_GIORNALIERE: {
                        return this.loggerStatisticheGiornaliere;
                    }
                    case STATISTICHE_SETTIMANALI: {
                        return this.loggerStatisticheSettimanali;
                    }
                    case STATISTICHE_MENSILI: {
                        return this.loggerStatisticheMensili;
                    }
                    case PDND_GENERAZIONE_TRACCIAMENTO: {
                        return this.loggerStatistichePdndGenerazione;
                    }
                    case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                        return this.loggerStatistichePdndPubblicazione;
                    }
                }
            }
            return this.loggerServer;
        }
        if (tipoStatistica != null) {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return this.loggerStatisticheOrarieError;
                }
                case STATISTICHE_GIORNALIERE: {
                    return this.loggerStatisticheGiornaliereError;
                }
                case STATISTICHE_SETTIMANALI: {
                    return this.loggerStatisticheSettimanaliError;
                }
                case STATISTICHE_MENSILI: {
                    return this.loggerStatisticheMensiliError;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndGenerazioneError;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndPubblicazioneError;
                }
            }
        }
        return this.loggerServerError;
    }

    public Logger getLoggerStatisticheSql(TipoIntervalloStatistico tipoStatistica, boolean debug) {
        if (debug) {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return this.loggerStatisticheOrarieSql;
                }
                case STATISTICHE_GIORNALIERE: {
                    return this.loggerStatisticheGiornaliereSql;
                }
                case STATISTICHE_SETTIMANALI: {
                    return this.loggerStatisticheSettimanaliSql;
                }
                case STATISTICHE_MENSILI: {
                    return this.loggerStatisticheMensiliSql;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndGenerazioneSql;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndPubblicazioneSql;
                }
            }
        } else {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return this.loggerStatisticheOrarieSqlError;
                }
                case STATISTICHE_GIORNALIERE: {
                    return this.loggerStatisticheGiornaliereSqlError;
                }
                case STATISTICHE_SETTIMANALI: {
                    return this.loggerStatisticheSettimanaliSqlError;
                }
                case STATISTICHE_MENSILI: {
                    return this.loggerStatisticheMensiliSqlError;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndGenerazioneSqlError;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return this.loggerStatistichePdndPubblicazioneSqlError;
                }
            }
        }
        return this.loggerServer;
    }

    public Logger getLoggerServer() {
        return this.loggerServer;
    }

    public Logger getLoggerServerError() {
        return this.loggerServerError;
    }
}

