/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.statistiche.server;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsForceIndexConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsGroupByConfig;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerInstanceProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.InstanceProperties;
import org.openspcoop2.utils.transport.http.HttpRequestConfig;
import org.slf4j.Logger;

public class StatisticheServerProperties {
    private static StatisticheServerProperties staticInstance = null;
    private String protocolloDefault = null;
    private volatile boolean statisticheGenerazioneBaseOrariaGestioneUltimaOra = false;
    private volatile boolean statisticheGenerazioneBaseGiornalieraGestioneUltimoGiorno = false;
    private volatile boolean statisticheGenerazioneBaseSettimanaleGestioneUltimaSettimana = false;
    private volatile boolean statisticheGenerazioneBaseMensileGestioneUltimoMese = false;
    private StatisticsForceIndexConfig statisticheGenerazioneForceIndexConfig = null;
    private volatile long waitMsBeforeNextInterval = -1L;
    private volatile boolean waitStatiInConsegna = false;
    private volatile boolean generazioneStatisticheUseUnionForLatency = true;
    private volatile boolean generazioneStatisticheCustom = false;
    private volatile boolean analisiTransazioniCustom = false;
    private File pddMonitorFrameworkRepositoryJars = null;
    private HttpRequestConfig pdndTracingRequestConfig;
    private volatile boolean pdndTracingSoggettiDisabled = false;
    private Set<String> pdndTracingSoggettiEnabled;
    private Integer pdndTracingMaxAttempt = null;
    private volatile boolean pdndTracingErogazioniEnabled = true;
    private volatile boolean pdndTracingFruizioniEnabled = true;
    private List<Integer> pdndTracingPendingCheck = null;
    private volatile int pdndTracingGenerazioneDelayMinutes = 0;
    private volatile int pdndTracciamentoGenerazioneDbBatchSize = 200;
    private volatile int pdndTracciamentoPubblicazioneDbBatchSize = 200;
    private volatile boolean timerStatisticheOrarieEnabled = true;
    private volatile boolean timerStatisticheGiornaliereEnabled = true;
    private volatile boolean timerStatisticheSettimanaliEnabled = true;
    private volatile boolean timerStatisticheMensiliEnabled = true;
    private volatile boolean timerPdndGenerazioneEnabled = false;
    private volatile boolean timerPdndPubblicazioneEnabled = false;
    private volatile long timerStatisticheOrarieIntervalloSecondi = 300L;
    private volatile long timerStatisticheGiornaliereIntervalloSecondi = 1800L;
    private volatile long timerStatisticheSettimanaliIntervalloSecondi = 3600L;
    private volatile long timerStatisticheMensiliIntervalloSecondi = 7200L;
    private volatile long timerPdndGenerazioneIntervalloSecondi = 3600L;
    private volatile long timerPdndPubblicazioneIntervalloSecondi = 3600L;
    private volatile long timerStatisticheOrarieDelayInizialeSecondi = 60L;
    private volatile long timerStatisticheGiornaliereDelayInizialeSecondi = 120L;
    private volatile long timerStatisticheSettimanaliDelayInizialeSecondi = 180L;
    private volatile long timerStatisticheMensiliDelayInizialeSecondi = 240L;
    private volatile long timerPdndGenerazioneDelayInizialeSecondi = 300L;
    private volatile long timerPdndPubblicazioneDelayInizialeSecondi = 360L;
    private volatile boolean semaphoreEnabled = true;
    private String semaphoreNodeId = null;
    private volatile long semaphoreLockMaxLifeSeconds = 7200L;
    private volatile long semaphoreLockIdleTimeSeconds = 600L;
    private volatile long semaphoreSerializableTimeWaitMs = 60000L;
    private volatile int semaphoreSerializableNextIntervalTimeMs = 100;
    private volatile long semaphoreLockAttesaAttivaSeconds = 90L;
    private volatile int semaphoreLockCheckIntervalMs = 50;
    private StatisticheServerInstanceProperties props;
    private Properties rawProperties = new Properties();
    private String confDirectory;
    private boolean jdbcCloseConnectionCheckIsClosed = false;
    private boolean jdbcCloseConnectionCheckAutocommit = false;
    private StatisticsGroupByConfig statisticheGenerazioneGroupByConfig = null;
    private static final String ENV_PROPERTIES_PREFIX = "env.";

    private static synchronized void init(Logger log) throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new StatisticheServerProperties(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticheServerProperties getInstance(Logger log) throws UtilsException {
        if (staticInstance != null) return staticInstance;
        Class<StatisticheServerProperties> clazz = StatisticheServerProperties.class;
        synchronized (StatisticheServerProperties.class) {
            StatisticheServerProperties.init(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return staticInstance;
        }
    }

    public static StatisticheServerProperties getInstance() throws UtilsException {
        if (staticInstance == null) {
            Class<StatisticheServerProperties> clazz = StatisticheServerProperties.class;
            synchronized (StatisticheServerProperties.class) {
                throw new UtilsException("StatisticheServerProperties non inizializzato");
            }
        }
        return staticInstance;
    }

    private StatisticheServerProperties(Logger log) throws UtilsException {
        try {
            InputStream is = StatisticheServerProperties.class.getResourceAsStream("/timer-statistiche.properties");
            if (is == null) {
                throw new UtilsException("File '/timer-statistiche.properties' not found in classpath");
            }
            this.rawProperties.load(is);
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante l'init delle properties: " + e.getMessage(), (Throwable)e);
        }
        this.confDirectory = this.rawProperties.getProperty("confDirectory");
        if (this.confDirectory != null) {
            this.confDirectory = this.confDirectory.trim();
            this.confDirectory = PropertiesEnvUtils.resolveGovWayEnvVariables((String)this.confDirectory);
        }
        this.props = new StatisticheServerInstanceProperties(this.rawProperties, log, this.confDirectory);
        try {
            PropertiesEnvUtils.checkRequiredEnvProperties((Properties)this.props.readPropertiesConvertEnvProperties(ENV_PROPERTIES_PREFIX), (Logger)log, (String)"statistiche-server");
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante l'init delle properties: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.statisticheGenerazioneForceIndexConfig = new StatisticsForceIndexConfig(this.rawProperties);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        BooleanNullable b = this.readBooleanProperty(true, "jdbc.closeConnection.checkIsClosed");
        this.jdbcCloseConnectionCheckIsClosed = this.parse(b, true);
        b = this.readBooleanProperty(true, "jdbc.closeConnection.checkAutocommit");
        this.jdbcCloseConnectionCheckAutocommit = this.parse(b, true);
    }

    public String getConfDirectory() {
        return this.confDirectory;
    }

    public void initProperties() throws UtilsException {
        this.protocolloDefault = this.getProperty("protocolloDefault", true);
        this.statisticheGenerazioneBaseOrariaGestioneUltimaOra = this.getBooleanProperty("statistiche.generazione.baseOraria.gestioneUltimaOra", true);
        this.statisticheGenerazioneBaseGiornalieraGestioneUltimoGiorno = this.getBooleanProperty("statistiche.generazione.baseGiornaliera.gestioneUltimoGiorno", true);
        this.statisticheGenerazioneBaseSettimanaleGestioneUltimaSettimana = this.getBooleanProperty("statistiche.generazione.baseSettimanale.gestioneUltimaSettimana", true);
        this.statisticheGenerazioneBaseMensileGestioneUltimoMese = this.getBooleanProperty("statistiche.generazione.baseMensile.gestioneUltimoMese", true);
        String p = this.getProperty("statistiche.generazione.tradeOffSeconds", false);
        this.waitMsBeforeNextInterval = p != null ? Long.parseLong(p) : -1L;
        this.waitStatiInConsegna = this.getBooleanProperty("statistiche.generazione.attendiCompletamentoTransazioniInFasiIntermedie", false);
        this.generazioneStatisticheUseUnionForLatency = this.getBooleanProperty("statistiche.generazione.useUnionForLatency", true);
        this.generazioneStatisticheCustom = this.getBooleanProperty("statistiche.generazione.custom.enabled", true);
        this.analisiTransazioniCustom = this.getBooleanProperty("statistiche.generazione.custom.transazioniSdk.enabled", true);
        String tmp = this.getProperty("statistiche.pddmonitorframework.sdk.repositoryJars", false);
        if (tmp != null) {
            this.pddMonitorFrameworkRepositoryJars = new File(tmp);
        }
        this.pdndTracingRequestConfig = new HttpRequestConfig("statistiche.pdnd.tracciamento", key -> {
            try {
                return this.props.getValueConvertEnvProperties((String)key);
            }
            catch (UtilsException e) {
                return null;
            }
        });
        String value = this.getProperty("statistiche.pdnd.tracciamento.soggetti.enabled", false);
        if (value == null || StringUtils.isEmpty((CharSequence)value.trim())) {
            this.pdndTracingSoggettiDisabled = true;
            this.pdndTracingSoggettiEnabled = Set.of();
        } else {
            this.pdndTracingSoggettiEnabled = "*".equals(value) ? Set.of() : Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        value = this.getProperty("statistiche.pdnd.tracciamento.maxAttempts", false);
        if (value != null) {
            this.pdndTracingMaxAttempt = Integer.valueOf(value);
        }
        value = this.getProperty("statistiche.pdnd.tracciamento.erogazioni.enabled", false);
        if (Boolean.FALSE.toString().equals(value)) {
            this.pdndTracingErogazioniEnabled = false;
        }
        value = this.getProperty("statistiche.pdnd.tracciamento.fruizioni.enabled", false);
        if (Boolean.FALSE.toString().equals(value)) {
            this.pdndTracingFruizioniEnabled = false;
        }
        this.pdndTracingPendingCheck = (value = this.getProperty("statistiche.pdnd.tracciamento.pending.check", false)) == null || StringUtils.isEmpty((CharSequence)value.trim()) ? List.of(Integer.valueOf(0)) : Arrays.stream(value.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        value = this.getProperty("statistiche.pdnd.tracciamento.generazione.delayMinutes", false);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            this.pdndTracingGenerazioneDelayMinutes = Integer.parseInt(value);
        }
        if ((value = this.getProperty("statistiche.pdnd.tracciamento.generazione.db.batchSize", false)) != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            this.pdndTracciamentoGenerazioneDbBatchSize = Integer.parseInt(value);
        }
        if ((value = this.getProperty("statistiche.pdnd.tracciamento.pubblicazione.db.batchSize", false)) != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            this.pdndTracciamentoPubblicazioneDbBatchSize = Integer.parseInt(value);
        }
        this.timerStatisticheOrarieEnabled = this.getBooleanProperty("timer.statistiche.orarie.enabled", false);
        this.timerStatisticheGiornaliereEnabled = this.getBooleanProperty("timer.statistiche.giornaliere.enabled", false);
        this.timerStatisticheSettimanaliEnabled = this.getBooleanProperty("timer.statistiche.settimanali.enabled", false);
        this.timerStatisticheMensiliEnabled = this.getBooleanProperty("timer.statistiche.mensili.enabled", false);
        this.timerPdndGenerazioneEnabled = this.getBooleanProperty("timer.pdnd.generazione.enabled", false);
        this.timerPdndPubblicazioneEnabled = this.getBooleanProperty("timer.pdnd.pubblicazione.enabled", false);
        this.timerStatisticheOrarieIntervalloSecondi = this.getLongProperty("timer.statistiche.orarie.intervalloSecondi", false, 300L);
        this.timerStatisticheGiornaliereIntervalloSecondi = this.getLongProperty("timer.statistiche.giornaliere.intervalloSecondi", false, 1800L);
        this.timerStatisticheSettimanaliIntervalloSecondi = this.getLongProperty("timer.statistiche.settimanali.intervalloSecondi", false, 3600L);
        this.timerStatisticheMensiliIntervalloSecondi = this.getLongProperty("timer.statistiche.mensili.intervalloSecondi", false, 7200L);
        this.timerPdndGenerazioneIntervalloSecondi = this.getLongProperty("timer.pdnd.generazione.intervalloSecondi", false, 3600L);
        this.timerPdndPubblicazioneIntervalloSecondi = this.getLongProperty("timer.pdnd.pubblicazione.intervalloSecondi", false, 3600L);
        this.timerStatisticheOrarieDelayInizialeSecondi = this.getLongProperty("timer.statistiche.orarie.delayInizialeSecondi", false, 60L);
        this.timerStatisticheGiornaliereDelayInizialeSecondi = this.getLongProperty("timer.statistiche.giornaliere.delayInizialeSecondi", false, 120L);
        this.timerStatisticheSettimanaliDelayInizialeSecondi = this.getLongProperty("timer.statistiche.settimanali.delayInizialeSecondi", false, 180L);
        this.timerStatisticheMensiliDelayInizialeSecondi = this.getLongProperty("timer.statistiche.mensili.delayInizialeSecondi", false, 240L);
        this.timerPdndGenerazioneDelayInizialeSecondi = this.getLongProperty("timer.pdnd.generazione.delayInizialeSecondi", false, 300L);
        this.timerPdndPubblicazioneDelayInizialeSecondi = this.getLongProperty("timer.pdnd.pubblicazione.delayInizialeSecondi", false, 360L);
        this.semaphoreEnabled = this.getBooleanProperty("semaphore.enabled", false);
        this.semaphoreNodeId = this.getProperty("semaphore.nodeId", false);
        if (this.semaphoreNodeId == null) {
            try {
                this.semaphoreNodeId = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.semaphoreNodeId = "node-" + System.currentTimeMillis();
            }
        }
        this.semaphoreLockMaxLifeSeconds = this.getLongProperty("semaphore.lock.maxLife", false, 7200L);
        this.semaphoreLockIdleTimeSeconds = this.getLongProperty("semaphore.lock.idleTime", false, 600L);
        this.semaphoreSerializableTimeWaitMs = this.getLongProperty("semaphore.serializable.timeWaitMs", false, 60000L);
        this.semaphoreSerializableNextIntervalTimeMs = (int)this.getLongProperty("semaphore.serializable.nextIntervalTimeMs", false, 100L);
        this.semaphoreLockAttesaAttivaSeconds = this.getLongProperty("semaphore.lock.attesaAttiva", false, 90L);
        this.semaphoreLockCheckIntervalMs = (int)this.getLongProperty("semaphore.lock.checkInterval", false, 50L);
    }

    private String getProperty(String name, boolean required) throws UtilsException {
        String tmp = this.props.getValueConvertEnvProperties(name);
        if (tmp == null) {
            if (required) {
                throw new UtilsException(String.format("Property '%s' not found", name));
            }
            return null;
        }
        return tmp.trim();
    }

    public String readProperty(boolean required, String property) throws UtilsException {
        return this.getProperty(property, required);
    }

    private boolean getBooleanProperty(String name, boolean required) throws UtilsException {
        String tmp = this.getProperty(name, required);
        if (tmp != null) {
            try {
                return Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(String.format("Property '%s' wrong boolean format: %s", name, e.getMessage()));
            }
        }
        return false;
    }

    private long getLongProperty(String name, boolean required, long defaultValue) throws UtilsException {
        String tmp = this.getProperty(name, required);
        if (tmp != null) {
            try {
                return Long.parseLong(tmp);
            }
            catch (Exception e) {
                throw new UtilsException("Property '" + name + "' wrong long format: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    private BooleanNullable readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.getProperty(property, required);
        if (tmp == null && !required) {
            return BooleanNullable.NULL();
        }
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (true/false expected)");
        }
        return Boolean.parseBoolean(tmp) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    private boolean parse(BooleanNullable b, boolean defaultValue) {
        return b != null && b.getValue() != null ? b.getValue() : defaultValue;
    }

    public String getProtocolloDefault() {
        return this.protocolloDefault;
    }

    public boolean isStatisticheGenerazioneDebug() throws UtilsException {
        return this.getBooleanProperty("statistiche.generazione.debug", true);
    }

    public boolean isStatisticheGenerazioneBaseOrariaGestioneUltimaOra() {
        return this.statisticheGenerazioneBaseOrariaGestioneUltimaOra;
    }

    public boolean isStatisticheGenerazioneBaseGiornalieraGestioneUltimoGiorno() {
        return this.statisticheGenerazioneBaseGiornalieraGestioneUltimoGiorno;
    }

    public boolean isStatisticheGenerazioneBaseSettimanaleGestioneUltimaSettimana() {
        return this.statisticheGenerazioneBaseSettimanaleGestioneUltimaSettimana;
    }

    public boolean isStatisticheGenerazioneBaseMensileGestioneUltimoMese() {
        return this.statisticheGenerazioneBaseMensileGestioneUltimoMese;
    }

    public StatisticsForceIndexConfig getStatisticheGenerazioneForceIndexConfig() {
        return this.statisticheGenerazioneForceIndexConfig;
    }

    public StatisticsGroupByConfig getStatisticheGenerazioneGroupByConfig() throws UtilsException {
        if (this.statisticheGenerazioneGroupByConfig == null) {
            this.statisticheGenerazioneGroupByConfig = StatisticsConfig.parseGroupByConfig((InstanceProperties)this.props, (String)"statistiche.generazione.");
        }
        return this.statisticheGenerazioneGroupByConfig;
    }

    public boolean isGenerazioneStatisticheUseUnionForLatency() {
        return this.generazioneStatisticheUseUnionForLatency;
    }

    public boolean isGenerazioneStatisticheCustom() {
        return this.generazioneStatisticheCustom;
    }

    public boolean isAnalisiTransazioniCustom() {
        return this.analisiTransazioniCustom;
    }

    public File getPddMonitorFrameworkRepositoryJars() {
        return this.pddMonitorFrameworkRepositoryJars;
    }

    public long getGenerazioneTradeOffMs() {
        return this.waitMsBeforeNextInterval;
    }

    public boolean isGenerazioneAttendiCompletamentoTransazioniInFasiIntermedie() {
        return this.waitStatiInConsegna;
    }

    public boolean isSecurityLoadBouncyCastleProvider() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "security.addBouncyCastleProvider");
        return this.parse(b, false);
    }

    public String getEnvMapConfig() throws UtilsException {
        return this.readProperty(false, "env.map.config");
    }

    public boolean isEnvMapConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "env.map.required");
        return this.parse(b, false);
    }

    public String getHSMConfigurazione() throws UtilsException {
        return this.readProperty(false, "hsm.config");
    }

    public boolean isHSMRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.required");
        return this.parse(b, false);
    }

    public boolean isHSMKeyPasswordConfigurable() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.keyPassword");
        return this.parse(b, false);
    }

    public String getBYOKConfigurazione() throws UtilsException {
        return this.readProperty(false, "byok.config");
    }

    public boolean isBYOKRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.required");
        return this.parse(b, false);
    }

    public String getBYOKEnvSecretsConfig() throws UtilsException {
        return this.readProperty(false, "byok.env.secrets.config");
    }

    public boolean isBYOKEnvSecretsConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.env.secrets.required");
        return this.parse(b, false);
    }

    public HttpRequestConfig getPdndTracingRequestConfig() {
        return this.pdndTracingRequestConfig;
    }

    public Set<String> getPdndTracingSoggettiEnabled() {
        return this.pdndTracingSoggettiEnabled;
    }

    public boolean isPdndTracingSoggettiDisabled() {
        return this.pdndTracingSoggettiDisabled;
    }

    public boolean isPdndTracingErogazioniEnabled() {
        return this.pdndTracingErogazioniEnabled;
    }

    public boolean isPdndTracingFruizioniEnabled() {
        return this.pdndTracingFruizioniEnabled;
    }

    public Integer getPdndTracingMaxAttempt() {
        return this.pdndTracingMaxAttempt;
    }

    public List<Integer> getPdndTracingPendingCheck() {
        return this.pdndTracingPendingCheck;
    }

    public int getPdndTracingGenerazioneDelayMinutes() {
        return this.pdndTracingGenerazioneDelayMinutes;
    }

    public int getPdndTracciamentoGenerazioneDbBatchSize() {
        return this.pdndTracciamentoGenerazioneDbBatchSize;
    }

    public int getPdndTracciamentoPubblicazioneDbBatchSize() {
        return this.pdndTracciamentoPubblicazioneDbBatchSize;
    }

    public boolean isTimerStatisticheOrarieEnabled() {
        return this.timerStatisticheOrarieEnabled;
    }

    public boolean isTimerStatisticheGiornaliereEnabled() {
        return this.timerStatisticheGiornaliereEnabled;
    }

    public boolean isTimerStatisticheSettimanaliEnabled() {
        return this.timerStatisticheSettimanaliEnabled;
    }

    public boolean isTimerStatisticheMensiliEnabled() {
        return this.timerStatisticheMensiliEnabled;
    }

    public boolean isTimerPdndGenerazioneEnabled() {
        return this.timerPdndGenerazioneEnabled;
    }

    public boolean isTimerPdndPubblicazioneEnabled() {
        return this.timerPdndPubblicazioneEnabled;
    }

    public long getTimerStatisticheOrarieIntervalloSecondi() {
        return this.timerStatisticheOrarieIntervalloSecondi;
    }

    public long getTimerStatisticheGiornaliereIntervalloSecondi() {
        return this.timerStatisticheGiornaliereIntervalloSecondi;
    }

    public long getTimerStatisticheSettimanaliIntervalloSecondi() {
        return this.timerStatisticheSettimanaliIntervalloSecondi;
    }

    public long getTimerStatisticheMensiliIntervalloSecondi() {
        return this.timerStatisticheMensiliIntervalloSecondi;
    }

    public long getTimerPdndGenerazioneIntervalloSecondi() {
        return this.timerPdndGenerazioneIntervalloSecondi;
    }

    public long getTimerPdndPubblicazioneIntervalloSecondi() {
        return this.timerPdndPubblicazioneIntervalloSecondi;
    }

    public long getTimerStatisticheOrarieDelayInizialeSecondi() {
        return this.timerStatisticheOrarieDelayInizialeSecondi;
    }

    public long getTimerStatisticheGiornaliereDelayInizialeSecondi() {
        return this.timerStatisticheGiornaliereDelayInizialeSecondi;
    }

    public long getTimerStatisticheSettimanaliDelayInizialeSecondi() {
        return this.timerStatisticheSettimanaliDelayInizialeSecondi;
    }

    public long getTimerStatisticheMensiliDelayInizialeSecondi() {
        return this.timerStatisticheMensiliDelayInizialeSecondi;
    }

    public long getTimerPdndGenerazioneDelayInizialeSecondi() {
        return this.timerPdndGenerazioneDelayInizialeSecondi;
    }

    public long getTimerPdndPubblicazioneDelayInizialeSecondi() {
        return this.timerPdndPubblicazioneDelayInizialeSecondi;
    }

    public boolean isSemaphoreEnabled() {
        return this.semaphoreEnabled;
    }

    public String getSemaphoreNodeId() {
        return this.semaphoreNodeId;
    }

    public long getSemaphoreLockMaxLife() {
        return this.semaphoreLockMaxLifeSeconds;
    }

    public long getSemaphoreLockIdleTime() {
        return this.semaphoreLockIdleTimeSeconds;
    }

    public long getSemaphoreSerializableTimeWaitMs() {
        return this.semaphoreSerializableTimeWaitMs;
    }

    public int getSemaphoreSerializableNextIntervalTimeMs() {
        return this.semaphoreSerializableNextIntervalTimeMs;
    }

    public long getSemaphoreLockAttesaAttiva() {
        return this.semaphoreLockAttesaAttivaSeconds * 1000L;
    }

    public int getSemaphoreLockCheckInterval() {
        return this.semaphoreLockCheckIntervalMs;
    }

    public boolean isJdbcCloseConnectionCheckIsClosed() {
        return this.jdbcCloseConnectionCheckIsClosed;
    }

    public boolean isJdbcCloseConnectionCheckAutocommit() {
        return this.jdbcCloseConnectionCheckAutocommit;
    }

    public Properties getEnvProperties() throws UtilsException {
        try {
            return this.props.readProperties(ENV_PROPERTIES_PREFIX);
        }
        catch (Exception e) {
            throw new UtilsException("Error reading environment properties: " + e.getMessage(), (Throwable)e);
        }
    }
}

