/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.statistiche.server;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerDBManager;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerExecutor;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerLogger;
import org.openspcoop2.pdd.timers.statistiche.server.StatisticheServerProperties;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.slf4j.Logger;

public class StatisticheServletListener
implements ServletContextListener {
    private Logger logCore = null;
    private StatisticheServerExecutor executor = null;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.initLogging();
            this.logCore.info("Inizializzazione servizio statistiche in corso...");
            StatisticheServerProperties serverProperties = StatisticheServerProperties.getInstance(this.logCore);
            PropertiesEnvUtils.checkRequiredEnvProperties((Properties)serverProperties.getEnvProperties(), (Logger)this.logCore, (String)"govwayStats");
            this.logCore = StatisticheServerLogger.getInstance().getLoggerStatistiche(null, serverProperties.isStatisticheGenerazioneDebug());
            this.initCheckConnection(serverProperties);
            this.initMapProperties(serverProperties);
            this.initSecurityProvider(serverProperties);
            this.initHSMManager(serverProperties);
            BYOKManager byokManager = this.initBYOKManager(serverProperties);
            this.initSecrets(serverProperties, byokManager);
            serverProperties.initProperties();
            this.initProtocolFactoryManager(serverProperties);
            if (serverProperties.isStatisticheGenerazioneDebug()) {
                this.logCore = LoggerWrapperFactory.getLogger((String)"govway.statistiche.server");
            }
            this.executor = new StatisticheServerExecutor(serverProperties);
            this.executor.start();
            this.logCore.info("Servizio statistiche inizializzato correttamente");
        }
        catch (Exception e) {
            String msg = "Errore durante l'inizializzazione del servizio statistiche: " + e.getMessage();
            if (this.logCore != null) {
                this.logCore.error(msg, (Throwable)e);
            }
            throw new IllegalStateException("Inizializzazione servizio statistiche fallita", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        block5: {
            if (this.logCore != null) {
                this.logCore.info("Arresto servizio statistiche in corso...");
            }
            try {
                if (this.executor != null) {
                    this.executor.stop();
                }
                if (this.logCore != null) {
                    this.logCore.info("Servizio statistiche arrestato correttamente");
                }
            }
            catch (Exception e) {
                String msg = "Errore durante l'arresto del servizio statistiche: " + e.getMessage();
                if (this.logCore == null) break block5;
                this.logCore.error(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readConfDir() {
        String confDir = null;
        try {
            InputStream is = StatisticheServletListener.class.getResourceAsStream("/timer-statistiche.properties");
            try {
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    confDir = p.getProperty("confDirectory");
                    if (confDir != null) {
                        confDir = confDir.trim();
                    }
                }
            }
            finally {
                this.close(is);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return confDir;
    }

    private void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initLogging() throws IllegalStateException, IOException, UtilsException {
        try {
            this.logCore = LoggerWrapperFactory.getLogger((String)"govway.statistiche.server");
            StatisticheServerLogger.initialize(this.logCore, this.readConfDir(), null);
            this.logCore = StatisticheServerLogger.getInstance().getLoggerServer();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void initCheckConnection(StatisticheServerProperties serverProperties) {
        ServicesUtils.initCheckConnectionDB((Logger)this.logCore, (boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
        StatisticheServerDBManager.setCheckLogger(this.logCore);
        StatisticheServerDBManager.setCheckIsClosed(serverProperties.isJdbcCloseConnectionCheckIsClosed());
        StatisticheServerDBManager.setCheckAutocommit(serverProperties.isJdbcCloseConnectionCheckAutocommit());
    }

    private void initMapProperties(StatisticheServerProperties serverProperties) throws UtilsException {
        String mapConfig = serverProperties.getEnvMapConfig();
        if (StringUtils.isNotEmpty((CharSequence)mapConfig)) {
            this.logCore.info("Inizializzazione environment in corso...");
            MapProperties.initialize((Logger)this.logCore, (String)mapConfig, (boolean)serverProperties.isEnvMapConfigRequired());
            MapProperties mapProperties = MapProperties.getInstance();
            mapProperties.initEnvironment();
            String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + String.valueOf(mapProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(mapProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + String.valueOf(mapProperties.getObfuscatedJavaKeys()) + "\n\tObfuscatedEnvKeys: " + String.valueOf(mapProperties.getObfuscatedEnvKeys());
            this.logCore.info(msgInit);
        }
    }

    private void initSecurityProvider(StatisticheServerProperties serverProperties) throws UtilsException {
        this.logCore.info("Inizializzazione security provider...");
        if (serverProperties.isSecurityLoadBouncyCastleProvider()) {
            ProviderUtils.addBouncyCastleAfterSun((boolean)true);
            this.logCore.info("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        this.logCore.info("Inizializzazione security provider effettuata con successo");
    }

    private void initHSMManager(StatisticheServerProperties serverProperties) throws UtilsException {
        String hsmConfig = serverProperties.getHSMConfigurazione();
        if (StringUtils.isNotEmpty((CharSequence)hsmConfig)) {
            this.logCore.info("Inizializzazione HSM in corso...");
            File f = new File(hsmConfig);
            HSMManager.init((File)f, (boolean)serverProperties.isHSMRequired(), (Logger)this.logCore, (boolean)false);
            HSMUtils.setHsmConfigurableKeyPassword((boolean)serverProperties.isHSMKeyPasswordConfigurable());
            this.logCore.info("Inizializzazione HSM effettuata con successo");
        }
    }

    private BYOKManager initBYOKManager(StatisticheServerProperties serverProperties) throws UtilsException {
        BYOKManager byokManager = null;
        String byokConfig = serverProperties.getBYOKConfigurazione();
        if (StringUtils.isNotEmpty((CharSequence)byokConfig)) {
            this.logCore.info("Inizializzazione BYOK in corso...");
            File f = new File(byokConfig);
            BYOKManager.init((File)f, (boolean)serverProperties.isBYOKRequired(), (Logger)this.logCore);
            byokManager = BYOKManager.getInstance();
            String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + String.valueOf(byokManager.getKeystoreTypes()) + "\n\tSecurityEngine registrati: " + String.valueOf(byokManager.getSecurityEngineTypes()) + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
            this.logCore.info(msgInit);
        }
        return byokManager;
    }

    private void initSecrets(StatisticheServerProperties serverProperties, BYOKManager byokManager) throws UtilsException {
        String secretsConfig = serverProperties.getBYOKEnvSecretsConfig();
        if (byokManager != null && StringUtils.isNotEmpty((CharSequence)secretsConfig)) {
            this.logCore.info("Inizializzazione secrets in corso...");
            HashMap dynamicMap = new HashMap();
            DynamicInfo dynamicInfo = new DynamicInfo();
            DynamicUtils.fillDynamicMap((Logger)this.logCore, dynamicMap, (DynamicInfo)dynamicInfo);
            BYOKMapProperties.initialize((Logger)this.logCore, (String)secretsConfig, (boolean)serverProperties.isBYOKEnvSecretsConfigRequired(), (boolean)true, dynamicMap, (boolean)true);
            BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
            secretsProperties.initEnvironment();
            String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + String.valueOf(secretsProperties.getJavaMap().keys()) + "\n\tEnvProperties: " + String.valueOf(secretsProperties.getEnvMap().keys()) + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
            this.logCore.info(msgInit);
        }
    }

    private void initProtocolFactoryManager(StatisticheServerProperties serverProperties) throws ProtocolException {
        this.logCore.info("Inizializzazione ProtocolFactoryManager in corso...");
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setAttesaAttivaJDBC(-1L);
        configPdD.setCheckIntervalJDBC(-1);
        configPdD.setLoader(new Loader(StatisticheServletListener.class.getClassLoader()));
        configPdD.setLog(this.logCore);
        ProtocolFactoryManager.initialize((Logger)this.logCore, (ConfigurazionePdD)configPdD, (String)serverProperties.getProtocolloDefault());
        this.logCore.info("Inizializzazione ProtocolFactoryManager effettuata con successo");
    }
}

