/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.IOUtils;
import org.openspcoop2.utils.CopyStreamMethod;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.UtilsException;

public class CopyStream {
    private CopyStream() {
    }

    public static InputStream buildTimeoutInputStream(InputStream isParam, int timeout) throws UtilsException {
        InputStream is = isParam;
        if (timeout > 0 && !(is instanceof TimeoutInputStream)) {
            try {
                is = new TimeoutInputStream(isParam, timeout);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return is;
    }

    public static InputStream buildLimitedInputStream(InputStream isParam, long limitBytes) throws UtilsException {
        InputStream is = isParam;
        if (limitBytes > 0L && !(is instanceof LimitedInputStream)) {
            try {
                is = new LimitedInputStream(isParam, limitBytes);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return is;
    }

    public static void copy(InputStream is, OutputStream os) throws UtilsException {
        CopyStream.copy(CopyStreamMethod.AUTO, is, os, -1, -1L);
    }

    public static void copy(CopyStreamMethod method, InputStream is, OutputStream os) throws UtilsException {
        CopyStream.copy(method, is, os, -1, -1L);
    }

    public static void copy(InputStream is, OutputStream os, int timeout) throws UtilsException {
        CopyStream.copy(CopyStreamMethod.AUTO, is, os, timeout);
    }

    public static void copy(CopyStreamMethod method, InputStream isParam, OutputStream os, int timeout) throws UtilsException {
        CopyStream.copy(method, isParam, os, timeout, -1L);
    }

    public static void copy(InputStream is, OutputStream os, long limitBytes) throws UtilsException {
        CopyStream.copy(CopyStreamMethod.AUTO, is, os, limitBytes);
    }

    public static void copy(CopyStreamMethod method, InputStream isParam, OutputStream os, long limitBytes) throws UtilsException {
        CopyStream.copy(method, isParam, os, -1, limitBytes);
    }

    public static void copy(InputStream isParam, OutputStream os, int timeout, long limitBytes) throws UtilsException {
        CopyStream.copy(CopyStreamMethod.AUTO, isParam, os, timeout, limitBytes);
    }

    public static void copy(CopyStreamMethod method, InputStream isParam, OutputStream os, int timeout, long limitBytes) throws UtilsException {
        InputStream is = isParam;
        if (limitBytes > 0L) {
            is = CopyStream.buildLimitedInputStream(is, limitBytes);
        }
        if (timeout > 0) {
            is = CopyStream.buildTimeoutInputStream(is, timeout);
        }
        switch (method) {
            case JAVA: {
                CopyStream.copyBuffer(is, os);
                break;
            }
            case JAVA_TRANSFER_TO: {
                CopyStream.transferTo(is, os);
                break;
            }
            case JAVA_NIO: {
                CopyStream.copyChannels(is, os);
                break;
            }
            case GUAVA: {
                CopyStream.copyGuava(is, os);
                break;
            }
            case COMMONS_IO: {
                CopyStream.copyCommonsIO(is, os);
                break;
            }
            case SERVER_SENT_EVENTS: {
                CopyStream.copyServerSentEvents(is, os);
                break;
            }
            case AUTO: {
                boolean timeoutInputStream = false;
                InputStream checkIs = is;
                OutputStream checkOs = os;
                if (is instanceof TimeoutInputStream) {
                    checkIs = ((TimeoutInputStream)is).getIsWrapped();
                    timeoutInputStream = true;
                }
                if (checkOs instanceof FileOutputStream) {
                    CopyStream.copyChannels(is, os);
                    break;
                }
                if (checkIs instanceof FileInputStream) {
                    if (timeoutInputStream) {
                        CopyStream.transferTo(is, os);
                        break;
                    }
                    CopyStream.copyChannels(is, os);
                    break;
                }
                CopyStream.transferTo(is, os);
            }
        }
    }

    public static void copyBuffer(InputStream is, OutputStream os) throws UtilsException {
        CopyStream.copyBuffer(is, os, 65536);
    }

    public static void copyBuffer(InputStream is, OutputStream os, int sizeBuffer) throws UtilsException {
        try {
            byte[] buffer = new byte[sizeBuffer];
            int letti = 0;
            while ((letti = is.read(buffer)) != -1) {
                os.write(buffer, 0, letti);
            }
            os.flush();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyServerSentEvents(InputStream is, OutputStream os) throws UtilsException {
        try (InputStreamReader isr = new InputStreamReader(is);
             BufferedReader reader = new BufferedReader(isr);
             PrintWriter writer = new PrintWriter(os);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
                writer.flush();
                if (!line.isEmpty()) continue;
                writer.println();
                writer.flush();
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void transferTo(InputStream is, OutputStream os) throws UtilsException {
        try {
            is.transferTo(os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyGuava(InputStream is, OutputStream os) throws UtilsException {
        try {
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyCommonsIO(InputStream is, OutputStream os) throws UtilsException {
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyChannels(InputStream src, OutputStream dest) throws UtilsException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        CopyStream.copyChannels(inputChannel, outputChannel);
    }

    public static void copyChannels(ReadableByteChannel src, WritableByteChannel dest) throws UtilsException {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, OutputStream os) throws UtilsException {
        try {
            Files.copy(from.toPath(), os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, File to) throws UtilsException {
        try {
            Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(File from, File to, CopyOption ... options) throws UtilsException {
        try {
            Files.copy(from.toPath(), to.toPath(), options);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(InputStream from, File to) throws UtilsException {
        CopyStream.copy(from, to, -1, -1L);
    }

    public static void copy(InputStream from, File to, int timeout) throws UtilsException {
        CopyStream.copy(from, to, timeout, -1L);
    }

    public static void copy(InputStream from, File to, long limitBytes) throws UtilsException {
        CopyStream.copy(from, to, -1, limitBytes);
    }

    public static void copy(InputStream from, File to, int timeout, long limitBytes) throws UtilsException {
        try {
            InputStream is = from;
            if (limitBytes > 0L) {
                is = CopyStream.buildLimitedInputStream(is, limitBytes);
            }
            if (timeout > 0) {
                is = CopyStream.buildTimeoutInputStream(is, timeout);
            }
            Files.copy(is, to.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(InputStream from, File to, CopyOption ... options) throws UtilsException {
        CopyStream.copy(from, to, -1, -1L, options);
    }

    public static void copy(InputStream from, File to, int timeout, CopyOption ... options) throws UtilsException {
        CopyStream.copy(from, to, timeout, -1L, options);
    }

    public static void copy(InputStream from, File to, long limitBytes, CopyOption ... options) throws UtilsException {
        CopyStream.copy(from, to, -1, limitBytes, options);
    }

    public static void copy(InputStream from, File to, int timeout, long limitBytes, CopyOption ... options) throws UtilsException {
        try {
            InputStream is = from;
            if (limitBytes > 0L) {
                is = CopyStream.buildLimitedInputStream(is, limitBytes);
            }
            if (timeout > 0) {
                is = CopyStream.buildTimeoutInputStream(is, timeout);
            }
            Files.copy(is, to.toPath(), options);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

