/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.LimitedInputStreamEngine;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;

public class LimitedInputStream
extends FilterInputStream {
    public static final MapKey<String> EXCEPTION_KEY = Map.newMapKey("LimitExceededIOException");
    public static final MapKey<String> ERROR_MSG_KEY = Map.newMapKey("LimitedInputStream");
    public static final String ERROR_PAYLOAD_TOO_LARGE_MSG = "Payload too large";
    public static final String ERROR_CONTENT_LENGTH_EXCEEDED_MSG = "Content-Length exceeds the allowed limit";

    public LimitedInputStream(InputStream is, long limitBytes) throws IOException {
        this(is, limitBytes, null, null, null);
    }

    public LimitedInputStream(InputStream is, long limitBytes, Map<Object> ctx) throws IOException {
        this(is, limitBytes, null, ctx, null);
    }

    public LimitedInputStream(InputStream is, long limitBytes, Map<Object> ctx, ILimitExceededNotifier notifier) throws IOException {
        this(is, limitBytes, null, ctx, notifier);
    }

    public LimitedInputStream(InputStream is, long limitBytes, String prefixError, Map<Object> ctx, ILimitExceededNotifier notifier) throws IOException {
        super(new LimitedInputStreamEngine(is, limitBytes, prefixError, ctx, notifier));
    }

    public InputStream getIsWrapped() {
        InputStream is = this.in;
        if (is instanceof LimitedInputStreamEngine) {
            return ((LimitedInputStreamEngine)is).getIsWrapped();
        }
        return is;
    }

    public void disableCheck() {
        InputStream is = this.in;
        if (is instanceof LimitedInputStreamEngine) {
            ((LimitedInputStreamEngine)is).disableCheck();
        }
    }

    public void updateThreshold(long limitBytes) throws IOException {
        InputStream is = this.in;
        if (is instanceof LimitedInputStreamEngine) {
            ((LimitedInputStreamEngine)is).updateThreshold(limitBytes);
        }
    }

    public void updateContext(Map<Object> ctx) {
        InputStream is = this.in;
        if (is instanceof LimitedInputStreamEngine) {
            ((LimitedInputStreamEngine)is).updateContext(ctx);
        }
    }

    public void updateNotifier(ILimitExceededNotifier notifier) {
        InputStream is = this.in;
        if (is instanceof LimitedInputStreamEngine) {
            ((LimitedInputStreamEngine)is).updateNotifier(notifier);
        }
    }
}

