/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.json.JsonConfigurationFactory;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.config.yaml.YamlConfigurationFactory;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerWrapperFactory {
    private static final String FORMAT_MSG = "%p <%d{dd-MM-yyyy HH:mm:ss.SSS}> %C.%M(%L): %m %n %n";
    private static final String LOGGER_CATEGORY_NAME_SUFFIX = ".name";
    private static final String LOGGER_APPENDER_PREFIX = "appender.";
    private static final String LOGGER_APPENDER_NAME_SUFFIX = ".name";
    private static final Pattern LOG_VARIABLE_PATTERN = Pattern.compile("%\\{([^\\}]+)\\}");
    private static final String LAYOUT_TYPE_SUFFIX = ".layout.type";
    private static final String LAYOUT_PATTERN_SUFFIX = ".layout.pattern";
    private static final String LAYOUT_EVENT_TEMPLATE_URI_SUFFIX = ".layout.eventTemplateUri";
    private static String clusterIdEnv;
    private static String clusterIdStrategy;
    private static Set<String> clusterId;

    private LoggerWrapperFactory() {
    }

    public static Logger getLogger(Class<?> c) {
        return LoggerFactory.getLogger(c);
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static org.apache.logging.log4j.Logger getLoggerImpl(Class<?> c) {
        return LogManager.getLogger(c);
    }

    public static org.apache.logging.log4j.Logger getLoggerImpl(String name) {
        return LogManager.getLogger((String)name);
    }

    public static void setPropertiesConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new PropertiesConfigurationFactory());
    }

    public static void setJSonConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new JsonConfigurationFactory());
    }

    public static void setXmlConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new XmlConfigurationFactory());
    }

    public static void setYamlConfigurationFactory() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new YamlConfigurationFactory());
    }

    private static LoggerContext getContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    private static LoggerContext getContext(boolean currentContext) {
        return (LoggerContext)LogManager.getContext((boolean)currentContext);
    }

    public static void setDefaultConsoleLogConfiguration(Level level) {
        LoggerWrapperFactory.setDefaultLogConfiguration(level, true, FORMAT_MSG, null, null);
    }

    public static void setDefaultConsoleLogConfiguration(Level level, String layout) {
        LoggerWrapperFactory.setDefaultLogConfiguration(level, true, layout, null, null);
    }

    public static void setDefaultLogConfiguration(Level level, boolean console, String layoutConsole, File file, String layoutFile) {
        System.setProperty("log4j2.disable.jmx", "true");
        if (layoutConsole == null) {
            layoutConsole = FORMAT_MSG;
        }
        if (layoutFile == null) {
            layoutFile = FORMAT_MSG;
        }
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("ConsoleDefault");
        builder.setStatusLevel(Level.ERROR);
        if (console) {
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", layoutConsole));
            builder.add(appenderBuilder);
        }
        if (file != null) {
            LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", layoutFile);
            ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100M"));
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", file.getAbsolutePath())).addAttribute("filePattern", file.getAbsolutePath() + ".%i")).add(layoutBuilder).addComponent(triggeringPolicy);
            builder.add(appenderBuilder);
        }
        RootLoggerComponentBuilder rootLoggerBuilder = builder.newRootLogger(level);
        if (console) {
            rootLoggerBuilder.add(builder.newAppenderRef("Stdout"));
        }
        if (file != null) {
            rootLoggerBuilder.add(builder.newAppenderRef("rolling"));
        }
        builder.add(rootLoggerBuilder);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }

    public static void setLogConfiguration(File file) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), file, false);
    }

    public static void setLogConfiguration(File file, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), file, append);
    }

    private static void setLogConfiguration(LoggerContext context, File file, boolean append) throws UtilsException {
        block6: {
            String filePath = "fs";
            try {
                if (file == null) {
                    throw new UtilsException("Resource file undefined");
                }
                filePath = file.getAbsolutePath();
                if (file.exists()) {
                    if (append) {
                        LoggerWrapperFactory.appendConfiguration(context, file.toURI());
                    } else {
                        LoggerWrapperFactory.newConfiguration(context, file.toURI());
                    }
                    break block6;
                }
                throw new UtilsException("Resource not exists");
            }
            catch (Exception e) {
                throw new UtilsException("Setting Logging Configuration (resource [" + filePath + "]): " + e.getMessage(), e);
            }
        }
    }

    public static void setLogConfiguration(String name) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), name, false);
    }

    public static void setLogConfiguration(String name, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), name, append);
    }

    private static void setLogConfiguration(LoggerContext context, String name, boolean append) throws UtilsException {
        try {
            if (name == null) {
                throw new UtilsException("Resource name undefined");
            }
            File f = new File(name);
            LoggerWrapperFactory.setLogConfiguration(context, name, append, f);
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed (resource [" + name + "]): " + e.getMessage(), e);
        }
    }

    private static void setLogConfiguration(LoggerContext context, String name, boolean append, File f) throws UtilsException, URISyntaxException {
        if (f.exists()) {
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, f.toURI());
            } else {
                LoggerWrapperFactory.newConfiguration(context, f.toURI());
            }
        } else {
            Object newName = null;
            newName = name.trim().startsWith("/") ? name : "/" + name;
            URL url = Utilities.class.getResource((String)newName);
            if (url != null) {
                if (append) {
                    LoggerWrapperFactory.appendConfiguration(context, url.toURI());
                } else {
                    LoggerWrapperFactory.newConfiguration(context, url.toURI());
                }
            } else {
                throw new UtilsException("Resource [" + name + "] not found");
            }
        }
    }

    public static void setLogConfiguration(URL url) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), url, false);
    }

    public static void setLogConfiguration(URL url, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), url, append);
    }

    private static void setLogConfiguration(LoggerContext context, URL url, boolean append) throws UtilsException {
        try {
            if (url == null) {
                throw new UtilsException("Resource URL undefined");
            }
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, url.toURI());
            } else {
                LoggerWrapperFactory.newConfiguration(context, url.toURI());
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed (url [" + String.valueOf(url) + "]): " + e.getMessage(), e);
        }
    }

    public static void setLogConfiguration(URI uri) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), uri, false);
    }

    public static void setLogConfiguration(URI uri, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), uri, append);
    }

    private static void setLogConfiguration(LoggerContext context, URI uri, boolean append) throws UtilsException {
        try {
            if (uri == null) {
                throw new UtilsException("Resource URI undefined");
            }
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, uri);
            } else {
                LoggerWrapperFactory.newConfiguration(context, uri);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed (uri [" + String.valueOf(uri) + "]): " + e.getMessage(), e);
        }
    }

    public static void setLogConfiguration(Properties props) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), props, false);
    }

    public static void setLogConfiguration(Properties props, boolean append) throws UtilsException {
        LoggerWrapperFactory.setLogConfiguration(LoggerWrapperFactory.getContext(), props, append);
    }

    private static void setLogConfiguration(LoggerContext context, Properties props, boolean append) throws UtilsException {
        if (props == null) {
            throw new UtilsException("Resource Properties undefined");
        }
        File fTmp = null;
        try {
            fTmp = Utilities.createTempPath("op2_log", ".properties").toFile();
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed: " + e.getMessage(), e);
        }
        try (FileOutputStream foutTmp = new FileOutputStream(fTmp);){
            props.store(foutTmp, "Tmp Configuration");
            foutTmp.flush();
            if (append) {
                LoggerWrapperFactory.appendConfiguration(context, fTmp.toURI());
            } else {
                LoggerWrapperFactory.newConfiguration(context, fTmp.toURI());
            }
        }
        catch (Exception e) {
            throw new UtilsException("Setting Logging Configuration failed: " + e.getMessage(), e);
        }
        finally {
            try {
                if (fTmp != null) {
                    Files.delete(fTmp.toPath());
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void newConfiguration(LoggerContext context, URI configUri) {
        context.setConfigLocation(configUri);
    }

    private static synchronized void appendConfiguration(LoggerContext context, URI configUri) {
        Map mapLoggers;
        Configuration actualConfiguration = context.getConfiguration();
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        Configuration appendConfiguration = configurationFactory.getConfiguration(new LoggerContext(actualConfiguration.getName()), actualConfiguration.getName(), configUri);
        appendConfiguration.initialize();
        Map mapAppenders = appendConfiguration.getAppenders();
        if (mapAppenders.size() > 0) {
            for (String appenderName : mapAppenders.keySet()) {
                Appender appender = (Appender)mapAppenders.get(appenderName);
                appender.start();
                actualConfiguration.addAppender(appender);
            }
        }
        if ((mapLoggers = appendConfiguration.getLoggers()).size() > 0) {
            for (String loggerName : mapLoggers.keySet()) {
                LoggerConfig logger = (LoggerConfig)mapLoggers.get(loggerName);
                actualConfiguration.addLogger(loggerName, logger);
            }
        }
    }

    private static String readProperty(Properties loggerProperties, String propName, Map<String, String> applicationEnv, String defaultValue) {
        String value = System.getenv(applicationEnv.get(propName));
        if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getenv(Costanti.ENV_LOG.get(propName));
        if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(applicationEnv.get(propName));
        if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = System.getProperty(Costanti.ENV_LOG.get(propName));
        if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = loggerProperties.getProperty(propName);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value)) {
            return value.trim();
        }
        return defaultValue;
    }

    private static Set<String> getLoggersIdByName(Properties loggerProperties, List<String> loggerNames) {
        HashSet<String> enabledLoggers = new HashSet<String>(loggerNames);
        HashSet<String> loggersId = new HashSet<String>();
        boolean enabledAll = enabledLoggers.contains(Boolean.TRUE.toString());
        if (enabledLoggers.contains(Boolean.FALSE.toString()) && enabledLoggers.size() == 1) {
            return loggersId;
        }
        for (Map.Entry<Object, Object> p : loggerProperties.entrySet()) {
            String key = p.getKey().toString().trim();
            if (!key.startsWith("logger.") || !key.endsWith(".name")) continue;
            String value = p.getValue().toString().trim();
            if (!enabledAll && !enabledLoggers.contains(value)) continue;
            String loggerId = key.substring(0, key.length() - ".name".length());
            loggersId.add(loggerId);
        }
        return loggersId;
    }

    private static Set<String> getLoggersIdByName(Properties loggerProperties, String propName, Map<String, String> applicationEnv) {
        List<String> enabledList = List.of(LoggerWrapperFactory.readProperty(loggerProperties, propName, applicationEnv, "false").split(","));
        enabledList = enabledList.stream().map(String::trim).collect(Collectors.toList());
        return LoggerWrapperFactory.getLoggersIdByName(loggerProperties, enabledList);
    }

    private static Set<String> getAppendersIdByName(Properties loggerProperties, Set<String> appenderNames) {
        HashSet<String> appenderIds = new HashSet<String>();
        for (Map.Entry<Object, Object> p : loggerProperties.entrySet()) {
            String key = p.getKey().toString().trim();
            if (!key.startsWith(LOGGER_APPENDER_PREFIX) || !key.endsWith(".name") || !appenderNames.contains(p.getValue().toString().trim())) continue;
            String appenderId = key.substring(0, key.length() - ".name".length());
            appenderIds.add(appenderId);
        }
        return appenderIds;
    }

    private static Set<String> getAppenderIdByLoggerName(Properties loggerProperties, String propName, Map<String, String> applicationEnv) {
        Set<String> loggerIds = LoggerWrapperFactory.getLoggersIdByName(loggerProperties, propName, applicationEnv);
        HashSet<String> appenderNames = new HashSet<String>();
        if (loggerIds.isEmpty()) {
            return Set.of();
        }
        for (Map.Entry<Object, Object> p : loggerProperties.entrySet()) {
            String loggerId;
            String key = p.getKey().toString().trim();
            if (!key.startsWith("logger.") || !key.endsWith(".ref") || !loggerIds.contains(loggerId = key.substring(0, key.indexOf(".appenderRef")))) continue;
            appenderNames.add(p.getValue().toString().trim());
        }
        return LoggerWrapperFactory.getAppendersIdByName(loggerProperties, appenderNames);
    }

    private static Properties patchLoggersStdout(Properties loggerProperties, Map<String, String> applicationEnv, Map<String, String> vars) {
        Set<String> loggerIds = LoggerWrapperFactory.getLoggersIdByName(loggerProperties, "option.stdout", applicationEnv);
        for (String string : loggerIds) {
            loggerProperties.put(string + ".appenderRef.stdout.ref", "STDOUT");
        }
        for (Map.Entry entry : loggerProperties.entrySet()) {
            String key = entry.getKey().toString().trim();
            if (!key.startsWith(LOGGER_APPENDER_PREFIX) || !key.endsWith(LAYOUT_PATTERN_SUFFIX)) continue;
            String value = entry.getValue().toString().trim();
            Matcher matcher = LOG_VARIABLE_PATTERN.matcher(value);
            value = matcher.replaceAll(m -> {
                String out = (String)vars.get(m.group(1).trim());
                return Objects.requireNonNullElse(out, m.group());
            });
            entry.setValue(value);
        }
        return loggerProperties;
    }

    private static Properties patchLoggersJSON(Properties loggerProperties, Map<String, String> applicationEnv, Map<String, String> vars) {
        Set<String> appenderIds = LoggerWrapperFactory.getAppenderIdByLoggerName(loggerProperties, "option.json", applicationEnv);
        String jsonTemplate = LoggerWrapperFactory.readProperty(loggerProperties, "option.json.template", applicationEnv, "classpath:JsonLayout.json");
        if (jsonTemplate != null) {
            for (String appenderId : appenderIds) {
                loggerProperties.remove(appenderId + LAYOUT_TYPE_SUFFIX);
                loggerProperties.remove(appenderId + LAYOUT_PATTERN_SUFFIX);
                loggerProperties.put(appenderId + LAYOUT_TYPE_SUFFIX, "JsonTemplateLayout");
                loggerProperties.put(appenderId + LAYOUT_EVENT_TEMPLATE_URI_SUFFIX, jsonTemplate.trim());
            }
        }
        return LoggerWrapperFactory.applyPatchLoggersJSON(loggerProperties, vars);
    }

    private static Properties applyPatchLoggersJSON(Properties loggerProperties, Map<String, String> vars) {
        HashSet<String> patchedAppenderIds = new HashSet<String>();
        for (Map.Entry<Object, Object> p : loggerProperties.entrySet()) {
            String key = p.getKey().toString().trim();
            LoggerWrapperFactory.addPatchLoggersJSONAppender(key, patchedAppenderIds, p, loggerProperties, vars);
        }
        return loggerProperties;
    }

    private static void addPatchLoggersJSONAppender(String key, Set<String> patchedAppenderIds, Map.Entry<Object, Object> p, Properties loggerProperties, Map<String, String> vars) {
        if (key.startsWith("appender") && key.endsWith(LAYOUT_TYPE_SUFFIX)) {
            int counter;
            String value = p.getValue().toString().trim();
            if (!value.equals("JsonTemplateLayout")) {
                return;
            }
            String appenderId = key.substring(0, key.length() - LAYOUT_TYPE_SUFFIX.length());
            if (patchedAppenderIds.contains(appenderId)) {
                return;
            }
            String TEMPLATE_ADDITIONAL_FIELD = "%s.layout.eventTemplateAdditionalField[%d]";
            for (counter = 0; counter < 1000 && loggerProperties.contains(String.format("%s.layout.eventTemplateAdditionalField[%d]", appenderId, counter) + ".key"); ++counter) {
            }
            for (Map.Entry<String, String> variable : vars.entrySet()) {
                loggerProperties.put(String.format("%s.layout.eventTemplateAdditionalField[%d]", appenderId, counter) + ".type", "EventTemplateAdditionalField");
                loggerProperties.put(String.format("%s.layout.eventTemplateAdditionalField[%d]", appenderId, counter) + ".key", variable.getKey());
                loggerProperties.put(String.format("%s.layout.eventTemplateAdditionalField[%d]", appenderId, counter) + ".value", variable.getValue());
            }
            patchedAppenderIds.add(appenderId);
        }
    }

    public static String applyClusterIdStrategy(String filePath, String id) {
        if (clusterId != null && (clusterId.contains(id) || clusterId.contains(Boolean.TRUE.toString()))) {
            return LoggerWrapperFactory.applyClusterIdStrategy(filePath);
        }
        return filePath;
    }

    private static String applyClusterIdStrategy(String filePath) {
        if (filePath == null) {
            return null;
        }
        Path oldPath = Path.of(filePath, new String[0]);
        if (oldPath == null || oldPath.getFileName() == null) {
            return null;
        }
        Object fileName = oldPath.getFileName().toString();
        Path dir = oldPath.getParent();
        if (dir == null) {
            return null;
        }
        if (clusterIdStrategy.equals("fileName")) {
            int index = ((String)fileName).lastIndexOf(46);
            index = index == -1 ? ((String)fileName).length() : index;
            String name = ((String)fileName).substring(0, index);
            String extension = ((String)fileName).substring(index);
            fileName = name + "." + clusterIdEnv + extension;
        } else if (clusterIdStrategy.equals("directory")) {
            dir = dir.resolve(clusterIdEnv);
        }
        return dir.resolve((String)fileName).toString();
    }

    private static Properties patchClusterIdPath(Properties loggerProperties, Map<String, String> applicationEnv) {
        String id;
        clusterIdEnv = LoggerWrapperFactory.readProperty(loggerProperties, "option.clusterId.env", applicationEnv, null);
        if (clusterIdEnv != null && StringUtils.isNotEmpty((CharSequence)clusterIdEnv) && ((clusterIdEnv = System.getenv(id = clusterIdEnv)) == null || StringUtils.isEmpty((CharSequence)clusterIdEnv))) {
            clusterIdEnv = System.getProperty(id);
        }
        if (clusterIdEnv == null || StringUtils.isEmpty((CharSequence)clusterIdEnv)) {
            clusterIdEnv = System.getenv("HOSTNAME");
        }
        if (clusterIdEnv == null || StringUtils.isEmpty((CharSequence)clusterIdEnv)) {
            clusterIdEnv = System.getProperty("HOSTNAME");
        }
        if (clusterIdEnv == null || StringUtils.isEmpty((CharSequence)clusterIdEnv)) {
            return loggerProperties;
        }
        clusterId = List.of(LoggerWrapperFactory.readProperty(loggerProperties, "option.clusterId", applicationEnv, Boolean.FALSE.toString()).split(",")).stream().map(String::trim).collect(Collectors.toSet());
        Set<String> appenderIds = LoggerWrapperFactory.getAppenderIdByLoggerName(loggerProperties, "option.clusterId", applicationEnv);
        if (appenderIds.isEmpty()) {
            return loggerProperties;
        }
        return LoggerWrapperFactory.applyPatchClusterIdPath(loggerProperties, applicationEnv, appenderIds);
    }

    private static Properties applyPatchClusterIdPath(Properties loggerProperties, Map<String, String> applicationEnv, Set<String> appenderIds) {
        clusterIdStrategy = LoggerWrapperFactory.readProperty(loggerProperties, "option.clusterId.strategy", applicationEnv, "directory");
        clusterIdStrategy = clusterIdStrategy.trim();
        for (Map.Entry<Object, Object> p : loggerProperties.entrySet()) {
            String key = p.getKey().toString().trim();
            String appenderId = null;
            if (key.startsWith(LOGGER_APPENDER_PREFIX)) {
                if (key.endsWith(".fileName")) {
                    appenderId = key.substring(0, key.length() - ".fileName".length());
                }
                if (key.endsWith(".filePattern")) {
                    appenderId = key.substring(0, key.length() - ".filePattern".length());
                }
            }
            if (appenderId == null || !appenderIds.contains(appenderId)) continue;
            String value = p.getValue().toString().trim();
            p.setValue(LoggerWrapperFactory.applyClusterIdStrategy(value));
        }
        return loggerProperties;
    }

    public static Properties patchLoggers(Properties loggerProperties, Map<String, String> propertyToEnv, Map<String, String> vars) {
        LoggerWrapperFactory.patchClusterIdPath(loggerProperties, propertyToEnv);
        LoggerWrapperFactory.patchLoggersStdout(loggerProperties, propertyToEnv, vars);
        LoggerWrapperFactory.patchLoggersJSON(loggerProperties, propertyToEnv, vars);
        LoggerWrapperFactory.cleanOptions(loggerProperties);
        return loggerProperties;
    }

    private static void cleanOptions(Properties loggerProperties) {
        ArrayList<String> deleteKeys = new ArrayList<String>();
        Enumeration<Object> keys = loggerProperties.keys();
        while (keys.hasMoreElements()) {
            String key;
            Object object = keys.nextElement();
            if (!(object instanceof String) || !(key = (String)object).startsWith("option.")) continue;
            deleteKeys.add(key);
        }
        while (!deleteKeys.isEmpty()) {
            String key = (String)deleteKeys.remove(0);
            loggerProperties.remove(key);
        }
    }
}

