/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.CopyStreamMethod;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.Utilities;

public class TestCopyStream {
    public static void main(String[] args) throws Exception {
        int size = 0x40000000;
        TestCopyStream.test(size, -1, false, -1L, false);
        int timeoutMs = 120000;
        TestCopyStream.test(size, timeoutMs, false, size, false);
        TestCopyStream.test(size, 60, true, -1L, false);
        TestCopyStream.test(size, -1, false, 10240L, true);
        TestCopyStream.test(size, 6000, false, 10240L, true);
        TestCopyStream.test(size, 60, true, 0x40000000L, false);
        TestCopyStream.test(size, 2, true, 0x40000000L, false);
        size = 0x100000;
        TestCopyStream.test(size, timeoutMs, false, size, false);
        size = 1024;
        TestCopyStream.test(size, timeoutMs, false, size, false);
        System.out.println("\n\n\nTESTSUITE COMPLETATA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(int size, int timeoutMs, boolean expectedTimeout, long limitBytes, boolean expectedLimitExceeded) throws Exception {
        System.out.println("\n\n========= (timeoutMs:" + timeoutMs + ") (limit:" + limitBytes + ") =============");
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = 97;
        }
        CopyStreamMethod[] methods = CopyStreamMethod.values();
        System.out.println("Creato buffer di dimensione: " + Utilities.convertBytesToFormatString(buffer.length, true, " "));
        File fSRC = File.createTempFile("testCopyStream", ".bin");
        try {
            FileOutputStream fos = new FileOutputStream(fSRC);
            fos.write(buffer);
            fos.flush();
            fos.close();
            System.out.println("Creato file di dimensione: " + Utilities.convertBytesToFormatString(fSRC.length(), true, " "));
            byte[] bufferInit = new byte[65536];
            for (int i = 0; i < 65536; ++i) {
                bufferInit[i] = 97;
            }
            try (CopyStreamMethod[] bin = new ByteArrayInputStream(bufferInit);){
                TestCopyStream.testBuffer("Buffer-Java-InitResources", CopyStreamMethod.JAVA, (InputStream)bin, 65536, -1, false, -1L, false);
            }
            System.out.println("\n");
            for (CopyStreamMethod copyStreamMethod : methods) {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(buffer);){
                    TestCopyStream.testBuffer("Buffer", copyStreamMethod, bin, CopyStreamMethod.SERVER_SENT_EVENTS.equals((Object)copyStreamMethod) ? size + 1 : size, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
                }
                if (!CopyStreamMethod.JAVA.equals((Object)copyStreamMethod)) continue;
                bin = new ByteArrayInputStream(buffer);
                try {
                    TestCopyStream.testBuffer("Buffer-Java-IterazioneBufferSize8192", copyStreamMethod, bin, size, 8192, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
                }
                finally {
                    bin.close();
                }
            }
            System.out.println("\n");
            for (CopyStreamMethod copyStreamMethod : methods) {
                try (FileInputStream fin = new FileInputStream(fSRC);){
                    TestCopyStream.testBuffer("File", copyStreamMethod, fin, CopyStreamMethod.SERVER_SENT_EVENTS.equals((Object)copyStreamMethod) ? size + 1 : size, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
                }
            }
            TestCopyStream.testBuffer("File", fSRC, size);
            System.out.println("\n");
            for (CopyStreamMethod copyStreamMethod : methods) {
                File fout = File.createTempFile("testCopyStreamOut", ".bin");
                try (ByteArrayInputStream bin = new ByteArrayInputStream(buffer);){
                    TestCopyStream.testFile("Buffer", copyStreamMethod, bin, fout, CopyStreamMethod.SERVER_SENT_EVENTS.equals((Object)copyStreamMethod) ? size + 1 : size, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
                }
                finally {
                    fout.delete();
                }
            }
            File fout = File.createTempFile("testCopyFileOut", ".bin");
            try (CopyStreamMethod[] bin = new ByteArrayInputStream(buffer);){
                String path = fout.getAbsolutePath();
                fout.delete();
                TestCopyStream.testFile("Buffer", (InputStream)bin, new File(path), size, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
            }
            finally {
                fout.delete();
            }
            System.out.println("\n");
            for (CopyStreamMethod copyStreamMethod : methods) {
                fout = File.createTempFile("testCopyStreamOut", ".bin");
                try (FileInputStream fin = new FileInputStream(fSRC);){
                    TestCopyStream.testFile("File", copyStreamMethod, fin, fout, CopyStreamMethod.SERVER_SENT_EVENTS.equals((Object)copyStreamMethod) ? size + 1 : size, timeoutMs, expectedTimeout, limitBytes, expectedLimitExceeded);
                }
                finally {
                    fout.delete();
                }
            }
            fout = File.createTempFile("testCopyStreamOut", ".bin");
            try {
                String path = fout.getAbsolutePath();
                fout.delete();
                TestCopyStream.testFile("File", fSRC, new File(path), size);
            }
            finally {
                fout.delete();
            }
        }
        finally {
            fSRC.delete();
        }
    }

    private static void testBuffer(String src, CopyStreamMethod method, InputStream is, int size, int timeout, boolean expectedTimeout, long limitBytes, boolean expectedLimitExceeded) throws Exception {
        TestCopyStream.testBuffer(src, method, is, size, -1, timeout, expectedTimeout, limitBytes, expectedLimitExceeded);
    }

    private static void testBuffer(String src, CopyStreamMethod method, InputStream isParam, int size, int sizeBuffer, int timeout, boolean expectedTimeout, long limitBytes, boolean expectedLimitExceeded) throws Exception {
        Date startDate = new Date();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream is = isParam;
        if (timeout > 0) {
            is = new TimeoutInputStream(is, timeout);
        }
        if (limitBytes > 0L) {
            is = new LimitedInputStream(is, limitBytes);
        }
        try {
            if (sizeBuffer > 0) {
                CopyStream.copyBuffer(is, bout, sizeBuffer);
            } else {
                CopyStream.copy(method, is, bout);
            }
            if (expectedTimeout) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] Eccezione attesa di timeout non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + bout.size());
            }
            if (expectedLimitExceeded) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] Eccezione attesa 'limit exceeded' non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + bout.size());
            }
        }
        catch (Exception e) {
            if (expectedTimeout && e.getMessage().equals("Read timed out")) {
                System.out.println("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Payload too large")) {
                System.out.println("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Content-Length exceeds the allowed limit")) {
                System.out.println("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            throw e;
        }
        bout.flush();
        bout.close();
        if (!expectedTimeout && !expectedLimitExceeded) {
            Date endDate = new Date();
            long time = endDate.getTime() - startDate.getTime();
            if (bout.size() != size) {
                throw new Exception("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] Buffer destinazione con dimensione differente (expected: " + size + ", found: " + bout.size() + ")");
            }
            System.out.println("[" + src + "->Buffer][" + String.valueOf((Object)method) + "] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
        }
    }

    private static void testBuffer(String src, File is, int size) throws Exception {
        Date startDate = new Date();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CopyStream.copy(is, (OutputStream)bout);
        bout.flush();
        bout.close();
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (bout.size() != size) {
            throw new Exception("[" + src + "->Buffer][COPY-FILE] Buffer destinazione con dimensione differente (expected: " + size + ", found: " + bout.size() + ")");
        }
        System.out.println("[" + src + "->Buffer][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }

    private static void testFile(String src, CopyStreamMethod method, InputStream is, File f, int size, int timeout, boolean expectedTimeout, long limitBytes, boolean expectedLimitExceeded) throws Exception {
        Date startDate = new Date();
        FileOutputStream fout = new FileOutputStream(f);
        try {
            if (timeout > 0 && limitBytes > 0L) {
                CopyStream.copy(method, is, fout, timeout, limitBytes);
            } else if (timeout > 0) {
                CopyStream.copy(method, is, (OutputStream)fout, timeout);
            } else if (limitBytes > 0L) {
                CopyStream.copy(method, is, (OutputStream)fout, limitBytes);
            } else {
                CopyStream.copy(method, is, fout);
            }
            if (expectedTimeout) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->File][" + String.valueOf((Object)method) + "] Eccezione attesa di timeout non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + f.length());
            }
            if (expectedLimitExceeded) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->File][" + String.valueOf((Object)method) + "] Eccezione attesa 'limit exceeded' non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + f.length());
            }
        }
        catch (Exception e) {
            if (expectedTimeout && e.getMessage().equals("Read timed out")) {
                System.out.println("[" + src + "->File][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Payload too large")) {
                System.out.println("[" + src + "->File][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Content-Length exceeds the allowed limit")) {
                System.out.println("[" + src + "->File][" + String.valueOf((Object)method) + "] eccezione attesa ricevuta: " + e.getMessage());
            }
            throw e;
        }
        fout.flush();
        fout.close();
        if (!expectedTimeout && !expectedLimitExceeded) {
            Date endDate = new Date();
            long time = endDate.getTime() - startDate.getTime();
            if (f.length() != (long)size) {
                throw new Exception("[" + src + "->File][" + String.valueOf((Object)method) + "] File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
            }
            System.out.println("[" + src + "->File][" + String.valueOf((Object)method) + "] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
        }
    }

    private static void testFile(String src, InputStream is, File f, int size, int timeout, boolean expectedTimeout, long limitBytes, boolean expectedLimitExceeded) throws Exception {
        Date startDate = new Date();
        try {
            if (timeout > 0 && limitBytes > 0L) {
                CopyStream.copy(is, f, timeout, limitBytes);
            } else if (timeout > 0) {
                CopyStream.copy(is, f, timeout);
            } else if (limitBytes > 0L) {
                CopyStream.copy(is, f, limitBytes);
            } else {
                CopyStream.copy(is, f);
            }
            if (expectedTimeout) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->File][COPY-FILE] Eccezione attesa di timeout non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + f.length());
            }
            if (expectedLimitExceeded) {
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                throw new Exception("[" + src + "->File][COPY-FILE] Eccezione attesa 'limit exceeded' non si \u00e8 verificata dopo " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true) + "; buffer expected: " + size + ", found: " + f.length());
            }
        }
        catch (Exception e) {
            if (expectedTimeout && e.getMessage().equals("Read timed out")) {
                System.out.println("[" + src + "->File][COPY-FILE] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Payload too large")) {
                System.out.println("[" + src + "->File][COPY-FILE] eccezione attesa ricevuta: " + e.getMessage());
            }
            if (expectedLimitExceeded && e.getMessage().equals("Content-Length exceeds the allowed limit")) {
                System.out.println("[" + src + "->File][COPY-FILE] eccezione attesa ricevuta: " + e.getMessage());
            }
            throw e;
        }
        if (!expectedTimeout && !expectedLimitExceeded) {
            Date endDate = new Date();
            long time = endDate.getTime() - startDate.getTime();
            if (f.length() != (long)size) {
                throw new Exception("[" + src + "->File][COPY-FILE] File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
            }
            System.out.println("[" + src + "->File][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
        }
    }

    private static void testFile(String src, File is, File f, int size) throws Exception {
        Date startDate = new Date();
        CopyStream.copy(is, f);
        Date endDate = new Date();
        long time = endDate.getTime() - startDate.getTime();
        if (f.length() != (long)size) {
            throw new Exception("[" + src + "->File][COPY-FILE] File destinazione con dimensione differente (expected: " + size + ", found: " + f.length() + ")");
        }
        System.out.println("[" + src + "->File][COPY-FILE] " + Utilities.convertSystemTimeIntoStringMillisecondi(time, true));
    }
}

