/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.spi.service.Service;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.AbstractCacheImpl;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;

public class EHCacheImpl
extends AbstractCacheImpl {
    private static CacheManager cacheManager;
    private static StatisticsService statisticsService;
    private org.ehcache.Cache<String, Serializable> cache = null;
    private volatile int maxSize = -1;
    private volatile int maxLifeTime = -1;

    private static synchronized void initCacheManager() {
        if (cacheManager == null) {
            statisticsService = new DefaultStatisticsService();
            cacheManager = CacheManagerBuilder.newCacheManagerBuilder().using((Service)statisticsService).build();
            cacheManager.init();
        }
    }

    public EHCacheImpl(String name) throws UtilsException {
        this(name, Cache.DEFAULT_DISABLE_SYNCRONIZED_GET);
    }

    @Deprecated
    private EHCacheImpl(String name, boolean disableSyncronizedGet) throws UtilsException {
        super(CacheType.EH, name);
        if (cacheManager == null) {
            EHCacheImpl.initCacheManager();
        }
    }

    @Override
    public int getCacheSize() {
        return this.maxSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.maxSize = cacheSize;
    }

    @Override
    public CacheAlgorithm getCacheAlgoritm() {
        return CacheAlgorithm.LRU;
    }

    @Override
    public void setCacheAlgoritm(CacheAlgorithm cacheAlgoritm) {
    }

    @Override
    public long getItemIdleTime() throws UtilsException {
        return -1L;
    }

    @Override
    public void setItemIdleTime(long itemIdleTimeCache) throws UtilsException {
    }

    @Override
    public long getItemLifeTime() throws UtilsException {
        return this.maxLifeTime;
    }

    @Override
    public void setItemLifeTime(long itemLifeTimeCache) throws UtilsException {
        this.maxLifeTime = (int)itemLifeTimeCache;
    }

    @Override
    public void build() throws UtilsException {
        if (this.maxSize <= 0 && this.maxLifeTime > 0) {
            throw new UtilsException("Cannot use maxLifeTime without maxSize");
        }
        ResourcePoolsBuilder rpb = ResourcePoolsBuilder.newResourcePoolsBuilder();
        if (this.maxSize > 0) {
            rpb = rpb.heap((long)this.maxSize, (ResourceUnit)EntryUnit.ENTRIES);
        }
        CacheConfigurationBuilder ccb = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Serializable.class, (Builder)rpb);
        if (this.maxLifeTime > 0) {
            ccb = ccb.withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(this.maxLifeTime)));
        }
        CacheConfiguration cacheConfiguration = ccb.build();
        this.cache = cacheManager.createCache(this.cacheName, cacheConfiguration);
    }

    @Override
    public void clear() throws UtilsException {
        this.cache.clear();
    }

    @Override
    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    @Override
    public void remove(String key) throws UtilsException {
        try {
            this.cache.remove((Object)key);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, CacheResponse value) throws UtilsException {
        try {
            this.cache.put((Object)key, (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, Serializable value) throws UtilsException {
        try {
            this.cache.put((Object)key, (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public int getItemCount() throws UtilsException {
        CacheStatistics ehCacheStat = statisticsService.getCacheStatistics(this.cacheName);
        return (int)((TierStatistics)ehCacheStat.getTierStatistics().get("OnHeap")).getMappings();
    }

    @Override
    public List<String> keys() throws UtilsException {
        try {
            HashSet set = new HashSet();
            this.cache.forEach(entry -> set.add((String)entry.getKey()));
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(set);
            return keys;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void printStats(OutputStream out, String separator) throws UtilsException {
        try {
            StringBuilder bf = new StringBuilder();
            bf.append(this._printStats(separator, true));
            CacheStatistics ehCacheStat = statisticsService.getCacheStatistics(this.cacheName);
            bf.append("PutCount:");
            bf.append(ehCacheStat.getCachePuts());
            bf.append(" ");
            bf.append(separator);
            bf.append("HitCount(Aux):");
            bf.append(ehCacheStat.getCacheHits());
            bf.append(" ");
            bf.append(separator);
            bf.append("Evictions:");
            bf.append(ehCacheStat.getCacheEvictions());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(Expired):");
            bf.append(ehCacheStat.getCacheExpirations());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(NotFound):");
            bf.append(ehCacheStat.getCacheMisses());
            bf.append(" ");
            out.write(bf.toString().getBytes());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

