/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.AbstractCacheImpl;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.cache.LimitedHashMap;

public class LimitedHashMapCacheImpl
extends AbstractCacheImpl {
    private Map<String, Serializable> cache = null;
    private int maxSize = -1;
    private int maxLifeTime = -1;

    public LimitedHashMapCacheImpl(String name) throws UtilsException {
        this(name, Cache.DEFAULT_DISABLE_SYNCRONIZED_GET);
    }

    @Deprecated
    private LimitedHashMapCacheImpl(String name, boolean disableSyncronizedGet) throws UtilsException {
        super(CacheType.LimitedHashMap, name);
    }

    @Override
    public int getCacheSize() {
        return this.maxSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.maxSize = cacheSize;
    }

    @Override
    public CacheAlgorithm getCacheAlgoritm() {
        return CacheAlgorithm.LRU;
    }

    @Override
    public void setCacheAlgoritm(CacheAlgorithm cacheAlgoritm) {
    }

    @Override
    public long getItemIdleTime() throws UtilsException {
        return -1L;
    }

    @Override
    public void setItemIdleTime(long itemIdleTimeCache) throws UtilsException {
    }

    @Override
    public long getItemLifeTime() throws UtilsException {
        return this.maxLifeTime;
    }

    @Override
    public void setItemLifeTime(long itemLifeTimeCache) throws UtilsException {
        this.maxLifeTime = (int)itemLifeTimeCache;
    }

    @Override
    public void build() throws UtilsException {
        if (this.maxSize <= 0 && this.maxLifeTime > 0) {
            throw new UtilsException("Cannot use maxLifeTime without maxSize");
        }
        this.cache = this.maxSize <= 0 ? new ConcurrentHashMap<String, Serializable>() : new LimitedHashMap<String, Serializable>(this.cacheName, this.maxSize, this.maxLifeTime);
    }

    @Override
    public void clear() throws UtilsException {
        this.cache.clear();
        if (this.maxSize > 0) {
            this.build();
        }
    }

    @Override
    public Object get(String key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(String key) throws UtilsException {
        try {
            this.cache.remove(key);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, CacheResponse value) throws UtilsException {
        try {
            this.cache.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, Serializable value) throws UtilsException {
        try {
            this.cache.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public int getItemCount() throws UtilsException {
        return this.cache.size();
    }

    @Override
    public List<String> keys() throws UtilsException {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this.cache.keySet());
            return keys;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void printStats(OutputStream out, String separator) throws UtilsException {
        this._printStats(out, separator, true);
    }
}

