/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateFactory;
import org.openspcoop2.utils.certificate.KeystoreUtils;

public class ArchiveLoader {
    private ArchiveLoader() {
    }

    public static Certificate load(byte[] content) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.CER, content, -1, null, null, false);
    }

    public static Certificate loadChain(byte[] content) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.CER, content, -1, null, null, true);
    }

    public static Certificate load(byte[] content, boolean chain) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.CER, content, -1, null, null, chain);
    }

    public static Certificate loadFromKeystorePKCS12(byte[] content, int position, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.PKCS12, content, position, null, password, false);
    }

    public static Certificate loadFromKeystorePKCS12(byte[] content, String alias, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.PKCS12, content, -1, alias, password, false);
    }

    public static Certificate loadFromKeystoreJKS(byte[] content, int position, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.JKS, content, position, null, password, false);
    }

    public static Certificate loadFromKeystoreJKS(byte[] content, String alias, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(ArchiveType.JKS, content, -1, alias, password, false);
    }

    public static Certificate load(ArchiveType type, byte[] content, int position, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(type, content, position, null, password, false);
    }

    public static Certificate load(ArchiveType type, byte[] content, String alias, String password) throws UtilsException {
        return ArchiveLoader.loadEngine(type, content, -1, alias, password, false);
    }

    private static Certificate loadEngine(ArchiveType type, byte[] content, int position, String alias, String password, boolean chain) throws UtilsException {
        try {
            switch (type) {
                case JKS: 
                case PKCS12: {
                    return ArchiveLoader.buildCertificateFromKeyStore(type, content, position, alias, password);
                }
                case CER: {
                    return ArchiveLoader.buildCertificateFromCER(content, alias, chain);
                }
            }
            throw new UtilsException("Certificate not found in archive (type: " + String.valueOf((Object)type) + ")");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static Certificate buildCertificateFromKeyStore(ArchiveType type, byte[] content, int position, String alias, String password) throws UtilsException {
        try {
            KeyStore ks = KeystoreUtils.readKeystore(content, type.name(), password);
            Enumeration<String> en = ks.aliases();
            int index = -1;
            while (en.hasMoreElements()) {
                ++index;
                String aliasCheck = en.nextElement();
                java.security.cert.Certificate baseCert = ks.getCertificate(aliasCheck);
                if (!(baseCert instanceof X509Certificate)) {
                    if (!aliasCheck.equalsIgnoreCase(alias)) continue;
                    throw new UtilsException("Certificate [" + alias + "] isn't X509");
                }
                X509Certificate cert = (X509Certificate)baseCert;
                java.security.cert.Certificate[] baseCertChain = ks.getCertificateChain(aliasCheck);
                List<X509Certificate> certChain = ArchiveLoader.readCertificateChain(baseCertChain);
                if (!aliasCheck.equalsIgnoreCase(alias) && (position < 0 || index != position)) continue;
                return new Certificate(aliasCheck, cert, certChain);
            }
            if (alias != null) {
                throw new UtilsException("Certificate [" + alias + "] not found");
            }
            throw new UtilsException("Certificate at position [" + position + "] not found");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static List<X509Certificate> readCertificateChain(java.security.cert.Certificate[] baseCertChain) throws UtilsException {
        try {
            ArrayList<X509Certificate> certChain = null;
            if (baseCertChain != null && baseCertChain.length > 0) {
                for (int i = 0; i < baseCertChain.length; ++i) {
                    java.security.cert.Certificate check = baseCertChain[i];
                    if (!(check instanceof X509Certificate)) continue;
                    if (certChain == null) {
                        certChain = new ArrayList<X509Certificate>();
                    }
                    certChain.add((X509Certificate)check);
                }
            }
            return certChain;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Certificate buildCertificateFromCER(byte[] content, String alias, boolean chain) throws UtilsException {
        try {
            if (alias == null) {
                alias = "cert";
            }
            java.security.cert.CertificateFactory fact = CertificateFactory.getCertificateFactory();
            if (chain) {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
                    Collection<? extends java.security.cert.Certificate> certs = fact.generateCertificates(bin);
                    Certificate certificate = ArchiveLoader.loadCertificateChain(certs, alias);
                    return certificate;
                }
            }
            Collection<? extends java.security.cert.Certificate> certs = ArchiveLoader.buildCollectionCertificate(fact, content);
            if (certs != null) {
                if (!certs.isEmpty()) return ArchiveLoader.loadCertificateChain(certs, alias);
            }
            try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
                X509Certificate cer = (X509Certificate)fact.generateCertificate(bin);
                Certificate certificate = new Certificate(alias, cer);
                return certificate;
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static Collection<? extends java.security.cert.Certificate> buildCollectionCertificate(java.security.cert.CertificateFactory fact, byte[] content) {
        Collection<? extends java.security.cert.Certificate> certs = null;
        try (ByteArrayInputStream bin = new ByteArrayInputStream(content);){
            certs = fact.generateCertificates(bin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return certs;
    }

    private static Certificate loadCertificateChain(Collection<? extends java.security.cert.Certificate> certs, String alias) throws UtilsException {
        if (certs == null || certs.isEmpty()) {
            throw new UtilsException("Certificates not found");
        }
        int cList = 0;
        X509Certificate cer = null;
        ArrayList<X509Certificate> listChain = null;
        for (java.security.cert.Certificate certificate : certs) {
            if (!(certificate instanceof X509Certificate)) continue;
            X509Certificate tmp = (X509Certificate)certificate;
            if (cList == 0) {
                cer = tmp;
            } else {
                if (listChain == null) {
                    listChain = new ArrayList<X509Certificate>();
                }
                listChain.add(tmp);
            }
            ++cList;
        }
        if (listChain != null) {
            return new Certificate(alias, cer, listChain);
        }
        return new Certificate(alias, cer);
    }

    public static List<String> readAliasesInKeystorePKCS12(byte[] content, String password) throws UtilsException {
        return ArchiveLoader.readAliasesEngine(ArchiveType.PKCS12, content, password);
    }

    public static List<String> readAliasesInKeystoreJKS(byte[] content, String password) throws UtilsException {
        return ArchiveLoader.readAliasesEngine(ArchiveType.JKS, content, password);
    }

    public static List<String> readAliases(ArchiveType type, byte[] content, String password) throws UtilsException {
        return ArchiveLoader.readAliasesEngine(type, content, password);
    }

    private static List<String> readAliasesEngine(ArchiveType type, byte[] content, String password) throws UtilsException {
        try {
            switch (type) {
                case JKS: 
                case PKCS12: {
                    KeyStore ks = KeystoreUtils.readKeystore(content, type.name(), password);
                    Enumeration<String> en = ks.aliases();
                    ArrayList<String> list = new ArrayList<String>();
                    while (en.hasMoreElements()) {
                        String alias = en.nextElement();
                        list.add(alias);
                    }
                    return list;
                }
                case CER: {
                    throw new UtilsException("Type '" + String.valueOf((Object)type) + "' hasn't alias");
                }
            }
            throw new UtilsException("Certificate not found in archive (type: " + String.valueOf((Object)type) + ")");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

