/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.PEMReader;

public class KeyUtils {
    public static final String ALGO_RSA = "RSA";
    public static final String ALGO_DSA = "DSA";
    public static final String ALGO_DH = "DH";
    public static final String ALGO_EC = "EC";
    private static volatile boolean useBouncyCastleProvider = true;
    private static Provider provider = null;
    private String algorithm;
    private KeyFactory kf;
    private Map<String, KeyFactory> keyFactoryMap = new ConcurrentHashMap<String, KeyFactory>();

    public static boolean isUseBouncyCastleProvider() {
        return useBouncyCastleProvider;
    }

    public static void setUseBouncyCastleProvider(boolean useBouncyCastleProvider) {
        KeyUtils.useBouncyCastleProvider = useBouncyCastleProvider;
    }

    private static synchronized Provider getProviderEngine() {
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        return provider;
    }

    private static Provider getProvider() {
        Provider p = null;
        if (!useBouncyCastleProvider) {
            return p;
        }
        if (provider == null) {
            return KeyUtils.getProviderEngine();
        }
        return provider;
    }

    public static KeyUtils getInstance() throws UtilsException {
        return new KeyUtils();
    }

    public static KeyUtils getInstance(String algo) throws UtilsException {
        return new KeyUtils(algo);
    }

    public KeyUtils() throws UtilsException {
        this(ALGO_RSA);
    }

    public KeyUtils(String algo) throws UtilsException {
        try {
            this.algorithm = algo;
            this.kf = this.getKeyFactoryEngine(algo);
            this.keyFactoryMap.put(algo, this.kf);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private KeyFactory getKeyFactory(String algo) {
        return this.keyFactoryMap.computeIfAbsent(algo, a -> {
            try {
                return this.getKeyFactoryEngine((String)a);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), e);
            }
        });
    }

    private KeyFactory getKeyFactoryEngine(String algo) throws NoSuchAlgorithmException {
        Provider p = KeyUtils.getProvider();
        if (p != null) {
            return KeyFactory.getInstance(algo, p);
        }
        return KeyFactory.getInstance(algo);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * Exception decompiling
     */
    public PublicKey readPublicKeyPEMFormat(byte[] publicKey) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PublicKey readPublicKeyDERFormat(byte[] publicKey) throws UtilsException {
        try {
            X509EncodedKeySpec specPub = new X509EncodedKeySpec(publicKey);
            return this.kf.generatePublic(specPub);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PublicKey readCertificate(byte[] publicKey) throws UtilsException {
        String cert;
        PEMReader pemArchive = new PEMReader(publicKey);
        if (pemArchive.getCertificates() != null && !pemArchive.getCertificates().isEmpty() && (cert = pemArchive.getCertificates().get(0)) != null && StringUtils.isNotEmpty((CharSequence)cert)) {
            publicKey = cert.getBytes();
        }
        return ArchiveLoader.load(publicKey).getCertificate().getCertificate().getPublicKey();
    }

    public PublicKey getPublicKey(byte[] publicKey) throws UtilsException {
        String cert;
        PEMReader pemArchive = new PEMReader(publicKey);
        if (pemArchive.getPublicKey() != null) {
            return this.readPublicKeyPEMFormat(pemArchive.getPublicKey().getBytes());
        }
        if (pemArchive.getCertificates() != null && !pemArchive.getCertificates().isEmpty() && (cert = pemArchive.getCertificates().get(0)) != null && StringUtils.isNotEmpty((CharSequence)cert)) {
            return this.readCertificate(cert.getBytes());
        }
        try {
            return this.readPublicKeyDERFormat(publicKey);
        }
        catch (Exception eDer) {
            try {
                return this.readCertificate(publicKey);
            }
            catch (Exception eX509) {
                UtilsMultiException multi = new UtilsMultiException("Load public key failed (DER)", eDer, eX509);
                throw new UtilsException(multi.getMultiMessage(), multi);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public PrivateKey readPKCS1PrivateKeyPEMFormat(byte[] privateKey) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public PrivateKey readPKCS8PrivateKeyPEMFormat(byte[] privateKey) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PrivateKey readPKCS8PrivateKeyDERFormat(byte[] privateKey) throws UtilsException {
        try {
            PKCS8EncodedKeySpec specPriv = new PKCS8EncodedKeySpec(privateKey);
            return this.kf.generatePrivate(specPriv);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PrivateKey readSEC1PrivateKeyDERFormat(byte[] privateKey) throws UtilsException {
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)privateKey);
            ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance((Object)seq);
            ASN1Object params = ecPrivateKey.getParametersObject();
            if (params == null) {
                throw new UtilsException("SEC1 EC private key does not contain curve parameters (tag [0])");
            }
            if (!(params instanceof ASN1ObjectIdentifier)) {
                throw new UtilsException("SEC1 EC private key parameters is not an OID, found: " + params.getClass().getName());
            }
            ASN1ObjectIdentifier curveOid = (ASN1ObjectIdentifier)params;
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)ecPrivateKey);
            PKCS8EncodedKeySpec specPriv = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            KeyFactory kfEC = this.getKeyFactory(ALGO_EC);
            PrivateKey result = kfEC.generatePrivate(specPriv);
            if (result != null) {
                // empty if block
            }
            return result;
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Could not parse SEC1 EC private key: " + e.getMessage(), e);
        }
    }

    public PrivateKey getPrivateKey(byte[] privateKey) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
            if (pemArchive.isPkcs1() || pemArchive.isSec1ec()) {
                return this.readPKCS1PrivateKeyPEMFormat(privateKey);
            }
            if (pemArchive.isPkcs8()) {
                return this.readPKCS8PrivateKeyPEMFormat(privateKey);
            }
        }
        try {
            return this.readPKCS8PrivateKeyDERFormat(privateKey);
        }
        catch (Exception ePkcs8) {
            try {
                return this.readSEC1PrivateKeyDERFormat(privateKey);
            }
            catch (Exception eSec1) {
                UtilsMultiException multi = new UtilsMultiException("Load private key failed (DER)", ePkcs8, eSec1);
                throw new UtilsException(multi.getMultiMessage(), multi);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public PrivateKey readPKCS1EncryptedPrivateKeyPEMFormat(byte[] privateKey, String password) throws UtilsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PrivateKey readPKCS8EncryptedPrivateKeyPEMFormat(byte[] privateKey, String password) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey, false, false, true);
        if (pemArchive.getPrivateKey() != null) {
            privateKey = pemArchive.getPrivateKey().getBytes();
        }
        PKCS8EncryptedPrivateKeyInfo pair = null;
        try (ByteArrayInputStream bin = new ByteArrayInputStream(privateKey);
             InputStreamReader ir = new InputStreamReader(bin);
             PEMParser parser = new PEMParser((Reader)ir);){
            pair = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return this.readPKCS8EncryptedPrivateKey(pair, password);
    }

    public PrivateKey readPKCS8EncryptedPrivateKeyDERFormat(byte[] privateKey, String password) throws UtilsException {
        PKCS8EncryptedPrivateKeyInfo pair = null;
        try {
            pair = new PKCS8EncryptedPrivateKeyInfo(privateKey);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return this.readPKCS8EncryptedPrivateKey(pair, password);
    }

    private PrivateKey readPKCS8EncryptedPrivateKey(PKCS8EncryptedPrivateKeyInfo pair, String password) throws UtilsException {
        try {
            JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC");
            InputDecryptorProvider decProv = jce.build(password.toCharArray());
            PrivateKeyInfo keyInfo = pair.decryptPrivateKeyInfo(decProv);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            return converter.getPrivateKey(keyInfo);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PrivateKey getPrivateKey(byte[] privateKey, String password) throws UtilsException {
        PEMReader pemArchive = new PEMReader(privateKey);
        if (pemArchive.getPrivateKey() != null) {
            byte[] pemPrivateKey = pemArchive.getPrivateKey().getBytes();
            return this.getPrivateKeyFromPEM(pemPrivateKey, password, pemArchive);
        }
        return this.getPrivateKeyFromDER(privateKey, password);
    }

    private PrivateKey getPrivateKeyFromPEM(byte[] privateKey, String password, PEMReader pemArchive) throws UtilsException {
        if (pemArchive.isPkcs8encrypted()) {
            return this.readPKCS8EncryptedPrivateKeyPEMFormat(privateKey, password);
        }
        if (pemArchive.isPkcs1() || pemArchive.isSec1ec()) {
            return this.getPrivateKeyFromPEMPkcs1OrSec1(privateKey, password);
        }
        if (pemArchive.isPkcs8()) {
            return this.readPKCS8PrivateKeyPEMFormat(privateKey);
        }
        throw new UtilsException("Unsupported PEM private key format");
    }

    private PrivateKey getPrivateKeyFromPEMPkcs1OrSec1(byte[] privateKey, String password) throws UtilsException {
        try {
            return this.readPKCS1EncryptedPrivateKeyPEMFormat(privateKey, password);
        }
        catch (Exception e) {
            try {
                return this.readPKCS1PrivateKeyPEMFormat(privateKey);
            }
            catch (Exception eNoPassword) {
                UtilsMultiException multi = new UtilsMultiException("Load private key failed (PEM PKCS1/SEC1)", e, eNoPassword);
                throw new UtilsException(multi.getMultiMessage(), multi);
            }
        }
    }

    private PrivateKey getPrivateKeyFromDER(byte[] privateKey, String password) throws UtilsException {
        try {
            return this.readPKCS8EncryptedPrivateKeyDERFormat(privateKey, password);
        }
        catch (Exception ePkcs8Enc) {
            return this.getPrivateKeyFromDERUnencrypted(privateKey, ePkcs8Enc);
        }
    }

    private PrivateKey getPrivateKeyFromDERUnencrypted(byte[] privateKey, Exception ePkcs8Enc) throws UtilsException {
        try {
            return this.readPKCS8PrivateKeyDERFormat(privateKey);
        }
        catch (Exception ePkcs8) {
            try {
                return this.readSEC1PrivateKeyDERFormat(privateKey);
            }
            catch (Exception eSec1) {
                UtilsMultiException multi = new UtilsMultiException("Load private key failed (DER)", ePkcs8Enc, ePkcs8, eSec1);
                throw new UtilsException(multi.getMultiMessage(), multi);
            }
        }
    }
}

