/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CRLCertstore;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceUtils;

public class OCSPResourceReader
implements IOCSPResourceReader {
    private OCSPConfig config;
    private static final String OCSP_CONFIG_NULL = "OCSPConfig is null";

    @Override
    public void initConfig(OCSPConfig config) throws UtilsException {
        this.config = config;
    }

    @Override
    public KeyStore getIssuerAlternativeTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getAlternativeTrustStoreCAPath() != null) {
            return OCSPResourceReader.newKeyStore(this.config.getAlternativeTrustStoreCAPath(), this.config.getAlternativeTrustStoreCAType(), this.config.getAlternativeTrustStoreCAPassword());
        }
        return null;
    }

    @Override
    public void readExternalResource(String resource, Map<String, byte[]> holderResource) throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        try {
            KeyStore ks;
            ExternalResourceConfig externalConfig = new ExternalResourceConfig();
            externalConfig.setHostnameVerifier(this.config.isExternalResourcesHostnameVerifier());
            externalConfig.setTrustAllCerts(this.config.isExternalResourcesTrustAllCerts());
            if (this.config.getExternalResourcesTrustStorePath() != null) {
                ks = OCSPResourceReader.newKeyStore(this.config.getExternalResourcesTrustStorePath(), this.config.getExternalResourcesTrustStoreType(), this.config.getExternalResourcesTrustStorePassword());
                externalConfig.setTrustStore(ks.getKeystore());
            }
            if (this.config.getExternalResourcesKeyStorePath() != null) {
                ks = OCSPResourceReader.newKeyStore(this.config.getExternalResourcesKeyStorePath(), this.config.getExternalResourcesKeyStoreType(), this.config.getExternalResourcesKeyStorePassword());
                externalConfig.setKeyStore(ks.getKeystore());
                externalConfig.setKeyAlias(this.config.getExternalResourcesKeyAlias());
                externalConfig.setKeyPassword(this.config.getExternalResourcesKeyPassword());
            }
            externalConfig.setBasicUsername(this.config.getExternalResourcesUsername());
            externalConfig.setBasicPassword(this.config.getExternalResourcesPassword());
            if (this.config.getForwardProxyUrl() != null) {
                externalConfig.setForwardProxyUrl(this.config.getForwardProxyUrl());
                externalConfig.setForwardProxyHeader(this.config.getForwardProxyHeader());
                externalConfig.setForwardProxyQueryParameter(this.config.getForwardProxyQueryParameter());
                externalConfig.setForwardProxyBase64(this.config.isForwardProxyBase64());
            }
            externalConfig.setConnectTimeout(this.config.getConnectTimeout());
            externalConfig.setReadTimeout(this.config.getReadTimeout());
            externalConfig.setHttpLibrary(this.config.getHttpLibrary());
            byte[] r = ExternalResourceUtils.readResource(resource, externalConfig);
            if (r != null) {
                holderResource.put(resource, r);
            }
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
    }

    @Override
    public CRLCertstore readCRL(List<String> crl, Map<String, byte[]> localResources) throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        try {
            return new CRLCertstore(crl, localResources);
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
    }

    @Override
    public KeyStore getSignerTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getTrustStoreSignerPath() != null) {
            return OCSPResourceReader.newKeyStore(this.config.getTrustStoreSignerPath(), this.config.getTrustStoreSignerType(), this.config.getTrustStoreSignerPassword());
        }
        return null;
    }

    @Override
    public KeyStore getHttpsTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getExternalResourcesTrustStorePath() != null) {
            return OCSPResourceReader.newKeyStore(this.config.getExternalResourcesTrustStorePath(), this.config.getExternalResourcesTrustStoreType(), this.config.getExternalResourcesTrustStorePassword());
        }
        return null;
    }

    @Override
    public KeyStore getHttpsKeyStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getExternalResourcesKeyStorePath() != null) {
            return OCSPResourceReader.newKeyStore(this.config.getExternalResourcesKeyStorePath(), this.config.getExternalResourcesKeyStoreType(), this.config.getExternalResourcesKeyStorePassword());
        }
        return null;
    }

    @Override
    public KeyStore getCrlAlternativeTrustStore() throws UtilsException {
        if (this.config == null) {
            throw new UtilsException(OCSP_CONFIG_NULL);
        }
        if (this.config.getAlternativeTrustStoreCRLPath() != null) {
            return OCSPResourceReader.newKeyStore(this.config.getAlternativeTrustStoreCRLPath(), this.config.getAlternativeTrustStoreCRLType(), this.config.getAlternativeTrustStoreCRLPassword());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore newKeyStore(String path, String type, String password) throws UtilsException {
        File f = new File(path);
        if (f.exists()) return new KeyStore(path, type, password);
        try (InputStream is = OCSPResourceReader.class.getResourceAsStream(path);){
            if (is == null) return new KeyStore(path, type, password);
            byte[] content = Utilities.getAsByteArray(is);
            KeyStore keyStore = new KeyStore(content, type, password);
            return keyStore;
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
    }
}

